/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jruby.truffle.core.TruffleProcessNodes;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=TruffleProcessNodes.class)
public final class TruffleProcessNodesFactory {
    public static List<NodeFactory<TruffleProcessNodes.SpawnNode>> getFactories() {
        return Collections.singletonList(SpawnNodeFactory.getInstance());
    }

    @GeneratedBy(value=TruffleProcessNodes.SpawnNode.class)
    public static final class SpawnNodeFactory
    implements NodeFactory<TruffleProcessNodes.SpawnNode> {
        private static SpawnNodeFactory spawnNodeFactoryInstance;

        private SpawnNodeFactory() {
        }

        public Class<TruffleProcessNodes.SpawnNode> getNodeClass() {
            return TruffleProcessNodes.SpawnNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public TruffleProcessNodes.SpawnNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SpawnNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleProcessNodes.SpawnNode> getInstance() {
            if (spawnNodeFactoryInstance == null) {
                spawnNodeFactoryInstance = new SpawnNodeFactory();
            }
            return spawnNodeFactoryInstance;
        }

        public static TruffleProcessNodes.SpawnNode create(RubyNode[] arguments) {
            return new SpawnNodeGen(arguments);
        }

        @GeneratedBy(value=TruffleProcessNodes.SpawnNode.class)
        public static final class SpawnNodeGen
        extends TruffleProcessNodes.SpawnNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SpawnNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments3Value_;
                DynamicObject arguments2Value_;
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    Object arguments3Value = this.arguments3_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    Object arguments3Value = this.arguments3_.execute(frameValue);
                    throw this.unsupported(arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                }
                try {
                    arguments2Value_ = this.arguments2_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value = this.arguments3_.execute(frameValue);
                    throw this.unsupported(arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
                }
                try {
                    arguments3Value_ = this.arguments3_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                }
                if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyArray(arguments1Value_) && RubyGuards.isRubyArray(arguments2Value_) && RubyGuards.isRubyHash(arguments3Value_)) {
                    return this.spawn(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value});
            }
        }
    }
}

