/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.cext;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.cext.DataAdapter;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNodeGen;
import org.jruby.truffle.language.objects.WriteObjectFieldNode;
import org.jruby.truffle.language.objects.WriteObjectFieldNodeGen;

public class DataMessageResolution {

    public static abstract class TypedDataWriteNode
    extends Node {
        @Node.Child
        private WriteObjectFieldNode writeDataNode;

        protected Object access(DataAdapter dataAdapter, int index, Object value) {
            if (index == 2) {
                if (this.writeDataNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.writeDataNode = (WriteObjectFieldNode)this.insert(WriteObjectFieldNodeGen.create("@data"));
                }
            } else {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException(String.format("Don't know what to do with a write to field %s in typed data", index));
            }
            this.writeDataNode.execute(dataAdapter.getObject(), value);
            return value;
        }
    }

    public static abstract class TypedDataReadNode
    extends Node {
        @Node.Child
        private ReadObjectFieldNode readDataNode;

        protected Object access(DataAdapter dataAdapter, long index) {
            if (index == 16L) {
                if (this.readDataNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.readDataNode = (ReadObjectFieldNode)this.insert(ReadObjectFieldNodeGen.create("@data", 0));
                }
                return this.readDataNode.execute(dataAdapter.getObject());
            }
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException(String.format("Don't know what to do with a read from field %s in typed data", index));
        }
    }

    public static abstract class TypedDataCheckNode
    extends Node {
        protected static boolean test(TruffleObject receiver) {
            return receiver instanceof DataAdapter;
        }
    }
}

