/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.symbol.SymbolTable;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.objects.WriteObjectFieldNode;
import org.jruby.truffle.language.objects.WriteObjectFieldNodeGen;

@NodeChildren(value={@NodeChild(value="object"), @NodeChild(value="name"), @NodeChild(value="value")})
public abstract class ObjectIVarSetNode
extends RubyNode {
    private final boolean checkName;

    public ObjectIVarSetNode(boolean checkName) {
        this.checkName = checkName;
    }

    public abstract Object executeIVarSet(DynamicObject var1, String var2, Object var3);

    @Specialization(guards={"name == cachedName"}, limit="getCacheLimit()")
    public Object ivarSetCached(DynamicObject object, String name, Object value, @Cached(value="name") String cachedName, @Cached(value="createWriteFieldNode(checkName(cachedName, object))") WriteObjectFieldNode writeObjectFieldNode) {
        writeObjectFieldNode.execute(object, value);
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(contains={"ivarSetCached"})
    public Object ivarSetUncached(DynamicObject object, String name, Object value) {
        object.define((Object)this.checkName(name, object), value, 0);
        return value;
    }

    protected String checkName(String name, DynamicObject object) {
        return this.checkName ? SymbolTable.checkInstanceVariableName(this.getContext(), name, object, this) : name;
    }

    protected WriteObjectFieldNode createWriteFieldNode(String name) {
        return WriteObjectFieldNodeGen.create(name);
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().INSTANCE_VARIABLE_CACHE;
    }
}

