/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.module.ModuleNodes;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.LookupForExistingModuleNode;
import org.jruby.truffle.language.objects.LookupForExistingModuleNodeGen;

@NodeChild(value="lexicalParentModule", type=RubyNode.class)
public abstract class DefineModuleNode
extends RubyNode {
    private final String name;
    @Node.Child
    LookupForExistingModuleNode lookupForExistingModuleNode;
    private final ConditionProfile needToDefineProfile = ConditionProfile.createBinaryProfile();
    private final BranchProfile errorProfile = BranchProfile.create();

    public DefineModuleNode(RubyContext context, SourceSection sourceSection, String name) {
        super(context, sourceSection);
        this.name = name;
    }

    @Specialization(guards={"isRubyModule(lexicalParentModule)"})
    public Object defineModule(VirtualFrame frame, DynamicObject lexicalParentModule) {
        DynamicObject definingModule;
        RubyConstant constant = this.lookupForExistingModule(frame, this.name, lexicalParentModule);
        if (this.needToDefineProfile.profile(constant == null)) {
            definingModule = ModuleNodes.createModule(this.getContext(), this.coreLibrary().getModuleClass(), lexicalParentModule, this.name, this);
        } else {
            Object constantValue = constant.getValue();
            if (!RubyGuards.isRubyModule(constantValue) || RubyGuards.isRubyClass(constantValue)) {
                this.errorProfile.enter();
                throw new RaiseException(this.coreExceptions().typeErrorIsNotA(this.name, "module", (Node)this));
            }
            definingModule = (DynamicObject)constantValue;
        }
        return definingModule;
    }

    @Specialization(guards={"!isRubyModule(lexicalParentObject)"})
    public Object defineModuleWrongParent(VirtualFrame frame, Object lexicalParentObject) {
        throw new RaiseException(this.coreExceptions().typeErrorIsNotA(lexicalParentObject, "module", (Node)this));
    }

    private RubyConstant lookupForExistingModule(VirtualFrame frame, String name, DynamicObject lexicalParent) {
        if (this.lookupForExistingModuleNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lookupForExistingModuleNode = (LookupForExistingModuleNode)this.insert(LookupForExistingModuleNodeGen.create(null, null));
        }
        return this.lookupForExistingModuleNode.executeLookupForExistingModule(frame, name, lexicalParent);
    }
}

