/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.numeric;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.builtins.UnaryCoreMethodNode;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.core.cast.ToIntNode;
import org.jruby.truffle.core.numeric.FixnumOrBignumNode;
import org.jruby.truffle.core.numeric.GeneralDivModNode;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

@CoreClass(value="Bignum")
public abstract class BignumNodes {

    @Primitive(name="bignum_pow")
    public static abstract class BignumPowPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        private final ConditionProfile negativeProfile = ConditionProfile.createBinaryProfile();

        @Specialization
        public DynamicObject pow(DynamicObject a, int b) {
            return this.pow(a, (long)b);
        }

        @Specialization
        public DynamicObject pow(DynamicObject a, long b) {
            if (this.negativeProfile.profile(b < 0L)) {
                return null;
            }
            return this.createBignum(Layouts.BIGNUM.getValue(a).pow((int)b));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public double pow(DynamicObject a, double b) {
            return Math.pow(Layouts.BIGNUM.getValue(a).doubleValue(), b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Void pow(DynamicObject a, DynamicObject b) {
            throw new UnsupportedOperationException();
        }
    }

    @Primitive(name="bignum_compare")
    public static abstract class BignumCompareNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public int compare(DynamicObject a, long b) {
            return Layouts.BIGNUM.getValue(a).compareTo(BigInteger.valueOf(b));
        }

        @Specialization(guards={"!isInfinity(b)"})
        public int compare(DynamicObject a, double b) {
            return Double.compare(Layouts.BIGNUM.getValue(a).doubleValue(), b);
        }

        @Specialization(guards={"isInfinity(b)"})
        public int compareInfinity(DynamicObject a, double b) {
            if (b < 0.0) {
                return 1;
            }
            return -1;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public int compare(DynamicObject a, DynamicObject b) {
            return Layouts.BIGNUM.getValue(a).compareTo(Layouts.BIGNUM.getValue(b));
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object compareFallback(DynamicObject a, DynamicObject b) {
            return null;
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"to_s", "inspect"}, optional=1)
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(DynamicObject value, NotProvided base) {
            return this.create7BitString(Layouts.BIGNUM.getValue(value).toString(), (Encoding)USASCIIEncoding.INSTANCE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(DynamicObject value, int base) {
            if (base < 2 || base > 36) {
                throw new RaiseException(this.coreExceptions().argumentErrorInvalidRadix(base, this));
            }
            return this.create7BitString(Layouts.BIGNUM.getValue(value).toString(base), (Encoding)USASCIIEncoding.INSTANCE);
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public double toF(DynamicObject value) {
            return Layouts.BIGNUM.getValue(value).doubleValue();
        }
    }

    @CoreMethod(names={"size"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int size(DynamicObject value) {
            return (Layouts.BIGNUM.getValue(value).bitLength() + 7) / 8;
        }
    }

    @CoreMethod(names={"odd?"})
    public static abstract class OddNode
    extends BignumCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean odd(DynamicObject value) {
            return Layouts.BIGNUM.getValue(value).testBit(0);
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int hash(DynamicObject value) {
            return Layouts.BIGNUM.getValue(value).hashCode();
        }
    }

    @CoreMethod(names={"even?"})
    public static abstract class EvenNode
    extends BignumCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean even(DynamicObject value) {
            return !Layouts.BIGNUM.getValue(value).testBit(0);
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private GeneralDivModNode divModNode;

        public DivModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.divModNode = new GeneralDivModNode(context, sourceSection);
        }

        @Specialization
        public DynamicObject divMod(DynamicObject a, long b) {
            return this.divModNode.execute(Layouts.BIGNUM.getValue(a), b);
        }

        @Specialization
        public DynamicObject divMod(DynamicObject a, double b) {
            return this.divModNode.execute(Layouts.BIGNUM.getValue(a), b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public DynamicObject divMod(DynamicObject a, DynamicObject b) {
            return this.divModNode.execute(Layouts.BIGNUM.getValue(a), Layouts.BIGNUM.getValue(b));
        }
    }

    @CoreMethod(names={"coerce"}, required=1)
    public static abstract class CoerceNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject coerce(DynamicObject a, int b) {
            Object[] store = new Object[]{b, a};
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
        }

        @Specialization
        public DynamicObject coerce(DynamicObject a, long b) {
            Object[] store = new Object[]{b, a};
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public DynamicObject coerce(DynamicObject a, DynamicObject b) {
            Object[] store = new Object[]{b, a};
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
        }
    }

    @CoreMethod(names={"bit_length"})
    public static abstract class BitLengthNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int bitLength(DynamicObject value) {
            return Layouts.BIGNUM.getValue(value).bitLength();
        }
    }

    @CoreMethod(names={"abs", "magnitude"})
    public static abstract class AbsNode
    extends BignumCoreMethodNode {
        @Specialization
        public Object abs(DynamicObject value) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(value).abs());
        }
    }

    @CoreMethod(names={">>"}, required=1, lowerFixnum={1})
    public static abstract class RightShiftNode
    extends BignumCoreMethodNode {
        public abstract Object executeRightShift(VirtualFrame var1, DynamicObject var2, Object var3);

        @Specialization
        public Object rightShift(DynamicObject a, int b, @Cached(value="createBinaryProfile()") ConditionProfile bPositive) {
            if (bPositive.profile(b >= 0)) {
                return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).shiftRight(b));
            }
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).shiftLeft(-b));
        }

        @Specialization
        public Object rightShift(VirtualFrame frame, DynamicObject a, long b) {
            if (CoreLibrary.fitsIntoInteger(b)) {
                return this.executeRightShift(frame, a, (int)b);
            }
            return 0;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public int rightShift(DynamicObject a, DynamicObject b) {
            return 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)"})
        public Object rightShift(VirtualFrame frame, DynamicObject a, Object b, @Cached(value="create()") ToIntNode toIntNode) {
            return this.executeRightShift(frame, a, toIntNode.doInt(frame, b));
        }
    }

    @CoreMethod(names={"<<"}, required=1, lowerFixnum={1})
    public static abstract class LeftShiftNode
    extends BignumCoreMethodNode {
        public abstract Object executeLeftShift(VirtualFrame var1, DynamicObject var2, Object var3);

        @Specialization
        public Object leftShift(DynamicObject a, int b, @Cached(value="createBinaryProfile()") ConditionProfile bPositive) {
            if (bPositive.profile(b >= 0)) {
                return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).shiftLeft(b));
            }
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).shiftRight(-b));
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object leftShift(VirtualFrame frame, DynamicObject a, DynamicObject b, @Cached(value="create()") ToIntNode toIntNode) {
            BigInteger bBigInt = Layouts.BIGNUM.getValue(b);
            if (bBigInt.signum() == -1) {
                return 0;
            }
            return this.executeLeftShift(frame, a, toIntNode.doInt(frame, b));
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)"})
        public Object leftShift(VirtualFrame frame, DynamicObject a, Object b, @Cached(value="create()") ToIntNode toIntNode) {
            return this.executeLeftShift(frame, a, toIntNode.doInt(frame, b));
        }
    }

    @CoreMethod(names={"^"}, required=1)
    public static abstract class BitXOrNode
    extends BignumCoreMethodNode {
        @Specialization
        public Object bitXOr(DynamicObject a, long b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).xor(BigInteger.valueOf(b)));
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object bitXOr(DynamicObject a, DynamicObject b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).xor(Layouts.BIGNUM.getValue(b)));
        }
    }

    @CoreMethod(names={"|"}, required=1)
    public static abstract class BitOrNode
    extends BignumCoreMethodNode {
        @Specialization
        public Object bitOr(DynamicObject a, long b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).or(BigInteger.valueOf(b)));
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object bitOr(DynamicObject a, DynamicObject b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).or(Layouts.BIGNUM.getValue(b)));
        }
    }

    @CoreMethod(names={"&"}, required=1)
    public static abstract class BitAndNode
    extends BignumCoreMethodNode {
        @Specialization
        public Object bitAnd(DynamicObject a, long b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).and(BigInteger.valueOf(b)));
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object bitAnd(DynamicObject a, DynamicObject b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).and(Layouts.BIGNUM.getValue(b)));
        }
    }

    @CoreMethod(names={"~"})
    public static abstract class ComplementNode
    extends BignumCoreMethodNode {
        @Specialization
        public Object complement(DynamicObject value) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(value).not());
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class GreaterNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean greater(DynamicObject a, long b) {
            return Layouts.BIGNUM.getValue(a).compareTo(BigInteger.valueOf(b)) > 0;
        }

        @Specialization
        public boolean greater(DynamicObject a, double b) {
            return Double.compare(Layouts.BIGNUM.getValue(a).doubleValue(), b) > 0;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greater(DynamicObject a, DynamicObject b) {
            return Layouts.BIGNUM.getValue(a).compareTo(Layouts.BIGNUM.getValue(b)) > 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object greaterCoerced(VirtualFrame frame, DynamicObject a, Object b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "b, a = math_coerce other, :compare_error; a > b", "other", b);
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class GreaterEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean greaterEqual(DynamicObject a, long b) {
            return Layouts.BIGNUM.getValue(a).compareTo(BigInteger.valueOf(b)) >= 0;
        }

        @Specialization
        public boolean greaterEqual(DynamicObject a, double b) {
            return Double.compare(Layouts.BIGNUM.getValue(a).doubleValue(), b) >= 0;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greaterEqual(DynamicObject a, DynamicObject b) {
            return Layouts.BIGNUM.getValue(a).compareTo(Layouts.BIGNUM.getValue(b)) >= 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object greaterEqualCoerced(VirtualFrame frame, DynamicObject a, Object b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "b, a = math_coerce other, :compare_error; a >= b", "other", b);
        }
    }

    @CoreMethod(names={"=="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private BooleanCastNode booleanCastNode;
        @Node.Child
        private CallDispatchHeadNode reverseCallNode;

        @Specialization
        public boolean equal(DynamicObject a, int b) {
            return false;
        }

        @Specialization
        public boolean equal(DynamicObject a, long b) {
            return false;
        }

        @Specialization
        public boolean equal(DynamicObject a, double b) {
            return Layouts.BIGNUM.getValue(a).doubleValue() == b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean equal(DynamicObject a, DynamicObject b) {
            return Layouts.BIGNUM.getValue(a).equals(Layouts.BIGNUM.getValue(b));
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public boolean equal(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            if (this.booleanCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(null));
            }
            if (this.reverseCallNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reverseCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            Object reversedResult = this.reverseCallNode.call(frame, b, "==", a);
            return this.booleanCastNode.executeBoolean(frame, reversedResult);
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class LessEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean lessEqual(DynamicObject a, long b) {
            return Layouts.BIGNUM.getValue(a).compareTo(BigInteger.valueOf(b)) <= 0;
        }

        @Specialization
        public boolean lessEqual(DynamicObject a, double b) {
            return Layouts.BIGNUM.getValue(a).compareTo(BigInteger.valueOf((long)b)) <= 0;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean lessEqual(DynamicObject a, DynamicObject b) {
            return Layouts.BIGNUM.getValue(a).compareTo(Layouts.BIGNUM.getValue(b)) <= 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object lessEqualCoerced(VirtualFrame frame, DynamicObject a, Object b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "b, a = math_coerce other, :compare_error; a <= b", "other", b);
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class LessNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean less(DynamicObject a, long b) {
            return Layouts.BIGNUM.getValue(a).compareTo(BigInteger.valueOf(b)) < 0;
        }

        @Specialization
        public boolean less(DynamicObject a, double b) {
            return Double.compare(Layouts.BIGNUM.getValue(a).doubleValue(), b) < 0;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean less(DynamicObject a, DynamicObject b) {
            return Layouts.BIGNUM.getValue(a).compareTo(Layouts.BIGNUM.getValue(b)) < 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object lessCoerced(VirtualFrame frame, DynamicObject a, Object b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "b, a = math_coerce other, :compare_error; a < b", "other", b);
        }
    }

    @CoreMethod(names={"%", "modulo"}, required=1)
    public static abstract class ModNode
    extends BignumCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object mod(DynamicObject a, long b) {
            if (b == 0L) {
                throw new ArithmeticException("divide by zero");
            }
            if (b < 0L) {
                BigInteger bigint = BigInteger.valueOf(b);
                BigInteger mod = Layouts.BIGNUM.getValue(a).mod(bigint.negate());
                return this.fixnumOrBignum(mod.add(bigint));
            }
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).mod(BigInteger.valueOf(b)));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyBignum(b)"})
        public Object mod(DynamicObject a, DynamicObject b) {
            BigInteger bigint = Layouts.BIGNUM.getValue(b);
            int compare = bigint.compareTo(BigInteger.ZERO);
            if (compare == 0) {
                throw new ArithmeticException("divide by zero");
            }
            if (compare < 0) {
                BigInteger mod = Layouts.BIGNUM.getValue(a).mod(bigint.negate());
                return this.fixnumOrBignum(mod.add(bigint));
            }
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).mod(Layouts.BIGNUM.getValue(b)));
        }

        @Specialization(guards={"!isInteger(b)", "!isLong(b)", "!isRubyBignum(b)"})
        public Object mod(VirtualFrame frame, DynamicObject a, Object b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :%, other", "other", b);
        }
    }

    @CoreMethod(names={"/", "__slash__"}, required=1)
    public static abstract class DivNode
    extends BignumCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object div(DynamicObject a, long b) {
            BigInteger bBigInt = BigInteger.valueOf(b);
            BigInteger aBigInt = Layouts.BIGNUM.getValue(a);
            BigInteger result = aBigInt.divide(bBigInt);
            if (result.signum() == -1 && !aBigInt.mod(bBigInt.abs()).equals(BigInteger.ZERO)) {
                return this.fixnumOrBignum(result.subtract(BigInteger.ONE));
            }
            return this.fixnumOrBignum(result);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public double div(DynamicObject a, double b) {
            return Layouts.BIGNUM.getValue(a).doubleValue() / b;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyBignum(b)"})
        public Object div(DynamicObject a, DynamicObject b) {
            BigInteger bBigInt;
            BigInteger aBigInt = Layouts.BIGNUM.getValue(a);
            BigInteger result = aBigInt.divide(bBigInt = Layouts.BIGNUM.getValue(b));
            if (result.signum() == -1 && !aBigInt.mod(bBigInt.abs()).equals(BigInteger.ZERO)) {
                return this.fixnumOrBignum(result.subtract(BigInteger.ONE));
            }
            return this.fixnumOrBignum(result);
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MulNode
    extends BignumCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object mul(DynamicObject a, long b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).multiply(BigInteger.valueOf(b)));
        }

        @Specialization
        public double mul(DynamicObject a, double b) {
            return Layouts.BIGNUM.getValue(a).doubleValue() * b;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyBignum(b)"})
        public Object mul(DynamicObject a, DynamicObject b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).multiply(Layouts.BIGNUM.getValue(b)));
        }

        @Specialization(guards={"!isInteger(b)", "!isLong(b)", "!isDouble(b)", "!isRubyBignum(b)"})
        public Object mul(VirtualFrame frame, DynamicObject a, Object b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :*, other", "other", b);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends BignumCoreMethodNode {
        @Specialization
        public Object sub(DynamicObject a, long b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).subtract(BigInteger.valueOf(b)));
        }

        @Specialization
        public double sub(DynamicObject a, double b) {
            return Layouts.BIGNUM.getValue(a).doubleValue() - b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object sub(DynamicObject a, DynamicObject b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).subtract(Layouts.BIGNUM.getValue(b)));
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends BignumCoreMethodNode {
        @Specialization
        public Object add(DynamicObject a, long b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).add(BigInteger.valueOf(b)));
        }

        @Specialization
        public double add(DynamicObject a, double b) {
            return Layouts.BIGNUM.getValue(a).doubleValue() + b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object add(DynamicObject a, DynamicObject b) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(a).add(Layouts.BIGNUM.getValue(b)));
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends BignumCoreMethodNode {
        @Specialization
        public Object neg(DynamicObject value) {
            return this.fixnumOrBignum(Layouts.BIGNUM.getValue(value).negate());
        }
    }

    public static abstract class BignumCoreMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public Object fixnumOrBignum(BigInteger value) {
            if (this.fixnumOrBignum == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.fixnumOrBignum = (FixnumOrBignumNode)this.insert(new FixnumOrBignumNode(this.getContext(), this.getSourceSection()));
            }
            return this.fixnumOrBignum.fixnumOrBignum(value);
        }
    }
}

