/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.mutex;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.mutex.ConditionVariableLayout;

@GeneratedBy(value=ConditionVariableLayout.class)
public class ConditionVariableLayoutImpl
extends BasicObjectLayoutImpl
implements ConditionVariableLayout {
    public static final ConditionVariableLayout INSTANCE = new ConditionVariableLayoutImpl();
    protected static final Shape.Allocator CONDITION_VARIABLE_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey CONDITION_IDENTIFIER = new HiddenKey("condition");
    protected static final Property CONDITION_PROPERTY = Property.create((Object)CONDITION_IDENTIFIER, (Location)CONDITION_VARIABLE_ALLOCATOR.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), (int)0);

    protected ConditionVariableLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createConditionVariableShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new ConditionVariableType(logicalClass, metaClass)).addProperty(CONDITION_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createConditionVariable(DynamicObjectFactory factory, Object condition) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (ConditionVariableLayoutImpl.createsConditionVariable(factory));
        assert (factory.getShape().hasProperty((Object)CONDITION_IDENTIFIER));
        assert (condition != null);
        return factory.newInstance(new Object[]{condition});
    }

    @Override
    public boolean isConditionVariable(DynamicObject object) {
        return ConditionVariableLayoutImpl.isConditionVariable(object.getShape().getObjectType());
    }

    private static boolean isConditionVariable(ObjectType objectType) {
        return objectType instanceof ConditionVariableType;
    }

    private static boolean createsConditionVariable(DynamicObjectFactory factory) {
        return ConditionVariableLayoutImpl.isConditionVariable(factory.getShape().getObjectType());
    }

    @Override
    public Object getCondition(DynamicObject object) {
        assert (this.isConditionVariable(object));
        assert (object.getShape().hasProperty((Object)CONDITION_IDENTIFIER));
        return CONDITION_PROPERTY.get(object, this.isConditionVariable(object));
    }

    public static class ConditionVariableType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public ConditionVariableType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public ConditionVariableType setLogicalClass(DynamicObject logicalClass) {
            return new ConditionVariableType(logicalClass, this.metaClass);
        }

        @Override
        public ConditionVariableType setMetaClass(DynamicObject metaClass) {
            return new ConditionVariableType(this.logicalClass, metaClass);
        }
    }
}

