/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.hash.Entry;
import org.jruby.truffle.core.hash.HashLayout;

@GeneratedBy(value=HashLayout.class)
public class HashLayoutImpl
extends BasicObjectLayoutImpl
implements HashLayout {
    public static final HashLayout INSTANCE = new HashLayoutImpl();
    protected static final Shape.Allocator HASH_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey STORE_IDENTIFIER = new HiddenKey("store");
    protected static final Property STORE_PROPERTY = Property.create((Object)STORE_IDENTIFIER, (Location)HASH_ALLOCATOR.locationForType(Object.class), (int)0);
    protected static final HiddenKey SIZE_IDENTIFIER = new HiddenKey("size");
    protected static final Property SIZE_PROPERTY = Property.create((Object)SIZE_IDENTIFIER, (Location)HASH_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey FIRST_IN_SEQUENCE_IDENTIFIER = new HiddenKey("firstInSequence");
    protected static final Property FIRST_IN_SEQUENCE_PROPERTY = Property.create((Object)FIRST_IN_SEQUENCE_IDENTIFIER, (Location)HASH_ALLOCATOR.locationForType(Entry.class), (int)0);
    protected static final HiddenKey LAST_IN_SEQUENCE_IDENTIFIER = new HiddenKey("lastInSequence");
    protected static final Property LAST_IN_SEQUENCE_PROPERTY = Property.create((Object)LAST_IN_SEQUENCE_IDENTIFIER, (Location)HASH_ALLOCATOR.locationForType(Entry.class), (int)0);
    protected static final HiddenKey DEFAULT_BLOCK_IDENTIFIER = new HiddenKey("defaultBlock");
    protected static final Property DEFAULT_BLOCK_PROPERTY = Property.create((Object)DEFAULT_BLOCK_IDENTIFIER, (Location)HASH_ALLOCATOR.locationForType(DynamicObject.class), (int)0);
    protected static final HiddenKey DEFAULT_VALUE_IDENTIFIER = new HiddenKey("defaultValue");
    protected static final Property DEFAULT_VALUE_PROPERTY = Property.create((Object)DEFAULT_VALUE_IDENTIFIER, (Location)HASH_ALLOCATOR.locationForType(Object.class), (int)0);
    protected static final HiddenKey COMPARE_BY_IDENTITY_IDENTIFIER = new HiddenKey("compareByIdentity");
    protected static final Property COMPARE_BY_IDENTITY_PROPERTY = Property.create((Object)COMPARE_BY_IDENTITY_IDENTIFIER, (Location)HASH_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull)), (int)0);

    protected HashLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createHashShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new HashType(logicalClass, metaClass)).addProperty(STORE_PROPERTY).addProperty(SIZE_PROPERTY).addProperty(FIRST_IN_SEQUENCE_PROPERTY).addProperty(LAST_IN_SEQUENCE_PROPERTY).addProperty(DEFAULT_BLOCK_PROPERTY).addProperty(DEFAULT_VALUE_PROPERTY).addProperty(COMPARE_BY_IDENTITY_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createHash(DynamicObjectFactory factory, Object store, int size, Entry firstInSequence, Entry lastInSequence, DynamicObject defaultBlock, Object defaultValue, boolean compareByIdentity) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsHash(factory));
        assert (factory.getShape().hasProperty((Object)STORE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)SIZE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)FIRST_IN_SEQUENCE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)LAST_IN_SEQUENCE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)DEFAULT_BLOCK_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)DEFAULT_VALUE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)COMPARE_BY_IDENTITY_IDENTIFIER));
        return factory.newInstance(new Object[]{store, size, firstInSequence, lastInSequence, defaultBlock, defaultValue, compareByIdentity});
    }

    @Override
    public boolean isHash(Object object) {
        return object instanceof DynamicObject && this.isHash((DynamicObject)object);
    }

    @Override
    public boolean isHash(DynamicObject object) {
        return this.isHash(object.getShape().getObjectType());
    }

    @Override
    public boolean isHash(ObjectType objectType) {
        return objectType instanceof HashType;
    }

    private boolean createsHash(DynamicObjectFactory factory) {
        return this.isHash(factory.getShape().getObjectType());
    }

    @Override
    public Object getStore(DynamicObject object) {
        assert (this.isHash(object));
        assert (object.getShape().hasProperty((Object)STORE_IDENTIFIER));
        return STORE_PROPERTY.get(object, this.isHash(object));
    }

    @Override
    public void setStore(DynamicObject object, Object value) {
        assert (this.isHash(object));
        assert (object.getShape().hasProperty((Object)STORE_IDENTIFIER));
        try {
            STORE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int getSize(DynamicObject object) {
        assert (this.isHash(object));
        assert (object.getShape().hasProperty((Object)SIZE_IDENTIFIER));
        return (Integer)SIZE_PROPERTY.get(object, this.isHash(object));
    }

    @Override
    public void setSize(DynamicObject object, int value) {
        assert (this.isHash(object));
        assert (object.getShape().hasProperty((Object)SIZE_IDENTIFIER));
        try {
            SIZE_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public Entry getFirstInSequence(DynamicObject object) {
        assert (this.isHash(object));
        assert (object.getShape().hasProperty((Object)FIRST_IN_SEQUENCE_IDENTIFIER));
        return (Entry)FIRST_IN_SEQUENCE_PROPERTY.get(object, this.isHash(object));
    }

    @Override
    public void setFirstInSequence(DynamicObject object, Entry value) {
        assert (this.isHash(object));
        assert (object.getShape().hasProperty((Object)FIRST_IN_SEQUENCE_IDENTIFIER));
        try {
            FIRST_IN_SEQUENCE_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public Entry getLastInSequence(DynamicObject object) {
        assert (this.isHash(object));
        assert (object.getShape().hasProperty((Object)LAST_IN_SEQUENCE_IDENTIFIER));
        return (Entry)LAST_IN_SEQUENCE_PROPERTY.get(object, this.isHash(object));
    }

    @Override
    public void setLastInSequence(DynamicObject object, Entry value) {
        assert (this.isHash(object));
        assert (object.getShape().hasProperty((Object)LAST_IN_SEQUENCE_IDENTIFIER));
        try {
            LAST_IN_SEQUENCE_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public DynamicObject getDefaultBlock(DynamicObject object) {
        assert (this.isHash(object));
        assert (object.getShape().hasProperty((Object)DEFAULT_BLOCK_IDENTIFIER));
        return (DynamicObject)DEFAULT_BLOCK_PROPERTY.get(object, this.isHash(object));
    }

    @Override
    public void setDefaultBlock(DynamicObject object, DynamicObject value) {
        assert (this.isHash(object));
        assert (object.getShape().hasProperty((Object)DEFAULT_BLOCK_IDENTIFIER));
        try {
            DEFAULT_BLOCK_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public Object getDefaultValue(DynamicObject object) {
        assert (this.isHash(object));
        assert (object.getShape().hasProperty((Object)DEFAULT_VALUE_IDENTIFIER));
        return DEFAULT_VALUE_PROPERTY.get(object, this.isHash(object));
    }

    @Override
    public void setDefaultValue(DynamicObject object, Object value) {
        assert (this.isHash(object));
        assert (object.getShape().hasProperty((Object)DEFAULT_VALUE_IDENTIFIER));
        try {
            DEFAULT_VALUE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public boolean getCompareByIdentity(DynamicObject object) {
        assert (this.isHash(object));
        assert (object.getShape().hasProperty((Object)COMPARE_BY_IDENTITY_IDENTIFIER));
        return (Boolean)COMPARE_BY_IDENTITY_PROPERTY.get(object, this.isHash(object));
    }

    @Override
    public void setCompareByIdentity(DynamicObject object, boolean value) {
        assert (this.isHash(object));
        assert (object.getShape().hasProperty((Object)COMPARE_BY_IDENTITY_IDENTIFIER));
        try {
            COMPARE_BY_IDENTITY_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class HashType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public HashType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public HashType setLogicalClass(DynamicObject logicalClass) {
            return new HashType(logicalClass, this.metaClass);
        }

        @Override
        public HashType setMetaClass(DynamicObject metaClass) {
            return new HashType(this.logicalClass, metaClass);
        }
    }
}

