/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.objects.IsANode;

@GeneratedBy(value=IsANode.class)
@SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
public final class IsANodeGen
extends IsANode
implements SpecializedNode {
    @Node.Child
    private RubyNode instance_;
    @Node.Child
    private RubyNode module_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeIsACached_;
    @Node.Child
    private BaseNode_ specialization_;

    private IsANodeGen(RubyContext context, SourceSection sourceSection, RubyNode instance, RubyNode module) {
        super(context, sourceSection);
        this.instance_ = instance;
        this.module_ = module;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public boolean executeIsA(Object instanceValue, DynamicObject moduleValue) {
        return this.specialization_.executeBoolean1(instanceValue, moduleValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        return this.specialization_.executeBoolean0(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static IsANode create(RubyContext context, SourceSection sourceSection, RubyNode instance, RubyNode module) {
        return new IsANodeGen(context, sourceSection, instance, module);
    }

    @GeneratedBy(methodName="isATypeError(Object, DynamicObject)", value=IsANode.class)
    private static final class IsATypeErrorNode_
    extends BaseNode_ {
        IsATypeErrorNode_(IsANodeGen root) {
            super(root, 3);
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue) {
            DynamicObject moduleValue_;
            Object instanceValue_ = this.root.instance_.execute(frameValue);
            try {
                moduleValue_ = this.root.module_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean_(instanceValue_, ex.getResult());
            }
            if (!RubyGuards.isRubyModule(moduleValue_)) {
                return this.root.isATypeError(instanceValue_, moduleValue_);
            }
            return this.getNext().executeBoolean_(instanceValue_, moduleValue_);
        }

        @Override
        public boolean executeBoolean1(Object instanceValue, DynamicObject moduleValue) {
            if (!RubyGuards.isRubyModule(moduleValue)) {
                return this.root.isATypeError(instanceValue, moduleValue);
            }
            return this.getNext().executeBoolean1(instanceValue, moduleValue);
        }

        @Override
        public boolean executeBoolean_(Object instanceValue, Object moduleValue) {
            DynamicObject moduleValue_;
            if (moduleValue instanceof DynamicObject && !RubyGuards.isRubyModule(moduleValue_ = (DynamicObject)moduleValue)) {
                return this.root.isATypeError(instanceValue, moduleValue_);
            }
            return this.getNext().executeBoolean_(instanceValue, moduleValue);
        }

        static BaseNode_ create(IsANodeGen root) {
            return new IsATypeErrorNode_(root);
        }
    }

    @GeneratedBy(methodName="isAUncached(Object, DynamicObject)", value=IsANode.class)
    private static final class IsAUncachedNode_
    extends BaseNode_ {
        IsAUncachedNode_(IsANodeGen root) {
            super(root, 2);
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue) {
            DynamicObject moduleValue_;
            Object instanceValue_ = this.root.instance_.execute(frameValue);
            try {
                moduleValue_ = this.root.module_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean_(instanceValue_, ex.getResult());
            }
            if (RubyGuards.isRubyModule(moduleValue_)) {
                return this.root.isAUncached(instanceValue_, moduleValue_);
            }
            return this.getNext().executeBoolean_(instanceValue_, moduleValue_);
        }

        @Override
        public boolean executeBoolean1(Object instanceValue, DynamicObject moduleValue) {
            if (RubyGuards.isRubyModule(moduleValue)) {
                return this.root.isAUncached(instanceValue, moduleValue);
            }
            return this.getNext().executeBoolean1(instanceValue, moduleValue);
        }

        @Override
        public boolean executeBoolean_(Object instanceValue, Object moduleValue) {
            DynamicObject moduleValue_;
            if (moduleValue instanceof DynamicObject && RubyGuards.isRubyModule(moduleValue_ = (DynamicObject)moduleValue)) {
                return this.root.isAUncached(instanceValue, moduleValue_);
            }
            return this.getNext().executeBoolean_(instanceValue, moduleValue);
        }

        static BaseNode_ create(IsANodeGen root) {
            return new IsAUncachedNode_(root);
        }
    }

    @GeneratedBy(methodName="isACached(Object, DynamicObject, DynamicObject, DynamicObject, boolean)", value=IsANode.class)
    private static final class IsACachedNode_
    extends BaseNode_ {
        private final DynamicObject cachedMetaClass;
        private final DynamicObject cachedModule;
        private final boolean result;
        @CompilerDirectives.CompilationFinal
        private final Assumption assumption0_;

        IsACachedNode_(IsANodeGen root, DynamicObject cachedMetaClass, DynamicObject cachedModule, boolean result, Assumption assumption0_) {
            super(root, 1);
            this.cachedMetaClass = cachedMetaClass;
            this.cachedModule = cachedModule;
            this.result = result;
            this.assumption0_ = assumption0_;
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object instanceValue, Object moduleValue) {
            if (newNode.getClass() == IsAUncachedNode_.class) {
                this.removeSame("Contained by isAUncached(Object, DynamicObject)");
            }
            return super.merge(newNode, frameValue, instanceValue, moduleValue);
        }

        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object instanceValue, Object moduleValue) {
            if (moduleValue instanceof DynamicObject) {
                DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                if (this.root.getMetaClass(instanceValue) == this.cachedMetaClass && moduleValue_ == this.cachedModule) {
                    assert (RubyGuards.isRubyModule(this.cachedModule));
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue) {
            DynamicObject moduleValue_;
            Object instanceValue_ = this.root.instance_.execute(frameValue);
            try {
                moduleValue_ = this.root.module_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean_(instanceValue_, ex.getResult());
            }
            try {
                IsACachedNode_.check((Assumption)this.assumption0_);
            }
            catch (InvalidAssumptionException ae) {
                return (Boolean)this.removeThis("Assumption [assumption0] invalidated", (Frame)frameValue, instanceValue_, moduleValue_);
            }
            if (this.root.getMetaClass(instanceValue_) == this.cachedMetaClass && moduleValue_ == this.cachedModule) {
                assert (RubyGuards.isRubyModule(this.cachedModule));
                return this.root.isACached(instanceValue_, moduleValue_, this.cachedMetaClass, this.cachedModule, this.result);
            }
            return this.getNext().executeBoolean_(instanceValue_, moduleValue_);
        }

        @Override
        public boolean executeBoolean1(Object instanceValue, DynamicObject moduleValue) {
            try {
                IsACachedNode_.check((Assumption)this.assumption0_);
            }
            catch (InvalidAssumptionException ae) {
                return (Boolean)this.removeThis("Assumption [assumption0] invalidated", null, instanceValue, moduleValue);
            }
            if (this.root.getMetaClass(instanceValue) == this.cachedMetaClass && moduleValue == this.cachedModule) {
                assert (RubyGuards.isRubyModule(this.cachedModule));
                return this.root.isACached(instanceValue, moduleValue, this.cachedMetaClass, this.cachedModule, this.result);
            }
            return this.getNext().executeBoolean1(instanceValue, moduleValue);
        }

        @Override
        public boolean executeBoolean_(Object instanceValue, Object moduleValue) {
            try {
                IsACachedNode_.check((Assumption)this.assumption0_);
            }
            catch (InvalidAssumptionException ae) {
                return (Boolean)this.removeThis("Assumption [assumption0] invalidated", null, instanceValue, moduleValue);
            }
            if (moduleValue instanceof DynamicObject) {
                DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                if (this.root.getMetaClass(instanceValue) == this.cachedMetaClass && moduleValue_ == this.cachedModule) {
                    assert (RubyGuards.isRubyModule(this.cachedModule));
                    return this.root.isACached(instanceValue, moduleValue_, this.cachedMetaClass, this.cachedModule, this.result);
                }
            }
            return this.getNext().executeBoolean_(instanceValue, moduleValue);
        }

        static BaseNode_ create(IsANodeGen root, DynamicObject cachedMetaClass, DynamicObject cachedModule, boolean result, Assumption assumption0_) {
            return new IsACachedNode_(root, cachedMetaClass, cachedModule, result, assumption0_);
        }
    }

    @GeneratedBy(value=IsANode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(IsANodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object instanceValue, Object moduleValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, instanceValue, moduleValue));
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue) {
            Object instanceValue_ = this.root.instance_.execute(frameValue);
            Object moduleValue_ = this.root.module_.execute(frameValue);
            return this.getNext().executeBoolean_(instanceValue_, moduleValue_);
        }

        @Override
        public boolean executeBoolean1(Object instanceValue, DynamicObject moduleValue) {
            return this.getNext().executeBoolean1(instanceValue, moduleValue);
        }

        @Override
        public boolean executeBoolean_(Object instanceValue, Object moduleValue) {
            return this.getNext().executeBoolean_(instanceValue, moduleValue);
        }

        static BaseNode_ create(IsANodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=IsANode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(IsANodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public boolean executeBoolean_(Object instanceValue, Object moduleValue) {
            return (Boolean)this.uninitialized(null, instanceValue, moduleValue);
        }

        static BaseNode_ create(IsANodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=IsANode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected IsANodeGen root;

        BaseNode_(IsANodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (IsANodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.instance_, this.root.module_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object instanceValue, Object moduleValue) {
            return this.executeBoolean_(instanceValue, moduleValue);
        }

        public abstract boolean executeBoolean_(Object var1, Object var2);

        public boolean executeBoolean1(Object instanceValue, DynamicObject moduleValue) {
            return this.executeBoolean_(instanceValue, moduleValue);
        }

        public Object execute(VirtualFrame frameValue) {
            Object instanceValue_ = this.root.instance_.execute(frameValue);
            Object moduleValue_ = this.root.module_.execute(frameValue);
            return this.executeBoolean_(instanceValue_, moduleValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public boolean executeBoolean0(VirtualFrame frameValue) {
            return (Boolean)this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object instanceValue, Object moduleValue) {
            if (moduleValue instanceof DynamicObject) {
                DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                DynamicObject cachedMetaClass1 = this.root.getMetaClass(instanceValue);
                DynamicObject cachedModule1 = moduleValue_;
                if (RubyGuards.isRubyModule(cachedModule1) && this.root.getMetaClass(instanceValue) == cachedMetaClass1 && moduleValue_ == cachedModule1 && !this.root.excludeIsACached_) {
                    BaseNode_ s;
                    boolean result1 = this.root.isA(cachedMetaClass1, cachedModule1);
                    Assumption assumption0_1 = this.root.getUnmodifiedAssumption(cachedModule1);
                    if (BaseNode_.isValid((Assumption)assumption0_1) && this.countSame(s = IsACachedNode_.create(this.root, cachedMetaClass1, cachedModule1, result1, assumption0_1)) < this.root.getCacheLimit()) {
                        return s;
                    }
                }
                if (RubyGuards.isRubyModule(moduleValue_)) {
                    this.root.excludeIsACached_ = true;
                    return IsAUncachedNode_.create(this.root);
                }
                return IsATypeErrorNode_.create(this.root);
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

