/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.range;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.range.LongRangeLayout;

@GeneratedBy(value=LongRangeLayout.class)
public class LongRangeLayoutImpl
extends BasicObjectLayoutImpl
implements LongRangeLayout {
    public static final LongRangeLayout INSTANCE = new LongRangeLayoutImpl();
    protected static final Shape.Allocator LONG_RANGE_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey EXCLUDED_END_IDENTIFIER = new HiddenKey("excludedEnd");
    protected static final Property EXCLUDED_END_PROPERTY = Property.create((Object)EXCLUDED_END_IDENTIFIER, (Location)LONG_RANGE_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), (int)0);
    protected static final HiddenKey BEGIN_IDENTIFIER = new HiddenKey("begin");
    protected static final Property BEGIN_PROPERTY = Property.create((Object)BEGIN_IDENTIFIER, (Location)LONG_RANGE_ALLOCATOR.locationForType(Long.TYPE, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), (int)0);
    protected static final HiddenKey END_IDENTIFIER = new HiddenKey("end");
    protected static final Property END_PROPERTY = Property.create((Object)END_IDENTIFIER, (Location)LONG_RANGE_ALLOCATOR.locationForType(Long.TYPE, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), (int)0);

    protected LongRangeLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createLongRangeShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new LongRangeType(logicalClass, metaClass)).addProperty(EXCLUDED_END_PROPERTY).addProperty(BEGIN_PROPERTY).addProperty(END_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createLongRange(DynamicObjectFactory factory, boolean excludedEnd, long begin, long end) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (LongRangeLayoutImpl.createsLongRange(factory));
        assert (factory.getShape().hasProperty((Object)EXCLUDED_END_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)BEGIN_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)END_IDENTIFIER));
        return factory.newInstance(new Object[]{excludedEnd, begin, end});
    }

    @Override
    public boolean isLongRange(Object object) {
        return object instanceof DynamicObject && this.isLongRange((DynamicObject)object);
    }

    @Override
    public boolean isLongRange(DynamicObject object) {
        return LongRangeLayoutImpl.isLongRange(object.getShape().getObjectType());
    }

    private static boolean isLongRange(ObjectType objectType) {
        return objectType instanceof LongRangeType;
    }

    private static boolean createsLongRange(DynamicObjectFactory factory) {
        return LongRangeLayoutImpl.isLongRange(factory.getShape().getObjectType());
    }

    @Override
    public boolean getExcludedEnd(DynamicObject object) {
        assert (this.isLongRange(object));
        assert (object.getShape().hasProperty((Object)EXCLUDED_END_IDENTIFIER));
        return (Boolean)EXCLUDED_END_PROPERTY.get(object, this.isLongRange(object));
    }

    @Override
    public long getBegin(DynamicObject object) {
        assert (this.isLongRange(object));
        assert (object.getShape().hasProperty((Object)BEGIN_IDENTIFIER));
        return (Long)BEGIN_PROPERTY.get(object, this.isLongRange(object));
    }

    @Override
    public long getEnd(DynamicObject object) {
        assert (this.isLongRange(object));
        assert (object.getShape().hasProperty((Object)END_IDENTIFIER));
        return (Long)END_PROPERTY.get(object, this.isLongRange(object));
    }

    public static class LongRangeType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public LongRangeType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public LongRangeType setLogicalClass(DynamicObject logicalClass) {
            return new LongRangeType(logicalClass, this.metaClass);
        }

        @Override
        public LongRangeType setMetaClass(DynamicObject metaClass) {
            return new LongRangeType(this.logicalClass, metaClass);
        }
    }
}

