/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.queue;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.queue.ArrayBlockingQueueLocksConditions;
import org.jruby.truffle.core.queue.SizedQueueLayout;

@GeneratedBy(value=SizedQueueLayout.class)
public class SizedQueueLayoutImpl
extends BasicObjectLayoutImpl
implements SizedQueueLayout {
    public static final SizedQueueLayout INSTANCE = new SizedQueueLayoutImpl();
    protected static final Shape.Allocator SIZED_QUEUE_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey QUEUE_IDENTIFIER = new HiddenKey("queue");
    protected static final Property QUEUE_PROPERTY = Property.create((Object)QUEUE_IDENTIFIER, (Location)SIZED_QUEUE_ALLOCATOR.locationForType(ArrayBlockingQueueLocksConditions.class), (int)0);

    protected SizedQueueLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createSizedQueueShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new SizedQueueType(logicalClass, metaClass)).addProperty(QUEUE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createSizedQueue(DynamicObjectFactory factory, ArrayBlockingQueueLocksConditions<Object> queue) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (SizedQueueLayoutImpl.createsSizedQueue(factory));
        assert (factory.getShape().hasProperty((Object)QUEUE_IDENTIFIER));
        return factory.newInstance(new Object[]{queue});
    }

    private static boolean isSizedQueue(DynamicObject object) {
        return SizedQueueLayoutImpl.isSizedQueue(object.getShape().getObjectType());
    }

    private static boolean isSizedQueue(ObjectType objectType) {
        return objectType instanceof SizedQueueType;
    }

    private static boolean createsSizedQueue(DynamicObjectFactory factory) {
        return SizedQueueLayoutImpl.isSizedQueue(factory.getShape().getObjectType());
    }

    @Override
    public ArrayBlockingQueueLocksConditions<Object> getQueue(DynamicObject object) {
        assert (SizedQueueLayoutImpl.isSizedQueue(object));
        assert (object.getShape().hasProperty((Object)QUEUE_IDENTIFIER));
        return (ArrayBlockingQueueLocksConditions)QUEUE_PROPERTY.get(object, SizedQueueLayoutImpl.isSizedQueue(object));
    }

    @Override
    public void setQueue(DynamicObject object, ArrayBlockingQueueLocksConditions<Object> value) {
        assert (SizedQueueLayoutImpl.isSizedQueue(object));
        assert (object.getShape().hasProperty((Object)QUEUE_IDENTIFIER));
        try {
            QUEUE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class SizedQueueType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public SizedQueueType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public SizedQueueType setLogicalClass(DynamicObject logicalClass) {
            return new SizedQueueType(logicalClass, this.metaClass);
        }

        @Override
        public SizedQueueType setMetaClass(DynamicObject metaClass) {
            return new SizedQueueType(this.logicalClass, metaClass);
        }
    }
}

