/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayDupNode;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=ArrayDupNode.class)
public final class ArrayDupNodeGen
extends ArrayDupNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayDupNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array) {
        super(context, sourceSection);
        this.array_ = array;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public DynamicObject executeDup(VirtualFrame frameValue, DynamicObject arrayValue) {
        return this.specialization_.executeDynamicObject1(frameValue, arrayValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static ArrayDupNode create(RubyContext context, SourceSection sourceSection, RubyNode array) {
        return new ArrayDupNodeGen(context, sourceSection, array);
    }

    @GeneratedBy(methodName="dupOther(DynamicObject, ArrayStrategy)", value=ArrayDupNode.class)
    private static final class DupOtherNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;

        DupOtherNode_(ArrayDupNodeGen root, ArrayStrategy strategy) {
            super(root, 2);
            this.strategy = strategy;
        }

        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            return arrayValue instanceof DynamicObject && this.strategy.matches(arrayValue_ = (DynamicObject)arrayValue);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arrayValue) {
            if (this.strategy.matches(arrayValue)) {
                return this.root.dupOther(arrayValue, this.strategy);
            }
            return this.getNext().executeDynamicObject1(frameValue, arrayValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && this.strategy.matches(arrayValue_ = (DynamicObject)arrayValue)) {
                return this.root.dupOther(arrayValue_, this.strategy);
            }
            return this.getNext().executeDynamicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArrayDupNodeGen root, ArrayStrategy strategy) {
            return new DupOtherNode_(root, strategy);
        }
    }

    @GeneratedBy(methodName="dupNull(DynamicObject)", value=ArrayDupNode.class)
    private static final class DupNullNode_
    extends BaseNode_ {
        DupNullNode_(ArrayDupNodeGen root) {
            super(root, 1);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arrayValue) {
            if (ArrayGuards.isNullArray(arrayValue)) {
                return this.root.dupNull(arrayValue);
            }
            return this.getNext().executeDynamicObject1(frameValue, arrayValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && ArrayGuards.isNullArray(arrayValue_ = (DynamicObject)arrayValue)) {
                return this.root.dupNull(arrayValue_);
            }
            return this.getNext().executeDynamicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArrayDupNodeGen root) {
            return new DupNullNode_(root);
        }
    }

    @GeneratedBy(value=ArrayDupNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayDupNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue));
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            return this.getNext().executeDynamicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArrayDupNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayDupNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayDupNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            return (DynamicObject)this.uninitialized((Frame)frameValue, arrayValue);
        }

        static BaseNode_ create(ArrayDupNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayDupNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayDupNodeGen root;

        BaseNode_(ArrayDupNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (ArrayDupNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object arrayValue) {
            return this.executeDynamicObject_((VirtualFrame)frameValue, arrayValue);
        }

        public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arrayValue) {
            return this.executeDynamicObject_(frameValue, arrayValue);
        }

        public Object execute(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            return this.executeDynamicObject_(frameValue, arrayValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue) {
            if (arrayValue instanceof DynamicObject) {
                BaseNode_ s;
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                if (ArrayGuards.isNullArray(arrayValue_)) {
                    return DupNullNode_.create(this.root);
                }
                ArrayStrategy strategy2 = ArrayStrategy.of(arrayValue_);
                if (strategy2.matches(arrayValue_) && this.countSame(s = DupOtherNode_.create(this.root, strategy2)) < 25) {
                    return s;
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

