/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.builtins;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveNodeConstructor;
import org.jruby.truffle.language.RubyNode;

public class PrimitiveManager {
    private final Map<String, PrimitiveNodeConstructor> primitives = new ConcurrentHashMap<String, PrimitiveNodeConstructor>();

    public PrimitiveNodeConstructor getPrimitive(String name) {
        PrimitiveNodeConstructor constructor = this.primitives.get(name);
        if (constructor == null) {
            return this.primitives.get("undefined");
        }
        return constructor;
    }

    public void addPrimitiveNodes(List<? extends NodeFactory<? extends RubyNode>> nodeFactories) {
        for (NodeFactory<? extends RubyNode> nodeFactory : nodeFactories) {
            GeneratedBy generatedBy = nodeFactory.getClass().getAnnotation(GeneratedBy.class);
            Class nodeClass = generatedBy.value();
            Primitive annotation = nodeClass.getAnnotation(Primitive.class);
            if (annotation == null) continue;
            this.primitives.put(annotation.name(), new PrimitiveNodeConstructor(annotation, nodeFactory));
        }
    }
}

