/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.klass.ClassNodes;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.DefineModuleNode;

public class DefineClassNode
extends RubyNode {
    protected final String name;
    @Node.Child
    private RubyNode superClassNode;
    @Node.Child
    private CallDispatchHeadNode inheritedNode;
    @Node.Child
    private RubyNode lexicalParentModule;
    @Node.Child
    private IndirectCallNode indirectCallNode;
    private final ConditionProfile needToDefineProfile = ConditionProfile.createBinaryProfile();
    private final BranchProfile errorProfile = BranchProfile.create();

    public DefineClassNode(RubyContext context, SourceSection sourceSection, String name, RubyNode lexicalParent, RubyNode superClass) {
        super(context, sourceSection);
        this.name = name;
        this.lexicalParentModule = lexicalParent;
        this.superClassNode = superClass;
        this.indirectCallNode = IndirectCallNode.create();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject definedClass;
        Object lexicalParentObject = this.lexicalParentModule.execute(frame);
        if (!RubyGuards.isRubyModule(lexicalParentObject)) {
            this.errorProfile.enter();
            throw new RaiseException(this.coreExceptions().typeErrorIsNotA(lexicalParentObject, "module", (Node)this));
        }
        DynamicObject lexicalParentModule = (DynamicObject)lexicalParentObject;
        DynamicObject superClass = this.executeSuperClass(frame);
        RubyConstant constant = DefineModuleNode.lookupForExistingModule(frame, this.getContext(), this.name, lexicalParentModule, this.indirectCallNode);
        if (this.needToDefineProfile.profile(constant == null)) {
            definedClass = ClassNodes.createInitializedRubyClass(this.getContext(), lexicalParentModule, superClass, this.name);
            this.callInherited(frame, superClass, definedClass);
        } else {
            if (!RubyGuards.isRubyClass(constant.getValue())) {
                this.errorProfile.enter();
                throw new RaiseException(this.coreExceptions().typeErrorIsNotA(constant.getValue(), "class", (Node)this));
            }
            definedClass = (DynamicObject)constant.getValue();
            DynamicObject currentSuperClass = ClassNodes.getSuperClass(definedClass);
            if (currentSuperClass != superClass && superClass != this.coreLibrary().getObjectClass()) {
                this.errorProfile.enter();
                throw new RaiseException(this.coreExceptions().superclassMismatch(Layouts.MODULE.getFields(definedClass).getName(), this));
            }
        }
        return definedClass;
    }

    private DynamicObject executeSuperClass(VirtualFrame frame) {
        Object superClassObject = this.superClassNode.execute(frame);
        if (!RubyGuards.isRubyClass(superClassObject)) {
            this.errorProfile.enter();
            throw new RaiseException(this.coreExceptions().typeError("superclass must be a Class", this));
        }
        DynamicObject superClass = (DynamicObject)superClassObject;
        if (Layouts.CLASS.getIsSingleton(superClass)) {
            this.errorProfile.enter();
            throw new RaiseException(this.coreExceptions().typeError("can't make subclass of virtual class", this));
        }
        return superClass;
    }

    private void callInherited(VirtualFrame frame, DynamicObject superClass, DynamicObject childClass) {
        if (this.inheritedNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.inheritedNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
        }
        this.inheritedNode.call(frame, superClass, "inherited", null, childClass);
    }
}

