/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.psych;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.unicode.UnicodeEncoding;
import org.jruby.RubyEncoding;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.adapaters.InputStreamAdapter;
import org.jruby.truffle.core.cast.ToStrNode;
import org.jruby.truffle.core.cast.ToStrNodeGen;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DoesRespondDispatchHeadNode;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNodeGen;
import org.jruby.truffle.language.objects.TaintNode;
import org.jruby.truffle.language.objects.TaintNodeGen;
import org.jruby.truffle.stdlib.psych.YAMLEncoding;
import org.jruby.util.ByteList;
import org.jruby.util.io.EncodingUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.ReaderException;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.ScannerException;

@CoreClass(value="Psych::Parser")
public abstract class PsychParserNodes {

    @CoreMethod(names={"parse"}, required=1, optional=1)
    public static abstract class ParseNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode = ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null);
        private static final int STYLE_PLAIN = 1;
        private static final int STYLE_SINGLE_QUOTED = 2;
        private static final int STYLE_DOUBLE_QUOTED = 3;
        private static final int STYLE_LITERAL = 4;
        private static final int STYLE_FOLDED = 5;
        private static final int STYLE_ANY = 0;
        private static final int STYLE_FLOW = 2;
        private static final int STYLE_NOT_FLOW = 1;

        public ParseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object executeParse(VirtualFrame var1, DynamicObject var2, DynamicObject var3, Object var4);

        @Specialization
        public Object parse(VirtualFrame frame, DynamicObject parserObject, DynamicObject yaml, NotProvided path) {
            return this.executeParse(frame, parserObject, yaml, this.nil());
        }

        @Specialization
        public Object parse(VirtualFrame frame, DynamicObject parserObject, DynamicObject yaml, DynamicObject path, @Cached(value="new()") SnippetNode taintedNode, @Cached(value="create()") DoesRespondDispatchHeadNode respondToReadNode, @Cached(value="create()") DoesRespondDispatchHeadNode respondToPathNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callPathNode, @Cached(value="createReadHandlerNode()") ReadObjectFieldNode readHandlerNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callStartStreamNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callStartDocumentNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callEndDocumentNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callAliasNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callScalarNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callStartSequenceNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callEndSequenceNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callStartMappingNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callEndMappingNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callEndStreamNode, @Cached(value="new()") SnippetNode raiseSyntaxErrorSnippetNode, @Cached(value="new()") SnippetNode tagPushNode, @Cached(value="createTaintNode()") TaintNode taintNode) {
            StreamReader reader;
            CompilerDirectives.bailout((String)"Psych parsing cannot be compiled");
            boolean tainted = (Boolean)taintedNode.execute(frame, "yaml.tainted? || yaml.is_a?(IO)", "yaml", yaml);
            if (!RubyGuards.isRubyString(yaml) && respondToReadNode.doesRespondTo(frame, "read", yaml)) {
                UTF8Encoding enc = UTF8Encoding.INSTANCE;
                Charset charset = enc.getCharset();
                reader = new StreamReader((Reader)new InputStreamReader((InputStream)new InputStreamAdapter(this.getContext(), yaml), charset));
            } else {
                ByteList byteList = StringOperations.getByteListReadOnly(this.toStrNode.executeToStr(frame, yaml));
                Encoding encoding = byteList.getEncoding();
                if (!(encoding instanceof UnicodeEncoding)) {
                    byteList = EncodingUtils.strConvEnc((ThreadContext)this.getContext().getJRubyRuntime().getCurrentContext(), (ByteList)byteList, (Encoding)encoding, (Encoding)UTF8Encoding.INSTANCE);
                    encoding = UTF8Encoding.INSTANCE;
                }
                reader = new StreamReader((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize()), encoding.getCharset()));
            }
            ParserImpl parser = new ParserImpl(reader);
            try {
                if (this.isNil(path) && respondToPathNode.doesRespondTo(frame, "path", yaml)) {
                    path = (DynamicObject)callPathNode.call(frame, yaml, "path", null, new Object[0]);
                }
                Object handler = readHandlerNode.execute(parserObject);
                while (true) {
                    Integer style;
                    Boolean implicit;
                    Object tag;
                    Object anchor;
                    Event event;
                    if ((event = parser.getEvent()).is(Event.ID.StreamStart)) {
                        callStartStreamNode.call(frame, handler, "start_stream", null, YAMLEncoding.YAML_ANY_ENCODING.ordinal());
                        continue;
                    }
                    if (event.is(Event.ID.DocumentStart)) {
                        DocumentStartEvent startEvent = (DocumentStartEvent)event;
                        DumperOptions.Version versionOptions = startEvent.getVersion();
                        Integer[] versionInts = versionOptions == null ? null : versionOptions.getArray();
                        DynamicObject versionArray = versionInts == null ? Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), null, 0) : Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), new Object[]{versionInts[0], versionInts[1]}, 2);
                        Map tagsMap = startEvent.getTags();
                        DynamicObject tags = Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), null, 0);
                        if (tagsMap != null && tagsMap.size() > 0) {
                            for (Map.Entry tag2 : tagsMap.entrySet()) {
                                Object key = this.stringFor((String)tag2.getKey(), tainted, taintNode);
                                Object value = this.stringFor((String)tag2.getValue(), tainted, taintNode);
                                tagPushNode.execute(frame, "tags.push [key, value]", "tags", tags, "key", key, "value", value);
                            }
                        }
                        Boolean notExplicit = !startEvent.getExplicit();
                        callStartDocumentNode.call(frame, handler, "start_document", null, versionArray, tags, notExplicit);
                        continue;
                    }
                    if (event.is(Event.ID.DocumentEnd)) {
                        DocumentEndEvent endEvent = (DocumentEndEvent)event;
                        Boolean notExplicit = !endEvent.getExplicit();
                        callEndDocumentNode.call(frame, handler, "end_document", null, notExplicit);
                        continue;
                    }
                    if (event.is(Event.ID.Alias)) {
                        AliasEvent aliasEvent = (AliasEvent)event;
                        Object alias = this.stringOrNilFor(aliasEvent.getAnchor(), tainted, taintNode);
                        callAliasNode.call(frame, handler, "alias", null, alias);
                        continue;
                    }
                    if (event.is(Event.ID.Scalar)) {
                        ScalarEvent scalarEvent = (ScalarEvent)event;
                        anchor = this.stringOrNilFor(scalarEvent.getAnchor(), tainted, taintNode);
                        tag = this.stringOrNilFor(scalarEvent.getTag(), tainted, taintNode);
                        Boolean plain_implicit = scalarEvent.getImplicit().canOmitTagInPlainScalar();
                        Boolean quoted_implicit = scalarEvent.getImplicit().canOmitTagInNonPlainScalar();
                        Integer style2 = ParseNode.translateStyle(scalarEvent.getStyle());
                        Object val = this.stringFor(scalarEvent.getValue(), tainted, taintNode);
                        callScalarNode.call(frame, handler, "scalar", null, val, anchor, tag, plain_implicit, quoted_implicit, style2);
                        continue;
                    }
                    if (event.is(Event.ID.SequenceStart)) {
                        SequenceStartEvent sequenceStartEvent = (SequenceStartEvent)event;
                        anchor = this.stringOrNilFor(sequenceStartEvent.getAnchor(), tainted, taintNode);
                        tag = this.stringOrNilFor(sequenceStartEvent.getTag(), tainted, taintNode);
                        implicit = sequenceStartEvent.getImplicit();
                        style = ParseNode.translateFlowStyle(sequenceStartEvent.getFlowStyle());
                        callStartSequenceNode.call(frame, handler, "start_sequence", null, anchor, tag, implicit, style);
                        continue;
                    }
                    if (event.is(Event.ID.SequenceEnd)) {
                        callEndSequenceNode.call(frame, handler, "end_sequence", null, new Object[0]);
                        continue;
                    }
                    if (event.is(Event.ID.MappingStart)) {
                        MappingStartEvent mappingStartEvent = (MappingStartEvent)event;
                        anchor = this.stringOrNilFor(mappingStartEvent.getAnchor(), tainted, taintNode);
                        tag = this.stringOrNilFor(mappingStartEvent.getTag(), tainted, taintNode);
                        implicit = mappingStartEvent.getImplicit();
                        style = ParseNode.translateFlowStyle(mappingStartEvent.getFlowStyle());
                        callStartMappingNode.call(frame, handler, "start_mapping", null, anchor, tag, implicit, style);
                        continue;
                    }
                    if (event.is(Event.ID.MappingEnd)) {
                        callEndMappingNode.call(frame, handler, "end_mapping", null, new Object[0]);
                        continue;
                    }
                    if (event.is(Event.ID.StreamEnd)) break;
                }
                callEndStreamNode.call(frame, handler, "end_stream", null, new Object[0]);
            }
            catch (ParserException pe) {
                Mark mark = pe.getProblemMark();
                raiseSyntaxErrorSnippetNode.execute(frame, "raise Psych::SyntaxError.new(file, line, col, offset, problem, context)", "file", path, "line", mark.getLine(), "col", mark.getColumn(), "offset", mark.getIndex(), "problem", pe.getProblem() == null ? this.nil() : this.createString(new ByteList(pe.getProblem().getBytes(StandardCharsets.UTF_8))), "context", pe.getContext() == null ? this.nil() : this.createString(new ByteList(pe.getContext().getBytes(StandardCharsets.UTF_8))));
            }
            catch (ScannerException se) {
                Mark mark = se.getProblemMark();
                raiseSyntaxErrorSnippetNode.execute(frame, "raise Psych::SyntaxError.new(file, line, col, offset, problem, context)", "file", path, "line", mark.getLine(), "col", mark.getColumn(), "offset", mark.getIndex(), "problem", se.getProblem() == null ? this.nil() : this.createString(new ByteList(se.getProblem().getBytes(StandardCharsets.UTF_8))), "context", se.getContext() == null ? this.nil() : this.createString(new ByteList(se.getContext().getBytes(StandardCharsets.UTF_8))));
            }
            catch (ReaderException re) {
                raiseSyntaxErrorSnippetNode.execute(frame, "raise Psych::SyntaxError.new(file, line, col, offset, problem, context)", "file", path, "line", 0, "col", 0, "offset", re.getPosition(), "problem", re.getName() == null ? this.nil() : this.createString(new ByteList(re.getName().getBytes(StandardCharsets.UTF_8))), "context", re.toString() == null ? this.nil() : this.createString(new ByteList(re.toString().getBytes(StandardCharsets.UTF_8))));
            }
            catch (Throwable t) {
                Helpers.throwException((Throwable)t);
                return parserObject;
            }
            return parserObject;
        }

        protected ReadObjectFieldNode createReadHandlerNode() {
            return ReadObjectFieldNodeGen.create("@handler", this.nil());
        }

        protected TaintNode createTaintNode() {
            return TaintNodeGen.create(this.getContext(), null, null);
        }

        private static int translateStyle(Character style) {
            switch (style.charValue()) {
                case '\u0000': {
                    return 1;
                }
                case '\'': {
                    return 2;
                }
                case '\"': {
                    return 3;
                }
                case '|': {
                    return 4;
                }
                case '>': {
                    return 5;
                }
            }
            return 0;
        }

        private static int translateFlowStyle(Boolean flowStyle) {
            if (flowStyle == null) {
                return 0;
            }
            if (flowStyle.booleanValue()) {
                return 2;
            }
            return 1;
        }

        private Object stringOrNilFor(String value, boolean tainted, TaintNode taintNode) {
            if (value == null) {
                return this.nil();
            }
            return this.stringFor(value, tainted, taintNode);
        }

        private Object stringFor(String value, boolean tainted, TaintNode taintNode) {
            Encoding encoding = this.getContext().getJRubyRuntime().getDefaultInternalEncoding();
            if (encoding == null) {
                encoding = UTF8Encoding.INSTANCE;
            }
            Charset charset = RubyEncoding.UTF8;
            if (encoding.getCharset() != null) {
                charset = encoding.getCharset();
            }
            DynamicObject string = this.createString(value.getBytes(charset), encoding);
            if (tainted) {
                taintNode.executeTaint(string);
            }
            return string;
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode;

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateNode.allocate(rubyClass, null, null);
        }
    }
}

