/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.interop.ForeignWriteStringCachedHelperNode;
import org.jruby.truffle.interop.ForeignWriteStringCachedHelperNodeGen;
import org.jruby.truffle.interop.IsStringLikeNode;
import org.jruby.truffle.interop.ToJavaStringNode;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={StringCachingGuards.class})
@NodeChildren(value={@NodeChild(value="receiver"), @NodeChild(value="name"), @NodeChild(value="value")})
abstract class ForeignWriteStringCachingHelperNode
extends RubyNode {
    @Node.Child
    private IsStringLikeNode isStringLikeNode;

    public ForeignWriteStringCachingHelperNode(RubyContext context) {
        super(context, null);
    }

    public abstract Object executeStringCachingHelper(VirtualFrame var1, DynamicObject var2, Object var3, Object var4);

    @Specialization(guards={"isStringLike(name)"})
    public Object cacheStringLikeAndForward(VirtualFrame frame, DynamicObject receiver, Object name, Object value, @Cached(value="create()") ToJavaStringNode toJavaStringNode, @Cached(value="createNextHelper()") ForeignWriteStringCachedHelperNode nextHelper) {
        String nameAsJavaString = toJavaStringNode.executeToJavaString(name);
        boolean isIVar = this.isIVar(nameAsJavaString);
        return nextHelper.executeStringCachedHelper(frame, receiver, name, nameAsJavaString, isIVar, value);
    }

    @Specialization(guards={"!isStringLike(name)"})
    public Object passThroughNonString(VirtualFrame frame, DynamicObject receiver, Object name, Object value, @Cached(value="create()") ToJavaStringNode toJavaStringNode, @Cached(value="createNextHelper()") ForeignWriteStringCachedHelperNode nextHelper) {
        return nextHelper.executeStringCachedHelper(frame, receiver, name, null, false, value);
    }

    protected boolean isStringLike(Object value) {
        if (this.isStringLikeNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.isStringLikeNode = (IsStringLikeNode)this.insert(IsStringLikeNode.create());
        }
        return this.isStringLikeNode.executeIsStringLike(value);
    }

    protected boolean isIVar(String name) {
        return !name.isEmpty() && name.charAt(0) == '@';
    }

    protected ForeignWriteStringCachedHelperNode createNextHelper() {
        return ForeignWriteStringCachedHelperNodeGen.create(null, null, null, null, null);
    }
}

