/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.hash.HashGuards;
import org.jruby.truffle.core.hash.SetNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=SetNode.class)
public final class SetNodeGen
extends SetNode
implements SpecializedNode {
    @Node.Child
    private RubyNode hash_;
    @Node.Child
    private RubyNode key_;
    @Node.Child
    private RubyNode value_;
    @Node.Child
    private RubyNode byIdentity_;
    @CompilerDirectives.CompilationFinal
    private Class<?> byIdentityType_;
    @Node.Child
    private BaseNode_ specialization_;

    private SetNodeGen(RubyContext context, SourceSection sourceSection, RubyNode hash, RubyNode key, RubyNode value, RubyNode byIdentity) {
        super(context, sourceSection);
        this.hash_ = hash;
        this.key_ = key;
        this.value_ = value;
        this.byIdentity_ = byIdentity;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeSet(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
        return this.specialization_.execute1(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static SetNode create(RubyContext context, SourceSection sourceSection, RubyNode hash, RubyNode key, RubyNode value, RubyNode byIdentity) {
        return new SetNodeGen(context, sourceSection, hash, key, value, byIdentity);
    }

    @GeneratedBy(methodName="setBucketsNotByIdentity(VirtualFrame, DynamicObject, DynamicObject, Object, boolean)", value=SetNode.class)
    private static final class SetBucketsNotByIdentityNode_
    extends BaseNode_ {
        SetBucketsNotByIdentityNode_(SetNodeGen root) {
            super(root, 9);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            boolean byIdentityValue_;
            DynamicObject keyValue_;
            DynamicObject hashValue_;
            try {
                hashValue_ = this.root.hash_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object keyValue = this.root.key_.execute(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), keyValue, valueValue, byIdentityValue);
            }
            try {
                keyValue_ = this.root.key_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_((Frame)frameValue);
                return this.getNext().execute_(frameValue, hashValue_, ex.getResult(), valueValue, byIdentityValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            try {
                byIdentityValue_ = this.root.byIdentity_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, ex.getResult());
            }
            if (HashGuards.isBucketHash(hashValue_) && !byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                return this.root.setBucketsNotByIdentity(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
            }
            return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
            if (keyValue instanceof DynamicObject) {
                DynamicObject keyValue_ = (DynamicObject)keyValue;
                if (HashGuards.isBucketHash(hashValue) && !byIdentityValue && RubyGuards.isRubyString(keyValue_)) {
                    return this.root.setBucketsNotByIdentity(frameValue, hashValue, keyValue_, valueValue, byIdentityValue);
                }
            }
            return this.getNext().execute1(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            if (hashValue instanceof DynamicObject && keyValue instanceof DynamicObject && byIdentityValue instanceof Boolean) {
                DynamicObject hashValue_ = (DynamicObject)hashValue;
                DynamicObject keyValue_ = (DynamicObject)keyValue;
                boolean byIdentityValue_ = (Boolean)byIdentityValue;
                if (HashGuards.isBucketHash(hashValue_) && !byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                    return this.root.setBucketsNotByIdentity(frameValue, hashValue_, keyValue_, valueValue, byIdentityValue_);
                }
            }
            return this.getNext().execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root) {
            return new SetBucketsNotByIdentityNode_(root);
        }
    }

    @GeneratedBy(methodName="setBucketsByIdentity(VirtualFrame, DynamicObject, DynamicObject, Object, boolean)", value=SetNode.class)
    private static final class SetBucketsByIdentityNode_
    extends BaseNode_ {
        SetBucketsByIdentityNode_(SetNodeGen root) {
            super(root, 8);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            boolean byIdentityValue_;
            DynamicObject keyValue_;
            DynamicObject hashValue_;
            try {
                hashValue_ = this.root.hash_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object keyValue = this.root.key_.execute(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), keyValue, valueValue, byIdentityValue);
            }
            try {
                keyValue_ = this.root.key_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_((Frame)frameValue);
                return this.getNext().execute_(frameValue, hashValue_, ex.getResult(), valueValue, byIdentityValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            try {
                byIdentityValue_ = this.root.byIdentity_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, ex.getResult());
            }
            if (HashGuards.isBucketHash(hashValue_) && byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                return this.root.setBucketsByIdentity(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
            }
            return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
            if (keyValue instanceof DynamicObject) {
                DynamicObject keyValue_ = (DynamicObject)keyValue;
                if (HashGuards.isBucketHash(hashValue) && byIdentityValue && RubyGuards.isRubyString(keyValue_)) {
                    return this.root.setBucketsByIdentity(frameValue, hashValue, keyValue_, valueValue, byIdentityValue);
                }
            }
            return this.getNext().execute1(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            if (hashValue instanceof DynamicObject && keyValue instanceof DynamicObject && byIdentityValue instanceof Boolean) {
                DynamicObject hashValue_ = (DynamicObject)hashValue;
                DynamicObject keyValue_ = (DynamicObject)keyValue;
                boolean byIdentityValue_ = (Boolean)byIdentityValue;
                if (HashGuards.isBucketHash(hashValue_) && byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                    return this.root.setBucketsByIdentity(frameValue, hashValue_, keyValue_, valueValue, byIdentityValue_);
                }
            }
            return this.getNext().execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root) {
            return new SetBucketsByIdentityNode_(root);
        }
    }

    @GeneratedBy(methodName="setBuckets(VirtualFrame, DynamicObject, Object, Object, boolean)", value=SetNode.class)
    private static final class SetBucketsNode_
    extends BaseNode_ {
        SetBucketsNode_(SetNodeGen root) {
            super(root, 7);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            boolean byIdentityValue_;
            DynamicObject hashValue_;
            try {
                hashValue_ = this.root.hash_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object keyValue = this.root.key_.execute(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), keyValue, valueValue, byIdentityValue);
            }
            Object keyValue_ = this.root.key_.execute(frameValue);
            Object valueValue_ = this.root.value_.execute(frameValue);
            try {
                byIdentityValue_ = this.root.byIdentity_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, ex.getResult());
            }
            if (HashGuards.isBucketHash(hashValue_) && !RubyGuards.isRubyString(keyValue_)) {
                return this.root.setBuckets(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
            }
            return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
            if (HashGuards.isBucketHash(hashValue) && !RubyGuards.isRubyString(keyValue)) {
                return this.root.setBuckets(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
            }
            return this.getNext().execute1(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            if (hashValue instanceof DynamicObject && byIdentityValue instanceof Boolean) {
                DynamicObject hashValue_ = (DynamicObject)hashValue;
                boolean byIdentityValue_ = (Boolean)byIdentityValue;
                if (HashGuards.isBucketHash(hashValue_) && !RubyGuards.isRubyString(keyValue)) {
                    return this.root.setBuckets(frameValue, hashValue_, keyValue, valueValue, byIdentityValue_);
                }
            }
            return this.getNext().execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root) {
            return new SetBucketsNode_(root);
        }
    }

    @GeneratedBy(methodName="setPackedArrayNotByIdentity(VirtualFrame, DynamicObject, DynamicObject, Object, boolean)", value=SetNode.class)
    private static final class SetPackedArrayNotByIdentityNode_
    extends BaseNode_ {
        SetPackedArrayNotByIdentityNode_(SetNodeGen root) {
            super(root, 6);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            boolean byIdentityValue_;
            DynamicObject keyValue_;
            DynamicObject hashValue_;
            try {
                hashValue_ = this.root.hash_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object keyValue = this.root.key_.execute(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), keyValue, valueValue, byIdentityValue);
            }
            try {
                keyValue_ = this.root.key_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_((Frame)frameValue);
                return this.getNext().execute_(frameValue, hashValue_, ex.getResult(), valueValue, byIdentityValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            try {
                byIdentityValue_ = this.root.byIdentity_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, ex.getResult());
            }
            if (HashGuards.isPackedHash(hashValue_) && !byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                return this.root.setPackedArrayNotByIdentity(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
            }
            return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
            if (keyValue instanceof DynamicObject) {
                DynamicObject keyValue_ = (DynamicObject)keyValue;
                if (HashGuards.isPackedHash(hashValue) && !byIdentityValue && RubyGuards.isRubyString(keyValue_)) {
                    return this.root.setPackedArrayNotByIdentity(frameValue, hashValue, keyValue_, valueValue, byIdentityValue);
                }
            }
            return this.getNext().execute1(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            if (hashValue instanceof DynamicObject && keyValue instanceof DynamicObject && byIdentityValue instanceof Boolean) {
                DynamicObject hashValue_ = (DynamicObject)hashValue;
                DynamicObject keyValue_ = (DynamicObject)keyValue;
                boolean byIdentityValue_ = (Boolean)byIdentityValue;
                if (HashGuards.isPackedHash(hashValue_) && !byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                    return this.root.setPackedArrayNotByIdentity(frameValue, hashValue_, keyValue_, valueValue, byIdentityValue_);
                }
            }
            return this.getNext().execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root) {
            return new SetPackedArrayNotByIdentityNode_(root);
        }
    }

    @GeneratedBy(methodName="setPackedArrayByIdentity(VirtualFrame, DynamicObject, DynamicObject, Object, boolean)", value=SetNode.class)
    private static final class SetPackedArrayByIdentityNode_
    extends BaseNode_ {
        SetPackedArrayByIdentityNode_(SetNodeGen root) {
            super(root, 5);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            boolean byIdentityValue_;
            DynamicObject keyValue_;
            DynamicObject hashValue_;
            try {
                hashValue_ = this.root.hash_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object keyValue = this.root.key_.execute(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), keyValue, valueValue, byIdentityValue);
            }
            try {
                keyValue_ = this.root.key_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_((Frame)frameValue);
                return this.getNext().execute_(frameValue, hashValue_, ex.getResult(), valueValue, byIdentityValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            try {
                byIdentityValue_ = this.root.byIdentity_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, ex.getResult());
            }
            if (HashGuards.isPackedHash(hashValue_) && byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                return this.root.setPackedArrayByIdentity(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
            }
            return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
            if (keyValue instanceof DynamicObject) {
                DynamicObject keyValue_ = (DynamicObject)keyValue;
                if (HashGuards.isPackedHash(hashValue) && byIdentityValue && RubyGuards.isRubyString(keyValue_)) {
                    return this.root.setPackedArrayByIdentity(frameValue, hashValue, keyValue_, valueValue, byIdentityValue);
                }
            }
            return this.getNext().execute1(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            if (hashValue instanceof DynamicObject && keyValue instanceof DynamicObject && byIdentityValue instanceof Boolean) {
                DynamicObject hashValue_ = (DynamicObject)hashValue;
                DynamicObject keyValue_ = (DynamicObject)keyValue;
                boolean byIdentityValue_ = (Boolean)byIdentityValue;
                if (HashGuards.isPackedHash(hashValue_) && byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                    return this.root.setPackedArrayByIdentity(frameValue, hashValue_, keyValue_, valueValue, byIdentityValue_);
                }
            }
            return this.getNext().execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root) {
            return new SetPackedArrayByIdentityNode_(root);
        }
    }

    @GeneratedBy(methodName="setPackedArray(VirtualFrame, DynamicObject, Object, Object, boolean)", value=SetNode.class)
    private static final class SetPackedArrayNode_
    extends BaseNode_ {
        SetPackedArrayNode_(SetNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            boolean byIdentityValue_;
            DynamicObject hashValue_;
            try {
                hashValue_ = this.root.hash_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object keyValue = this.root.key_.execute(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), keyValue, valueValue, byIdentityValue);
            }
            Object keyValue_ = this.root.key_.execute(frameValue);
            Object valueValue_ = this.root.value_.execute(frameValue);
            try {
                byIdentityValue_ = this.root.byIdentity_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, ex.getResult());
            }
            if (HashGuards.isPackedHash(hashValue_) && !RubyGuards.isRubyString(keyValue_)) {
                return this.root.setPackedArray(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
            }
            return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
            if (HashGuards.isPackedHash(hashValue) && !RubyGuards.isRubyString(keyValue)) {
                return this.root.setPackedArray(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
            }
            return this.getNext().execute1(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            if (hashValue instanceof DynamicObject && byIdentityValue instanceof Boolean) {
                DynamicObject hashValue_ = (DynamicObject)hashValue;
                boolean byIdentityValue_ = (Boolean)byIdentityValue;
                if (HashGuards.isPackedHash(hashValue_) && !RubyGuards.isRubyString(keyValue)) {
                    return this.root.setPackedArray(frameValue, hashValue_, keyValue, valueValue, byIdentityValue_);
                }
            }
            return this.getNext().execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root) {
            return new SetPackedArrayNode_(root);
        }
    }

    @GeneratedBy(methodName="setNullNotByIdentity(VirtualFrame, DynamicObject, DynamicObject, Object, boolean)", value=SetNode.class)
    private static final class SetNullNotByIdentityNode_
    extends BaseNode_ {
        SetNullNotByIdentityNode_(SetNodeGen root) {
            super(root, 3);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            boolean byIdentityValue_;
            DynamicObject keyValue_;
            DynamicObject hashValue_;
            try {
                hashValue_ = this.root.hash_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object keyValue = this.root.key_.execute(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), keyValue, valueValue, byIdentityValue);
            }
            try {
                keyValue_ = this.root.key_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_((Frame)frameValue);
                return this.getNext().execute_(frameValue, hashValue_, ex.getResult(), valueValue, byIdentityValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            try {
                byIdentityValue_ = this.root.byIdentity_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, ex.getResult());
            }
            if (HashGuards.isNullHash(hashValue_) && !byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                return this.root.setNullNotByIdentity(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
            }
            return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
            if (keyValue instanceof DynamicObject) {
                DynamicObject keyValue_ = (DynamicObject)keyValue;
                if (HashGuards.isNullHash(hashValue) && !byIdentityValue && RubyGuards.isRubyString(keyValue_)) {
                    return this.root.setNullNotByIdentity(frameValue, hashValue, keyValue_, valueValue, byIdentityValue);
                }
            }
            return this.getNext().execute1(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            if (hashValue instanceof DynamicObject && keyValue instanceof DynamicObject && byIdentityValue instanceof Boolean) {
                DynamicObject hashValue_ = (DynamicObject)hashValue;
                DynamicObject keyValue_ = (DynamicObject)keyValue;
                boolean byIdentityValue_ = (Boolean)byIdentityValue;
                if (HashGuards.isNullHash(hashValue_) && !byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                    return this.root.setNullNotByIdentity(frameValue, hashValue_, keyValue_, valueValue, byIdentityValue_);
                }
            }
            return this.getNext().execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root) {
            return new SetNullNotByIdentityNode_(root);
        }
    }

    @GeneratedBy(methodName="setNullByIdentity(VirtualFrame, DynamicObject, DynamicObject, Object, boolean)", value=SetNode.class)
    private static final class SetNullByIdentityNode_
    extends BaseNode_ {
        SetNullByIdentityNode_(SetNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            boolean byIdentityValue_;
            DynamicObject keyValue_;
            DynamicObject hashValue_;
            try {
                hashValue_ = this.root.hash_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object keyValue = this.root.key_.execute(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), keyValue, valueValue, byIdentityValue);
            }
            try {
                keyValue_ = this.root.key_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_((Frame)frameValue);
                return this.getNext().execute_(frameValue, hashValue_, ex.getResult(), valueValue, byIdentityValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            try {
                byIdentityValue_ = this.root.byIdentity_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, ex.getResult());
            }
            if (HashGuards.isNullHash(hashValue_) && byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                return this.root.setNullByIdentity(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
            }
            return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
            if (keyValue instanceof DynamicObject) {
                DynamicObject keyValue_ = (DynamicObject)keyValue;
                if (HashGuards.isNullHash(hashValue) && byIdentityValue && RubyGuards.isRubyString(keyValue_)) {
                    return this.root.setNullByIdentity(frameValue, hashValue, keyValue_, valueValue, byIdentityValue);
                }
            }
            return this.getNext().execute1(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            if (hashValue instanceof DynamicObject && keyValue instanceof DynamicObject && byIdentityValue instanceof Boolean) {
                DynamicObject hashValue_ = (DynamicObject)hashValue;
                DynamicObject keyValue_ = (DynamicObject)keyValue;
                boolean byIdentityValue_ = (Boolean)byIdentityValue;
                if (HashGuards.isNullHash(hashValue_) && byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                    return this.root.setNullByIdentity(frameValue, hashValue_, keyValue_, valueValue, byIdentityValue_);
                }
            }
            return this.getNext().execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root) {
            return new SetNullByIdentityNode_(root);
        }
    }

    @GeneratedBy(methodName="setNull(VirtualFrame, DynamicObject, Object, Object, boolean)", value=SetNode.class)
    private static final class SetNullNode_
    extends BaseNode_ {
        SetNullNode_(SetNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            boolean byIdentityValue_;
            DynamicObject hashValue_;
            try {
                hashValue_ = this.root.hash_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object keyValue = this.root.key_.execute(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), keyValue, valueValue, byIdentityValue);
            }
            Object keyValue_ = this.root.key_.execute(frameValue);
            Object valueValue_ = this.root.value_.execute(frameValue);
            try {
                byIdentityValue_ = this.root.byIdentity_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, ex.getResult());
            }
            if (HashGuards.isNullHash(hashValue_) && !RubyGuards.isRubyString(keyValue_)) {
                return this.root.setNull(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
            }
            return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
            if (HashGuards.isNullHash(hashValue) && !RubyGuards.isRubyString(keyValue)) {
                return this.root.setNull(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
            }
            return this.getNext().execute1(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            if (hashValue instanceof DynamicObject && byIdentityValue instanceof Boolean) {
                DynamicObject hashValue_ = (DynamicObject)hashValue;
                boolean byIdentityValue_ = (Boolean)byIdentityValue;
                if (HashGuards.isNullHash(hashValue_) && !RubyGuards.isRubyString(keyValue)) {
                    return this.root.setNull(frameValue, hashValue_, keyValue, valueValue, byIdentityValue_);
                }
            }
            return this.getNext().execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root) {
            return new SetNullNode_(root);
        }
    }

    @GeneratedBy(value=SetNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(SetNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, hashValue, keyValue, valueValue, byIdentityValue));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            return this.getNext().execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=SetNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(SetNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            return this.uninitialized((Frame)frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=SetNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected SetNodeGen root;

        BaseNode_(SetNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (SetNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.hash_, this.root.key_, this.root.value_, this.root.byIdentity_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            return this.execute_((VirtualFrame)frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

        public Object execute1(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
            return this.execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object hashValue_ = this.root.hash_.execute(frameValue);
            Object keyValue_ = this.root.key_.execute(frameValue);
            Object valueValue_ = this.root.value_.execute(frameValue);
            Object byIdentityValue_ = this.executeByIdentity_((Frame)frameValue);
            return this.execute_(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            if (hashValue instanceof DynamicObject && byIdentityValue instanceof Boolean) {
                DynamicObject keyValue_;
                DynamicObject hashValue_ = (DynamicObject)hashValue;
                boolean byIdentityValue_ = (Boolean)byIdentityValue;
                if (HashGuards.isNullHash(hashValue_) && !RubyGuards.isRubyString(keyValue)) {
                    return SetNullNode_.create(this.root);
                }
                if (keyValue instanceof DynamicObject) {
                    keyValue_ = (DynamicObject)keyValue;
                    if (HashGuards.isNullHash(hashValue_) && byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                        return SetNullByIdentityNode_.create(this.root);
                    }
                    if (HashGuards.isNullHash(hashValue_) && !byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                        return SetNullNotByIdentityNode_.create(this.root);
                    }
                }
                if (HashGuards.isPackedHash(hashValue_) && !RubyGuards.isRubyString(keyValue)) {
                    return SetPackedArrayNode_.create(this.root);
                }
                if (keyValue instanceof DynamicObject) {
                    keyValue_ = (DynamicObject)keyValue;
                    if (HashGuards.isPackedHash(hashValue_) && byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                        return SetPackedArrayByIdentityNode_.create(this.root);
                    }
                    if (HashGuards.isPackedHash(hashValue_) && !byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                        return SetPackedArrayNotByIdentityNode_.create(this.root);
                    }
                }
                if (HashGuards.isBucketHash(hashValue_) && !RubyGuards.isRubyString(keyValue)) {
                    return SetBucketsNode_.create(this.root);
                }
                if (keyValue instanceof DynamicObject) {
                    keyValue_ = (DynamicObject)keyValue;
                    if (HashGuards.isBucketHash(hashValue_) && byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                        return SetBucketsByIdentityNode_.create(this.root);
                    }
                    if (HashGuards.isBucketHash(hashValue_) && !byIdentityValue_ && RubyGuards.isRubyString(keyValue_)) {
                        return SetBucketsNotByIdentityNode_.create(this.root);
                    }
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeByIdentity_(Frame frameValue) {
            Object object;
            Class byIdentityType_ = this.root.byIdentityType_;
            if (byIdentityType_ == Boolean.TYPE) {
                return this.root.byIdentity_.executeBoolean((VirtualFrame)frameValue);
            }
            if (byIdentityType_ != null) return this.root.byIdentity_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.byIdentity_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.byIdentityType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.byIdentityType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.byIdentityType_ = _type;
            return object;
        }
    }
}

