/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayReadSliceNormalizedNode;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
public final class ArrayReadSliceNormalizedNodeGen
extends ArrayReadSliceNormalizedNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode index_;
    @Node.Child
    private RubyNode length_;
    @CompilerDirectives.CompilationFinal
    private Class<?> indexType_;
    @CompilerDirectives.CompilationFinal
    private Class<?> lengthType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayReadSliceNormalizedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode length) {
        super(context, sourceSection);
        this.array_ = array;
        this.index_ = index;
        this.length_ = length;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public DynamicObject executeReadSlice(DynamicObject arrayValue, int indexValue, int lengthValue) {
        return this.specialization_.executeDynamicObject1(arrayValue, indexValue, lengthValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
        return this.specialization_.executeDynamicObject0(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static ArrayReadSliceNormalizedNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode length) {
        return new ArrayReadSliceNormalizedNodeGen(context, sourceSection, array, index, length);
    }

    @GeneratedBy(methodName="readOutOfBounds(DynamicObject, int, int, ArrayStrategy)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadOutOfBoundsNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;
        private final Class<?> indexImplicitType;
        private final Class<?> lengthImplicitType;

        ReadOutOfBoundsNode_(ArrayReadSliceNormalizedNodeGen root, Object indexValue, Object lengthValue, ArrayStrategy strategy) {
            super(root, 5);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.lengthImplicitType = RubyTypesGen.getImplicitIntegerClass(lengthValue);
            this.strategy = strategy;
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((ReadOutOfBoundsNode_)other).indexImplicitType && this.lengthImplicitType == ((ReadOutOfBoundsNode_)other).lengthImplicitType;
        }

        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitInteger(lengthValue, this.lengthImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                int lengthValue_ = RubyTypesGen.asImplicitInteger(lengthValue, this.lengthImplicitType);
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && this.strategy.matches(arrayValue_)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object lengthValue = this.executeLength_((Frame)frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_((Frame)frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                if (this.lengthImplicitType == Integer.TYPE) {
                    lengthValue_ = this.root.length_.executeInteger(frameValue);
                } else {
                    Object lengthValue__ = this.executeLength_((Frame)frameValue);
                    lengthValue_ = RubyTypesGen.expectImplicitInteger(lengthValue__, this.lengthImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && this.strategy.matches(arrayValue_)) {
                return this.root.readOutOfBounds(arrayValue_, indexValue_, lengthValue_, this.strategy);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValue, indexValue) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue, indexValue, lengthValue) && this.strategy.matches(arrayValue)) {
                return this.root.readOutOfBounds(arrayValue, indexValue, lengthValue, this.strategy);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitInteger(lengthValue, this.lengthImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                int lengthValue_ = RubyTypesGen.asImplicitInteger(lengthValue, this.lengthImplicitType);
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && this.strategy.matches(arrayValue_)) {
                    return this.root.readOutOfBounds(arrayValue_, indexValue_, lengthValue_, this.strategy);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root, Object indexValue, Object lengthValue, ArrayStrategy strategy) {
            return new ReadOutOfBoundsNode_(root, indexValue, lengthValue, strategy);
        }
    }

    @GeneratedBy(methodName="readInBounds(DynamicObject, int, int, ArrayStrategy)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadInBoundsNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;
        private final Class<?> indexImplicitType;
        private final Class<?> lengthImplicitType;

        ReadInBoundsNode_(ArrayReadSliceNormalizedNodeGen root, Object indexValue, Object lengthValue, ArrayStrategy strategy) {
            super(root, 4);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.lengthImplicitType = RubyTypesGen.getImplicitIntegerClass(lengthValue);
            this.strategy = strategy;
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((ReadInBoundsNode_)other).indexImplicitType && this.lengthImplicitType == ((ReadInBoundsNode_)other).lengthImplicitType;
        }

        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitInteger(lengthValue, this.lengthImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                int lengthValue_ = RubyTypesGen.asImplicitInteger(lengthValue, this.lengthImplicitType);
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && this.strategy.matches(arrayValue_)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object lengthValue = this.executeLength_((Frame)frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_((Frame)frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                if (this.lengthImplicitType == Integer.TYPE) {
                    lengthValue_ = this.root.length_.executeInteger(frameValue);
                } else {
                    Object lengthValue__ = this.executeLength_((Frame)frameValue);
                    lengthValue_ = RubyTypesGen.expectImplicitInteger(lengthValue__, this.lengthImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && this.strategy.matches(arrayValue_)) {
                return this.root.readInBounds(arrayValue_, indexValue_, lengthValue_, this.strategy);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValue, indexValue) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue, indexValue, lengthValue) && this.strategy.matches(arrayValue)) {
                return this.root.readInBounds(arrayValue, indexValue, lengthValue, this.strategy);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitInteger(lengthValue, this.lengthImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                int lengthValue_ = RubyTypesGen.asImplicitInteger(lengthValue, this.lengthImplicitType);
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && this.strategy.matches(arrayValue_)) {
                    return this.root.readInBounds(arrayValue_, indexValue_, lengthValue_, this.strategy);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root, Object indexValue, Object lengthValue, ArrayStrategy strategy) {
            return new ReadInBoundsNode_(root, indexValue, lengthValue, strategy);
        }
    }

    @GeneratedBy(methodName="readNull(DynamicObject, int, int)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadNullNode_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;
        private final Class<?> lengthImplicitType;

        ReadNullNode_(ArrayReadSliceNormalizedNodeGen root, Object indexValue, Object lengthValue) {
            super(root, 3);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.lengthImplicitType = RubyTypesGen.getImplicitIntegerClass(lengthValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((ReadNullNode_)other).indexImplicitType && this.lengthImplicitType == ((ReadNullNode_)other).lengthImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object lengthValue = this.executeLength_((Frame)frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_((Frame)frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                if (this.lengthImplicitType == Integer.TYPE) {
                    lengthValue_ = this.root.length_.executeInteger(frameValue);
                } else {
                    Object lengthValue__ = this.executeLength_((Frame)frameValue);
                    lengthValue_ = RubyTypesGen.expectImplicitInteger(lengthValue__, this.lengthImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayGuards.isNullArray(arrayValue_)) {
                return this.root.readNull(arrayValue_, indexValue_, lengthValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValue, indexValue) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue) && ArrayGuards.isNullArray(arrayValue)) {
                return this.root.readNull(arrayValue, indexValue, lengthValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitInteger(lengthValue, this.lengthImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                int lengthValue_ = RubyTypesGen.asImplicitInteger(lengthValue, this.lengthImplicitType);
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayGuards.isNullArray(arrayValue_)) {
                    return this.root.readNull(arrayValue_, indexValue_, lengthValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root, Object indexValue, Object lengthValue) {
            return new ReadNullNode_(root, indexValue, lengthValue);
        }
    }

    @GeneratedBy(methodName="readNegativeLength(DynamicObject, int, int)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadNegativeLengthNode_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;
        private final Class<?> lengthImplicitType;

        ReadNegativeLengthNode_(ArrayReadSliceNormalizedNodeGen root, Object indexValue, Object lengthValue) {
            super(root, 2);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.lengthImplicitType = RubyTypesGen.getImplicitIntegerClass(lengthValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((ReadNegativeLengthNode_)other).indexImplicitType && this.lengthImplicitType == ((ReadNegativeLengthNode_)other).lengthImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object lengthValue = this.executeLength_((Frame)frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_((Frame)frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                if (this.lengthImplicitType == Integer.TYPE) {
                    lengthValue_ = this.root.length_.executeInteger(frameValue);
                } else {
                    Object lengthValue__ = this.executeLength_((Frame)frameValue);
                    lengthValue_ = RubyTypesGen.expectImplicitInteger(lengthValue__, this.lengthImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (!ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_)) {
                return this.root.readNegativeLength(arrayValue_, indexValue_, lengthValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (!ArrayReadSliceNormalizedNode.lengthPositive(lengthValue)) {
                return this.root.readNegativeLength(arrayValue, indexValue, lengthValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitInteger(lengthValue, this.lengthImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                int lengthValue_ = RubyTypesGen.asImplicitInteger(lengthValue, this.lengthImplicitType);
                if (!ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_)) {
                    return this.root.readNegativeLength(arrayValue_, indexValue_, lengthValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root, Object indexValue, Object lengthValue) {
            return new ReadNegativeLengthNode_(root, indexValue, lengthValue);
        }
    }

    @GeneratedBy(methodName="readIndexOutOfBounds(DynamicObject, int, int)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadIndexOutOfBoundsNode_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;
        private final Class<?> lengthImplicitType;

        ReadIndexOutOfBoundsNode_(ArrayReadSliceNormalizedNodeGen root, Object indexValue, Object lengthValue) {
            super(root, 1);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.lengthImplicitType = RubyTypesGen.getImplicitIntegerClass(lengthValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((ReadIndexOutOfBoundsNode_)other).indexImplicitType && this.lengthImplicitType == ((ReadIndexOutOfBoundsNode_)other).lengthImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object lengthValue = this.executeLength_((Frame)frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_((Frame)frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                if (this.lengthImplicitType == Integer.TYPE) {
                    lengthValue_ = this.root.length_.executeInteger(frameValue);
                } else {
                    Object lengthValue__ = this.executeLength_((Frame)frameValue);
                    lengthValue_ = RubyTypesGen.expectImplicitInteger(lengthValue__, this.lengthImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (!ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_)) {
                return this.root.readIndexOutOfBounds(arrayValue_, indexValue_, lengthValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (!ArrayReadSliceNormalizedNode.indexInBounds(arrayValue, indexValue)) {
                return this.root.readIndexOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitInteger(lengthValue, this.lengthImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                int lengthValue_ = RubyTypesGen.asImplicitInteger(lengthValue, this.lengthImplicitType);
                if (!ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_)) {
                    return this.root.readIndexOutOfBounds(arrayValue_, indexValue_, lengthValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root, Object indexValue, Object lengthValue) {
            return new ReadIndexOutOfBoundsNode_(root, indexValue, lengthValue);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayReadSliceNormalizedNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, indexValue, lengthValue));
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayReadSliceNormalizedNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            return (DynamicObject)this.uninitialized(null, arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayReadSliceNormalizedNodeGen root;

        BaseNode_(ArrayReadSliceNormalizedNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (ArrayReadSliceNormalizedNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.index_, this.root.length_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            return this.executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        public abstract DynamicObject executeDynamicObject_(Object var1, Object var2, Object var3);

        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            return this.executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        public Object execute(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object indexValue_ = this.executeIndex_((Frame)frameValue);
            Object lengthValue_ = this.executeLength_((Frame)frameValue);
            return this.executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            return (DynamicObject)this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue) && RubyTypesGen.isImplicitInteger(lengthValue)) {
                BaseNode_ s;
                BaseNode_ s2;
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue);
                int lengthValue_ = RubyTypesGen.asImplicitInteger(lengthValue);
                if (!ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_)) {
                    return ReadIndexOutOfBoundsNode_.create(this.root, indexValue, lengthValue);
                }
                if (!ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_)) {
                    return ReadNegativeLengthNode_.create(this.root, indexValue, lengthValue);
                }
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayGuards.isNullArray(arrayValue_)) {
                    return ReadNullNode_.create(this.root, indexValue, lengthValue);
                }
                ArrayStrategy strategy4 = ArrayStrategy.of(arrayValue_);
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && strategy4.matches(arrayValue_) && this.countSame(s2 = ReadInBoundsNode_.create(this.root, indexValue, lengthValue, strategy4)) < 25) {
                    return s2;
                }
                ArrayStrategy strategy5 = ArrayStrategy.of(arrayValue_);
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && strategy5.matches(arrayValue_) && this.countSame(s = ReadOutOfBoundsNode_.create(this.root, indexValue, lengthValue, strategy5)) < 25) {
                    return s;
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeIndex_(Frame frameValue) {
            Object object;
            Class indexType_ = this.root.indexType_;
            if (indexType_ == Integer.TYPE) {
                return this.root.index_.executeInteger((VirtualFrame)frameValue);
            }
            if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.indexType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.indexType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.indexType_ = _type;
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeLength_(Frame frameValue) {
            Object object;
            Class lengthType_ = this.root.lengthType_;
            if (lengthType_ == Integer.TYPE) {
                return this.root.length_.executeInteger((VirtualFrame)frameValue);
            }
            if (lengthType_ != null) return this.root.length_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.length_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.lengthType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.lengthType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.lengthType_ = _type;
            return object;
        }
    }
}

