/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayGetTailNode;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=ArrayGetTailNode.class)
public final class ArrayGetTailNodeGen
extends ArrayGetTailNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayGetTailNodeGen(RubyContext context, SourceSection sourceSection, int index, RubyNode array) {
        super(context, sourceSection, index);
        this.array_ = array;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static ArrayGetTailNode create(RubyContext context, SourceSection sourceSection, int index, RubyNode array) {
        return new ArrayGetTailNodeGen(context, sourceSection, index, array);
    }

    @GeneratedBy(methodName="getTail(DynamicObject, ArrayStrategy, ConditionProfile)", value=ArrayGetTailNode.class)
    private static final class GetTailNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;
        private final ConditionProfile indexLargerThanSize;

        GetTailNode_(ArrayGetTailNodeGen root, ArrayStrategy strategy, ConditionProfile indexLargerThanSize) {
            super(root, 2);
            this.strategy = strategy;
            this.indexLargerThanSize = indexLargerThanSize;
        }

        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            return arrayValue instanceof DynamicObject && this.strategy.matches(arrayValue_ = (DynamicObject)arrayValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && this.strategy.matches(arrayValue_ = (DynamicObject)arrayValue)) {
                return this.root.getTail(arrayValue_, this.strategy, this.indexLargerThanSize);
            }
            return this.getNext().executeDynamicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArrayGetTailNodeGen root, ArrayStrategy strategy, ConditionProfile indexLargerThanSize) {
            return new GetTailNode_(root, strategy, indexLargerThanSize);
        }
    }

    @GeneratedBy(methodName="getTailNull(DynamicObject)", value=ArrayGetTailNode.class)
    private static final class GetTailNullNode_
    extends BaseNode_ {
        GetTailNullNode_(ArrayGetTailNodeGen root) {
            super(root, 1);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && ArrayGuards.isNullArray(arrayValue_ = (DynamicObject)arrayValue)) {
                return this.root.getTailNull(arrayValue_);
            }
            return this.getNext().executeDynamicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArrayGetTailNodeGen root) {
            return new GetTailNullNode_(root);
        }
    }

    @GeneratedBy(value=ArrayGetTailNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayGetTailNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue));
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            return this.getNext().executeDynamicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArrayGetTailNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayGetTailNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayGetTailNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            return (DynamicObject)this.uninitialized((Frame)frameValue, arrayValue);
        }

        static BaseNode_ create(ArrayGetTailNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayGetTailNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayGetTailNodeGen root;

        BaseNode_(ArrayGetTailNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (ArrayGetTailNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object arrayValue) {
            return this.executeDynamicObject_((VirtualFrame)frameValue, arrayValue);
        }

        public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

        public Object execute(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            return this.executeDynamicObject_(frameValue, arrayValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue) {
            if (arrayValue instanceof DynamicObject) {
                ConditionProfile indexLargerThanSize2;
                BaseNode_ s;
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                if (ArrayGuards.isNullArray(arrayValue_)) {
                    return GetTailNullNode_.create(this.root);
                }
                ArrayStrategy strategy2 = ArrayStrategy.of(arrayValue_);
                if (strategy2.matches(arrayValue_) && this.countSame(s = GetTailNode_.create(this.root, strategy2, indexLargerThanSize2 = ConditionProfile.createBinaryProfile())) < 25) {
                    return s;
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

