/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.constants;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;

public class WriteConstantNode
extends RubyNode {
    private final String name;
    @Node.Child
    private RubyNode module;
    @Node.Child
    private RubyNode rhs;

    public WriteConstantNode(RubyContext context, SourceSection sourceSection, String name, RubyNode module, RubyNode rhs) {
        super(context, sourceSection);
        this.name = name;
        this.module = module;
        this.rhs = rhs;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        Object rhsValue = this.rhs.execute(frame);
        Object receiverObject = this.module.execute(frame);
        if (!RubyGuards.isRubyModule(receiverObject)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.coreExceptions().typeErrorIsNotA(receiverObject.toString(), "class/module", (Node)this));
        }
        DynamicObject module = (DynamicObject)receiverObject;
        Layouts.MODULE.getFields(module).setConstant(this.getContext(), this, this.name, rhsValue);
        return rhsValue;
    }
}

