/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.rubinius.IOBufferLayout;

@GeneratedBy(value=IOBufferLayout.class)
public class IOBufferLayoutImpl
extends BasicObjectLayoutImpl
implements IOBufferLayout {
    public static final IOBufferLayout INSTANCE = new IOBufferLayoutImpl();
    protected static final Shape.Allocator I_O_BUFFER_ALLOCATOR = LAYOUT.createAllocator();
    protected static final Property WRITE_SYNCED_PROPERTY = Property.create((Object)"@write_synced", (Location)I_O_BUFFER_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final Property STORAGE_PROPERTY = Property.create((Object)"@storage", (Location)I_O_BUFFER_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final Property USED_PROPERTY = Property.create((Object)"@used", (Location)I_O_BUFFER_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final Property TOTAL_PROPERTY = Property.create((Object)"@total", (Location)I_O_BUFFER_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), (int)0);

    protected IOBufferLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createIOBufferShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new IOBufferType(logicalClass, metaClass)).addProperty(WRITE_SYNCED_PROPERTY).addProperty(STORAGE_PROPERTY).addProperty(USED_PROPERTY).addProperty(TOTAL_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createIOBuffer(DynamicObjectFactory factory, boolean writeSynced, DynamicObject storage, int used, int total) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (IOBufferLayoutImpl.createsIOBuffer(factory));
        assert (factory.getShape().hasProperty((Object)"@write_synced"));
        assert (factory.getShape().hasProperty((Object)"@storage"));
        assert (factory.getShape().hasProperty((Object)"@used"));
        assert (factory.getShape().hasProperty((Object)"@total"));
        assert (storage != null);
        return factory.newInstance(new Object[]{writeSynced, storage, used, total});
    }

    private static boolean isIOBuffer(DynamicObject object) {
        return IOBufferLayoutImpl.isIOBuffer(object.getShape().getObjectType());
    }

    private static boolean isIOBuffer(ObjectType objectType) {
        return objectType instanceof IOBufferType;
    }

    private static boolean createsIOBuffer(DynamicObjectFactory factory) {
        return IOBufferLayoutImpl.isIOBuffer(factory.getShape().getObjectType());
    }

    @Override
    public boolean getWriteSynced(DynamicObject object) {
        assert (IOBufferLayoutImpl.isIOBuffer(object));
        assert (object.getShape().hasProperty((Object)"@write_synced"));
        return (Boolean)WRITE_SYNCED_PROPERTY.get(object, IOBufferLayoutImpl.isIOBuffer(object));
    }

    @Override
    public void setWriteSynced(DynamicObject object, boolean value) {
        assert (IOBufferLayoutImpl.isIOBuffer(object));
        assert (object.getShape().hasProperty((Object)"@write_synced"));
        try {
            WRITE_SYNCED_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public DynamicObject getStorage(DynamicObject object) {
        assert (IOBufferLayoutImpl.isIOBuffer(object));
        assert (object.getShape().hasProperty((Object)"@storage"));
        return (DynamicObject)STORAGE_PROPERTY.get(object, IOBufferLayoutImpl.isIOBuffer(object));
    }

    @Override
    public void setStorage(DynamicObject object, DynamicObject value) {
        assert (IOBufferLayoutImpl.isIOBuffer(object));
        assert (object.getShape().hasProperty((Object)"@storage"));
        assert (value != null);
        try {
            STORAGE_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int getUsed(DynamicObject object) {
        assert (IOBufferLayoutImpl.isIOBuffer(object));
        assert (object.getShape().hasProperty((Object)"@used"));
        return (Integer)USED_PROPERTY.get(object, IOBufferLayoutImpl.isIOBuffer(object));
    }

    @Override
    public void setUsed(DynamicObject object, int value) {
        assert (IOBufferLayoutImpl.isIOBuffer(object));
        assert (object.getShape().hasProperty((Object)"@used"));
        try {
            USED_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int getTotal(DynamicObject object) {
        assert (IOBufferLayoutImpl.isIOBuffer(object));
        assert (object.getShape().hasProperty((Object)"@total"));
        return (Integer)TOTAL_PROPERTY.get(object, IOBufferLayoutImpl.isIOBuffer(object));
    }

    @Override
    public void setTotal(DynamicObject object, int value) {
        assert (IOBufferLayoutImpl.isIOBuffer(object));
        assert (object.getShape().hasProperty((Object)"@total"));
        try {
            TOTAL_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class IOBufferType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public IOBufferType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public IOBufferType setLogicalClass(DynamicObject logicalClass) {
            return new IOBufferType(logicalClass, this.metaClass);
        }

        @Override
        public IOBufferType setMetaClass(DynamicObject metaClass) {
            return new IOBufferType(this.logicalClass, metaClass);
        }
    }
}

