/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.cast.ToIntNode;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;

@ImportStatic(value={Integer.class})
@NodeChild(value="value", type=RubyNode.class)
public abstract class ArrayAttributeCastNode
extends RubyNode {
    final String indexName;

    public ArrayAttributeCastNode(RubyContext context, SourceSection sourceSection, String indexName) {
        super(context, sourceSection);
        this.indexName = indexName;
    }

    @Specialization
    public int doIntegerFixnum(int value) {
        return value;
    }

    @Specialization(guards={"inBounds(value)"})
    public int doLongFixnum(long value) {
        return (int)value;
    }

    @Specialization(guards={"!inBounds(value)"})
    public int doLongFixnumOutOfBounds(long value) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.coreExceptions().argumentError(String.format("%s out of int range", this.indexName), this));
    }

    @Specialization(guards={"inBounds(value)"})
    public int doDouble(double value) {
        return (int)value;
    }

    @Specialization(guards={"!inBounds(value)"})
    public int doDoubleOutOfBounds(double value) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.coreExceptions().argumentError(String.format("%s out of int range", this.indexName), this));
    }

    @Specialization(guards={"isRubyBignum(value)"})
    public DynamicObject doBignum(DynamicObject value) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.coreExceptions().argumentError(String.format("%s out of int range", this.indexName), this));
    }

    @Specialization(guards={"isRubyRange(range)"})
    public DynamicObject passThroughRange(DynamicObject range) {
        return range;
    }

    @Specialization
    public Object passThroughNotProvided(NotProvided value) {
        return value;
    }

    @Specialization(guards={"!isInteger(value)", "!isLong(value)", "!isDouble(value)", "!isRubyBignum(value)", "!isRubyRange(value)"})
    public Object coerce(VirtualFrame frame, DynamicObject value, @Cached(value="create()") ToIntNode toIntNode) {
        return toIntNode.executeIntOrLong(frame, value);
    }

    @Fallback
    public int doBasicObject(Object object) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.coreExceptions().typeErrorIsNotA(object.toString(), "Fixnum (fitting in int)", (Node)this));
    }

    protected static boolean inBounds(long value) {
        return value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE;
    }

    protected static boolean inBounds(double value) {
        return value >= -2.147483648E9 && value <= 2.147483647E9;
    }
}

