/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.core.array.ArrayReadNormalizedNode;
import org.jruby.truffle.core.array.ArrayReadNormalizedNodeGen;
import org.jruby.truffle.language.RubyNode;

@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class)})
public abstract class ArrayReadDenormalizedNode
extends RubyNode {
    @Node.Child
    private ArrayReadNormalizedNode readNode = ArrayReadNormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null);

    public ArrayReadDenormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeRead(DynamicObject var1, int var2);

    @Specialization
    public Object read(DynamicObject array, int index, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile) {
        int normalizedIndex = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), index, negativeIndexProfile);
        return this.readNode.executeRead(array, normalizedIndex);
    }
}

