/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.IsFrozenNode;
import org.jruby.truffle.language.objects.IsFrozenNodeGen;

public class RaiseIfFrozenNode
extends RubyNode {
    @Node.Child
    private RubyNode child;
    @Node.Child
    private IsFrozenNode isFrozenNode;

    public RaiseIfFrozenNode(RubyNode child) {
        super(child.getContext(), child.getEncapsulatingSourceSection());
        this.child = child;
        this.isFrozenNode = IsFrozenNodeGen.create(child.getContext(), child.getEncapsulatingSourceSection(), null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object result = this.child.execute(frame);
        if (this.isFrozenNode.executeIsFrozen(result)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.coreExceptions().frozenError(result, this));
        }
        return result;
    }
}

