/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.jruby.ast.visitor.AbstractNodeVisitor;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.InvalidSourcePosition;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.literal.NilNode;
import org.jruby.truffle.runtime.RubyContext;

public abstract class Translator
extends AbstractNodeVisitor<RubyNode> {
    public static final Set<String> ALWAYS_DEFINED_GLOBALS = new HashSet<String>(Collections.singletonList("$~"));
    public static final Set<String> FRAME_LOCAL_GLOBAL_VARIABLES = new HashSet<String>(Arrays.asList("$_", "$+", "$&", "$`", "$'"));
    protected final Node currentNode;
    protected final RubyContext context;
    protected final Source source;
    protected Deque<SourceSection> parentSourceSection = new ArrayDeque<SourceSection>();

    public Translator(Node currentNode, RubyContext context, Source source) {
        this.currentNode = currentNode;
        this.context = context;
        this.source = source;
    }

    protected SourceSection translate(ISourcePosition sourcePosition) {
        return this.translate(this.source, sourcePosition, this.getIdentifier());
    }

    protected SourceSection translate(ISourcePosition sourcePosition, String identifier) {
        return this.translate(this.source, sourcePosition, identifier);
    }

    private SourceSection translate(Source source, ISourcePosition sourcePosition, String identifier) {
        if (sourcePosition == InvalidSourcePosition.INSTANCE) {
            if (this.parentSourceSection.peek() == null) {
                throw new UnsupportedOperationException("Truffle doesn't want invalid positions - find a way to give me a real position!");
            }
            return this.parentSourceSection.peek();
        }
        return source.createSection(identifier, sourcePosition.getLine() + 1);
    }

    protected RubyNode nilNode(SourceSection sourceSection) {
        return new NilNode(this.context, sourceSection);
    }

    protected RubyNode translateNodeOrNil(SourceSection sourceSection, org.jruby.ast.Node node) {
        RubyNode rubyNode = node != null ? (RubyNode)((Object)node.accept((NodeVisitor)this)) : this.nilNode(sourceSection);
        return rubyNode;
    }

    protected abstract String getIdentifier();
}

