/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.KeywordArgNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.SuperNode;
import org.jruby.ast.UnnamedRestArgNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.arguments.CheckArityNode;
import org.jruby.truffle.nodes.arguments.IsNilNode;
import org.jruby.truffle.nodes.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.arguments.ReadBlockNode;
import org.jruby.truffle.nodes.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.arguments.ShouldDestructureNode;
import org.jruby.truffle.nodes.cast.ArrayCastNode;
import org.jruby.truffle.nodes.cast.ArrayCastNodeGen;
import org.jruby.truffle.nodes.control.AndNode;
import org.jruby.truffle.nodes.control.IfNode;
import org.jruby.truffle.nodes.control.NotNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.nodes.dispatch.RespondToNode;
import org.jruby.truffle.nodes.locals.FlipFlopStateNode;
import org.jruby.truffle.nodes.locals.ReadLocalVariableNode;
import org.jruby.truffle.nodes.locals.WriteLocalVariableNode;
import org.jruby.truffle.nodes.methods.BlockDefinitionNode;
import org.jruby.truffle.nodes.methods.CatchForLambdaNode;
import org.jruby.truffle.nodes.methods.CatchForMethodNode;
import org.jruby.truffle.nodes.methods.CatchForProcNode;
import org.jruby.truffle.nodes.methods.ExceptionTranslatingNode;
import org.jruby.truffle.nodes.methods.MethodDefinitionNode;
import org.jruby.truffle.nodes.supercall.ReadSuperArgumentsNode;
import org.jruby.truffle.nodes.supercall.ReadZSuperArgumentsNode;
import org.jruby.truffle.nodes.supercall.SuperCallNode;
import org.jruby.truffle.nodes.supercall.ZSuperOutsideMethodNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.truffle.translator.LoadArgumentsTranslator;
import org.jruby.truffle.translator.ParameterCollector;
import org.jruby.truffle.translator.ReloadArgumentsTranslator;
import org.jruby.truffle.translator.TranslatorEnvironment;

public class MethodTranslator
extends BodyTranslator {
    private final ArgsNode argsNode;
    private boolean isBlock;

    public MethodTranslator(com.oracle.truffle.api.nodes.Node currentNode, RubyContext context, BodyTranslator parent, TranslatorEnvironment environment, boolean isBlock, Source source, ArgsNode argsNode) {
        super(currentNode, context, parent, environment, source, false);
        this.isBlock = isBlock;
        this.argsNode = argsNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockDefinitionNode compileBlockNode(SourceSection sourceSection, String methodName, Node bodyNode, SharedMethodInfo sharedMethodInfo, ProcNodes.Type type) {
        FrameSlot frameOnStackMarkerSlot;
        RubyNode body;
        RubyNode preludeProc;
        this.declareArguments(sourceSection, methodName, sharedMethodInfo);
        Arity arity = MethodTranslator.getArity(this.argsNode);
        Arity arityForCheck = this.argsNode.getRestArgNode() instanceof UnnamedRestArgNode && !((UnnamedRestArgNode)this.argsNode.getRestArgNode()).isStar() ? arity.withRest(false) : arity;
        boolean isProc = type == ProcNodes.Type.PROC;
        LoadArgumentsTranslator loadArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, isProc, this);
        RubyNode loadArguments = (RubyNode)((Object)this.argsNode.accept((NodeVisitor)loadArgumentsTranslator));
        if (this.shouldConsiderDestructuringArrayArg(arity)) {
            ReadPreArgumentNode readArrayNode = new ReadPreArgumentNode(this.context, sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR);
            ArrayCastNode castArrayNode = ArrayCastNodeGen.create(this.context, sourceSection, readArrayNode);
            FrameSlot arraySlot = this.environment.declareVar(this.environment.allocateLocalTemp("destructure"));
            WriteLocalVariableNode writeArrayNode = new WriteLocalVariableNode(this.context, sourceSection, castArrayNode, arraySlot);
            LoadArgumentsTranslator destructureArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, isProc, this);
            destructureArgumentsTranslator.pushArraySlot(arraySlot);
            RubyNode newDestructureArguments = (RubyNode)((Object)this.argsNode.accept((NodeVisitor)destructureArgumentsTranslator));
            ShouldDestructureNode shouldDestructure = new ShouldDestructureNode(this.context, sourceSection, new RespondToNode(this.context, sourceSection, readArrayNode, "to_ary"));
            RubyNode arrayWasNotNil = SequenceNode.sequence(this.context, sourceSection, writeArrayNode, new NotNode(this.context, sourceSection, new IsNilNode(this.context, sourceSection, new ReadLocalVariableNode(this.context, sourceSection, arraySlot))));
            AndNode shouldDestructureAndArrayWasNotNil = new AndNode(this.context, sourceSection, shouldDestructure, arrayWasNotNil);
            preludeProc = new IfNode(this.context, sourceSection, shouldDestructureAndArrayWasNotNil, newDestructureArguments, loadArguments);
        } else {
            preludeProc = loadArguments;
        }
        RubyNode preludeLambda = SequenceNode.sequence(this.context, sourceSection, CheckArityNode.create(this.context, sourceSection, arityForCheck), (RubyNode)NodeUtil.cloneNode((com.oracle.truffle.api.nodes.Node)loadArguments));
        this.parentSourceSection.push(sourceSection);
        try {
            if (this.argsNode.getBlockLocalVariables() != null && !this.argsNode.getBlockLocalVariables().isEmpty()) {
                for (Node var : this.argsNode.getBlockLocalVariables().children()) {
                    this.environment.declareVar(((INameNode)var).getName());
                }
            }
            body = this.translateNodeOrNil(sourceSection, bodyNode);
        }
        finally {
            this.parentSourceSection.pop();
        }
        CatchForProcNode bodyProc = new CatchForProcNode(this.context, SequenceNode.enclosing(sourceSection, body.getEncapsulatingSourceSection()), this.composeBody(preludeProc, (RubyNode)NodeUtil.cloneNode((com.oracle.truffle.api.nodes.Node)body)));
        RubyRootNode newRootNodeForProcs = new RubyRootNode(this.context, MethodTranslator.considerExtendingMethodToCoverEnd(bodyProc.getEncapsulatingSourceSection()), this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), bodyProc, this.environment.needsDeclarationFrame());
        RubyNode composed = this.composeBody(preludeLambda, body);
        CatchForLambdaNode bodyLambda = new CatchForLambdaNode(this.context, composed.getEncapsulatingSourceSection(), composed, this.environment.getReturnID());
        RubyRootNode newRootNodeForLambdas = new RubyRootNode(this.context, MethodTranslator.considerExtendingMethodToCoverEnd(bodyLambda.getEncapsulatingSourceSection()), this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), bodyLambda, this.environment.needsDeclarationFrame());
        RootCallTarget callTargetAsLambda = Truffle.getRuntime().createCallTarget((RootNode)newRootNodeForLambdas);
        RootCallTarget callTargetAsProc = Truffle.getRuntime().createCallTarget((RootNode)newRootNodeForProcs);
        if (this.frameOnStackMarkerSlotStack.isEmpty()) {
            frameOnStackMarkerSlot = null;
        } else {
            frameOnStackMarkerSlot = (FrameSlot)this.frameOnStackMarkerSlotStack.peek();
            if (frameOnStackMarkerSlot == BAD_FRAME_SLOT) {
                frameOnStackMarkerSlot = null;
            }
        }
        return new BlockDefinitionNode(this.context, newRootNodeForProcs.getEncapsulatingSourceSection(), type, this.environment.getSharedMethodInfo(), (CallTarget)callTargetAsProc, (CallTarget)callTargetAsLambda, this.environment.getBreakID(), frameOnStackMarkerSlot);
    }

    private boolean shouldConsiderDestructuringArrayArg(Arity arity) {
        if (arity.hasKeywordsRest()) {
            return true;
        }
        if (!arity.hasRest() && arity.getOptional() == 0 && arity.getRequired() <= 1) {
            return false;
        }
        return !arity.hasRest() || arity.getRequired() != 0;
    }

    private RubyNode composeBody(RubyNode prelude, RubyNode body) {
        SourceSection sourceSection = SequenceNode.enclosing(prelude.getSourceSection(), body.getSourceSection());
        body = SequenceNode.sequence(this.context, sourceSection, prelude, body);
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = SequenceNode.sequence(this.context, sourceSection, this.initFlipFlopStates(sourceSection), body);
        }
        return body;
    }

    public RubyNode compileMethodBody(SourceSection sourceSection, String methodName, Node bodyNode, SharedMethodInfo sharedMethodInfo) {
        return this.doCompileMethodBody(sourceSection, methodName, bodyNode, sharedMethodInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode doCompileMethodBody(SourceSection sourceSection, String methodName, Node bodyNode, SharedMethodInfo sharedMethodInfo) {
        RubyNode body;
        this.declareArguments(sourceSection, methodName, sharedMethodInfo);
        Arity arity = MethodTranslator.getArity(this.argsNode);
        LoadArgumentsTranslator loadArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, false, this);
        RubyNode loadArguments = (RubyNode)((Object)this.argsNode.accept((NodeVisitor)loadArgumentsTranslator));
        this.parentSourceSection.push(sourceSection);
        try {
            body = this.translateNodeOrNil(sourceSection, bodyNode);
        }
        finally {
            this.parentSourceSection.pop();
        }
        RubyNode prelude = this.usesRubiniusPrimitive ? loadArguments : SequenceNode.sequence(this.context, sourceSection, CheckArityNode.create(this.context, sourceSection, arity), loadArguments);
        body = SequenceNode.sequence(this.context, body.getSourceSection(), prelude, body);
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = SequenceNode.sequence(this.context, body.getSourceSection(), this.initFlipFlopStates(sourceSection), body);
        }
        body = new CatchForMethodNode(this.context, body.getSourceSection(), body, this.environment.getReturnID());
        body = new ExceptionTranslatingNode(this.context, body.getSourceSection(), body);
        return body;
    }

    public MethodDefinitionNode compileMethodNode(SourceSection sourceSection, String methodName, Node bodyNode, SharedMethodInfo sharedMethodInfo) {
        RubyNode body = this.compileMethodBody(sourceSection, methodName, bodyNode, sharedMethodInfo);
        RubyRootNode rootNode = new RubyRootNode(this.context, MethodTranslator.considerExtendingMethodToCoverEnd(body.getSourceSection()), this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), body, this.environment.needsDeclarationFrame());
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
        return new MethodDefinitionNode(this.context, sourceSection, methodName, this.environment.getSharedMethodInfo(), (CallTarget)callTarget);
    }

    private void declareArguments(SourceSection sourceSection, String methodName, SharedMethodInfo sharedMethodInfo) {
        ParameterCollector parameterCollector = new ParameterCollector();
        this.argsNode.accept((NodeVisitor)parameterCollector);
        for (String parameter : parameterCollector.getParameters()) {
            this.environment.declareVar(parameter);
        }
    }

    public static Arity getArity(ArgsNode argsNode) {
        String[] keywordArguments;
        if (argsNode.hasKwargs() && argsNode.getKeywords() != null) {
            Node[] keywordNodes = argsNode.getKeywords().children();
            int keywordsCount = keywordNodes.length;
            keywordArguments = new String[keywordsCount];
            for (int i = 0; i < keywordsCount; ++i) {
                KeywordArgNode kwarg = (KeywordArgNode)keywordNodes[i];
                AssignableNode assignableNode = kwarg.getAssignable();
                if (assignableNode instanceof LocalAsgnNode) {
                    keywordArguments[i] = ((LocalAsgnNode)assignableNode).getName();
                    continue;
                }
                if (assignableNode instanceof DAsgnNode) {
                    keywordArguments[i] = ((DAsgnNode)assignableNode).getName();
                    continue;
                }
                throw new UnsupportedOperationException("unsupported keyword arg " + kwarg);
            }
        } else {
            keywordArguments = Arity.NO_KEYWORDS;
        }
        return new Arity(argsNode.getPreCount(), argsNode.getOptionalArgsCount(), argsNode.hasRestArg(), argsNode.getPostCount(), keywordArguments, argsNode.hasKeyRest());
    }

    public RubyNode visitSuperNode(SuperNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        BodyTranslator.ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, node.getIterNode(), node.getArgsNode(), this.environment.getNamedMethodName());
        ReadSuperArgumentsNode arguments = new ReadSuperArgumentsNode(this.context, sourceSection, argumentsAndBlock.getArguments(), argumentsAndBlock.isSplatted());
        RubyNode block = this.executeOrInheritBlock(sourceSection, argumentsAndBlock.getBlock());
        return new SuperCallNode(this.context, sourceSection, arguments, block);
    }

    public RubyNode visitZSuperNode(ZSuperNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        if (this.environment.isBlock()) {
            this.environment.setNeedsDeclarationFrame();
        }
        this.currentCallMethodName = this.environment.getNamedMethodName();
        RubyNode blockNode = node.getIterNode() != null ? (RubyNode)((Object)node.getIterNode().accept((NodeVisitor)this)) : null;
        boolean insideDefineMethod = false;
        MethodTranslator methodArgumentsTranslator = this;
        while (methodArgumentsTranslator.isBlock) {
            if (!(methodArgumentsTranslator.parent instanceof MethodTranslator)) {
                return new ZSuperOutsideMethodNode(this.context, sourceSection, insideDefineMethod);
            }
            if (methodArgumentsTranslator.currentCallMethodName.equals("define_method")) {
                insideDefineMethod = true;
            }
            methodArgumentsTranslator = (MethodTranslator)methodArgumentsTranslator.parent;
        }
        ReloadArgumentsTranslator reloadTranslator = new ReloadArgumentsTranslator(this.currentNode, this.context, this.source, this);
        ArgsNode argsNode = methodArgumentsTranslator.argsNode;
        SequenceNode reloadSequence = (SequenceNode)reloadTranslator.visitArgsNode(argsNode);
        ReadZSuperArgumentsNode arguments = new ReadZSuperArgumentsNode(this.context, sourceSection, reloadTranslator.isSplatted(), reloadSequence.getSequence());
        RubyNode block = this.executeOrInheritBlock(sourceSection, blockNode);
        return new SuperCallNode(this.context, sourceSection, arguments, block);
    }

    private RubyNode executeOrInheritBlock(SourceSection sourceSection, RubyNode blockNode) {
        if (blockNode != null) {
            return blockNode;
        }
        return new ReadBlockNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
    }

    @Override
    protected FlipFlopStateNode createFlipFlopState(SourceSection sourceSection, int depth) {
        if (this.isBlock) {
            this.environment.setNeedsDeclarationFrame();
            return this.parent.createFlipFlopState(sourceSection, depth + 1);
        }
        return super.createFlipFlopState(sourceSection, depth);
    }

    public TranslatorState getCurrentState() {
        return new TranslatorState(this.getEnvironment().getLexicalScope(), new ArrayDeque(this.parentSourceSection));
    }

    public void restoreState(TranslatorState state) {
        this.getEnvironment().getParseEnvironment().resetLexicalScope(state.scope);
        this.parentSourceSection = state.parentSourceSection;
    }

    private static SourceSection considerExtendingMethodToCoverEnd(SourceSection sourceSection) {
        Source source = sourceSection.getSource();
        if (sourceSection.getEndLine() + 1 >= source.getLineCount()) {
            return sourceSection;
        }
        String indentationOnFirstLine = MethodTranslator.indentation(source.getCode(sourceSection.getStartLine()));
        int lineAfter = sourceSection.getEndLine() + 1;
        String lineAfterString = source.getCode(lineAfter).replaceAll("\\s+$", "");
        if (lineAfterString.equals(indentationOnFirstLine + "end") || lineAfterString.equals(indentationOnFirstLine + "}")) {
            return source.createSection(sourceSection.getIdentifier(), sourceSection.getCharIndex(), sourceSection.getCharLength() + 1 + source.getLineLength(lineAfter));
        }
        return sourceSection;
    }

    private static String indentation(String line) {
        for (int n = 0; n < line.length(); ++n) {
            if (Character.isWhitespace(line.charAt(n))) continue;
            return line.substring(0, n);
        }
        return "";
    }

    public static class TranslatorState {
        private final LexicalScope scope;
        private final Deque<SourceSection> parentSourceSection;

        private TranslatorState(LexicalScope scope, Deque<SourceSection> parentSourceSection) {
            this.scope = scope;
            this.parentSourceSection = parentSourceSection;
        }
    }
}

