/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.ObjectRangeLayout;

public class ObjectRangeLayoutImpl
extends BasicObjectLayoutImpl
implements ObjectRangeLayout {
    public static final ObjectRangeLayout INSTANCE = new ObjectRangeLayoutImpl();
    protected static final Shape.Allocator OBJECT_RANGE_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey EXCLUDED_END_IDENTIFIER = new HiddenKey("excludedEnd");
    protected static final Property EXCLUDED_END_PROPERTY = Property.create((Object)EXCLUDED_END_IDENTIFIER, (Location)OBJECT_RANGE_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey BEGIN_IDENTIFIER = new HiddenKey("begin");
    protected static final Property BEGIN_PROPERTY = Property.create((Object)BEGIN_IDENTIFIER, (Location)OBJECT_RANGE_ALLOCATOR.locationForType(Object.class), (int)0);
    protected static final HiddenKey END_IDENTIFIER = new HiddenKey("end");
    protected static final Property END_PROPERTY = Property.create((Object)END_IDENTIFIER, (Location)OBJECT_RANGE_ALLOCATOR.locationForType(Object.class), (int)0);

    protected ObjectRangeLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createObjectRangeShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new ObjectRangeType(logicalClass, metaClass)).addProperty(EXCLUDED_END_PROPERTY).addProperty(BEGIN_PROPERTY).addProperty(END_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createObjectRange(DynamicObjectFactory factory, boolean excludedEnd, Object begin, Object end) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsObjectRange(factory));
        assert (factory.getShape().hasProperty((Object)EXCLUDED_END_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)BEGIN_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)END_IDENTIFIER));
        return factory.newInstance(new Object[]{excludedEnd, begin, end});
    }

    @Override
    public boolean isObjectRange(Object object) {
        return object instanceof DynamicObject && this.isObjectRange((DynamicObject)object);
    }

    @Override
    public boolean isObjectRange(DynamicObject object) {
        return this.isObjectRange(object.getShape().getObjectType());
    }

    private boolean isObjectRange(ObjectType objectType) {
        return objectType instanceof ObjectRangeType;
    }

    private boolean createsObjectRange(DynamicObjectFactory factory) {
        return this.isObjectRange(factory.getShape().getObjectType());
    }

    @Override
    public boolean getExcludedEnd(DynamicObject object) {
        assert (this.isObjectRange(object));
        assert (object.getShape().hasProperty((Object)EXCLUDED_END_IDENTIFIER));
        return (Boolean)EXCLUDED_END_PROPERTY.get(object, true);
    }

    @Override
    public void setExcludedEnd(DynamicObject object, boolean value) {
        assert (this.isObjectRange(object));
        assert (object.getShape().hasProperty((Object)EXCLUDED_END_IDENTIFIER));
        try {
            EXCLUDED_END_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public Object getBegin(DynamicObject object) {
        assert (this.isObjectRange(object));
        assert (object.getShape().hasProperty((Object)BEGIN_IDENTIFIER));
        return BEGIN_PROPERTY.get(object, true);
    }

    @Override
    public void setBegin(DynamicObject object, Object value) {
        assert (this.isObjectRange(object));
        assert (object.getShape().hasProperty((Object)BEGIN_IDENTIFIER));
        try {
            BEGIN_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public Object getEnd(DynamicObject object) {
        assert (this.isObjectRange(object));
        assert (object.getShape().hasProperty((Object)END_IDENTIFIER));
        return END_PROPERTY.get(object, true);
    }

    @Override
    public void setEnd(DynamicObject object, Object value) {
        assert (this.isObjectRange(object));
        assert (object.getShape().hasProperty((Object)END_IDENTIFIER));
        try {
            END_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class ObjectRangeType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public ObjectRangeType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public ObjectRangeType setLogicalClass(DynamicObject logicalClass) {
            return new ObjectRangeType(logicalClass, this.metaClass);
        }

        @Override
        public ObjectRangeType setMetaClass(DynamicObject metaClass) {
            return new ObjectRangeType(this.logicalClass, metaClass);
        }
    }
}

