/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrument.Visualizer;
import com.oracle.truffle.api.instrument.WrapperNode;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.truffle.nodes.LazyRubyRootNode;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.instrument.RubyWrapperNode;
import org.jruby.truffle.runtime.RubyContext;

public class RubyLanguage
extends TruffleLanguage<RubyContext> {
    public static final String MIME_TYPE = "application/x-ruby";
    public static final RubyLanguage INSTANCE = new RubyLanguage();

    private RubyLanguage() {
    }

    public RubyContext createContext(TruffleLanguage.Env env) {
        Ruby runtime;
        JRubyContextWrapper runtimeWrapper = (JRubyContextWrapper)env.importSymbol("org.jruby.truffle.runtime");
        if (runtimeWrapper == null) {
            RubyInstanceConfig config = new RubyInstanceConfig();
            config.setCompileMode(RubyInstanceConfig.CompileMode.TRUFFLE);
            runtime = Ruby.newInstance((RubyInstanceConfig)config);
        } else {
            runtime = runtimeWrapper.getRuby();
        }
        return new RubyContext(runtime, env);
    }

    protected void disposeContext(RubyContext context) {
        context.shutdown();
    }

    protected CallTarget parse(Source source, Node node, String ... argumentNames) throws IOException {
        return Truffle.getRuntime().createCallTarget((RootNode)new LazyRubyRootNode(null, null, source, argumentNames));
    }

    protected Object findExportedSymbol(RubyContext context, String s, boolean b) {
        return context.findExportedObject(s);
    }

    protected Object getLanguageGlobal(RubyContext context) {
        return context.getCoreLibrary().getObjectClass();
    }

    protected boolean isObjectOfLanguage(Object object) {
        throw new UnsupportedOperationException();
    }

    protected Visualizer getVisualizer() {
        throw new UnsupportedOperationException();
    }

    public boolean isInstrumentable(Node node) {
        return !(node instanceof RubyWrapperNode);
    }

    protected WrapperNode createWrapperNode(Node node) {
        return new RubyWrapperNode((RubyNode)node);
    }

    protected Object evalInContext(Source source, Node node, MaterializedFrame mFrame) throws IOException {
        return null;
    }

    protected String toString(RubyContext context, Object value) {
        if (value == null) {
            return "<null>";
        }
        if (RubyGuards.isBoxedPrimitive(value) || RubyGuards.isRubyBasicObject(value)) {
            return context.send(value, "inspect", null, new Object[0]).toString();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return "<foreign>";
    }

    public Node unprotectedCreateFindContextNode() {
        return super.createFindContextNode();
    }

    public RubyContext unprotectedFindContext(Node node) {
        return (RubyContext)((Object)super.findContext(node));
    }

    public static class JRubyContextWrapper
    implements TruffleObject {
        private final Ruby ruby;

        public JRubyContextWrapper(Ruby ruby) {
            this.ruby = ruby;
        }

        public Ruby getRuby() {
            return this.ruby;
        }

        public ForeignAccess getForeignAccess() {
            throw new UnsupportedOperationException();
        }
    }
}

