/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.ThreadLocalObject;

@NodeChild(value="value", type=RubyNode.class)
public abstract class RubiniusLastStringWriteNode
extends RubyNode {
    public RubiniusLastStringWriteNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    @Specialization
    public Object lastStringWrite(Object value) {
        CompilerDirectives.transferToInterpreter();
        MaterializedFrame callerFrame = RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.READ_ONLY, true).materialize();
        FrameSlot slot = callerFrame.getFrameDescriptor().findFrameSlot((Object)"$_");
        while (slot == null && (callerFrame = RubyArguments.getDeclarationFrame(callerFrame.getArguments())) != null) {
            slot = callerFrame.getFrameDescriptor().findFrameSlot((Object)"$_");
        }
        if (slot == null) {
            return value;
        }
        try {
            Object currentValue = callerFrame.getObject(slot);
            if (currentValue instanceof ThreadLocalObject) {
                ThreadLocalObject threadLocalObject = (ThreadLocalObject)currentValue;
                threadLocalObject.set(value);
            } else {
                callerFrame.setObject(slot, value);
            }
        }
        catch (FrameSlotTypeException e) {
            throw new UnsupportedOperationException(e);
        }
        return value;
    }

    protected abstract RubyNode getValue();
}

