/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=SingletonClassNode.class)
public final class SingletonClassNodeGen
extends SingletonClassNode
implements SpecializedNode {
    @Node.Child
    private RubyNode value_;
    @CompilerDirectives.CompilationFinal
    private Class<?> valueType_;
    @Node.Child
    private BaseNode_ specialization_;

    private SingletonClassNodeGen(RubyContext context, SourceSection sourceSection, RubyNode value) {
        super(context, sourceSection);
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public DynamicObject executeSingletonClass(Object valueValue) {
        return this.specialization_.executeDynamicObject1(valueValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
        return this.specialization_.executeDynamicObject0(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static SingletonClassNode create(RubyContext context, SourceSection sourceSection, RubyNode value) {
        return new SingletonClassNodeGen(context, sourceSection, value);
    }

    @GeneratedBy(methodName="singletonClass(DynamicObject)", value=SingletonClassNode.class)
    private static final class SingletonClass3Node_
    extends BaseNode_ {
        SingletonClass3Node_(SingletonClassNodeGen root) {
            super(root, 10);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object valueValue) {
            DynamicObject valueValue_;
            if (!(!(valueValue instanceof DynamicObject) || this.root.isNil(valueValue_ = (DynamicObject)valueValue) || RubyGuards.isRubyBignum(valueValue_) || RubyGuards.isRubySymbol(valueValue_) || RubyGuards.isRubyClass(valueValue_))) {
                return this.root.singletonClass(valueValue_);
            }
            return this.getNext().executeDynamicObject1(valueValue);
        }

        static BaseNode_ create(SingletonClassNodeGen root) {
            return new SingletonClass3Node_(root);
        }
    }

    @GeneratedBy(methodName="singletonClassClass(DynamicObject)", value=SingletonClassNode.class)
    private static final class SingletonClassClassNode_
    extends BaseNode_ {
        SingletonClassClassNode_(SingletonClassNodeGen root) {
            super(root, 9);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubyClass(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.singletonClassClass(valueValue_);
            }
            return this.getNext().executeDynamicObject1(valueValue);
        }

        static BaseNode_ create(SingletonClassNodeGen root) {
            return new SingletonClassClassNode_(root);
        }
    }

    @GeneratedBy(methodName="singletonClassSymbol(DynamicObject)", value=SingletonClassNode.class)
    private static final class SingletonClassSymbolNode_
    extends BaseNode_ {
        SingletonClassSymbolNode_(SingletonClassNodeGen root) {
            super(root, 8);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubySymbol(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.singletonClassSymbol(valueValue_);
            }
            return this.getNext().executeDynamicObject1(valueValue);
        }

        static BaseNode_ create(SingletonClassNodeGen root) {
            return new SingletonClassSymbolNode_(root);
        }
    }

    @GeneratedBy(methodName="singletonClassBignum(DynamicObject)", value=SingletonClassNode.class)
    private static final class SingletonClassBignumNode_
    extends BaseNode_ {
        SingletonClassBignumNode_(SingletonClassNodeGen root) {
            super(root, 7);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubyBignum(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.singletonClassBignum(valueValue_);
            }
            return this.getNext().executeDynamicObject1(valueValue);
        }

        static BaseNode_ create(SingletonClassNodeGen root) {
            return new SingletonClassBignumNode_(root);
        }
    }

    @GeneratedBy(methodName="singletonClass(double)", value=SingletonClassNode.class)
    private static final class SingletonClass2Node_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        SingletonClass2Node_(SingletonClassNodeGen root, Object valueValue) {
            super(root, 6);
            this.valueImplicitType = RubyTypesGen.getImplicitDoubleClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((SingletonClass2Node_)other).valueImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            double valueValue_;
            try {
                if (this.valueImplicitType == Double.TYPE) {
                    valueValue_ = this.root.value_.executeDouble(frameValue);
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitDouble(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(ex.getResult());
            }
            return this.root.singletonClass(valueValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object valueValue) {
            if (RubyTypesGen.isImplicitDouble(valueValue, this.valueImplicitType)) {
                double valueValue_ = RubyTypesGen.asImplicitDouble(valueValue, this.valueImplicitType);
                return this.root.singletonClass(valueValue_);
            }
            return this.getNext().executeDynamicObject1(valueValue);
        }

        static BaseNode_ create(SingletonClassNodeGen root, Object valueValue) {
            return new SingletonClass2Node_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="singletonClass(long)", value=SingletonClassNode.class)
    private static final class SingletonClass1Node_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        SingletonClass1Node_(SingletonClassNodeGen root, Object valueValue) {
            super(root, 5);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((SingletonClass1Node_)other).valueImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            long valueValue_;
            try {
                if (this.valueImplicitType == Long.TYPE) {
                    valueValue_ = this.root.value_.executeLong(frameValue);
                } else if (this.valueImplicitType == Integer.TYPE) {
                    valueValue_ = RubyTypes.promoteToLong(this.root.value_.executeInteger(frameValue));
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitLong(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(ex.getResult());
            }
            return this.root.singletonClass(valueValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object valueValue) {
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                return this.root.singletonClass(valueValue_);
            }
            return this.getNext().executeDynamicObject1(valueValue);
        }

        static BaseNode_ create(SingletonClassNodeGen root, Object valueValue) {
            return new SingletonClass1Node_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="singletonClass(int)", value=SingletonClassNode.class)
    private static final class SingletonClass0Node_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        SingletonClass0Node_(SingletonClassNodeGen root, Object valueValue) {
            super(root, 4);
            this.valueImplicitType = RubyTypesGen.getImplicitIntegerClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((SingletonClass0Node_)other).valueImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int valueValue_;
            try {
                if (this.valueImplicitType == Integer.TYPE) {
                    valueValue_ = this.root.value_.executeInteger(frameValue);
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitInteger(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(ex.getResult());
            }
            return this.root.singletonClass(valueValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object valueValue) {
            if (RubyTypesGen.isImplicitInteger(valueValue, this.valueImplicitType)) {
                int valueValue_ = RubyTypesGen.asImplicitInteger(valueValue, this.valueImplicitType);
                return this.root.singletonClass(valueValue_);
            }
            return this.getNext().executeDynamicObject1(valueValue);
        }

        static BaseNode_ create(SingletonClassNodeGen root, Object valueValue) {
            return new SingletonClass0Node_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="singletonClassNil(DynamicObject)", value=SingletonClassNode.class)
    private static final class SingletonClassNilNode_
    extends BaseNode_ {
        SingletonClassNilNode_(SingletonClassNodeGen root) {
            super(root, 3);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && this.root.isNil(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.singletonClassNil(valueValue_);
            }
            return this.getNext().executeDynamicObject1(valueValue);
        }

        static BaseNode_ create(SingletonClassNodeGen root) {
            return new SingletonClassNilNode_(root);
        }
    }

    @GeneratedBy(methodName="singletonClassFalse(boolean)", value=SingletonClassNode.class)
    private static final class SingletonClassFalseNode_
    extends BaseNode_ {
        SingletonClassFalseNode_(SingletonClassNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            boolean valueValue_;
            try {
                valueValue_ = this.root.value_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(ex.getResult());
            }
            if (!valueValue_) {
                return this.root.singletonClassFalse(valueValue_);
            }
            return this.getNext().executeDynamicObject1(valueValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object valueValue) {
            boolean valueValue_;
            if (valueValue instanceof Boolean && !(valueValue_ = ((Boolean)valueValue).booleanValue())) {
                return this.root.singletonClassFalse(valueValue_);
            }
            return this.getNext().executeDynamicObject1(valueValue);
        }

        static BaseNode_ create(SingletonClassNodeGen root) {
            return new SingletonClassFalseNode_(root);
        }
    }

    @GeneratedBy(methodName="singletonClassTrue(boolean)", value=SingletonClassNode.class)
    private static final class SingletonClassTrueNode_
    extends BaseNode_ {
        SingletonClassTrueNode_(SingletonClassNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            boolean valueValue_;
            try {
                valueValue_ = this.root.value_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(ex.getResult());
            }
            if (valueValue_) {
                return this.root.singletonClassTrue(valueValue_);
            }
            return this.getNext().executeDynamicObject1(valueValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object valueValue) {
            boolean valueValue_;
            if (valueValue instanceof Boolean && (valueValue_ = ((Boolean)valueValue).booleanValue())) {
                return this.root.singletonClassTrue(valueValue_);
            }
            return this.getNext().executeDynamicObject1(valueValue);
        }

        static BaseNode_ create(SingletonClassNodeGen root) {
            return new SingletonClassTrueNode_(root);
        }
    }

    @GeneratedBy(value=SingletonClassNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(SingletonClassNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue));
        }

        @Override
        public DynamicObject executeDynamicObject1(Object valueValue) {
            return this.getNext().executeDynamicObject1(valueValue);
        }

        static BaseNode_ create(SingletonClassNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=SingletonClassNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(SingletonClassNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object valueValue) {
            return (DynamicObject)this.uninitialized(null, valueValue);
        }

        static BaseNode_ create(SingletonClassNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=SingletonClassNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected SingletonClassNodeGen root;

        BaseNode_(SingletonClassNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (SingletonClassNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.value_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object valueValue) {
            return this.executeDynamicObject1(valueValue);
        }

        public abstract DynamicObject executeDynamicObject1(Object var1);

        public Object execute(VirtualFrame frameValue) {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            return this.executeDynamicObject1(valueValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            return (DynamicObject)this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof Boolean) {
                boolean valueValue_2 = (Boolean)valueValue;
                if (valueValue_2) {
                    return SingletonClassTrueNode_.create(this.root);
                }
                return SingletonClassFalseNode_.create(this.root);
            }
            if (valueValue instanceof DynamicObject && this.root.isNil(valueValue_ = (DynamicObject)valueValue)) {
                return SingletonClassNilNode_.create(this.root);
            }
            if (RubyTypesGen.isImplicitInteger(valueValue)) {
                return SingletonClass0Node_.create(this.root, valueValue);
            }
            if (RubyTypesGen.isImplicitLong(valueValue)) {
                return SingletonClass1Node_.create(this.root, valueValue);
            }
            if (RubyTypesGen.isImplicitDouble(valueValue)) {
                return SingletonClass2Node_.create(this.root, valueValue);
            }
            if (valueValue instanceof DynamicObject) {
                valueValue_ = (DynamicObject)valueValue;
                if (RubyGuards.isRubyBignum(valueValue_)) {
                    return SingletonClassBignumNode_.create(this.root);
                }
                if (RubyGuards.isRubySymbol(valueValue_)) {
                    return SingletonClassSymbolNode_.create(this.root);
                }
                if (RubyGuards.isRubyClass(valueValue_)) {
                    return SingletonClassClassNode_.create(this.root);
                }
                if (!(this.root.isNil(valueValue_) || RubyGuards.isRubyBignum(valueValue_) || RubyGuards.isRubySymbol(valueValue_) || RubyGuards.isRubyClass(valueValue_))) {
                    return SingletonClass3Node_.create(this.root);
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeValue_(Frame frameValue) {
            Object object;
            Class valueType_ = this.root.valueType_;
            if (valueType_ == Boolean.TYPE) {
                return this.root.value_.executeBoolean((VirtualFrame)frameValue);
            }
            if (valueType_ == Double.TYPE) {
                return this.root.value_.executeDouble((VirtualFrame)frameValue);
            }
            if (valueType_ == Integer.TYPE) {
                return this.root.value_.executeInteger((VirtualFrame)frameValue);
            }
            if (valueType_ == Long.TYPE) {
                return this.root.value_.executeLong((VirtualFrame)frameValue);
            }
            if (valueType_ != null) return this.root.value_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.value_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.valueType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.valueType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.valueType_ = _type;
            return object;
        }
    }
}

