/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CachedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.interop.RubyToIndexLabelNode;
import org.jruby.truffle.nodes.interop.RubyToIndexLabelNodeGen;
import org.jruby.truffle.runtime.RubyContext;

public final class CachedForeignDispatchNode
extends CachedDispatchNode {
    private final String name;
    private final String nameForMessage;
    private final int arity;
    @Node.Child
    private Node directArray;
    @Node.Child
    private Node directField;
    @Node.Child
    private Node directCall;
    @Node.Child
    private Node nullCheck;
    @Node.Child
    private Node access;
    @Node.Child
    private PrepareArguments prepareArguments;

    public CachedForeignDispatchNode(RubyContext context, DispatchNode next, Object cachedName, int arity) {
        super(context, cachedName, next, DispatchAction.CALL_METHOD);
        this.name = cachedName.toString();
        this.arity = arity;
        this.nameForMessage = this.name.endsWith("=") && arity == 1 ? this.name.substring(0, this.name.length() - 1) : this.name;
        this.initializeNodes(context, arity);
    }

    private void initializeNodes(RubyContext context, int arity) {
        if (this.name.equals("[]")) {
            this.directArray = Message.READ.createNode();
        } else if (this.name.equals("[]=")) {
            this.directArray = Message.WRITE.createNode();
        } else if (this.name.endsWith("=") && arity == 1) {
            this.directField = Message.WRITE.createNode();
        } else if (this.name.equals("call")) {
            this.directCall = Message.createExecute((int)arity).createNode();
        } else if (this.name.equals("nil?")) {
            this.nullCheck = Message.IS_NULL.createNode();
        } else {
            this.access = Message.createInvoke((int)arity).createNode();
        }
        this.prepareArguments = new PrepareArguments(context, this.getSourceSection(), arity);
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return true;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object[] argumentsObjects) {
        if (receiverObject instanceof TruffleObject) {
            return this.doDispatch(frame, (TruffleObject)receiverObject, argumentsObjects);
        }
        return this.next.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
    }

    private Object doDispatch(VirtualFrame frame, TruffleObject receiverObject, Object[] arguments) {
        if (arguments.length != this.arity) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException();
        }
        if (this.directArray != null) {
            Object[] args = this.prepareArguments.convertArguments(frame, arguments, 0);
            return ForeignAccess.execute((Node)this.directArray, (VirtualFrame)frame, (TruffleObject)receiverObject, (Object[])args);
        }
        if (this.directField != null) {
            Object[] args = this.prepareArguments.convertArguments(frame, arguments, 1);
            args[0] = this.nameForMessage;
            return ForeignAccess.execute((Node)this.directField, (VirtualFrame)frame, (TruffleObject)receiverObject, (Object[])args);
        }
        if (this.directCall != null) {
            Object[] args = this.prepareArguments.convertArguments(frame, arguments, 0);
            return ForeignAccess.execute((Node)this.directCall, (VirtualFrame)frame, (TruffleObject)receiverObject, (Object[])args);
        }
        if (this.nullCheck != null) {
            Object[] args = this.prepareArguments.convertArguments(frame, arguments, 0);
            return ForeignAccess.execute((Node)this.nullCheck, (VirtualFrame)frame, (TruffleObject)receiverObject, (Object[])args);
        }
        if (this.access != null) {
            Object[] args = this.prepareArguments.convertArguments(frame, arguments, 1);
            args[0] = this.name;
            return ForeignAccess.execute((Node)this.access, (VirtualFrame)frame, (TruffleObject)receiverObject, (Object[])args);
        }
        CompilerDirectives.transferToInterpreter();
        throw new IllegalStateException();
    }

    private static class PrepareArguments
    extends RubyNode {
        @Node.Children
        private final RubyToIndexLabelNode[] converters;
        private final int arity;

        public PrepareArguments(RubyContext context, SourceSection sourceSection, int arity) {
            super(context, sourceSection);
            this.converters = new RubyToIndexLabelNode[arity];
            this.arity = arity;
            for (int i = 0; i < arity; ++i) {
                this.converters[i] = RubyToIndexLabelNodeGen.create(context, sourceSection, null);
            }
        }

        @ExplodeLoop
        public Object[] convertArguments(VirtualFrame frame, Object[] arguments, int offset) {
            Object[] result = new Object[this.arity + offset];
            for (int i = 0; i < this.arity; ++i) {
                result[i + offset] = this.converters[i].executeWithTarget(frame, arguments[i]);
            }
            return result;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException();
        }
    }
}

