/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.ThreadNodes;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=ThreadNodes.class)
public final class ThreadNodesFactory {
    public static List<NodeFactory<? extends CoreMethodArrayArgumentsNode>> getFactories() {
        return Arrays.asList(AliveNodeFactory.getInstance(), BacktraceNodeFactory.getInstance(), CurrentNodeFactory.getInstance(), KillNodeFactory.getInstance(), HandleInterruptNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), JoinNodeFactory.getInstance(), MainNodeFactory.getInstance(), PassNodeFactory.getInstance(), StatusNodeFactory.getInstance(), StopNodeFactory.getInstance(), ValueNodeFactory.getInstance(), WakeupNodeFactory.getInstance(), AbortOnExceptionNodeFactory.getInstance(), SetAbortOnExceptionNodeFactory.getInstance(), AllocateNodeFactory.getInstance(), ListNodeFactory.getInstance());
    }

    @GeneratedBy(value=ThreadNodes.ListNode.class)
    public static final class ListNodeFactory
    extends NodeFactoryBase<ThreadNodes.ListNode> {
        private static ListNodeFactory listNodeFactoryInstance;

        private ListNodeFactory() {
            super(ThreadNodes.ListNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.ListNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ListNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ListNode> getInstance() {
            if (listNodeFactoryInstance == null) {
                listNodeFactoryInstance = new ListNodeFactory();
            }
            return listNodeFactoryInstance;
        }

        public static ThreadNodes.ListNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ListNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.ListNode.class)
        public static final class ListNodeGen
        extends ThreadNodes.ListNode {
            private ListNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.list();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<ThreadNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(ThreadNodes.AllocateNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.AllocateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllocateNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static ThreadNodes.AllocateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AllocateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends ThreadNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.SetAbortOnExceptionNode.class)
    public static final class SetAbortOnExceptionNodeFactory
    extends NodeFactoryBase<ThreadNodes.SetAbortOnExceptionNode> {
        private static SetAbortOnExceptionNodeFactory setAbortOnExceptionNodeFactoryInstance;

        private SetAbortOnExceptionNodeFactory() {
            super(ThreadNodes.SetAbortOnExceptionNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.SetAbortOnExceptionNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetAbortOnExceptionNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.SetAbortOnExceptionNode> getInstance() {
            if (setAbortOnExceptionNodeFactoryInstance == null) {
                setAbortOnExceptionNodeFactoryInstance = new SetAbortOnExceptionNodeFactory();
            }
            return setAbortOnExceptionNodeFactoryInstance;
        }

        public static ThreadNodes.SetAbortOnExceptionNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SetAbortOnExceptionNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.SetAbortOnExceptionNode.class)
        public static final class SetAbortOnExceptionNodeGen
        extends ThreadNodes.SetAbortOnExceptionNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SetAbortOnExceptionNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeDynamicObject(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                boolean arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.setAbortOnException(arguments0Value_, arguments1Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.AbortOnExceptionNode.class)
    public static final class AbortOnExceptionNodeFactory
    extends NodeFactoryBase<ThreadNodes.AbortOnExceptionNode> {
        private static AbortOnExceptionNodeFactory abortOnExceptionNodeFactoryInstance;

        private AbortOnExceptionNodeFactory() {
            super(ThreadNodes.AbortOnExceptionNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.AbortOnExceptionNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AbortOnExceptionNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.AbortOnExceptionNode> getInstance() {
            if (abortOnExceptionNodeFactoryInstance == null) {
                abortOnExceptionNodeFactoryInstance = new AbortOnExceptionNodeFactory();
            }
            return abortOnExceptionNodeFactoryInstance;
        }

        public static ThreadNodes.AbortOnExceptionNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AbortOnExceptionNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.AbortOnExceptionNode.class)
        public static final class AbortOnExceptionNodeGen
        extends ThreadNodes.AbortOnExceptionNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AbortOnExceptionNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.abortOnException(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.WakeupNode.class)
    public static final class WakeupNodeFactory
    extends NodeFactoryBase<ThreadNodes.WakeupNode> {
        private static WakeupNodeFactory wakeupNodeFactoryInstance;

        private WakeupNodeFactory() {
            super(ThreadNodes.WakeupNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.WakeupNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return WakeupNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.WakeupNode> getInstance() {
            if (wakeupNodeFactoryInstance == null) {
                wakeupNodeFactoryInstance = new WakeupNodeFactory();
            }
            return wakeupNodeFactoryInstance;
        }

        public static ThreadNodes.WakeupNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new WakeupNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.WakeupNode.class)
        public static final class WakeupNodeGen
        extends ThreadNodes.WakeupNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private WakeupNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.wakeup(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ValueNode.class)
    public static final class ValueNodeFactory
    extends NodeFactoryBase<ThreadNodes.ValueNode> {
        private static ValueNodeFactory valueNodeFactoryInstance;

        private ValueNodeFactory() {
            super(ThreadNodes.ValueNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.ValueNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ValueNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ValueNode> getInstance() {
            if (valueNodeFactoryInstance == null) {
                valueNodeFactoryInstance = new ValueNodeFactory();
            }
            return valueNodeFactoryInstance;
        }

        public static ThreadNodes.ValueNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ValueNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.ValueNode.class)
        public static final class ValueNodeGen
        extends ThreadNodes.ValueNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ValueNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.value(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.StopNode.class)
    public static final class StopNodeFactory
    extends NodeFactoryBase<ThreadNodes.StopNode> {
        private static StopNodeFactory stopNodeFactoryInstance;

        private StopNodeFactory() {
            super(ThreadNodes.StopNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.StopNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StopNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.StopNode> getInstance() {
            if (stopNodeFactoryInstance == null) {
                stopNodeFactoryInstance = new StopNodeFactory();
            }
            return stopNodeFactoryInstance;
        }

        public static ThreadNodes.StopNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new StopNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.StopNode.class)
        public static final class StopNodeGen
        extends ThreadNodes.StopNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private StopNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.stop(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.StatusNode.class)
    public static final class StatusNodeFactory
    extends NodeFactoryBase<ThreadNodes.StatusNode> {
        private static StatusNodeFactory statusNodeFactoryInstance;

        private StatusNodeFactory() {
            super(ThreadNodes.StatusNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.StatusNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StatusNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.StatusNode> getInstance() {
            if (statusNodeFactoryInstance == null) {
                statusNodeFactoryInstance = new StatusNodeFactory();
            }
            return statusNodeFactoryInstance;
        }

        public static ThreadNodes.StatusNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new StatusNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.StatusNode.class)
        public static final class StatusNodeGen
        extends ThreadNodes.StatusNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private StatusNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.status(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.PassNode.class)
    public static final class PassNodeFactory
    extends NodeFactoryBase<ThreadNodes.PassNode> {
        private static PassNodeFactory passNodeFactoryInstance;

        private PassNodeFactory() {
            super(ThreadNodes.PassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.PassNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PassNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.PassNode> getInstance() {
            if (passNodeFactoryInstance == null) {
                passNodeFactoryInstance = new PassNodeFactory();
            }
            return passNodeFactoryInstance;
        }

        public static ThreadNodes.PassNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PassNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.PassNode.class)
        public static final class PassNodeGen
        extends ThreadNodes.PassNode {
            private PassNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.pass(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.MainNode.class)
    public static final class MainNodeFactory
    extends NodeFactoryBase<ThreadNodes.MainNode> {
        private static MainNodeFactory mainNodeFactoryInstance;

        private MainNodeFactory() {
            super(ThreadNodes.MainNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.MainNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MainNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.MainNode> getInstance() {
            if (mainNodeFactoryInstance == null) {
                mainNodeFactoryInstance = new MainNodeFactory();
            }
            return mainNodeFactoryInstance;
        }

        public static ThreadNodes.MainNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MainNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.MainNode.class)
        public static final class MainNodeGen
        extends ThreadNodes.MainNode {
            private MainNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.main();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.JoinNode.class)
    public static final class JoinNodeFactory
    extends NodeFactoryBase<ThreadNodes.JoinNode> {
        private static JoinNodeFactory joinNodeFactoryInstance;

        private JoinNodeFactory() {
            super(ThreadNodes.JoinNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.JoinNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return JoinNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.JoinNode> getInstance() {
            if (joinNodeFactoryInstance == null) {
                joinNodeFactoryInstance = new JoinNodeFactory();
            }
            return joinNodeFactoryInstance;
        }

        public static ThreadNodes.JoinNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new JoinNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.JoinNode.class)
        public static final class JoinNodeGen
        extends ThreadNodes.JoinNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private JoinNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="join(DynamicObject, double)", value=ThreadNodes.JoinNode.class)
            private static final class Join3Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Join3Node_(JoinNodeGen root, Object arguments1Value) {
                    super(root, 4);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Join3Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    double arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.join(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.join(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(JoinNodeGen root, Object arguments1Value) {
                    return new Join3Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="join(DynamicObject, int)", value=ThreadNodes.JoinNode.class)
            private static final class Join2Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Join2Node_(JoinNodeGen root, Object arguments1Value) {
                    super(root, 3);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Join2Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.join(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.join(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(JoinNodeGen root, Object arguments1Value) {
                    return new Join2Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="join(DynamicObject, Object)", value=ThreadNodes.JoinNode.class)
            private static final class Join1Node_
            extends BaseNode_ {
                Join1Node_(JoinNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (this.root.isNil(arguments1Value)) {
                            return this.root.join(arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(JoinNodeGen root) {
                    return new Join1Node_(root);
                }
            }

            @GeneratedBy(methodName="join(DynamicObject, NotProvided)", value=ThreadNodes.JoinNode.class)
            private static final class Join0Node_
            extends BaseNode_ {
                Join0Node_(JoinNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.join(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(JoinNodeGen root) {
                    return new Join0Node_(root);
                }
            }

            @GeneratedBy(value=ThreadNodes.JoinNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(JoinNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(JoinNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ThreadNodes.JoinNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(JoinNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(JoinNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ThreadNodes.JoinNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected JoinNodeGen root;

                BaseNode_(JoinNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (JoinNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (arguments1Value instanceof NotProvided) {
                            return Join0Node_.create(this.root);
                        }
                        if (this.root.isNil(arguments1Value)) {
                            return Join1Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Join2Node_.create(this.root, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value)) {
                            return Join3Node_.create(this.root, arguments1Value);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<ThreadNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(ThreadNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static ThreadNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends ThreadNodes.InitializeNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private InitializeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments2Value_;
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value, arguments2Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    throw this.unsupported(arguments0Value_, ex.getResult(), arguments2Value);
                }
                try {
                    arguments2Value_ = this.arguments2_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, arguments1Value_, ex.getResult());
                }
                return this.initialize(arguments0Value_, arguments1Value_, arguments2Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.HandleInterruptNode.class)
    public static final class HandleInterruptNodeFactory
    extends NodeFactoryBase<ThreadNodes.HandleInterruptNode> {
        private static HandleInterruptNodeFactory handleInterruptNodeFactoryInstance;

        private HandleInterruptNodeFactory() {
            super(ThreadNodes.HandleInterruptNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.HandleInterruptNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return HandleInterruptNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.HandleInterruptNode> getInstance() {
            if (handleInterruptNodeFactoryInstance == null) {
                handleInterruptNodeFactoryInstance = new HandleInterruptNodeFactory();
            }
            return handleInterruptNodeFactoryInstance;
        }

        public static ThreadNodes.HandleInterruptNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new HandleInterruptNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.HandleInterruptNode.class)
        public static final class HandleInterruptNodeGen
        extends ThreadNodes.HandleInterruptNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private HandleInterruptNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments3Value_;
                DynamicObject arguments2Value_;
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    Object arguments3Value = this.arguments3_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    Object arguments3Value = this.arguments3_.execute(frameValue);
                    throw this.unsupported(arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                }
                try {
                    arguments2Value_ = this.arguments2_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value = this.arguments3_.execute(frameValue);
                    throw this.unsupported(arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
                }
                try {
                    arguments3Value_ = this.arguments3_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                }
                if (RubyGuards.isRubyClass(arguments1Value_) && RubyGuards.isRubySymbol(arguments2Value_)) {
                    return this.handle_interrupt(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.KillNode.class)
    public static final class KillNodeFactory
    extends NodeFactoryBase<ThreadNodes.KillNode> {
        private static KillNodeFactory killNodeFactoryInstance;

        private KillNodeFactory() {
            super(ThreadNodes.KillNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.KillNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KillNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.KillNode> getInstance() {
            if (killNodeFactoryInstance == null) {
                killNodeFactoryInstance = new KillNodeFactory();
            }
            return killNodeFactoryInstance;
        }

        public static ThreadNodes.KillNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new KillNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.KillNode.class)
        public static final class KillNodeGen
        extends ThreadNodes.KillNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private KillNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.kill(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.CurrentNode.class)
    public static final class CurrentNodeFactory
    extends NodeFactoryBase<ThreadNodes.CurrentNode> {
        private static CurrentNodeFactory currentNodeFactoryInstance;

        private CurrentNodeFactory() {
            super(ThreadNodes.CurrentNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.CurrentNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CurrentNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.CurrentNode> getInstance() {
            if (currentNodeFactoryInstance == null) {
                currentNodeFactoryInstance = new CurrentNodeFactory();
            }
            return currentNodeFactoryInstance;
        }

        public static ThreadNodes.CurrentNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CurrentNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.CurrentNode.class)
        public static final class CurrentNodeGen
        extends ThreadNodes.CurrentNode {
            private CurrentNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.current();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.BacktraceNode.class)
    public static final class BacktraceNodeFactory
    extends NodeFactoryBase<ThreadNodes.BacktraceNode> {
        private static BacktraceNodeFactory backtraceNodeFactoryInstance;

        private BacktraceNodeFactory() {
            super(ThreadNodes.BacktraceNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.BacktraceNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BacktraceNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.BacktraceNode> getInstance() {
            if (backtraceNodeFactoryInstance == null) {
                backtraceNodeFactoryInstance = new BacktraceNodeFactory();
            }
            return backtraceNodeFactoryInstance;
        }

        public static ThreadNodes.BacktraceNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BacktraceNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.BacktraceNode.class)
        public static final class BacktraceNodeGen
        extends ThreadNodes.BacktraceNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private BacktraceNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.backtrace(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.AliveNode.class)
    public static final class AliveNodeFactory
    extends NodeFactoryBase<ThreadNodes.AliveNode> {
        private static AliveNodeFactory aliveNodeFactoryInstance;

        private AliveNodeFactory() {
            super(ThreadNodes.AliveNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.AliveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AliveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.AliveNode> getInstance() {
            if (aliveNodeFactoryInstance == null) {
                aliveNodeFactoryInstance = new AliveNodeFactory();
            }
            return aliveNodeFactoryInstance;
        }

        public static ThreadNodes.AliveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AliveNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ThreadNodes.AliveNode.class)
        public static final class AliveNodeGen
        extends ThreadNodes.AliveNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AliveNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.alive(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }
}

