/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.array.ArrayUtils;

public class ReturnEnumeratorIfNoBlockNode
extends RubyNode {
    @Node.Child
    private RubyNode method;
    @Node.Child
    private CallDispatchHeadNode toEnumNode;
    private final String methodName;
    private final ConditionProfile noBlockProfile = ConditionProfile.createBinaryProfile();

    public ReturnEnumeratorIfNoBlockNode(String methodName, RubyNode method) {
        super(method.getContext(), method.getEncapsulatingSourceSection());
        this.method = method;
        this.methodName = methodName;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject block = RubyArguments.getBlock(frame.getArguments());
        if (this.noBlockProfile.profile(block == null)) {
            if (this.toEnumNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toEnumNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            Object[] arguments = ArrayUtils.unshift(RubyArguments.getArguments(frame.getArguments()), this.getSymbol(this.methodName));
            return this.toEnumNode.call(frame, RubyArguments.getSelf(frame.getArguments()), "to_enum", null, arguments);
        }
        return this.method.execute(frame);
    }
}

