/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes;

import com.oracle.truffle.api.ExecutionContext;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.RubyLanguage;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;

public class RubyRootNode
extends RootNode {
    private final RubyContext context;
    private final SharedMethodInfo sharedMethodInfo;
    @Node.Child
    private RubyNode body;
    private final boolean needsDeclarationFrame;

    public RubyRootNode(RubyContext context, SourceSection sourceSection, FrameDescriptor frameDescriptor, SharedMethodInfo sharedMethodInfo, RubyNode body) {
        this(context, sourceSection, frameDescriptor, sharedMethodInfo, body, false);
    }

    public RubyRootNode(RubyContext context, SourceSection sourceSection, FrameDescriptor frameDescriptor, SharedMethodInfo sharedMethodInfo, RubyNode body, boolean needsDeclarationFrame) {
        super(RubyLanguage.class, sourceSection, frameDescriptor);
        assert (body != null);
        this.context = context;
        this.body = body;
        this.sharedMethodInfo = sharedMethodInfo;
        this.needsDeclarationFrame = needsDeclarationFrame;
        if (context.getCallGraph() != null) {
            context.getCallGraph().registerRootNode(this);
        }
    }

    public RubyRootNode withBody(RubyNode body) {
        return new RubyRootNode(this.context, this.getSourceSection(), this.getFrameDescriptor(), this.sharedMethodInfo, body, this.needsDeclarationFrame);
    }

    public boolean isCloningAllowed() {
        return true;
    }

    public Object execute(VirtualFrame frame) {
        this.context.getSafepointManager().poll((Node)this);
        return this.body.execute(frame);
    }

    public String toString() {
        return this.sharedMethodInfo.toString();
    }

    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }

    public RubyNode getBody() {
        return this.body;
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    public boolean needsDeclarationFrame() {
        return this.needsDeclarationFrame;
    }

    public Node copy() {
        RubyRootNode cloned = (RubyRootNode)super.copy();
        if (this.context.getCallGraph() != null) {
            this.context.getCallGraph().registerRootNode(cloned);
        }
        return cloned;
    }
}

