/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.parser;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.RootNode;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jruby.truffle.format.nodes.PackRootNode;
import org.jruby.truffle.format.parser.PackErrorListener;
import org.jruby.truffle.format.parser.PackLexer;
import org.jruby.truffle.format.parser.PackParser;
import org.jruby.truffle.format.parser.PackTreeBuilder;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;

public class PackCompiler {
    private final RubyContext context;
    private final RubyNode currentNode;

    public PackCompiler(RubyContext context, RubyNode currentNode) {
        this.context = context;
        this.currentNode = currentNode;
    }

    public CallTarget compile(String format) {
        if (format.length() > this.context.getOptions().PACK_RECOVER_LOOP_MIN) {
            format = PackCompiler.recoverLoop(format);
        }
        PackErrorListener errorListener = new PackErrorListener(this.context, this.currentNode);
        ANTLRInputStream input = new ANTLRInputStream(format);
        PackLexer lexer = new PackLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PackParser parser = new PackParser((TokenStream)tokens);
        PackTreeBuilder builder = new PackTreeBuilder(this.context, this.currentNode);
        parser.addParseListener(builder);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        parser.sequence();
        return Truffle.getRuntime().createCallTarget((RootNode)new PackRootNode(PackCompiler.describe(format), builder.getEncoding(), builder.getNode()));
    }

    public static String recoverLoop(String format) {
        int index = 0;
        while (index < format.length()) {
            if ("CSLQcslqInNvVUwDdFfEeFfAaZBbHhuMmpPXx@".indexOf(format.charAt(index)) == -1) {
                ++index;
                continue;
            }
            int successfulLengthOfLoopedString = -1;
            for (int tryLengthOfLoopedString = 1; tryLengthOfLoopedString <= index && index + tryLengthOfLoopedString <= format.length(); ++tryLengthOfLoopedString) {
                String afterIndex;
                String beforeIndex = format.substring(index - tryLengthOfLoopedString, index);
                if (!beforeIndex.equals(afterIndex = format.substring(index, index + tryLengthOfLoopedString))) continue;
                successfulLengthOfLoopedString = tryLengthOfLoopedString;
            }
            if (successfulLengthOfLoopedString == -1) {
                ++index;
                continue;
            }
            String repeated = format.substring(index, index + successfulLengthOfLoopedString);
            int repetitionsCount = 2;
            int indexOfEndOfRepititions = index + successfulLengthOfLoopedString;
            while (indexOfEndOfRepititions + successfulLengthOfLoopedString <= format.length() && format.substring(indexOfEndOfRepititions, indexOfEndOfRepititions + successfulLengthOfLoopedString).equals(repeated)) {
                ++repetitionsCount;
                indexOfEndOfRepititions += successfulLengthOfLoopedString;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(format.substring(0, index - successfulLengthOfLoopedString));
            builder.append('(');
            builder.append(repeated);
            builder.append(')');
            builder.append(repetitionsCount);
            builder.append(format.substring(indexOfEndOfRepititions));
            format = builder.toString();
        }
        return format;
    }

    public static String describe(String format) {
        if ((format = format.replace("\\s+", "")).length() > 10) {
            format = format.substring(0, 10) + "\u2026";
        }
        return format;
    }
}

