/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.callgraph;

import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.HashMap;
import java.util.Map;
import org.jruby.truffle.callgraph.CallSite;
import org.jruby.truffle.callgraph.CallSiteVersion;
import org.jruby.truffle.callgraph.Calls;
import org.jruby.truffle.callgraph.CallsForeign;
import org.jruby.truffle.callgraph.CallsMegamorphic;
import org.jruby.truffle.callgraph.CallsMethod;
import org.jruby.truffle.callgraph.Method;
import org.jruby.truffle.nodes.RubyRootNode;

public class MethodVersion {
    private final Method method;
    private final RubyRootNode rootNode;
    private final Map<CallSite, CallSiteVersion> callSiteVersions = new HashMap<CallSite, CallSiteVersion>();

    public MethodVersion(Method method, RubyRootNode rootNode) {
        this.method = method;
        this.rootNode = rootNode;
        method.getVersions().add(this);
    }

    public Method getMethod() {
        return this.method;
    }

    public Map<CallSite, CallSiteVersion> getCallSiteVersions() {
        return this.callSiteVersions;
    }

    public void resolve() {
        this.rootNode.accept(new NodeVisitor(){

            public boolean visit(Node node) {
                MethodVersion.this.resolve(node);
                return true;
            }
        });
    }

    private void resolve(Node node) {
        if (node instanceof DirectCallNode || node instanceof IndirectCallNode) {
            Calls calls;
            CallSiteVersion callSiteVersion = this.getCallSiteVersion(node);
            if (node instanceof DirectCallNode) {
                DirectCallNode directNode = (DirectCallNode)node;
                RootNode rootNode = directNode.getCurrentRootNode();
                if (rootNode instanceof RubyRootNode) {
                    MethodVersion methodVersion = this.method.getCallGraph().rootNodeToMethodVersion((RubyRootNode)rootNode);
                    calls = new CallsMethod(methodVersion);
                } else {
                    calls = CallsForeign.INSTANCE;
                }
            } else {
                calls = CallsMegamorphic.INSTANCE;
            }
            callSiteVersion.getCalls().add(calls);
        }
    }

    private CallSiteVersion getCallSiteVersion(Node node) {
        CallSite callSite = this.method.getCallSite(node);
        CallSiteVersion callSiteVersion = this.callSiteVersions.get(callSite);
        if (callSiteVersion == null) {
            callSiteVersion = new CallSiteVersion(callSite, this);
            this.callSiteVersions.put(callSite, callSiteVersion);
        }
        return callSiteVersion;
    }

    public RubyRootNode getRootNode() {
        return this.rootNode;
    }
}

