/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.supercall;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.ProcOrNullNode;
import org.jruby.truffle.nodes.cast.ProcOrNullNodeGen;
import org.jruby.truffle.nodes.methods.CallMethodNode;
import org.jruby.truffle.nodes.methods.CallMethodNodeGen;
import org.jruby.truffle.nodes.methods.DeclarationContext;
import org.jruby.truffle.nodes.supercall.LookupSuperMethodNode;
import org.jruby.truffle.nodes.supercall.LookupSuperMethodNodeGen;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class GeneralSuperReCallNode
extends RubyNode {
    private final boolean hasRestParameter;
    @Node.Children
    private final RubyNode[] reloadNodes;
    @Node.Child
    private RubyNode block;
    @Node.Child
    ProcOrNullNode procOrNullNode;
    @Node.Child
    LookupSuperMethodNode lookupSuperMethodNode;
    @Node.Child
    CallMethodNode callMethodNode;

    public GeneralSuperReCallNode(RubyContext context, SourceSection sourceSection, boolean hasRestParameter, RubyNode[] reloadNodes, RubyNode block) {
        super(context, sourceSection);
        this.hasRestParameter = hasRestParameter;
        this.reloadNodes = reloadNodes;
        this.block = block;
        this.procOrNullNode = ProcOrNullNodeGen.create(context, sourceSection, null);
        this.lookupSuperMethodNode = LookupSuperMethodNodeGen.create(context, sourceSection, null);
        this.callMethodNode = CallMethodNodeGen.create(context, sourceSection, null, new RubyNode[0]);
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        CompilerAsserts.compilationConstant((Object)this.reloadNodes.length);
        Object self = RubyArguments.getSelf(frame.getArguments());
        Object[] originalArguments = frame.getArguments();
        Object[] superArguments = new Object[this.reloadNodes.length];
        for (int n = 0; n < superArguments.length; ++n) {
            superArguments[n] = this.reloadNodes[n].execute(frame);
        }
        if (this.hasRestParameter) {
            CompilerDirectives.transferToInterpreter();
            Object restArg = superArguments[superArguments.length - 1];
            assert (RubyGuards.isRubyArray(restArg));
            Object[] restArgs = ArrayOperations.toObjectArray((DynamicObject)restArg);
            int restArgIndex = this.reloadNodes.length - 1;
            superArguments = Arrays.copyOf(superArguments, restArgIndex + restArgs.length);
            ArrayUtils.arraycopy(restArgs, 0, superArguments, restArgIndex, restArgs.length);
        }
        DynamicObject blockObject = this.block != null ? this.procOrNullNode.executeProcOrNull(this.block.execute(frame)) : RubyArguments.getBlock(originalArguments);
        InternalMethod superMethod = this.lookupSuperMethodNode.executeLookupSuperMethod(frame, self);
        if (superMethod == null) {
            CompilerDirectives.transferToInterpreter();
            String name = RubyArguments.getMethod(frame.getArguments()).getSharedMethodInfo().getName();
            throw new RaiseException(this.getContext().getCoreLibrary().noMethodError(String.format("super: no superclass method `%s'", name), name, this));
        }
        Object[] frameArguments = RubyArguments.pack(superMethod, RubyArguments.getDeclarationFrame(originalArguments), null, RubyArguments.getSelf(originalArguments), blockObject, DeclarationContext.METHOD, superArguments);
        return this.callMethodNode.executeCallMethod(frame, superMethod, frameArguments);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        Object self = RubyArguments.getSelf(frame.getArguments());
        InternalMethod superMethod = this.lookupSuperMethodNode.executeLookupSuperMethod(frame, self);
        if (superMethod == null) {
            return this.nil();
        }
        return this.create7BitString(StringOperations.encodeByteList("super", (Encoding)UTF8Encoding.INSTANCE));
    }
}

