/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.interop.ForeignAccessArguments;
import com.oracle.truffle.interop.messages.Execute;
import com.oracle.truffle.interop.messages.Read;
import com.oracle.truffle.interop.messages.Write;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.interop.IndexLabelToRubyNode;
import org.jruby.truffle.nodes.interop.IndexLabelToRubyNodeGen;
import org.jruby.truffle.nodes.objects.ReadInstanceVariableNode;
import org.jruby.truffle.nodes.objects.WriteInstanceVariableNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;

public abstract class InteropNode
extends RubyNode {
    public InteropNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public static InteropNode createRead(RubyContext context, SourceSection sourceSection, Read read) {
        return new UnresolvedInteropReadNode(context, sourceSection, read);
    }

    public static InteropNode createWrite(RubyContext context, SourceSection sourceSection, Write write) {
        return new UnresolvedInteropWriteNode(context, sourceSection, write);
    }

    public static InteropNode createExecuteAfterRead(RubyContext context, SourceSection sourceSection, Execute execute) {
        return new UnresolvedInteropExecuteAfterReadNode(context, sourceSection, execute);
    }

    public static InteropNode createIsExecutable(RubyContext context, SourceSection sourceSection) {
        return new InteropIsExecutable(context, sourceSection);
    }

    public static InteropNode createIsBoxedPrimitive(RubyContext context, SourceSection sourceSection) {
        return new InteropIsBoxedPrimitive(context, sourceSection);
    }

    public static InteropNode createIsNull(RubyContext context, SourceSection sourceSection) {
        return new InteropIsNull(context, sourceSection);
    }

    public static InteropNode createHasSizePropertyFalse(RubyContext context, SourceSection sourceSection) {
        return new InteropHasSizePropertyFalse(context, sourceSection);
    }

    public static InteropNode createHasSizePropertyTrue(RubyContext context, SourceSection sourceSection) {
        return new InteropHasSizePropertyTrue(context, sourceSection);
    }

    public static RubyNode createGetSize(RubyContext context, SourceSection sourceSection) {
        return new InteropGetSizeProperty(context, sourceSection);
    }

    public static RubyNode createStringIsBoxed(RubyContext context, SourceSection sourceSection) {
        return new InteropStringIsBoxed(context, sourceSection);
    }

    public static RubyNode createStringRead(RubyContext context, SourceSection sourceSection, Read read) {
        return new UnresolvedInteropStringReadNode(context, sourceSection, read);
    }

    public static RubyNode createStringUnbox(RubyContext context, SourceSection sourceSection) {
        return new InteropStringUnboxNode(context, sourceSection);
    }

    private static class InteropArgumentsNode
    extends RubyNode {
        @Node.Children
        private final InteropArgumentNode[] arguments;

        public InteropArgumentsNode(RubyContext context, SourceSection sourceSection, Execute message) {
            super(context, sourceSection);
            this.arguments = new InteropArgumentNode[message.getArity() - 1];
            for (int i = 2; i < 2 + message.getArity() - 1; ++i) {
                this.arguments[i - 2] = new InteropArgumentNode(context, sourceSection, i);
            }
        }

        public int getCount(VirtualFrame frame) {
            return this.arguments.length;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException();
        }

        @ExplodeLoop
        public void executeFillObjectArray(VirtualFrame frame, Object[] args) {
            for (int i = 0; i < this.arguments.length; ++i) {
                args[i] = this.arguments[i].execute(frame);
            }
        }
    }

    private static class InteropArgumentNode
    extends RubyNode {
        private final int index;

        public InteropArgumentNode(RubyContext context, SourceSection sourceSection, int index) {
            super(context, sourceSection);
            this.index = index;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return ForeignAccessArguments.extractUserArguments((Object[])frame.getArguments())[this.index];
        }
    }

    private static class ResolvedInteropExecuteAfterReadNode
    extends InteropNode {
        @Node.Child
        private DispatchHeadNode head;
        @Node.Child
        private InteropArgumentsNode arguments;
        private final String name;
        private final int labelIndex;
        private final int receiverIndex;

        public ResolvedInteropExecuteAfterReadNode(RubyContext context, SourceSection sourceSection, String name, Execute message) {
            super(context, sourceSection);
            this.name = name;
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
            this.arguments = new InteropArgumentsNode(context, sourceSection, message);
            this.labelIndex = 0;
            this.receiverIndex = 1;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (this.name.equals(ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.labelIndex))) {
                Object[] args = new Object[this.arguments.getCount(frame)];
                this.arguments.executeFillObjectArray(frame, args);
                return this.head.dispatch(frame, ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.receiverIndex), ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.labelIndex), null, args);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Name changed");
        }
    }

    private static class UnresolvedInteropExecuteAfterReadNode
    extends InteropNode {
        private final Execute execute;
        private final int labelIndex;

        public UnresolvedInteropExecuteAfterReadNode(RubyContext context, SourceSection sourceSection, Execute execute) {
            super(context, sourceSection);
            this.execute = execute;
            this.labelIndex = 0;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.labelIndex) instanceof String) {
                return ((ResolvedInteropExecuteAfterReadNode)this.replace(new ResolvedInteropExecuteAfterReadNode(this.getContext(), this.getSourceSection(), (String)ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.labelIndex), this.execute))).execute(frame);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)0) + " not allowed as name");
        }
    }

    private static class ResolvedInteropWriteToSymbolNode
    extends InteropNode {
        @Node.Child
        private DispatchHeadNode head;
        private final DynamicObject name;
        private final DynamicObject accessName;
        private final int labelIndex;
        private final int valueIndex;

        public ResolvedInteropWriteToSymbolNode(RubyContext context, SourceSection sourceSection, DynamicObject name, int labelIndex, int valueIndex) {
            super(context, sourceSection);
            this.name = name;
            this.accessName = context.getSymbol(Layouts.SYMBOL.getString(name) + "=");
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
            this.labelIndex = labelIndex;
            this.valueIndex = valueIndex;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (this.name.equals(ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.labelIndex))) {
                Object value = ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.valueIndex);
                return this.head.dispatch(frame, ForeignAccessArguments.getReceiver((Object[])frame.getArguments()), this.accessName, null, new Object[]{value});
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Name changed");
        }
    }

    private static class ResolvedInteropWriteNode
    extends InteropNode {
        @Node.Child
        private DispatchHeadNode head;
        private final String name;
        private final String accessName;
        private final int labelIndex;
        private final int valueIndex;

        public ResolvedInteropWriteNode(RubyContext context, SourceSection sourceSection, String name, int labelIndex, int valueIndex) {
            super(context, sourceSection);
            this.name = name;
            this.accessName = name + "=";
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
            this.labelIndex = labelIndex;
            this.valueIndex = valueIndex;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (this.name.equals(ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.labelIndex))) {
                Object value = ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.valueIndex);
                return this.head.dispatch(frame, ForeignAccessArguments.getReceiver((Object[])frame.getArguments()), this.accessName, null, new Object[]{value});
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Name changed");
        }
    }

    private static class ResolvedInteropIndexedWriteNode
    extends RubyNode {
        private final String name;
        @Node.Child
        private DispatchHeadNode head;
        @Node.Child
        private IndexLabelToRubyNode toRubyIndex;
        private final int indexIndex;
        private final int valueIndex;

        public ResolvedInteropIndexedWriteNode(RubyContext context, SourceSection sourceSection, int indexIndex, int valueIndex) {
            super(context, sourceSection);
            this.name = "[]=";
            this.indexIndex = indexIndex;
            this.valueIndex = valueIndex;
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
            this.toRubyIndex = IndexLabelToRubyNodeGen.create(context, sourceSection, null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object index = this.toRubyIndex.executeWithTarget(frame, ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.indexIndex));
            Object value = ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.valueIndex);
            return this.head.dispatch(frame, ForeignAccessArguments.getReceiver((Object[])frame.getArguments()), this.name, null, new Object[]{index, value});
        }
    }

    private static class UnresolvedInteropWriteNode
    extends InteropNode {
        private final int labelIndex;
        private final int valueIndex;

        public UnresolvedInteropWriteNode(RubyContext context, SourceSection sourceSection, Write write) {
            super(context, sourceSection);
            this.labelIndex = 0;
            this.valueIndex = 1;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object label = ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.labelIndex);
            if (label instanceof String || RubyGuards.isRubySymbol(label) || label instanceof Integer) {
                String name;
                if (label instanceof String && (name = (String)label).startsWith("@")) {
                    return ((InteropInstanceVariableWriteNode)this.replace(new InteropInstanceVariableWriteNode(this.getContext(), this.getSourceSection(), name, this.labelIndex, this.valueIndex))).execute(frame);
                }
                DynamicObject receiver = (DynamicObject)ForeignAccessArguments.getReceiver((Object[])frame.getArguments());
                InternalMethod labelMethod = ModuleOperations.lookupMethod(this.getContext().getCoreLibrary().getMetaClass(receiver), label.toString());
                InternalMethod indexedSetter = ModuleOperations.lookupMethod(this.getContext().getCoreLibrary().getMetaClass(receiver), "[]=");
                if (labelMethod == null && indexedSetter != null) {
                    return ((ResolvedInteropIndexedWriteNode)this.replace(new ResolvedInteropIndexedWriteNode(this.getContext(), this.getSourceSection(), this.labelIndex, this.valueIndex))).execute(frame);
                }
                if (label instanceof String) {
                    return ((ResolvedInteropWriteNode)this.replace(new ResolvedInteropWriteNode(this.getContext(), this.getSourceSection(), (String)label, this.labelIndex, this.valueIndex))).execute(frame);
                }
                if (RubyGuards.isRubySymbol(label)) {
                    return ((ResolvedInteropWriteToSymbolNode)this.replace(new ResolvedInteropWriteToSymbolNode(this.getContext(), this.getSourceSection(), (DynamicObject)label, this.labelIndex, this.valueIndex))).execute(frame);
                }
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(label + " not allowed as name");
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(label + " not allowed as name");
        }
    }

    private static class ResolvedInteropReadFromSymbolNode
    extends InteropNode {
        @Node.Child
        private DispatchHeadNode head;
        private final DynamicObject name;
        private final int labelIndex;

        public ResolvedInteropReadFromSymbolNode(RubyContext context, SourceSection sourceSection, DynamicObject name, int labelIndex) {
            super(context, sourceSection);
            this.name = name;
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
            this.labelIndex = labelIndex;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (this.name.equals(ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.labelIndex))) {
                return this.head.dispatch(frame, ForeignAccessArguments.getReceiver((Object[])frame.getArguments()), this.name, null, new Object[0]);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Name changed");
        }
    }

    private static class ResolvedInteropReadNode
    extends InteropNode {
        @Node.Child
        private DispatchHeadNode head;
        private final String name;
        private final int labelIndex;

        public ResolvedInteropReadNode(RubyContext context, SourceSection sourceSection, String name, int labelIndex) {
            super(context, sourceSection);
            this.name = name;
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
            this.labelIndex = labelIndex;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (this.name.equals(ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.labelIndex))) {
                return this.head.dispatch(frame, ForeignAccessArguments.getReceiver((Object[])frame.getArguments()), this.name, null, new Object[0]);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Name changed");
        }
    }

    private static class RubyInteropArgumentNode
    extends RubyNode {
        private final int index;

        public RubyInteropArgumentNode(RubyContext context, SourceSection sourceSection, int index) {
            super(context, sourceSection);
            this.index = index;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.index);
        }
    }

    private static class RubyInteropReceiverNode
    extends RubyNode {
        public RubyInteropReceiverNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return ForeignAccessArguments.getReceiver((Object[])frame.getArguments());
        }
    }

    private static class InteropInstanceVariableWriteNode
    extends RubyNode {
        @Node.Child
        private WriteInstanceVariableNode write;
        private final String name;
        private final int labelIndex;

        public InteropInstanceVariableWriteNode(RubyContext context, SourceSection sourceSection, String name, int labelIndex, int valueIndex) {
            super(context, sourceSection);
            this.name = name;
            this.labelIndex = labelIndex;
            this.write = new WriteInstanceVariableNode(context, sourceSection, name, new RubyInteropReceiverNode(context, sourceSection), new RubyInteropArgumentNode(context, sourceSection, valueIndex), false);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (this.name.equals((String)ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.labelIndex))) {
                return this.write.execute(frame);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Not implemented");
        }
    }

    private static class InteropInstanceVariableReadNode
    extends InteropNode {
        @Node.Child
        private ReadInstanceVariableNode read;
        private final String name;
        private final int labelIndex;

        public InteropInstanceVariableReadNode(RubyContext context, SourceSection sourceSection, String name, int labelIndex) {
            super(context, sourceSection);
            this.name = name;
            this.read = new ReadInstanceVariableNode(context, sourceSection, name, new RubyInteropReceiverNode(context, sourceSection), false);
            this.labelIndex = labelIndex;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (this.name.equals((String)ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.labelIndex))) {
                return this.read.execute(frame);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Not implemented");
        }
    }

    private static class ResolvedInteropIndexedReadNode
    extends RubyNode {
        private final String name;
        @Node.Child
        private DispatchHeadNode head;
        @Node.Child
        private IndexLabelToRubyNode toRubyIndex;
        private final int indexIndex;

        public ResolvedInteropIndexedReadNode(RubyContext context, SourceSection sourceSection, int indexIndex) {
            super(context, sourceSection);
            this.name = "[]";
            this.indexIndex = indexIndex;
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
            this.toRubyIndex = IndexLabelToRubyNodeGen.create(context, sourceSection, null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object index = this.toRubyIndex.executeWithTarget(frame, ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.indexIndex));
            return this.head.dispatch(frame, ForeignAccessArguments.getReceiver((Object[])frame.getArguments()), this.name, null, new Object[]{index});
        }
    }

    static class InteropReadStringByteNode
    extends RubyNode {
        private final int labelIndex;

        public InteropReadStringByteNode(RubyContext context, SourceSection sourceSection, int labelIndex) {
            super(context, sourceSection);
            this.labelIndex = labelIndex;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (RubyGuards.isRubyString(ForeignAccessArguments.getReceiver((Object[])frame.getArguments()))) {
                DynamicObject string = (DynamicObject)ForeignAccessArguments.getReceiver((Object[])frame.getArguments());
                int index = (Integer)ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.labelIndex);
                if (index >= StringOperations.getByteList(string).length()) {
                    return 0;
                }
                return (byte)StringOperations.getByteList(string).get(index);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Not implemented");
        }
    }

    private static class UnresolvedInteropStringReadNode
    extends InteropNode {
        private final int labelIndex;

        public UnresolvedInteropStringReadNode(RubyContext context, SourceSection sourceSection, Read read) {
            super(context, sourceSection);
            this.labelIndex = 0;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object label = ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.labelIndex);
            if (label instanceof String || RubyGuards.isRubySymbol(label) || label instanceof Integer) {
                String name;
                if (label instanceof String && (name = (String)label).startsWith("@")) {
                    return ((InteropInstanceVariableReadNode)this.replace(new InteropInstanceVariableReadNode(this.getContext(), this.getSourceSection(), name, this.labelIndex))).execute(frame);
                }
                if (label instanceof Integer || label instanceof Long) {
                    return ((InteropReadStringByteNode)this.replace(new InteropReadStringByteNode(this.getContext(), this.getSourceSection(), this.labelIndex))).execute(frame);
                }
                if (label instanceof String) {
                    return ((ResolvedInteropReadNode)this.replace(new ResolvedInteropReadNode(this.getContext(), this.getSourceSection(), (String)label, this.labelIndex))).execute(frame);
                }
                if (RubyGuards.isRubySymbol(label)) {
                    return ((ResolvedInteropReadFromSymbolNode)this.replace(new ResolvedInteropReadFromSymbolNode(this.getContext(), this.getSourceSection(), (DynamicObject)label, this.labelIndex))).execute(frame);
                }
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(label + " not allowed as name");
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(label + " not allowed as name");
        }
    }

    private static class UnresolvedInteropReadNode
    extends InteropNode {
        private final int labelIndex;

        public UnresolvedInteropReadNode(RubyContext context, SourceSection sourceSection, Read read) {
            super(context, sourceSection);
            this.labelIndex = 0;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object label = ForeignAccessArguments.getArgument((Object[])frame.getArguments(), (int)this.labelIndex);
            if (label instanceof String || RubyGuards.isRubySymbol(label) || label instanceof Integer) {
                String name;
                if (label instanceof String && (name = (String)label).startsWith("@")) {
                    return ((InteropInstanceVariableReadNode)this.replace(new InteropInstanceVariableReadNode(this.getContext(), this.getSourceSection(), name, this.labelIndex))).execute(frame);
                }
                DynamicObject receiver = (DynamicObject)ForeignAccessArguments.getReceiver((Object[])frame.getArguments());
                InternalMethod labelMethod = ModuleOperations.lookupMethod(this.getContext().getCoreLibrary().getMetaClass(receiver), label.toString());
                InternalMethod indexedSetter = ModuleOperations.lookupMethod(this.getContext().getCoreLibrary().getMetaClass(receiver), "[]=");
                if (labelMethod == null && indexedSetter != null) {
                    return ((ResolvedInteropIndexedReadNode)this.replace(new ResolvedInteropIndexedReadNode(this.getContext(), this.getSourceSection(), this.labelIndex))).execute(frame);
                }
                if (label instanceof String) {
                    return ((ResolvedInteropReadNode)this.replace(new ResolvedInteropReadNode(this.getContext(), this.getSourceSection(), (String)label, this.labelIndex))).execute(frame);
                }
                if (RubyGuards.isRubySymbol(label)) {
                    return ((ResolvedInteropReadFromSymbolNode)this.replace(new ResolvedInteropReadFromSymbolNode(this.getContext(), this.getSourceSection(), (DynamicObject)label, this.labelIndex))).execute(frame);
                }
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(label + " not allowed as name");
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(label + " not allowed as name");
        }
    }

    private static class InteropStringUnboxNode
    extends RubyNode {
        public InteropStringUnboxNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return StringOperations.getByteList((DynamicObject)ForeignAccessArguments.getReceiver((Object[])frame.getArguments())).get(0);
        }
    }

    private static class InteropStringIsBoxed
    extends InteropNode {
        public InteropStringIsBoxed(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object o = ForeignAccessArguments.getReceiver((Object[])frame.getArguments());
            return RubyGuards.isRubyString(o) && StringOperations.getByteList((DynamicObject)o).length() == 1;
        }
    }

    private static class InteropGetSizeProperty
    extends InteropNode {
        @Node.Child
        private DispatchHeadNode head;

        public InteropGetSizeProperty(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.head.dispatch(frame, ForeignAccessArguments.getReceiver((Object[])frame.getArguments()), "size", null, new Object[0]);
        }
    }

    private static class InteropHasSizePropertyTrue
    extends InteropNode {
        public InteropHasSizePropertyTrue(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return true;
        }
    }

    private static class InteropHasSizePropertyFalse
    extends InteropNode {
        public InteropHasSizePropertyFalse(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return false;
        }
    }

    private static class InteropIsNull
    extends InteropNode {
        public InteropIsNull(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return ForeignAccessArguments.getReceiver((Object[])frame.getArguments()) == this.nil();
        }
    }

    private static class InteropIsBoxedPrimitive
    extends InteropNode {
        public InteropIsBoxedPrimitive(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return false;
        }
    }

    private static class InteropIsExecutable
    extends InteropNode {
        public InteropIsExecutable(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return false;
        }
    }
}

