/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.Arrays;
import java.util.Map;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.core.array.ArrayBuilderNode;
import org.jruby.truffle.nodes.core.hash.HashGuards;
import org.jruby.truffle.nodes.core.hash.HashNode;
import org.jruby.truffle.nodes.core.hash.HashNodesFactory;
import org.jruby.truffle.nodes.core.hash.LookupEntryNode;
import org.jruby.truffle.nodes.core.hash.SetNode;
import org.jruby.truffle.nodes.core.hash.SetNodeGen;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.objects.AllocateObjectNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNodeGen;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.hash.BucketsStrategy;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.HashLookupResult;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.PackedArrayStrategy;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;

@CoreClass(name="Hash")
public abstract class HashNodes {

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="defaultProc")})
    public static abstract class SetDefaultProcNode
    extends CoreMethodNode {
        public SetDefaultProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyProc(defaultProc)"})
        public DynamicObject setDefaultProc(DynamicObject hash, DynamicObject defaultProc) {
            Layouts.HASH.setDefaultValue(hash, null);
            Layouts.HASH.setDefaultBlock(hash, defaultProc);
            return defaultProc;
        }

        @Specialization(guards={"isNil(nil)"})
        public DynamicObject setDefaultProc(DynamicObject hash, Object nil) {
            Layouts.HASH.setDefaultValue(hash, null);
            Layouts.HASH.setDefaultBlock(hash, null);
            return this.nil();
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="defaultValue")})
    public static abstract class SetDefaultValueNode
    extends CoreMethodNode {
        public SetDefaultValueNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object setDefaultValue(DynamicObject hash, Object defaultValue) {
            Layouts.HASH.setDefaultValue(hash, defaultValue);
            return defaultValue;
        }
    }

    @NodeChild(type=RubyNode.class, value="self")
    public static abstract class DefaultValueNode
    extends CoreMethodNode {
        public DefaultValueNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object defaultValue(DynamicObject hash) {
            Object value = Layouts.HASH.getDefaultValue(hash);
            if (value == null) {
                return this.nil();
            }
            return value;
        }
    }

    @CoreMethod(names={"rehash"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class RehashNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private HashNode hashNode;

        public RehashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.hashNode = new HashNode(context, sourceSection);
        }

        @Specialization(guards={"isNullHash(hash)"})
        public DynamicObject rehashNull(DynamicObject hash) {
            return hash;
        }

        @Specialization(guards={"isPackedHash(hash)"})
        public DynamicObject rehashPackedArray(VirtualFrame frame, DynamicObject hash) {
            assert (HashOperations.verifyStore(this.getContext(), hash));
            Object[] store = (Object[])Layouts.HASH.getStore(hash);
            int size = Layouts.HASH.getSize(hash);
            for (int n = 0; n < this.getContext().getOptions().HASH_PACKED_ARRAY_MAX; ++n) {
                if (n >= size) continue;
                PackedArrayStrategy.setHashed(store, n, this.hashNode.hash(frame, PackedArrayStrategy.getKey(store, n)));
            }
            assert (HashOperations.verifyStore(this.getContext(), hash));
            return hash;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isBucketHash(hash)"})
        public DynamicObject rehashBuckets(DynamicObject hash) {
            assert (HashOperations.verifyStore(this.getContext(), hash));
            Object[] entries = (Entry[])Layouts.HASH.getStore(hash);
            Arrays.fill(entries, null);
            for (Entry entry = Layouts.HASH.getFirstInSequence(hash); entry != null; entry = entry.getNextInSequence()) {
                int index = BucketsStrategy.getBucketIndex(entry.getHashed(), entries.length);
                Object bucketEntry = entries[index];
                if (bucketEntry == null) {
                    entries[index] = entry;
                    continue;
                }
                while (((Entry)bucketEntry).getNextInLookup() != null) {
                    bucketEntry = ((Entry)bucketEntry).getNextInLookup();
                }
                ((Entry)bucketEntry).setNextInLookup(entry);
            }
            assert (HashOperations.verifyStore(this.getContext(), hash));
            return hash;
        }
    }

    @CoreMethod(names={"size", "length"})
    @ImportStatic(value={HashGuards.class})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullHash(hash)"})
        public int sizeNull(DynamicObject hash) {
            return 0;
        }

        @Specialization(guards={"!isNullHash(hash)"})
        public int sizePackedArray(DynamicObject hash) {
            return Layouts.HASH.getSize(hash);
        }
    }

    @CoreMethod(names={"shift"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class ShiftNode
    extends CoreMethodArrayArgumentsNode {
        public ShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isEmptyHash(hash)", "!hasDefaultValue(hash)", "!hasDefaultBlock(hash)"})
        public DynamicObject shiftEmpty(DynamicObject hash) {
            return this.nil();
        }

        @Specialization(guards={"isEmptyHash(hash)", "hasDefaultValue(hash)", "!hasDefaultBlock(hash)"})
        public Object shiftEmpyDefaultValue(DynamicObject hash) {
            return Layouts.HASH.getDefaultValue(hash);
        }

        @Specialization(guards={"isEmptyHash(hash)", "!hasDefaultValue(hash)", "hasDefaultBlock(hash)"})
        public Object shiftEmptyDefaultProc(DynamicObject hash) {
            return ProcNodes.rootCall(Layouts.HASH.getDefaultBlock(hash), hash, this.nil());
        }

        @Specialization(guards={"!isEmptyHash(hash)", "isPackedHash(hash)"})
        public DynamicObject shiftPackedArray(DynamicObject hash) {
            assert (HashOperations.verifyStore(this.getContext(), hash));
            Object[] store = (Object[])Layouts.HASH.getStore(hash);
            Object key = PackedArrayStrategy.getKey(store, 0);
            Object value = PackedArrayStrategy.getValue(store, 0);
            PackedArrayStrategy.removeEntry(this.getContext(), store, 0);
            Layouts.HASH.setSize(hash, Layouts.HASH.getSize(hash) - 1);
            assert (HashOperations.verifyStore(this.getContext(), hash));
            Object[] objects = new Object[]{key, value};
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }

        @Specialization(guards={"!isEmptyHash(hash)", "isBucketHash(hash)"})
        public DynamicObject shiftBuckets(DynamicObject hash) {
            assert (HashOperations.verifyStore(this.getContext(), hash));
            Entry first = Layouts.HASH.getFirstInSequence(hash);
            assert (first.getPreviousInSequence() == null);
            Object key = first.getKey();
            Object value = first.getValue();
            Layouts.HASH.setFirstInSequence(hash, first.getNextInSequence());
            if (first.getNextInSequence() != null) {
                first.getNextInSequence().setPreviousInSequence(null);
                Layouts.HASH.setFirstInSequence(hash, first.getNextInSequence());
            }
            if (Layouts.HASH.getLastInSequence(hash) == first) {
                Layouts.HASH.setLastInSequence(hash, null);
            }
            Entry[] store = (Entry[])Layouts.HASH.getStore(hash);
            block0: for (int n = 0; n < store.length; ++n) {
                Entry previous = null;
                for (Entry entry = store[n]; entry != null; entry = entry.getNextInLookup()) {
                    if (entry == first) {
                        if (previous == null) {
                            store[n] = first.getNextInLookup();
                            break block0;
                        }
                        previous.setNextInLookup(first.getNextInLookup());
                        break block0;
                    }
                    previous = entry;
                }
            }
            Layouts.HASH.setSize(hash, Layouts.HASH.getSize(hash) - 1);
            assert (HashOperations.verifyStore(this.getContext(), hash));
            Object[] objects = new Object[]{key, value};
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"default="}, required=1, raiseIfFrozenSelf=true)
    public static abstract class SetDefaultNode
    extends CoreMethodArrayArgumentsNode {
        public SetDefaultNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object setDefault(DynamicObject hash, Object defaultValue) {
            Layouts.HASH.setDefaultValue(hash, defaultValue);
            Layouts.HASH.setDefaultBlock(hash, null);
            return defaultValue;
        }
    }

    @ImportStatic(value={HashGuards.class})
    @CoreMethod(names={"merge"}, required=1, needsBlock=true)
    public static abstract class MergeNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eqlNode;
        @Node.Child
        private CallDispatchHeadNode fallbackCallNode;
        @Node.Child
        private LookupEntryNode lookupEntryNode;
        @Node.Child
        private SetNode setNode;
        @Node.Child
        private AllocateObjectNode allocateObjectNode;
        private final BranchProfile nothingFromFirstProfile = BranchProfile.create();
        private final BranchProfile considerResultIsSmallProfile = BranchProfile.create();
        private final BranchProfile resultIsSmallProfile = BranchProfile.create();
        private final BranchProfile promoteProfile = BranchProfile.create();

        public MergeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.setNode = SetNodeGen.create(context, sourceSection, null, null, null, null);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization(guards={"isNullHash(hash)", "isRubyHash(other)", "isNullHash(other)"})
        public DynamicObject mergeEmptyEmpty(DynamicObject hash, DynamicObject other, NotProvided block) {
            return this.allocateObjectNode.allocateHash(Layouts.BASIC_OBJECT.getLogicalClass(hash), null, 0, null, null, Layouts.HASH.getDefaultBlock(hash), Layouts.HASH.getDefaultValue(hash), false);
        }

        @Specialization(guards={"isEmptyHash(hash)", "isRubyHash(other)", "isPackedHash(other)"})
        public DynamicObject mergeEmptyPacked(DynamicObject hash, DynamicObject other, NotProvided block) {
            Object[] store = (Object[])Layouts.HASH.getStore(other);
            Object[] copy = PackedArrayStrategy.copyStore(this.getContext(), store);
            return this.allocateObjectNode.allocateHash(Layouts.BASIC_OBJECT.getLogicalClass(hash), copy, Layouts.HASH.getSize(other), null, null, Layouts.HASH.getDefaultBlock(hash), Layouts.HASH.getDefaultValue(hash), false);
        }

        @Specialization(guards={"isPackedHash(hash)", "isRubyHash(other)", "isEmptyHash(other)"})
        public DynamicObject mergePackedEmpty(DynamicObject hash, DynamicObject other, NotProvided block) {
            Object[] store = (Object[])Layouts.HASH.getStore(hash);
            Object[] copy = PackedArrayStrategy.copyStore(this.getContext(), store);
            return this.allocateObjectNode.allocateHash(Layouts.BASIC_OBJECT.getLogicalClass(hash), copy, Layouts.HASH.getSize(hash), null, null, Layouts.HASH.getDefaultBlock(hash), Layouts.HASH.getDefaultValue(hash), false);
        }

        @Specialization(guards={"isEmptyHash(hash)", "isRubyHash(other)", "isBucketHash(other)"})
        public DynamicObject mergeEmptyBuckets(DynamicObject hash, DynamicObject other, NotProvided block) {
            DynamicObject merged = this.allocateObjectNode.allocateHash(Layouts.BASIC_OBJECT.getLogicalClass(hash), null, 0, null, null, Layouts.HASH.getDefaultBlock(hash), Layouts.HASH.getDefaultValue(hash), false);
            BucketsStrategy.copyInto(this.getContext(), other, merged);
            return merged;
        }

        @Specialization(guards={"isBucketHash(hash)", "isRubyHash(other)", "isEmptyHash(other)"})
        public DynamicObject mergeBucketsEmpty(DynamicObject hash, DynamicObject other, NotProvided block) {
            DynamicObject merged = this.allocateObjectNode.allocateHash(Layouts.BASIC_OBJECT.getLogicalClass(hash), null, 0, null, null, Layouts.HASH.getDefaultBlock(hash), Layouts.HASH.getDefaultValue(hash), false);
            BucketsStrategy.copyInto(this.getContext(), hash, merged);
            return merged;
        }

        @ExplodeLoop
        @Specialization(guards={"isPackedHash(hash)", "!isEmptyHash(hash)", "isRubyHash(other)", "isPackedHash(other)", "!isEmptyHash(other)", "!isCompareByIdentity(hash)"})
        public DynamicObject mergePackedPacked(VirtualFrame frame, DynamicObject hash, DynamicObject other, NotProvided block) {
            int n;
            assert (HashOperations.verifyStore(this.getContext(), hash));
            assert (HashOperations.verifyStore(this.getContext(), other));
            Object[] storeA = (Object[])Layouts.HASH.getStore(hash);
            int storeASize = Layouts.HASH.getSize(hash);
            Object[] storeB = (Object[])Layouts.HASH.getStore(other);
            int storeBSize = Layouts.HASH.getSize(other);
            boolean[] mergeFromA = new boolean[storeASize];
            int mergeFromACount = 0;
            for (int a = 0; a < this.getContext().getOptions().HASH_PACKED_ARRAY_MAX; ++a) {
                if (a >= storeASize) continue;
                boolean merge = true;
                for (int b = 0; b < this.getContext().getOptions().HASH_PACKED_ARRAY_MAX; ++b) {
                    if (b >= storeBSize || !this.eqlNode.callBoolean(frame, PackedArrayStrategy.getKey(storeA, a), "eql?", null, PackedArrayStrategy.getKey(storeB, b))) continue;
                    merge = false;
                    break;
                }
                if (merge) {
                    ++mergeFromACount;
                }
                mergeFromA[a] = merge;
            }
            if (mergeFromACount == 0) {
                this.nothingFromFirstProfile.enter();
                return this.allocateObjectNode.allocateHash(Layouts.BASIC_OBJECT.getLogicalClass(hash), PackedArrayStrategy.copyStore(this.getContext(), storeB), storeBSize, null, null, Layouts.HASH.getDefaultBlock(hash), Layouts.HASH.getDefaultValue(hash), false);
            }
            this.considerResultIsSmallProfile.enter();
            int mergedSize = storeBSize + mergeFromACount;
            if (storeBSize + mergeFromACount <= this.getContext().getOptions().HASH_PACKED_ARRAY_MAX) {
                int n2;
                this.resultIsSmallProfile.enter();
                Object[] merged = PackedArrayStrategy.createStore(this.getContext());
                int index = 0;
                for (n2 = 0; n2 < storeASize; ++n2) {
                    if (!mergeFromA[n2]) continue;
                    PackedArrayStrategy.setHashedKeyValue(merged, index, PackedArrayStrategy.getHashed(storeA, n2), PackedArrayStrategy.getKey(storeA, n2), PackedArrayStrategy.getValue(storeA, n2));
                    ++index;
                }
                for (n2 = 0; n2 < storeBSize; ++n2) {
                    PackedArrayStrategy.setHashedKeyValue(merged, index, PackedArrayStrategy.getHashed(storeB, n2), PackedArrayStrategy.getKey(storeB, n2), PackedArrayStrategy.getValue(storeB, n2));
                    ++index;
                }
                return this.allocateObjectNode.allocateHash(Layouts.BASIC_OBJECT.getLogicalClass(hash), merged, mergedSize, null, null, Layouts.HASH.getDefaultBlock(hash), Layouts.HASH.getDefaultValue(hash), false);
            }
            this.promoteProfile.enter();
            DynamicObject merged = this.allocateObjectNode.allocateHash(Layouts.BASIC_OBJECT.getLogicalClass(hash), new Entry[BucketsStrategy.capacityGreaterThan(mergedSize)], 0, null, null, null, null, false);
            for (n = 0; n < storeASize; ++n) {
                if (!mergeFromA[n]) continue;
                this.setNode.executeSet(frame, merged, PackedArrayStrategy.getKey(storeA, n), PackedArrayStrategy.getValue(storeA, n), false);
            }
            for (n = 0; n < storeBSize; ++n) {
                this.setNode.executeSet(frame, merged, PackedArrayStrategy.getKey(storeB, n), PackedArrayStrategy.getValue(storeB, n), false);
            }
            assert (HashOperations.verifyStore(this.getContext(), hash));
            return merged;
        }

        @Specialization(guards={"isBucketHash(hash)", "!isEmptyHash(hash)", "isRubyHash(other)", "isBucketHash(other)", "!isEmptyHash(other)"})
        public DynamicObject mergeBucketsBuckets(VirtualFrame frame, DynamicObject hash, DynamicObject other, NotProvided block) {
            boolean isCompareByIdentity = Layouts.HASH.getCompareByIdentity(hash);
            DynamicObject merged = this.allocateObjectNode.allocateHash(Layouts.BASIC_OBJECT.getLogicalClass(hash), new Entry[BucketsStrategy.capacityGreaterThan(Layouts.HASH.getSize(hash) + Layouts.HASH.getSize(other))], 0, null, null, null, null, false);
            for (Map.Entry<Object, Object> keyValue : BucketsStrategy.iterableKeyValues(Layouts.HASH.getFirstInSequence(hash))) {
                this.setNode.executeSet(frame, merged, keyValue.getKey(), keyValue.getValue(), isCompareByIdentity);
            }
            for (Map.Entry<Object, Object> keyValue : BucketsStrategy.iterableKeyValues(Layouts.HASH.getFirstInSequence(other))) {
                this.setNode.executeSet(frame, merged, keyValue.getKey(), keyValue.getValue(), isCompareByIdentity);
            }
            assert (HashOperations.verifyStore(this.getContext(), hash));
            return merged;
        }

        @Specialization(guards={"isPackedHash(hash)", "!isEmptyHash(hash)", "isRubyHash(other)", "isBucketHash(other)", "!isEmptyHash(other)"})
        public DynamicObject mergePackedBuckets(VirtualFrame frame, DynamicObject hash, DynamicObject other, NotProvided block) {
            boolean isCompareByIdentity = Layouts.HASH.getCompareByIdentity(hash);
            DynamicObject merged = this.allocateObjectNode.allocateHash(Layouts.BASIC_OBJECT.getLogicalClass(hash), new Entry[BucketsStrategy.capacityGreaterThan(Layouts.HASH.getSize(hash) + Layouts.HASH.getSize(other))], 0, null, null, null, null, false);
            Object[] hashStore = (Object[])Layouts.HASH.getStore(hash);
            int hashSize = Layouts.HASH.getSize(hash);
            for (int n = 0; n < this.getContext().getOptions().HASH_PACKED_ARRAY_MAX; ++n) {
                if (n >= hashSize) continue;
                this.setNode.executeSet(frame, merged, PackedArrayStrategy.getKey(hashStore, n), PackedArrayStrategy.getValue(hashStore, n), isCompareByIdentity);
            }
            for (Map.Entry<Object, Object> keyValue : BucketsStrategy.iterableKeyValues(Layouts.HASH.getFirstInSequence(other))) {
                this.setNode.executeSet(frame, merged, keyValue.getKey(), keyValue.getValue(), isCompareByIdentity);
            }
            assert (HashOperations.verifyStore(this.getContext(), hash));
            return merged;
        }

        @Specialization(guards={"isBucketHash(hash)", "!isEmptyHash(hash)", "isRubyHash(other)", "isPackedHash(other)", "!isEmptyHash(other)"})
        public DynamicObject mergeBucketsPacked(VirtualFrame frame, DynamicObject hash, DynamicObject other, NotProvided block) {
            boolean isCompareByIdentity = Layouts.HASH.getCompareByIdentity(hash);
            DynamicObject merged = this.allocateObjectNode.allocateHash(Layouts.BASIC_OBJECT.getLogicalClass(hash), new Entry[BucketsStrategy.capacityGreaterThan(Layouts.HASH.getSize(hash) + Layouts.HASH.getSize(other))], 0, null, null, null, null, false);
            for (Map.Entry<Object, Object> keyValue : BucketsStrategy.iterableKeyValues(Layouts.HASH.getFirstInSequence(hash))) {
                this.setNode.executeSet(frame, merged, keyValue.getKey(), keyValue.getValue(), isCompareByIdentity);
            }
            Object[] otherStore = (Object[])Layouts.HASH.getStore(other);
            int otherSize = Layouts.HASH.getSize(other);
            for (int n = 0; n < this.getContext().getOptions().HASH_PACKED_ARRAY_MAX; ++n) {
                if (n >= otherSize) continue;
                this.setNode.executeSet(frame, merged, PackedArrayStrategy.getKey(otherStore, n), PackedArrayStrategy.getValue(otherStore, n), isCompareByIdentity);
            }
            assert (HashOperations.verifyStore(this.getContext(), hash));
            return merged;
        }

        @Specialization(guards={"isRubyHash(other)", "!isCompareByIdentity(hash)"})
        public DynamicObject merge(VirtualFrame frame, DynamicObject hash, DynamicObject other, DynamicObject block) {
            CompilerDirectives.bailout((String)"Hash#merge with a block cannot be compiled at the moment");
            DynamicObject merged = this.allocateObjectNode.allocateHash(Layouts.BASIC_OBJECT.getLogicalClass(hash), new Entry[BucketsStrategy.capacityGreaterThan(Layouts.HASH.getSize(hash) + Layouts.HASH.getSize(other))], 0, null, null, null, null, false);
            int size = 0;
            for (Map.Entry<Object, Object> keyValue : HashOperations.iterableKeyValues(hash)) {
                this.setNode.executeSet(frame, merged, keyValue.getKey(), keyValue.getValue(), false);
                ++size;
            }
            if (this.lookupEntryNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.lookupEntryNode = (LookupEntryNode)this.insert(new LookupEntryNode(this.getContext(), this.getSourceSection()));
            }
            for (Map.Entry<Object, Object> keyValue : HashOperations.iterableKeyValues(other)) {
                HashLookupResult searchResult = this.lookupEntryNode.lookup(frame, merged, keyValue.getKey());
                if (searchResult.getEntry() == null) {
                    this.setNode.executeSet(frame, merged, keyValue.getKey(), keyValue.getValue(), false);
                    ++size;
                    continue;
                }
                Object oldValue = searchResult.getEntry().getValue();
                Object newValue = keyValue.getValue();
                Object mergedValue = this.yield(frame, block, keyValue.getKey(), oldValue, newValue);
                this.setNode.executeSet(frame, merged, keyValue.getKey(), mergedValue, false);
            }
            Layouts.HASH.setSize(merged, size);
            assert (HashOperations.verifyStore(this.getContext(), hash));
            return merged;
        }

        @Specialization(guards={"!isRubyHash(other)"})
        public Object merge(VirtualFrame frame, DynamicObject hash, Object other, Object maybeBlock) {
            if (this.fallbackCallNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            DynamicObject block = maybeBlock == NotProvided.INSTANCE ? null : (DynamicObject)maybeBlock;
            return this.fallbackCallNode.call(frame, hash, "merge_fallback", block, other);
        }
    }

    @CoreMethod(names={"map", "collect"}, needsBlock=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class MapNode
    extends YieldingCoreMethodNode {
        public MapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullHash(hash)"})
        public DynamicObject mapNull(VirtualFrame frame, DynamicObject hash, DynamicObject block) {
            assert (HashOperations.verifyStore(this.getContext(), hash));
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        @Specialization(guards={"isPackedHash(hash)"})
        public DynamicObject mapPackedArray(VirtualFrame frame, DynamicObject hash, DynamicObject block, @Cached(value="create(getContext())") ArrayBuilderNode arrayBuilderNode) {
            assert (HashOperations.verifyStore(this.getContext(), hash));
            Object[] store = (Object[])Layouts.HASH.getStore(hash);
            int length = Layouts.HASH.getSize(hash);
            Object resultStore = arrayBuilderNode.start(length);
            try {
                for (int n = 0; n < this.getContext().getOptions().HASH_PACKED_ARRAY_MAX; ++n) {
                    if (n >= length) continue;
                    Object key = PackedArrayStrategy.getKey(store, n);
                    Object value = PackedArrayStrategy.getValue(store, n);
                    resultStore = arrayBuilderNode.appendValue(resultStore, n, this.yield(frame, block, key, value));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(length);
                }
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), arrayBuilderNode.finish(resultStore, length), length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isBucketHash(hash)"})
        public DynamicObject mapBuckets(VirtualFrame frame, DynamicObject hash, DynamicObject block, @Cached(value="create(getContext())") ArrayBuilderNode arrayBuilderNode) {
            assert (HashOperations.verifyStore(this.getContext(), hash));
            int length = Layouts.HASH.getSize(hash);
            Object store = arrayBuilderNode.start(length);
            int index = 0;
            try {
                for (Map.Entry<Object, Object> keyValue : BucketsStrategy.iterableKeyValues(Layouts.HASH.getFirstInSequence(hash))) {
                    arrayBuilderNode.appendValue(store, index, this.yield(frame, block, keyValue.getKey(), keyValue.getValue()));
                    ++index;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(length);
                }
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), arrayBuilderNode.finish(store, length), length);
        }
    }

    @CoreMethod(names={"initialize_copy", "replace"}, required=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyHash(from)", "isNullHash(from)"})
        public DynamicObject replaceNull(DynamicObject self, DynamicObject from) {
            if (self == from) {
                return self;
            }
            assert (HashOperations.verifyStore(this.getContext(), null, 0, null, null));
            Layouts.HASH.setStore(self, null);
            Layouts.HASH.setSize(self, 0);
            Layouts.HASH.setFirstInSequence(self, null);
            Layouts.HASH.setLastInSequence(self, null);
            this.copyOtherFields(self, from);
            return self;
        }

        @Specialization(guards={"isRubyHash(from)", "isPackedHash(from)"})
        public DynamicObject replacePackedArray(DynamicObject self, DynamicObject from) {
            if (self == from) {
                return self;
            }
            Object[] store = (Object[])Layouts.HASH.getStore(from);
            Object[] store1 = PackedArrayStrategy.copyStore(this.getContext(), store);
            int size = Layouts.HASH.getSize(from);
            assert (HashOperations.verifyStore(this.getContext(), store1, size, null, null));
            Layouts.HASH.setStore(self, store1);
            Layouts.HASH.setSize(self, size);
            Layouts.HASH.setFirstInSequence(self, null);
            Layouts.HASH.setLastInSequence(self, null);
            this.copyOtherFields(self, from);
            assert (HashOperations.verifyStore(this.getContext(), self));
            return self;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyHash(from)", "isBucketHash(from)"})
        public DynamicObject replaceBuckets(DynamicObject self, DynamicObject from) {
            if (self == from) {
                return self;
            }
            BucketsStrategy.copyInto(this.getContext(), from, self);
            this.copyOtherFields(self, from);
            assert (HashOperations.verifyStore(this.getContext(), self));
            return self;
        }

        @Specialization(guards={"!isRubyHash(other)"})
        public Object replaceBuckets(VirtualFrame frame, DynamicObject self, Object other) {
            return this.ruby(frame, "replace(Rubinius::Type.coerce_to other, Hash, :to_hash)", "other", other);
        }

        private void copyOtherFields(DynamicObject self, DynamicObject from) {
            Layouts.HASH.setDefaultBlock(self, Layouts.HASH.getDefaultBlock(from));
            Layouts.HASH.setDefaultValue(self, Layouts.HASH.getDefaultValue(from));
            Layouts.HASH.setCompareByIdentity(self, Layouts.HASH.getCompareByIdentity(from));
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true, optional=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject initialize(DynamicObject hash, NotProvided defaultValue, NotProvided block) {
            assert (HashOperations.verifyStore(this.getContext(), null, 0, null, null));
            Layouts.HASH.setStore(hash, null);
            Layouts.HASH.setSize(hash, 0);
            Layouts.HASH.setFirstInSequence(hash, null);
            Layouts.HASH.setLastInSequence(hash, null);
            Layouts.HASH.setDefaultValue(hash, null);
            Layouts.HASH.setDefaultBlock(hash, null);
            return hash;
        }

        @Specialization
        public DynamicObject initialize(DynamicObject hash, NotProvided defaultValue, DynamicObject block) {
            assert (HashOperations.verifyStore(this.getContext(), null, 0, null, null));
            Layouts.HASH.setStore(hash, null);
            Layouts.HASH.setSize(hash, 0);
            Layouts.HASH.setFirstInSequence(hash, null);
            Layouts.HASH.setLastInSequence(hash, null);
            Layouts.HASH.setDefaultValue(hash, null);
            Layouts.HASH.setDefaultBlock(hash, block);
            return hash;
        }

        @Specialization(guards={"wasProvided(defaultValue)"})
        public DynamicObject initialize(DynamicObject hash, Object defaultValue, NotProvided block) {
            assert (HashOperations.verifyStore(this.getContext(), null, 0, null, null));
            Layouts.HASH.setStore(hash, null);
            Layouts.HASH.setSize(hash, 0);
            Layouts.HASH.setFirstInSequence(hash, null);
            Layouts.HASH.setLastInSequence(hash, null);
            Layouts.HASH.setDefaultValue(hash, defaultValue);
            Layouts.HASH.setDefaultBlock(hash, null);
            return hash;
        }

        @Specialization(guards={"wasProvided(defaultValue)"})
        public Object initialize(DynamicObject hash, Object defaultValue, DynamicObject block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("wrong number of arguments (1 for 0)", this));
        }
    }

    @CoreMethod(names={"empty?"})
    @ImportStatic(value={HashGuards.class})
    public static abstract class EmptyNode
    extends CoreMethodArrayArgumentsNode {
        public EmptyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullHash(hash)"})
        public boolean emptyNull(DynamicObject hash) {
            return true;
        }

        @Specialization(guards={"!isNullHash(hash)"})
        public boolean emptyPackedArray(DynamicObject hash) {
            return Layouts.HASH.getSize(hash) == 0;
        }
    }

    @CoreMethod(names={"each", "each_pair"}, needsBlock=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class EachNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toEnumNode;

        public EachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullHash(hash)"})
        public DynamicObject eachNull(DynamicObject hash, DynamicObject block) {
            return hash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        @Specialization(guards={"isPackedHash(hash)"})
        public DynamicObject eachPackedArray(VirtualFrame frame, DynamicObject hash, DynamicObject block) {
            assert (HashOperations.verifyStore(this.getContext(), hash));
            Object[] store = (Object[])Layouts.HASH.getStore(hash);
            int count = 0;
            try {
                for (int n = 0; n < this.getContext().getOptions().HASH_PACKED_ARRAY_MAX; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    if (n >= Layouts.HASH.getSize(hash)) continue;
                    this.yield(frame, block, Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{PackedArrayStrategy.getKey(store, n), PackedArrayStrategy.getValue(store, n)}, 2));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return hash;
        }

        @Specialization(guards={"isBucketHash(hash)"})
        public DynamicObject eachBuckets(VirtualFrame frame, DynamicObject hash, DynamicObject block) {
            assert (HashOperations.verifyStore(this.getContext(), hash));
            for (Map.Entry<Object, Object> keyValue : BucketsStrategy.iterableKeyValues(Layouts.HASH.getFirstInSequence(hash))) {
                this.yield(frame, block, Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{keyValue.getKey(), keyValue.getValue()}, 2));
            }
            return hash;
        }

        @Specialization
        public Object each(VirtualFrame frame, DynamicObject hash, NotProvided block) {
            if (this.toEnumNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toEnumNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            InternalMethod method = RubyArguments.getMethod(frame.getArguments());
            return this.toEnumNode.call(frame, hash, "to_enum", null, this.getSymbol(method.getName()));
        }
    }

    @CoreMethod(names={"delete"}, required=1, needsBlock=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class DeleteNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private HashNode hashNode;
        @Node.Child
        private CallDispatchHeadNode eqlNode;
        @Node.Child
        private LookupEntryNode lookupEntryNode;
        @Node.Child
        private YieldDispatchHeadNode yieldNode;

        public DeleteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.hashNode = new HashNode(context, sourceSection);
            this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.lookupEntryNode = new LookupEntryNode(context, sourceSection);
            this.yieldNode = new YieldDispatchHeadNode(context);
        }

        @Specialization(guards={"isNullHash(hash)"})
        public Object deleteNull(VirtualFrame frame, DynamicObject hash, Object key, NotProvided block) {
            assert (HashOperations.verifyStore(this.getContext(), hash));
            return this.nil();
        }

        @Specialization(guards={"isNullHash(hash)"})
        public Object deleteNull(VirtualFrame frame, DynamicObject hash, Object key, DynamicObject block) {
            assert (HashOperations.verifyStore(this.getContext(), hash));
            return this.yieldNode.dispatch(frame, block, key);
        }

        @Specialization(guards={"isPackedHash(hash)", "!isCompareByIdentity(hash)"})
        public Object deletePackedArray(VirtualFrame frame, DynamicObject hash, Object key, Object maybeBlock) {
            assert (HashOperations.verifyStore(this.getContext(), hash));
            int hashed = this.hashNode.hash(frame, key);
            Object[] store = (Object[])Layouts.HASH.getStore(hash);
            int size = Layouts.HASH.getSize(hash);
            for (int n = 0; n < this.getContext().getOptions().HASH_PACKED_ARRAY_MAX; ++n) {
                if (n >= size || hashed != PackedArrayStrategy.getHashed(store, n) || !this.eqlNode.callBoolean(frame, PackedArrayStrategy.getKey(store, n), "eql?", null, key)) continue;
                Object value = PackedArrayStrategy.getValue(store, n);
                PackedArrayStrategy.removeEntry(this.getContext(), store, n);
                Layouts.HASH.setSize(hash, size - 1);
                assert (HashOperations.verifyStore(this.getContext(), hash));
                return value;
            }
            assert (HashOperations.verifyStore(this.getContext(), hash));
            if (maybeBlock == NotProvided.INSTANCE) {
                return this.nil();
            }
            return this.yieldNode.dispatch(frame, (DynamicObject)maybeBlock, key);
        }

        @Specialization(guards={"isBucketHash(hash)"})
        public Object delete(VirtualFrame frame, DynamicObject hash, Object key, Object maybeBlock) {
            assert (HashOperations.verifyStore(this.getContext(), hash));
            HashLookupResult hashLookupResult = this.lookupEntryNode.lookup(frame, hash, key);
            if (hashLookupResult.getEntry() == null) {
                if (maybeBlock == NotProvided.INSTANCE) {
                    return this.nil();
                }
                return this.yieldNode.dispatch(frame, (DynamicObject)maybeBlock, key);
            }
            Entry entry = hashLookupResult.getEntry();
            if (entry.getPreviousInSequence() == null) {
                assert (Layouts.HASH.getFirstInSequence(hash) == entry);
                Layouts.HASH.setFirstInSequence(hash, entry.getNextInSequence());
            } else {
                assert (Layouts.HASH.getFirstInSequence(hash) != entry);
                entry.getPreviousInSequence().setNextInSequence(entry.getNextInSequence());
            }
            if (entry.getNextInSequence() == null) {
                Layouts.HASH.setLastInSequence(hash, entry.getPreviousInSequence());
            } else {
                entry.getNextInSequence().setPreviousInSequence(entry.getPreviousInSequence());
            }
            if (hashLookupResult.getPreviousEntry() == null) {
                ((Entry[])Layouts.HASH.getStore((DynamicObject)hash))[hashLookupResult.getIndex()] = entry.getNextInLookup();
            } else {
                hashLookupResult.getPreviousEntry().setNextInLookup(entry.getNextInLookup());
            }
            Layouts.HASH.setSize(hash, Layouts.HASH.getSize(hash) - 1);
            assert (HashOperations.verifyStore(this.getContext(), hash));
            return entry.getValue();
        }
    }

    @CoreMethod(names={"default_proc"})
    public static abstract class DefaultProcNode
    extends CoreMethodArrayArgumentsNode {
        public DefaultProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object defaultProc(DynamicObject hash) {
            if (Layouts.HASH.getDefaultBlock(hash) == null) {
                return this.nil();
            }
            return Layouts.HASH.getDefaultBlock(hash);
        }
    }

    @CoreMethod(names={"compare_by_identity?"})
    public static abstract class IsCompareByIdentityNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile profile = ConditionProfile.createBinaryProfile();

        public IsCompareByIdentityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean compareByIdentity(DynamicObject hash) {
            return this.profile.profile(Layouts.HASH.getCompareByIdentity(hash));
        }
    }

    @CoreMethod(names={"compare_by_identity"}, raiseIfFrozenSelf=true)
    public static abstract class CompareByIdentityNode
    extends CoreMethodArrayArgumentsNode {
        public CompareByIdentityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject compareByIdentity(DynamicObject hash) {
            Layouts.HASH.setCompareByIdentity(hash, true);
            return hash;
        }
    }

    @CoreMethod(names={"clear"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullHash(hash)"})
        public DynamicObject emptyNull(DynamicObject hash) {
            return hash;
        }

        @Specialization(guards={"!isNullHash(hash)"})
        public DynamicObject empty(DynamicObject hash) {
            assert (HashOperations.verifyStore(this.getContext(), hash));
            assert (HashOperations.verifyStore(this.getContext(), null, 0, null, null));
            Layouts.HASH.setStore(hash, null);
            Layouts.HASH.setSize(hash, 0);
            Layouts.HASH.setFirstInSequence(hash, null);
            Layouts.HASH.setLastInSequence(hash, null);
            assert (HashOperations.verifyStore(this.getContext(), hash));
            return hash;
        }
    }

    @CoreMethod(names={"[]="}, required=2, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class SetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SetNode setNode;

        public SetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object setNull(VirtualFrame frame, DynamicObject hash, Object key, Object value) {
            if (this.setNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.setNode = (SetNode)this.insert(SetNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null, null, null, null));
            }
            return this.setNode.executeSet(frame, hash, key, value, Layouts.HASH.getCompareByIdentity(hash));
        }
    }

    @CoreMethod(names={"_get_or_undefined"}, required=1)
    public static abstract class GetOrUndefinedNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private GetIndexNode getIndexNode;

        public GetOrUndefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.getIndexNode = HashNodesFactory.GetIndexNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
            this.getIndexNode.setUndefinedValue(context.getCoreLibrary().getRubiniusUndefined());
        }

        @Specialization
        public Object getOrUndefined(VirtualFrame frame, DynamicObject hash, Object key) {
            return this.getIndexNode.executeGet(frame, hash, key);
        }
    }

    @CoreMethod(names={"[]"}, required=1)
    @ImportStatic(value={HashGuards.class})
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private HashNode hashNode;
        @Node.Child
        private CallDispatchHeadNode eqlNode;
        @Node.Child
        private BasicObjectNodes.ReferenceEqualNode equalNode;
        @Node.Child
        private CallDispatchHeadNode callDefaultNode;
        @Node.Child
        private LookupEntryNode lookupEntryNode;
        @CompilerDirectives.CompilationFinal
        private Object undefinedValue;

        public GetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.hashNode = new HashNode(context, sourceSection);
            this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.equalNode = BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(context, sourceSection, null, null);
            this.callDefaultNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.lookupEntryNode = new LookupEntryNode(context, sourceSection);
        }

        public abstract Object executeGet(VirtualFrame var1, DynamicObject var2, Object var3);

        @Specialization(guards={"isNullHash(hash)"})
        public Object getNull(VirtualFrame frame, DynamicObject hash, Object key) {
            this.hashNode.hash(frame, key);
            if (this.undefinedValue != null) {
                return this.undefinedValue;
            }
            return this.callDefaultNode.call(frame, hash, "default", null, key);
        }

        @Specialization(guards={"isPackedHash(hash)", "!isCompareByIdentity(hash)", "cachedIndex >= 0", "cachedIndex < getSize(hash)", "hash(frame, key) == getHashedAt(hash, cachedIndex)", "eql(frame, key, getKeyAt(hash, cachedIndex))"}, limit="1")
        public Object getConstantIndexPackedArray(VirtualFrame frame, DynamicObject hash, Object key, @Cached(value="index(frame, hash, key)") int cachedIndex) {
            Object[] store = (Object[])Layouts.HASH.getStore(hash);
            return PackedArrayStrategy.getValue(store, cachedIndex);
        }

        protected int hash(VirtualFrame frame, Object key) {
            return this.hashNode.hash(frame, key);
        }

        protected int getHashedAt(DynamicObject hash, int index) {
            Object[] store = (Object[])Layouts.HASH.getStore(hash);
            return PackedArrayStrategy.getHashed(store, index);
        }

        protected Object getKeyAt(DynamicObject hash, int index) {
            Object[] store = (Object[])Layouts.HASH.getStore(hash);
            return PackedArrayStrategy.getKey(store, index);
        }

        protected int index(VirtualFrame frame, DynamicObject hash, Object key) {
            if (!HashGuards.isPackedHash(hash)) {
                return -1;
            }
            int hashed = this.hashNode.hash(frame, key);
            Object[] store = (Object[])Layouts.HASH.getStore(hash);
            int size = Layouts.HASH.getSize(hash);
            for (int n = 0; n < size; ++n) {
                if (hashed != PackedArrayStrategy.getHashed(store, n) || !this.eql(frame, key, PackedArrayStrategy.getKey(store, n))) continue;
                return n;
            }
            return -1;
        }

        protected int getSize(DynamicObject hash) {
            return Layouts.HASH.getSize(hash);
        }

        protected boolean eql(VirtualFrame frame, Object key1, Object key2) {
            return this.eqlNode.callBoolean(frame, key1, "eql?", null, key2);
        }

        @ExplodeLoop
        @Specialization(guards={"isPackedHash(hash)"}, contains={"getConstantIndexPackedArray"})
        public Object getPackedArray(VirtualFrame frame, DynamicObject hash, Object key, @Cached(value="createBinaryProfile()") ConditionProfile byIdentityProfile, @Cached(value="create()") BranchProfile notInHashProfile, @Cached(value="create()") BranchProfile useDefaultProfile) {
            int hashed = this.hashNode.hash(frame, key);
            Object[] store = (Object[])Layouts.HASH.getStore(hash);
            int size = Layouts.HASH.getSize(hash);
            for (int n = 0; n < this.getContext().getOptions().HASH_PACKED_ARRAY_MAX; ++n) {
                boolean equal;
                if (n >= size || hashed != PackedArrayStrategy.getHashed(store, n) || !(equal = byIdentityProfile.profile(Layouts.HASH.getCompareByIdentity(hash)) ? this.equalNode.executeReferenceEqual(frame, key, PackedArrayStrategy.getKey(store, n)) : this.eqlNode.callBoolean(frame, key, "eql?", null, PackedArrayStrategy.getKey(store, n)))) continue;
                return PackedArrayStrategy.getValue(store, n);
            }
            notInHashProfile.enter();
            if (this.undefinedValue != null) {
                return this.undefinedValue;
            }
            useDefaultProfile.enter();
            return this.callDefaultNode.call(frame, hash, "default", null, key);
        }

        @Specialization(guards={"isBucketHash(hash)"})
        public Object getBuckets(VirtualFrame frame, DynamicObject hash, Object key, @Cached(value="create()") BranchProfile notInHashProfile, @Cached(value="create()") BranchProfile useDefaultProfile) {
            HashLookupResult hashLookupResult = this.lookupEntryNode.lookup(frame, hash, key);
            if (hashLookupResult.getEntry() != null) {
                return hashLookupResult.getEntry().getValue();
            }
            notInHashProfile.enter();
            if (this.undefinedValue != null) {
                return this.undefinedValue;
            }
            useDefaultProfile.enter();
            return this.callDefaultNode.call(frame, hash, "default", null, key);
        }

        public void setUndefinedValue(Object undefinedValue) {
            this.undefinedValue = undefinedValue;
        }
    }

    @CoreMethod(names={"[]"}, constructor=true, rest=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class ConstructNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private HashNode hashNode;
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public ConstructNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.hashNode = new HashNode(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @ExplodeLoop
        @Specialization(guards={"isSmallArrayOfPairs(args)"})
        public Object construct(VirtualFrame frame, DynamicObject hashClass, Object[] args) {
            DynamicObject array = (DynamicObject)args[0];
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            int size = Layouts.ARRAY.getSize(array);
            Object[] newStore = PackedArrayStrategy.createStore(this.getContext());
            for (int n = 0; n < this.getContext().getOptions().HASH_PACKED_ARRAY_MAX; ++n) {
                if (n >= size) continue;
                Object pair = store[n];
                if (!RubyGuards.isRubyArray(pair)) {
                    return this.constructFallback(frame, hashClass, args);
                }
                DynamicObject pairArray = (DynamicObject)pair;
                if (!(Layouts.ARRAY.getStore(pairArray) instanceof Object[])) {
                    return this.constructFallback(frame, hashClass, args);
                }
                if (Layouts.ARRAY.getSize(pairArray) != 2) {
                    return this.constructFallback(frame, hashClass, args);
                }
                Object[] pairStore = (Object[])Layouts.ARRAY.getStore(pairArray);
                Object key = pairStore[0];
                Object value = pairStore[1];
                int hashed = this.hashNode.hash(frame, key);
                PackedArrayStrategy.setHashedKeyValue(newStore, n, hashed, key, value);
            }
            return this.allocateObjectNode.allocateHash(hashClass, newStore, size, null, null, null, null, false);
        }

        @Specialization(guards={"!isSmallArrayOfPairs(args)"})
        public Object constructFallback(VirtualFrame frame, DynamicObject hashClass, Object[] args) {
            return this.ruby(frame, "_constructor_fallback(*args)", "args", Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), args, args.length));
        }

        public boolean isSmallArrayOfPairs(Object[] args) {
            if (args.length != 1) {
                return false;
            }
            Object arg = args[0];
            if (!RubyGuards.isRubyArray(arg)) {
                return false;
            }
            DynamicObject array = (DynamicObject)arg;
            if (!(Layouts.ARRAY.getStore(array) instanceof Object[])) {
                return false;
            }
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            return store.length <= this.getContext().getOptions().HASH_PACKED_ARRAY_MAX;
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocateHash(rubyClass, null, 0, null, null, null, null, false);
        }
    }
}

