/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.object;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.object.ObjectGraphNode;
import org.jruby.truffle.runtime.subsystems.SafepointAction;

public abstract class ObjectGraph {
    public static Set<DynamicObject> stopAndGetAllObjects(Node currentNode, final RubyContext context) {
        final HashSet<DynamicObject> visited = new HashSet<DynamicObject>();
        final Thread stoppingThread = Thread.currentThread();
        context.getSafepointManager().pauseAllThreadsAndExecute(currentNode, false, new SafepointAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(DynamicObject thread, Node currentNode) {
                Set set = visited;
                synchronized (set) {
                    FrameInstance currentFrame;
                    final ArrayDeque<DynamicObject> stack = new ArrayDeque<DynamicObject>();
                    stack.add(thread);
                    if (Thread.currentThread() == stoppingThread) {
                        ObjectGraph.visitContextRoots(context, stack);
                    }
                    if ((currentFrame = Truffle.getRuntime().getCurrentFrame()) != null) {
                        stack.addAll(ObjectGraph.getObjectsInFrame(currentFrame.getFrame(FrameInstance.FrameAccess.READ_ONLY, true)));
                    }
                    Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Object>(){

                        public Object visitFrame(FrameInstance frameInstance) {
                            stack.addAll(ObjectGraph.getObjectsInFrame(frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY, true)));
                            return null;
                        }
                    });
                    while (!stack.isEmpty()) {
                        DynamicObject object = (DynamicObject)stack.pop();
                        if (!visited.add(object)) continue;
                        stack.addAll(ObjectGraph.getAdjacentObjects(object));
                    }
                }
            }
        });
        return visited;
    }

    public static Set<DynamicObject> stopAndGetRootObjects(Node currentNode, final RubyContext context) {
        final HashSet<DynamicObject> objects = new HashSet<DynamicObject>();
        final Thread stoppingThread = Thread.currentThread();
        context.getSafepointManager().pauseAllThreadsAndExecute(currentNode, false, new SafepointAction(){

            @Override
            public void run(DynamicObject thread, Node currentNode) {
                objects.add(thread);
                if (Thread.currentThread() == stoppingThread) {
                    ObjectGraph.visitContextRoots(context, objects);
                }
            }
        });
        return objects;
    }

    public static void visitContextRoots(RubyContext context, Collection<DynamicObject> stack) {
        stack.addAll(ObjectGraph.getAdjacentObjects(context.getCoreLibrary().getGlobalVariablesObject()));
        stack.addAll(context.getAtExitManager().getHandlers());
        stack.addAll(context.getObjectSpaceManager().getFinalizerHandlers());
    }

    public static Set<DynamicObject> getAdjacentObjects(DynamicObject object) {
        HashSet<DynamicObject> reachable = new HashSet<DynamicObject>();
        reachable.add(Layouts.BASIC_OBJECT.getLogicalClass(object));
        reachable.add(Layouts.BASIC_OBJECT.getMetaClass(object));
        for (Property property : object.getShape().getPropertyListInternal(false)) {
            Object propertyValue = property.get(object, object.getShape());
            if (propertyValue instanceof DynamicObject) {
                reachable.add((DynamicObject)propertyValue);
                continue;
            }
            if (propertyValue instanceof Entry[]) {
                Object[] arr$ = (Entry[])propertyValue;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    for (Object bucket = arr$[i$]; bucket != null; bucket = ((Entry)bucket).getNextInLookup()) {
                        if (((Entry)bucket).getKey() instanceof DynamicObject) {
                            reachable.add((DynamicObject)((Entry)bucket).getKey());
                        }
                        if (!(((Entry)bucket).getValue() instanceof DynamicObject)) continue;
                        reachable.add((DynamicObject)((Entry)bucket).getValue());
                    }
                }
                continue;
            }
            if (propertyValue instanceof Object[]) {
                for (Object element : (Object[])propertyValue) {
                    if (!(element instanceof DynamicObject)) continue;
                    reachable.add((DynamicObject)element);
                }
                continue;
            }
            if (propertyValue instanceof Frame) {
                reachable.addAll(ObjectGraph.getObjectsInFrame((Frame)propertyValue));
                continue;
            }
            if (!(propertyValue instanceof ObjectGraphNode)) continue;
            reachable.addAll(((ObjectGraphNode)propertyValue).getAdjacentObjects());
        }
        return reachable;
    }

    public static Set<DynamicObject> getObjectsInFrame(Frame frame) {
        HashSet<DynamicObject> objects = new HashSet<DynamicObject>();
        MaterializedFrame lexicalParentFrame = RubyArguments.tryGetDeclarationFrame(frame.getArguments());
        if (lexicalParentFrame != null) {
            objects.addAll(ObjectGraph.getObjectsInFrame((Frame)lexicalParentFrame));
        }
        for (FrameSlot slot : frame.getFrameDescriptor().getSlots()) {
            Object slotValue = frame.getValue(slot);
            if (!(slotValue instanceof DynamicObject)) continue;
            objects.add((DynamicObject)slotValue);
        }
        return objects;
    }
}

