/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.loader;

import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.jruby.Ruby;
import org.jruby.truffle.runtime.RubyContext;

public class SourceLoader {
    public static final String TRUFFLE_SCHEME = "truffle:";
    public static final String JRUBY_SCHEME = "jruby:";
    private final RubyContext context;

    public SourceLoader(RubyContext context) {
        this.context = context;
    }

    public Source load(String canonicalPath) throws IOException {
        if (canonicalPath.equals("-e")) {
            return this.loadInlineScript();
        }
        if (canonicalPath.startsWith(TRUFFLE_SCHEME) || canonicalPath.startsWith(JRUBY_SCHEME)) {
            return this.loadResource(canonicalPath);
        }
        assert (new File(canonicalPath).getCanonicalPath().equals(canonicalPath)) : canonicalPath;
        return Source.fromFileName((String)canonicalPath);
    }

    private Source loadInlineScript() {
        return Source.fromText((CharSequence)new String(this.context.getRuntime().getInstanceConfig().inlineScript(), StandardCharsets.UTF_8), (String)"-e");
    }

    private Source loadResource(String path) throws IOException {
        String relativePath;
        Class<RubyContext> relativeClass;
        if (!path.toLowerCase(Locale.ENGLISH).endsWith(".rb")) {
            throw new FileNotFoundException(path);
        }
        if (path.startsWith(TRUFFLE_SCHEME)) {
            relativeClass = RubyContext.class;
            relativePath = path.substring(TRUFFLE_SCHEME.length());
        } else if (path.startsWith(JRUBY_SCHEME)) {
            relativeClass = Ruby.class;
            relativePath = path.substring(JRUBY_SCHEME.length());
        } else {
            throw new UnsupportedOperationException();
        }
        String canonicalPath = new File(relativePath).getCanonicalPath();
        InputStream stream = relativeClass.getResourceAsStream(canonicalPath);
        if (stream == null) {
            throw new FileNotFoundException(path);
        }
        return Source.fromReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), (String)path);
    }
}

