/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts.ext;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.math.BigDecimal;
import java.util.EnumSet;
import org.jruby.truffle.nodes.ext.BigDecimalNodes;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.ext.BigDecimalLayout;

public class BigDecimalLayoutImpl
extends BasicObjectLayoutImpl
implements BigDecimalLayout {
    public static final BigDecimalLayout INSTANCE = new BigDecimalLayoutImpl();
    protected static final Shape.Allocator BIG_DECIMAL_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey VALUE_IDENTIFIER = new HiddenKey("value");
    protected static final Property VALUE_PROPERTY = Property.create((Object)VALUE_IDENTIFIER, (Location)BIG_DECIMAL_ALLOCATOR.locationForType(BigDecimal.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey TYPE_IDENTIFIER = new HiddenKey("type");
    protected static final Property TYPE_PROPERTY = Property.create((Object)TYPE_IDENTIFIER, (Location)BIG_DECIMAL_ALLOCATOR.locationForType(BigDecimalNodes.Type.class, EnumSet.of(LocationModifier.NonNull)), (int)0);

    protected BigDecimalLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createBigDecimalShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new BigDecimalType(logicalClass, metaClass)).addProperty(VALUE_PROPERTY).addProperty(TYPE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createBigDecimal(DynamicObjectFactory factory, BigDecimal value, BigDecimalNodes.Type type) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsBigDecimal(factory));
        assert (factory.getShape().hasProperty((Object)VALUE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)TYPE_IDENTIFIER));
        assert (value != null);
        assert (type != null);
        return factory.newInstance(new Object[]{value, type});
    }

    @Override
    public boolean isBigDecimal(DynamicObject object) {
        return this.isBigDecimal(object.getShape().getObjectType());
    }

    private boolean isBigDecimal(ObjectType objectType) {
        return objectType instanceof BigDecimalType;
    }

    private boolean createsBigDecimal(DynamicObjectFactory factory) {
        return this.isBigDecimal(factory.getShape().getObjectType());
    }

    @Override
    public BigDecimal getValue(DynamicObject object) {
        assert (this.isBigDecimal(object));
        assert (object.getShape().hasProperty((Object)VALUE_IDENTIFIER));
        return (BigDecimal)VALUE_PROPERTY.get(object, true);
    }

    @Override
    public void setValue(DynamicObject object, BigDecimal value) {
        assert (this.isBigDecimal(object));
        assert (object.getShape().hasProperty((Object)VALUE_IDENTIFIER));
        assert (value != null);
        try {
            VALUE_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public BigDecimalNodes.Type getType(DynamicObject object) {
        assert (this.isBigDecimal(object));
        assert (object.getShape().hasProperty((Object)TYPE_IDENTIFIER));
        return (BigDecimalNodes.Type)((Object)TYPE_PROPERTY.get(object, true));
    }

    @Override
    public void setType(DynamicObject object, BigDecimalNodes.Type value) {
        assert (this.isBigDecimal(object));
        assert (object.getShape().hasProperty((Object)TYPE_IDENTIFIER));
        assert (value != null);
        try {
            TYPE_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class BigDecimalType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public BigDecimalType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public BigDecimalType setLogicalClass(DynamicObject logicalClass) {
            return new BigDecimalType(logicalClass, this.metaClass);
        }

        @Override
        public BigDecimalType setMetaClass(DynamicObject metaClass) {
            return new BigDecimalType(this.logicalClass, metaClass);
        }
    }
}

