/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.concurrent.BlockingQueue;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.SizedQueueLayout;

public class SizedQueueLayoutImpl
extends BasicObjectLayoutImpl
implements SizedQueueLayout {
    public static final SizedQueueLayout INSTANCE = new SizedQueueLayoutImpl();
    protected static final Shape.Allocator SIZED_QUEUE_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey QUEUE_IDENTIFIER = new HiddenKey("queue");
    protected static final Property QUEUE_PROPERTY = Property.create((Object)QUEUE_IDENTIFIER, (Location)SIZED_QUEUE_ALLOCATOR.locationForType(BlockingQueue.class), (int)0);

    protected SizedQueueLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createSizedQueueShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new SizedQueueType(logicalClass, metaClass)).addProperty(QUEUE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createSizedQueue(DynamicObjectFactory factory, BlockingQueue<Object> queue) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsSizedQueue(factory));
        assert (factory.getShape().hasProperty((Object)QUEUE_IDENTIFIER));
        return factory.newInstance(new Object[]{queue});
    }

    private boolean isSizedQueue(DynamicObject object) {
        return this.isSizedQueue(object.getShape().getObjectType());
    }

    private boolean isSizedQueue(ObjectType objectType) {
        return objectType instanceof SizedQueueType;
    }

    private boolean createsSizedQueue(DynamicObjectFactory factory) {
        return this.isSizedQueue(factory.getShape().getObjectType());
    }

    @Override
    public BlockingQueue<Object> getQueue(DynamicObject object) {
        assert (this.isSizedQueue(object));
        assert (object.getShape().hasProperty((Object)QUEUE_IDENTIFIER));
        return (BlockingQueue)QUEUE_PROPERTY.get(object, true);
    }

    @Override
    public void setQueue(DynamicObject object, BlockingQueue<Object> value) {
        assert (this.isSizedQueue(object));
        assert (object.getShape().hasProperty((Object)QUEUE_IDENTIFIER));
        try {
            QUEUE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class SizedQueueType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public SizedQueueType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public SizedQueueType setLogicalClass(DynamicObject logicalClass) {
            return new SizedQueueType(logicalClass, this.metaClass);
        }

        @Override
        public SizedQueueType setMetaClass(DynamicObject metaClass) {
            return new SizedQueueType(this.logicalClass, metaClass);
        }
    }
}

