/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.om.dsl.processor.layout;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.TypeKind;
import org.jruby.truffle.om.dsl.processor.layout.model.LayoutModel;
import org.jruby.truffle.om.dsl.processor.layout.model.NameUtils;
import org.jruby.truffle.om.dsl.processor.layout.model.PropertyModel;

public class LayoutGenerator {
    private static final boolean GENERATE_SHAPE_BOUNDARY_CONSTANT_CHECKS = Boolean.valueOf(System.getProperty("org.jruby.truffle.om.dsl.processor.layout.LayoutGenerator.GENERATE_SHAPE_BOUNDARY_CONSTANT_CHECKS", Boolean.FALSE.toString()));
    private final LayoutModel layout;

    public LayoutGenerator(LayoutModel layout) {
        this.layout = layout;
    }

    public void generate(final PrintStream stream) {
        String locationType;
        StringBuilder modifiersExpressionBuilder;
        String modifiersExpression;
        stream.printf("package %s;%n", this.layout.getPackageName());
        stream.println();
        stream.println("import java.util.EnumSet;");
        stream.println("import com.oracle.truffle.api.object.*;");
        stream.println("import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;");
        stream.println("import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;");
        stream.println("import com.oracle.truffle.api.CompilerAsserts;");
        stream.println("import java.util.concurrent.atomic.*;");
        stream.printf("import %s;%n", this.layout.getInterfaceFullName());
        if (this.layout.getSuperLayout() != null) {
            stream.printf("import %s.%sLayoutImpl;%n", this.layout.getSuperLayout().getPackageName(), this.layout.getSuperLayout().getName());
        }
        stream.println();
        stream.printf("public class %sLayoutImpl", this.layout.getName());
        if (this.layout.getSuperLayout() != null) {
            stream.printf(" extends %sLayoutImpl", this.layout.getSuperLayout().getName());
        }
        stream.printf(" implements %sLayout {%n", this.layout.getName());
        stream.println("    ");
        stream.printf("    public static final %sLayout INSTANCE = new %sLayoutImpl();%n", this.layout.getName(), this.layout.getName());
        stream.println("    ");
        String typeSuperclass = this.layout.getSuperLayout() == null ? this.layout.getObjectTypeSuperclass() : this.layout.getSuperLayout().getName() + "LayoutImpl." + this.layout.getSuperLayout().getName() + "Type";
        stream.printf("    protected static class %sType extends %s {%n", this.layout.getName(), typeSuperclass);
        if (this.layout.hasShapeProperties()) {
            stream.println("        ");
            for (PropertyModel property : this.layout.getShapeProperties()) {
                stream.printf("        protected final %s %s;%n", property.getType(), property.getName());
            }
            if (!this.layout.getShapeProperties().isEmpty()) {
                stream.println("        ");
            }
            stream.printf("        public %sType(%n", this.layout.getName());
            this.iterateProperties(this.layout.getAllShapeProperties(), new PropertyIteratorAction(){

                @Override
                public void run(PropertyModel property, boolean last) {
                    stream.printf("                %s %s", property.getType().toString(), property.getName());
                    if (last) {
                        stream.println(") {");
                    } else {
                        stream.println(",");
                    }
                }
            });
            if (!this.layout.getInheritedShapeProperties().isEmpty()) {
                stream.println("            super(");
                this.iterateProperties(this.layout.getInheritedShapeProperties(), new PropertyIteratorAction(){

                    @Override
                    public void run(PropertyModel property, boolean last) {
                        stream.printf("                %s", property.getName());
                        if (last) {
                            stream.println(");");
                        } else {
                            stream.println(",");
                        }
                    }
                });
            }
            this.iterateProperties(this.layout.getShapeProperties(), new PropertyIteratorAction(){

                @Override
                public void run(PropertyModel property, boolean last) {
                    stream.printf("            this.%s = %s;%n", property.getName(), property.getName());
                }
            });
            stream.println("        }");
            stream.println("        ");
            for (PropertyModel property : this.layout.getAllShapeProperties()) {
                boolean inherited;
                boolean bl = inherited = !this.layout.getShapeProperties().contains(property);
                if (!inherited) {
                    stream.printf("        public %s %s() {%n", property.getType(), NameUtils.asGetter(property.getName()));
                    stream.printf("            return %s;%n", property.getName());
                    stream.println("        }");
                    stream.println("        ");
                }
                if (inherited) {
                    stream.println("        @Override");
                }
                stream.printf("        public %sType %s(%s %s) {%n", this.layout.getName(), NameUtils.asSetter(property.getName()), property.getType(), property.getName());
                stream.printf("            return new %sType(%n", this.layout.getName());
                this.iterateProperties(this.layout.getAllShapeProperties(), new PropertyIteratorAction(){

                    @Override
                    public void run(PropertyModel property, boolean last) {
                        stream.printf("                %s", property.getName());
                        if (last) {
                            stream.println(");");
                        } else {
                            stream.println(",");
                        }
                    }
                });
                stream.println("        }");
                stream.println("        ");
            }
        } else {
            stream.println("        ");
        }
        stream.println("    }");
        stream.println("    ");
        if (!this.layout.hasShapeProperties()) {
            stream.printf("    protected static final %sType %s_TYPE = new %sType();%n", this.layout.getName(), NameUtils.identifierToConstant(this.layout.getName()), this.layout.getName());
            stream.println("    ");
        }
        if (this.layout.getSuperLayout() == null) {
            stream.println("    protected static final Layout LAYOUT = Layout.createLayout(Layout.INT_TO_LONG);");
            stream.printf("    protected static final Shape.Allocator %S_ALLOCATOR = LAYOUT.createAllocator();%n", NameUtils.identifierToConstant(this.layout.getName()));
        } else {
            stream.printf("    protected static final Shape.Allocator %S_ALLOCATOR = LAYOUT.createAllocator();%n", NameUtils.identifierToConstant(this.layout.getName()));
            stream.println("    ");
            if (this.layout.getSuperLayout().hasNonShapeProperties()) {
                stream.println("    static {");
                for (PropertyModel property : this.layout.getSuperLayout().getAllNonShapeProperties()) {
                    ArrayList<String> modifiers = new ArrayList<String>();
                    if (!property.isNullable()) {
                        modifiers.add("LocationModifier.NonNull");
                    }
                    if (modifiers.isEmpty()) {
                        modifiersExpression = "";
                    } else {
                        modifiersExpressionBuilder = new StringBuilder();
                        modifiersExpressionBuilder.append(", EnumSet.of(");
                        for (String modifier : modifiers) {
                            if (modifier != modifiers.get(0)) {
                                modifiersExpressionBuilder.append(", ");
                            }
                            modifiersExpressionBuilder.append(modifier);
                        }
                        modifiersExpressionBuilder.append(")");
                        modifiersExpression = modifiersExpressionBuilder.toString();
                    }
                    locationType = property.isVolatile() ? (property.getType().getKind() == TypeKind.INT ? "AtomicInteger" : (property.getType().getKind() == TypeKind.BOOLEAN ? "AtomicBoolean" : "AtomicReference")) : NameUtils.typeWithoutParameters(property.getType().toString());
                    stream.printf("         %s_ALLOCATOR.locationForType(%s.class%s);%n", NameUtils.identifierToConstant(this.layout.getName()), locationType, modifiersExpression);
                }
                stream.println("    }");
                stream.println("    ");
            }
        }
        for (PropertyModel property : this.layout.getNonShapeProperties()) {
            if (!property.hasIdentifier()) {
                stream.printf("    protected static final HiddenKey %s_IDENTIFIER = new HiddenKey(\"%s\");%n", NameUtils.identifierToConstant(property.getName()), property.getName());
            }
            ArrayList<String> modifiers = new ArrayList<String>();
            if (!property.isNullable()) {
                modifiers.add("LocationModifier.NonNull");
            }
            if (modifiers.isEmpty()) {
                modifiersExpression = "";
            } else {
                modifiersExpressionBuilder = new StringBuilder();
                modifiersExpressionBuilder.append(", EnumSet.of(");
                for (String modifier : modifiers) {
                    if (modifier != modifiers.get(0)) {
                        modifiersExpressionBuilder.append(", ");
                    }
                    modifiersExpressionBuilder.append(modifier);
                }
                modifiersExpressionBuilder.append(")");
                modifiersExpression = modifiersExpressionBuilder.toString();
            }
            locationType = property.isVolatile() ? (property.getType().getKind() == TypeKind.INT ? "AtomicInteger" : (property.getType().getKind() == TypeKind.BOOLEAN ? "AtomicBoolean" : "AtomicReference")) : NameUtils.typeWithoutParameters(property.getType().toString());
            stream.printf("    protected static final Property %S_PROPERTY = Property.create(%s_IDENTIFIER, %S_ALLOCATOR.locationForType(%s.class%s), 0);%n", NameUtils.identifierToConstant(property.getName()), NameUtils.identifierToConstant(property.getName()), NameUtils.identifierToConstant(this.layout.getName()), locationType, modifiersExpression);
            stream.println("    ");
        }
        if (!this.layout.hasShapeProperties()) {
            stream.printf("    private static final DynamicObjectFactory %s_FACTORY = create%sShape();%n", NameUtils.identifierToConstant(this.layout.getName()), this.layout.getName());
            stream.println("    ");
        }
        stream.printf("    protected %sLayoutImpl() {%n", this.layout.getName());
        stream.println("    }");
        stream.println("    ");
        if (this.layout.hasShapeProperties()) {
            stream.println("    @Override");
            stream.print("    public");
        } else {
            stream.print("    private");
        }
        stream.printf(" DynamicObjectFactory create%sShape(%n", this.layout.getName());
        for (PropertyModel property : this.layout.getAllShapeProperties()) {
            stream.printf("            %s %s", property.getType().toString(), property.getName());
            if (property == this.layout.getAllShapeProperties().get(this.layout.getAllShapeProperties().size() - 1)) {
                stream.println(") {");
                continue;
            }
            stream.println(",");
        }
        for (PropertyModel property : this.layout.getAllShapeProperties()) {
            if (property.getType().getKind().isPrimitive() || property.isNullable()) continue;
            stream.printf("        assert %s != null;%n", property.getName());
        }
        stream.printf("        return LAYOUT.createShape(new %sType(%n", this.layout.getName());
        this.iterateProperties(this.layout.getAllShapeProperties(), new PropertyIteratorAction(){

            @Override
            public void run(PropertyModel property, boolean last) {
                stream.printf("                %s", property.getName());
                if (last) {
                    stream.println("))");
                } else {
                    stream.println(",");
                }
            }
        });
        this.iterateProperties(this.layout.getAllNonShapeProperties(), new PropertyIteratorAction(){

            @Override
            public void run(PropertyModel property, boolean last) {
                stream.printf("            .addProperty(%s_PROPERTY)%n", NameUtils.identifierToConstant(property.getName()));
            }
        });
        stream.println("            .createFactory();");
        stream.println("    }");
        stream.println("    ");
        if (!this.layout.hasShapeProperties()) {
            stream.println("    @Override");
            stream.printf("    public DynamicObject create%s(%n", this.layout.getName());
            for (PropertyModel property : this.layout.getAllProperties()) {
                stream.printf("            %s %s", property.getType().toString(), property.getName());
                if (property == this.layout.getAllProperties().get(this.layout.getAllProperties().size() - 1)) {
                    stream.println(") {");
                    continue;
                }
                stream.println(",");
            }
            stream.printf("        return create%s(%s_FACTORY,%n", this.layout.getName(), NameUtils.identifierToConstant(this.layout.getName()));
            for (PropertyModel property : this.layout.getAllProperties()) {
                stream.printf("            %s", property.getName());
                if (property == this.layout.getAllProperties().get(this.layout.getAllProperties().size() - 1)) {
                    stream.println(");");
                    continue;
                }
                stream.println(",");
            }
            stream.println("    }");
            stream.println("    ");
        }
        if (this.layout.hasShapeProperties()) {
            stream.println("    @Override");
            stream.print("    public");
        } else {
            stream.print("    private");
        }
        if (this.layout.hasNonShapeProperties()) {
            stream.printf(" DynamicObject create%s(%n", this.layout.getName());
            stream.println("            DynamicObjectFactory factory,");
            for (PropertyModel property : this.layout.getAllNonShapeProperties()) {
                stream.printf("            %s %s", property.getType().toString(), property.getName());
                if (property == this.layout.getAllProperties().get(this.layout.getAllProperties().size() - 1)) {
                    stream.println(") {");
                    continue;
                }
                stream.println(",");
            }
        } else {
            stream.printf(" DynamicObject create%s(DynamicObjectFactory factory) {%n", this.layout.getName());
        }
        stream.println("        assert factory != null;");
        stream.println("        CompilerAsserts.partialEvaluationConstant(factory);");
        stream.printf("        assert creates%s(factory);%n", this.layout.getName());
        for (PropertyModel property : this.layout.getAllNonShapeProperties()) {
            stream.printf("        assert factory.getShape().hasProperty(%s_IDENTIFIER);%n", NameUtils.identifierToConstant(property.getName()));
        }
        for (PropertyModel property : this.layout.getAllNonShapeProperties()) {
            if (property.getType().getKind().isPrimitive() || property.isNullable()) continue;
            stream.printf("        assert %s != null;%n", property.getName());
        }
        if (GENERATE_SHAPE_BOUNDARY_CONSTANT_CHECKS) {
            if (this.layout.hasNonShapeProperties()) {
                stream.printf("        return create%sBoundary(factory,%n", this.layout.getName());
                for (PropertyModel property : this.layout.getAllNonShapeProperties()) {
                    stream.printf("            %s", property.getName());
                    if (property == this.layout.getAllProperties().get(this.layout.getAllProperties().size() - 1)) {
                        stream.println(");");
                        continue;
                    }
                    stream.println(",");
                }
            } else {
                stream.printf("        return create%sBoundary(factory);%n", this.layout.getName());
            }
        } else if (this.layout.hasNonShapeProperties()) {
            stream.println("        return factory.newInstance(");
            for (PropertyModel property : this.layout.getAllNonShapeProperties()) {
                if (property.isVolatile()) {
                    if (property.getType().getKind() == TypeKind.INT) {
                        stream.printf("            new AtomicInteger(%s)", property.getName());
                    } else if (property.getType().getKind() == TypeKind.BOOLEAN) {
                        stream.printf("            new AtomicBoolean(%s)", property.getName());
                    } else {
                        stream.printf("            new AtomicReference<%s>(%s)", property.getType(), property.getName());
                    }
                } else {
                    stream.printf("            %s", property.getName());
                }
                if (property == this.layout.getAllProperties().get(this.layout.getAllProperties().size() - 1)) {
                    stream.println(");");
                    continue;
                }
                stream.println(",");
            }
        } else {
            stream.println("        return factory.newInstance();");
        }
        stream.println("    }");
        stream.println("    ");
        if (GENERATE_SHAPE_BOUNDARY_CONSTANT_CHECKS) {
            stream.println("    @TruffleBoundary");
            if (this.layout.hasNonShapeProperties()) {
                stream.printf("    private DynamicObject create%sBoundary(%n", this.layout.getName());
                stream.println("            DynamicObjectFactory factory,");
                for (PropertyModel property : this.layout.getAllNonShapeProperties()) {
                    stream.printf("            %s %s", property.getType().toString(), property.getName());
                    if (property == this.layout.getAllProperties().get(this.layout.getAllProperties().size() - 1)) {
                        stream.println(") {");
                        continue;
                    }
                    stream.println(",");
                }
            } else {
                stream.printf(" DynamicObject create%sBoundary(DynamicObjectFactory factory) {%n", this.layout.getName());
            }
            stream.println("        assert factory != null;");
            stream.println("        CompilerAsserts.partialEvaluationConstant(factory);");
            stream.printf("        assert creates%s(factory);%n", this.layout.getName());
            for (PropertyModel property : this.layout.getAllNonShapeProperties()) {
                stream.printf("        assert factory.getShape().hasProperty(%s_IDENTIFIER);%n", NameUtils.identifierToConstant(property.getName()));
            }
            for (PropertyModel property : this.layout.getAllNonShapeProperties()) {
                if (property.getType().getKind().isPrimitive() || property.isNullable()) continue;
                stream.printf("        assert %s != null;%n", property.getName());
            }
            if (this.layout.hasNonShapeProperties()) {
                stream.println("        return factory.newInstance(");
                for (PropertyModel property : this.layout.getAllNonShapeProperties()) {
                    if (property.isVolatile()) {
                        if (property.getType().getKind() == TypeKind.INT) {
                            stream.printf("            new AtomicInteger(%s)", property.getName());
                        } else if (property.getType().getKind() == TypeKind.BOOLEAN) {
                            stream.printf("            new AtomicBoolean(%s)", property.getName());
                        } else {
                            stream.printf("            new AtomicReference<%s>(%s)", property.getType(), property.getName());
                        }
                    } else {
                        stream.printf("            %s", property.getName());
                    }
                    if (property == this.layout.getAllProperties().get(this.layout.getAllProperties().size() - 1)) {
                        stream.println(");");
                        continue;
                    }
                    stream.println(",");
                }
            } else {
                stream.println("        return factory.newInstance();");
            }
            stream.println("    }");
            stream.println("    ");
        }
        if (this.layout.hasObjectGuard()) {
            stream.println("    @Override");
            stream.printf("    public boolean is%s(Object object) {%n", this.layout.getName());
            stream.printf("        return (object instanceof DynamicObject) && is%s((DynamicObject) object);%n", this.layout.getName());
            stream.println("    }");
            stream.println("    ");
        }
        if (this.layout.hasDynamicObjectGuard()) {
            stream.println("    @Override");
            stream.print("    public");
        } else {
            stream.print("    private");
        }
        stream.printf(" boolean is%s(DynamicObject object) {%n", this.layout.getName());
        stream.printf("        return is%s(object.getShape().getObjectType());%n", this.layout.getName());
        stream.println("    }");
        stream.println("    ");
        if (this.layout.hasObjectTypeGuard()) {
            stream.println("    @Override");
            stream.print("    public");
        } else {
            stream.print("    private");
        }
        stream.printf(" boolean is%s(ObjectType objectType) {%n", this.layout.getName());
        stream.printf("        return objectType instanceof %sType;%n", this.layout.getName());
        stream.println("    }");
        stream.println("    ");
        stream.printf("    private boolean creates%s(DynamicObjectFactory factory) {%n", this.layout.getName());
        stream.printf("        return is%s(factory.getShape().getObjectType());%n", this.layout.getName());
        stream.println("    }");
        stream.println("    ");
        for (PropertyModel property : this.layout.getProperties()) {
            if (property.hasObjectTypeGetter()) {
                stream.println("    @Override");
                stream.printf("    public %s %s(ObjectType objectType) {%n", property.getType(), NameUtils.asGetter(property.getName()));
                stream.printf("        assert is%s(objectType);%n", this.layout.getName());
                stream.printf("        return ((%sType) objectType).%s();%n", this.layout.getName(), NameUtils.asGetter(property.getName()));
                stream.println("    }");
                stream.println("    ");
            }
            if (property.hasFactoryGetter()) {
                stream.println("    @Override");
                stream.printf("    public %s %s(DynamicObjectFactory factory) {%n", property.getType(), NameUtils.asGetter(property.getName()));
                stream.printf("        assert creates%s(object);%n", this.layout.getName());
                stream.printf("        return ((%sType) factory.getShape().getObjectType()).%s();%n", this.layout.getName(), NameUtils.asGetter(property.getName()));
                stream.println("    }");
                stream.println("    ");
            }
            if (property.hasGetter()) {
                this.addUncheckedCastWarning(stream, property);
                stream.println("    @Override");
                stream.printf("    public %s %s(DynamicObject object) {%n", property.getType(), NameUtils.asGetter(property.getName()));
                stream.printf("        assert is%s(object);%n", this.layout.getName());
                if (property.isShapeProperty()) {
                    stream.printf("        return getObjectType(object).%s();%n", NameUtils.asGetter(property.getName()));
                } else {
                    stream.printf("        assert object.getShape().hasProperty(%s_IDENTIFIER);%n", NameUtils.identifierToConstant(property.getName()));
                    stream.println("        ");
                    if (property.isVolatile()) {
                        if (property.getType().getKind() == TypeKind.INT) {
                            stream.printf("        return ((AtomicInteger) %s_PROPERTY.get(object, true)).get();%n", NameUtils.identifierToConstant(property.getName()));
                        } else if (property.getType().getKind() == TypeKind.BOOLEAN) {
                            stream.printf("        return ((AtomicBoolean) %s_PROPERTY.get(object, true)).get();%n", NameUtils.identifierToConstant(property.getName()));
                        } else {
                            stream.printf("        return ((AtomicReference<%s>) %s_PROPERTY.get(object, true)).get();%n", property.getType(), NameUtils.identifierToConstant(property.getName()));
                        }
                    } else {
                        stream.printf("        return (%s) %s_PROPERTY.get(object, true);%n", property.getType(), NameUtils.identifierToConstant(property.getName()));
                    }
                }
                stream.println("    }");
                stream.println("    ");
            }
            if (property.hasFactorySetter()) {
                stream.println("    @TruffleBoundary");
                stream.println("    @Override");
                stream.printf("    public DynamicObjectFactory %s(DynamicObjectFactory factory, %s value) {%n", NameUtils.asSetter(property.getName()), property.getType());
                stream.printf("        assert creates%s(factory);%n", this.layout.getName());
                stream.println("        final Shape shape = factory.getShape();");
                stream.printf("        return shape.changeType(((%sType) shape.getObjectType()).%s(value)).createFactory();%n", this.layout.getName(), NameUtils.asSetter(property.getName()));
                stream.println("    }");
                stream.println("    ");
            }
            assert (!property.hasSetter() || !property.hasUnsafeSetter());
            if (!property.hasSetter() && !property.hasUnsafeSetter()) continue;
            this.addUncheckedCastWarning(stream, property);
            if (property.isShapeProperty()) {
                stream.println("    @TruffleBoundary");
            }
            stream.println("    @Override");
            String methodNameSuffix = property.hasUnsafeSetter() ? "Unsafe" : "";
            stream.printf("    public void %s%s(DynamicObject object, %s value) {%n", NameUtils.asSetter(property.getName()), methodNameSuffix, property.getType());
            stream.printf("        assert is%s(object);%n", this.layout.getName());
            if (property.isShapeProperty()) {
                stream.println("        final Shape shape = object.getShape();");
                stream.printf("        object.setShapeAndResize(shape, shape.changeType(getObjectType(object).%s(value)));%n", NameUtils.asSetter(property.getName()));
            } else {
                stream.printf("        assert object.getShape().hasProperty(%s_IDENTIFIER);%n", NameUtils.identifierToConstant(property.getName()));
                if (!property.getType().getKind().isPrimitive() && !property.isNullable()) {
                    stream.println("        assert value != null;");
                }
                stream.println("        ");
                if (property.hasUnsafeSetter()) {
                    stream.printf("        %s_PROPERTY.setInternal(object, value);%n", NameUtils.identifierToConstant(property.getName()));
                } else if (property.isVolatile()) {
                    if (property.getType().getKind() == TypeKind.INT) {
                        stream.printf("        ((AtomicInteger) %s_PROPERTY.get(object, true)).set(value);%n", NameUtils.identifierToConstant(property.getName()));
                    } else if (property.getType().getKind() == TypeKind.BOOLEAN) {
                        stream.printf("        ((AtomicBoolean) %s_PROPERTY.get(object, true)).set(value);%n", NameUtils.identifierToConstant(property.getName()));
                    } else {
                        stream.printf("        ((AtomicReference<%s>) %s_PROPERTY.get(object, true)).set(value);%n", property.getType(), NameUtils.identifierToConstant(property.getName()));
                    }
                } else {
                    stream.printf("        try {%n", new Object[0]);
                    stream.printf("            %s_PROPERTY.set(object, value, object.getShape());%n", NameUtils.identifierToConstant(property.getName()));
                    stream.printf("        } catch (IncompatibleLocationException | FinalLocationException e) {%n", new Object[0]);
                    stream.printf("            throw new UnexpectedLayoutRefusalException(e);%n", new Object[0]);
                    stream.printf("        }%n", new Object[0]);
                }
            }
            stream.println("    }");
            stream.println("    ");
        }
        if (this.layout.hasShapeProperties() && (this.layout.getSuperLayout() == null || !this.layout.getSuperLayout().hasShapeProperties())) {
            stream.printf("    private %sType getObjectType(DynamicObject object) {%n", this.layout.getName());
            stream.printf("        assert is%s(object);%n", this.layout.getName());
            stream.printf("        return (%sType) object.getShape().getObjectType();%n", this.layout.getName());
            stream.println("    }");
            stream.println("    ");
        }
        stream.println("}");
    }

    private void addUncheckedCastWarning(PrintStream stream, PropertyModel property) {
        if (property.getType().toString().indexOf(60) != -1 || property.isVolatile() && !property.getType().getKind().isPrimitive()) {
            stream.println("    @SuppressWarnings(\"unchecked\")");
        }
    }

    private void iterateProperties(List<PropertyModel> properties, PropertyIteratorAction action) {
        for (int n = 0; n < properties.size(); ++n) {
            action.run(properties.get(n), n == properties.size() - 1);
        }
    }

    private static interface PropertyIteratorAction {
        public void run(PropertyModel var1, boolean var2);
    }
}

