/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import jnr.constants.platform.Errno;
import org.jruby.truffle.nodes.core.ExceptionNodes;
import org.jruby.truffle.nodes.rubinius.ByteArrayNodes;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;

public abstract class IOBufferPrimitiveNodes {
    private static final int IOBUFFER_SIZE = 32768;
    private static final int STACK_BUF_SZ = 8192;

    @RubiniusPrimitive(name="iobuffer_fill")
    public static abstract class IOBufferFillPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOBufferFillPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int fill(VirtualFrame frame, DynamicObject ioBuffer, DynamicObject io) {
            int bytesRead;
            int fd = Layouts.IO.getDescriptor(io);
            byte[] readBuffer = new byte[8192];
            int count = 8192;
            if (this.left(frame, ioBuffer) < count) {
                count = this.left(frame, ioBuffer);
            }
            if ((bytesRead = this.performFill(fd, readBuffer, count)) > 0) {
                if (bytesRead > this.left(frame, ioBuffer)) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().internalError("IO buffer overrun", this));
                }
                int used = Layouts.IO_BUFFER.getUsed(ioBuffer);
                ByteList storage = Layouts.BYTE_ARRAY.getBytes(Layouts.IO_BUFFER.getStorage(ioBuffer));
                System.arraycopy(readBuffer, 0, storage.getUnsafeBytes(), storage.getBegin() + used, bytesRead);
                storage.setRealSize(used + bytesRead);
                Layouts.IO_BUFFER.setUsed(ioBuffer, used + bytesRead);
            }
            return bytesRead;
        }

        @CompilerDirectives.TruffleBoundary
        private int performFill(int fd, byte[] readBuffer, int count) {
            int bytesRead;
            while ((bytesRead = this.posix().read(fd, readBuffer, count)) == -1) {
                int errno = this.posix().errno();
                if (errno == Errno.ECONNRESET.intValue() || errno == Errno.ETIMEDOUT.intValue()) {
                    bytesRead = 0;
                    break;
                }
                if (errno == Errno.EAGAIN.intValue() || errno == Errno.EINTR.intValue()) {
                    this.getContext().getSafepointManager().poll(this);
                    continue;
                }
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(ExceptionNodes.createRubyException(this.getContext().getCoreLibrary().getErrnoClass(Errno.valueOf((long)errno))));
            }
            return bytesRead;
        }

        private int left(VirtualFrame frame, DynamicObject ioBuffer) {
            int total = Layouts.IO_BUFFER.getTotal(ioBuffer);
            int used = Layouts.IO_BUFFER.getUsed(ioBuffer);
            return total - used;
        }
    }

    @RubiniusPrimitive(name="iobuffer_unshift", lowerFixnumParameters={1})
    public static abstract class IOBufferUnshiftPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOBufferUnshiftPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public int unshift(VirtualFrame frame, DynamicObject ioBuffer, DynamicObject string, int startPosition) {
            Layouts.IO_BUFFER.setWriteSynced(ioBuffer, false);
            ByteList byteList = StringOperations.getByteList(string);
            int stringSize = byteList.realSize() - startPosition;
            int usedSpace = Layouts.IO_BUFFER.getUsed(ioBuffer);
            int availableSpace = 32768 - usedSpace;
            if (stringSize > availableSpace) {
                stringSize = availableSpace;
            }
            ByteList storage = Layouts.BYTE_ARRAY.getBytes(Layouts.IO_BUFFER.getStorage(ioBuffer));
            System.arraycopy(byteList.unsafeBytes(), byteList.begin() + startPosition, storage.getUnsafeBytes(), storage.begin() + usedSpace, stringSize);
            Layouts.IO_BUFFER.setUsed(ioBuffer, usedSpace + stringSize);
            return stringSize;
        }
    }

    @RubiniusPrimitive(name="iobuffer_allocate")
    public static abstract class IOBufferAllocatePrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOBufferAllocatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject classToAllocate) {
            return Layouts.IO_BUFFER.createIOBuffer(Layouts.CLASS.getInstanceFactory(classToAllocate), true, ByteArrayNodes.createByteArray(this.getContext().getCoreLibrary().getByteArrayClass(), new ByteList(32768)), 0, 0, 32768);
        }
    }
}

