/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.StringNodesFactory;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;

@CoreClass(name="Rubinius::ByteArray")
public abstract class ByteArrayNodes {
    public static DynamicObject createByteArray(DynamicObject rubyClass, ByteList bytes) {
        return Layouts.BYTE_ARRAY.createByteArray(Layouts.CLASS.getInstanceFactory(rubyClass), bytes);
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"locate"}, required=3, lowerFixnumParameters={1, 2})
    public static abstract class LocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private StringNodes.SizeNode sizeNode;

        public LocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.sizeNode = StringNodesFactory.SizeNodeFactory.create(context, sourceSection, new RubyNode[0]);
        }

        @Specialization(guards={"isRubyString(pattern)"})
        public Object getByte(VirtualFrame frame, DynamicObject bytes, DynamicObject pattern, int start, int length) {
            int index = new ByteList(Layouts.BYTE_ARRAY.getBytes(bytes), start, length).indexOf(StringOperations.getByteList(pattern));
            if (index == -1) {
                return this.nil();
            }
            return start + index + this.sizeNode.executeInteger(frame, pattern);
        }
    }

    @CoreMethod(names={"size"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int size(DynamicObject bytes) {
            return Layouts.BYTE_ARRAY.getBytes(bytes).getRealSize();
        }
    }

    @CoreMethod(names={"set_byte"}, required=2, lowerFixnumParameters={0, 1})
    public static abstract class SetByteNode
    extends CoreMethodArrayArgumentsNode {
        public SetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object setByte(DynamicObject bytes, int index, int value) {
            if (index < 0 || index >= Layouts.BYTE_ARRAY.getBytes(bytes).getRealSize()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError("index out of bounds", this));
            }
            Layouts.BYTE_ARRAY.getBytes(bytes).set(index, value);
            return Layouts.BYTE_ARRAY.getBytes(bytes).get(index);
        }
    }

    @CoreMethod(names={"prepend"}, required=1)
    public static abstract class PrependNode
    extends CoreMethodArrayArgumentsNode {
        public PrependNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject prepend(DynamicObject bytes, DynamicObject string) {
            int prependLength = StringOperations.getByteList(string).getUnsafeBytes().length;
            int originalLength = Layouts.BYTE_ARRAY.getBytes(bytes).getUnsafeBytes().length;
            int newLength = prependLength + originalLength;
            byte[] prependedBytes = new byte[newLength];
            System.arraycopy(StringOperations.getByteList(string).getUnsafeBytes(), 0, prependedBytes, 0, prependLength);
            System.arraycopy(Layouts.BYTE_ARRAY.getBytes(bytes).getUnsafeBytes(), 0, prependedBytes, prependLength, originalLength);
            return ByteArrayNodes.createByteArray(this.getContext().getCoreLibrary().getByteArrayClass(), new ByteList(prependedBytes));
        }
    }

    @CoreMethod(names={"get_byte"}, required=1, lowerFixnumParameters={0})
    public static abstract class GetByteNode
    extends CoreMethodArrayArgumentsNode {
        public GetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int getByte(DynamicObject bytes, int index) {
            return Layouts.BYTE_ARRAY.getBytes(bytes).get(index) & 0xFF;
        }
    }
}

