/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.StringCachingGuards;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.ByteList;

@GeneratedBy(value=ArrayNodes.class)
public final class ArrayNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AllocateNodeFactory.getInstance(), AddNodeFactory.getInstance(), MulNodeFactory.getInstance(), IndexNodeFactory.getInstance(), IndexSetNodeFactory.getInstance(), AtNodeFactory.getInstance(), ClearNodeFactory.getInstance(), CompactNodeFactory.getInstance(), CompactBangNodeFactory.getInstance(), ConcatNodeFactory.getInstance(), DeleteNodeFactory.getInstance(), DeleteAtNodeFactory.getInstance(), EachNodeFactory.getInstance(), EachWithIndexNodeFactory.getInstance(), IncludeNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), InjectNodeFactory.getInstance(), InsertNodeFactory.getInstance(), MapNodeFactory.getInstance(), MapInPlaceNodeFactory.getInstance(), MaxNodeFactory.getInstance(), MaxBlockNodeFactory.getInstance(), MinNodeFactory.getInstance(), MinBlockNodeFactory.getInstance(), PackNodeFactory.getInstance(), PopNodeFactory.getInstance(), LeftShiftNodeFactory.getInstance(), PushNodeFactory.getInstance(), PushOneNodeFactory.getInstance(), RejectNodeFactory.getInstance(), DeleteIfNodeFactory.getInstance(), RejectInPlaceNodeFactory.getInstance(), ReplaceNodeFactory.getInstance(), SelectNodeFactory.getInstance(), ShiftNodeFactory.getInstance(), SizeNodeFactory.getInstance(), SortNodeFactory.getInstance(), UnshiftNodeFactory.getInstance(), ZipNodeFactory.getInstance());
    }

    @GeneratedBy(value=ArrayNodes.ZipNode.class)
    public static final class ZipNodeFactory
    extends NodeFactoryBase<ArrayNodes.ZipNode> {
        private static ZipNodeFactory zipNodeFactoryInstance;

        private ZipNodeFactory() {
            super(ArrayNodes.ZipNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.ZipNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ZipNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.ZipNode> getInstance() {
            if (zipNodeFactoryInstance == null) {
                zipNodeFactoryInstance = new ZipNodeFactory();
            }
            return zipNodeFactoryInstance;
        }

        public static ArrayNodes.ZipNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ZipNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.ZipNode.class)
        public static final class ZipNodeGen
        extends ArrayNodes.ZipNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @Node.Child
            private BaseNode_ specialization_;

            private ZipNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="zipBlock(VirtualFrame, DynamicObject, DynamicObject, Object[], DynamicObject)", value=ArrayNodes.ZipNode.class)
            private static final class ZipBlockNode_
            extends BaseNode_ {
                ZipBlockNode_(ZipNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[] && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        return this.root.zipBlock(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(ZipNodeGen root) {
                    return new ZipBlockNode_(root);
                }
            }

            @GeneratedBy(methodName="zipObjectObjectNotArray(VirtualFrame, DynamicObject, DynamicObject, Object[], NotProvided)", value=ArrayNodes.ZipNode.class)
            private static final class ZipObjectObjectNotArrayNode_
            extends BaseNode_ {
                ZipObjectObjectNotArrayNode_(ZipNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[] && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (!RubyGuards.isRubyArray(arguments1Value_)) {
                            return this.root.zipObjectObjectNotArray(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(ZipNodeGen root) {
                    return new ZipObjectObjectNotArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="zipObjectObjectNotSingleObject(VirtualFrame, DynamicObject, DynamicObject, Object[], NotProvided)", value=ArrayNodes.ZipNode.class)
            private static final class ZipObjectObjectNotSingleObjectNode_
            extends BaseNode_ {
                ZipObjectObjectNotSingleObjectNode_(ZipNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[] && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubyArray(arguments1Value_) && ArrayNodes.ZipNode.fallback(arguments0Value_, arguments1Value_, arguments2Value_)) {
                            return this.root.zipObjectObjectNotSingleObject(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(ZipNodeGen root) {
                    return new ZipObjectObjectNotSingleObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="zipObjectObject(DynamicObject, DynamicObject, Object[], NotProvided)", value=ArrayNodes.ZipNode.class)
            private static final class ZipObjectObjectNode_
            extends BaseNode_ {
                ZipObjectObjectNode_(ZipNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[] && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyArray(arguments1Value_) && ArrayGuards.isObjectArray(arguments1Value_) && arguments2Value_.length == 0) {
                            return this.root.zipObjectObject(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(ZipNodeGen root) {
                    return new ZipObjectObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="zipObjectIntegerFixnum(DynamicObject, DynamicObject, Object[], NotProvided)", value=ArrayNodes.ZipNode.class)
            private static final class ZipObjectIntegerFixnumNode_
            extends BaseNode_ {
                ZipObjectIntegerFixnumNode_(ZipNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[] && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyArray(arguments1Value_) && ArrayGuards.isIntArray(arguments1Value_) && arguments2Value_.length == 0) {
                            return this.root.zipObjectIntegerFixnum(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(ZipNodeGen root) {
                    return new ZipObjectIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ZipNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ZipNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(ZipNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ZipNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ZipNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(ZipNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ZipNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ZipNodeGen root;

                BaseNode_(ZipNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (arguments3Value instanceof NotProvided) {
                            if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyArray(arguments1Value_) && ArrayGuards.isIntArray(arguments1Value_) && arguments2Value_.length == 0) {
                                return ZipObjectIntegerFixnumNode_.create(this.root);
                            }
                            if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyArray(arguments1Value_) && ArrayGuards.isObjectArray(arguments1Value_) && arguments2Value_.length == 0) {
                                return ZipObjectObjectNode_.create(this.root);
                            }
                            if (RubyGuards.isRubyArray(arguments1Value_) && ArrayNodes.ZipNode.fallback(arguments0Value_, arguments1Value_, arguments2Value_)) {
                                return ZipObjectObjectNotSingleObjectNode_.create(this.root);
                            }
                            if (!RubyGuards.isRubyArray(arguments1Value_)) {
                                return ZipObjectObjectNotArrayNode_.create(this.root);
                            }
                        }
                        if (arguments3Value instanceof DynamicObject) {
                            return ZipBlockNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.UnshiftNode.class)
    public static final class UnshiftNodeFactory
    extends NodeFactoryBase<ArrayNodes.UnshiftNode> {
        private static UnshiftNodeFactory unshiftNodeFactoryInstance;

        private UnshiftNodeFactory() {
            super(ArrayNodes.UnshiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.UnshiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UnshiftNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.UnshiftNode> getInstance() {
            if (unshiftNodeFactoryInstance == null) {
                unshiftNodeFactoryInstance = new UnshiftNodeFactory();
            }
            return unshiftNodeFactoryInstance;
        }

        public static ArrayNodes.UnshiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new UnshiftNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.UnshiftNode.class)
        public static final class UnshiftNodeGen
        extends ArrayNodes.UnshiftNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private UnshiftNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.unshift(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.SortNode.class)
    public static final class SortNodeFactory
    extends NodeFactoryBase<ArrayNodes.SortNode> {
        private static SortNodeFactory sortNodeFactoryInstance;

        private SortNodeFactory() {
            super(ArrayNodes.SortNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.SortNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SortNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.SortNode> getInstance() {
            if (sortNodeFactoryInstance == null) {
                sortNodeFactoryInstance = new SortNodeFactory();
            }
            return sortNodeFactoryInstance;
        }

        public static ArrayNodes.SortNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SortNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        public static final class SortNodeGen
        extends ArrayNodes.SortNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private SortNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="sortUsingRubinius(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.SortNode.class)
            private static final class SortUsingRubinius1Node_
            extends BaseNode_ {
                SortUsingRubinius1Node_(SortNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (!ArrayGuards.isNullArray(arguments0Value_) && !this.root.isSmall(arguments0Value_)) {
                            return this.root.sortUsingRubinius(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SortNodeGen root) {
                    return new SortUsingRubinius1Node_(root);
                }
            }

            @GeneratedBy(methodName="sortUsingRubinius(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.SortNode.class)
            private static final class SortUsingRubinius0Node_
            extends BaseNode_ {
                SortUsingRubinius0Node_(SortNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (!ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.sortUsingRubinius(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SortNodeGen root) {
                    return new SortUsingRubinius0Node_(root);
                }
            }

            @GeneratedBy(methodName="sortVeryShortObject(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.SortNode.class)
            private static final class SortVeryShortObjectNode_
            extends BaseNode_ {
                SortVeryShortObjectNode_(SortNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_) && this.root.isSmall(arguments0Value_)) {
                            return this.root.sortVeryShortObject(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SortNodeGen root) {
                    return new SortVeryShortObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="sortVeryShortLongFixnum(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.SortNode.class)
            private static final class SortVeryShortLongFixnumNode_
            extends BaseNode_ {
                SortVeryShortLongFixnumNode_(SortNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value_) && this.root.isSmall(arguments0Value_)) {
                            return this.root.sortVeryShortLongFixnum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SortNodeGen root) {
                    return new SortVeryShortLongFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="sortVeryShortIntegerFixnum(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.SortNode.class)
            private static final class SortVeryShortIntegerFixnumNode_
            extends BaseNode_ {
                SortVeryShortIntegerFixnumNode_(SortNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && this.root.isSmall(arguments0Value_)) {
                            return this.root.sortVeryShortIntegerFixnum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SortNodeGen root) {
                    return new SortVeryShortIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="sortNull(DynamicObject, Object)", value=ArrayNodes.SortNode.class)
            private static final class SortNullNode_
            extends BaseNode_ {
                SortNullNode_(SortNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isNullArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.sortNull(arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SortNodeGen root) {
                    return new SortNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.SortNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SortNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SortNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.SortNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SortNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SortNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.SortNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SortNodeGen root;

                BaseNode_(SortNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return SortNullNode_.create(this.root);
                        }
                        if (arguments1Value instanceof NotProvided) {
                            if (ArrayGuards.isIntArray(arguments0Value_) && this.root.isSmall(arguments0Value_)) {
                                return SortVeryShortIntegerFixnumNode_.create(this.root);
                            }
                            if (ArrayGuards.isLongArray(arguments0Value_) && this.root.isSmall(arguments0Value_)) {
                                return SortVeryShortLongFixnumNode_.create(this.root);
                            }
                            if (ArrayGuards.isObjectArray(arguments0Value_) && this.root.isSmall(arguments0Value_)) {
                                return SortVeryShortObjectNode_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                            if (!ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return SortUsingRubinius0Node_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof NotProvided && !ArrayGuards.isNullArray(arguments0Value_) && !this.root.isSmall(arguments0Value_)) {
                            return SortUsingRubinius1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<ArrayNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(ArrayNodes.SizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.SizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        public static ArrayNodes.SizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SizeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.SizeNode.class)
        public static final class SizeNodeGen
        extends ArrayNodes.SizeNode {
            @Node.Child
            private RubyNode arguments0_;

            private SizeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.size(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ShiftNode.class)
    public static final class ShiftNodeFactory
    extends NodeFactoryBase<ArrayNodes.ShiftNode> {
        private static ShiftNodeFactory shiftNodeFactoryInstance;

        private ShiftNodeFactory() {
            super(ArrayNodes.ShiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.ShiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ShiftNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.ShiftNode> getInstance() {
            if (shiftNodeFactoryInstance == null) {
                shiftNodeFactoryInstance = new ShiftNodeFactory();
            }
            return shiftNodeFactoryInstance;
        }

        public static ArrayNodes.ShiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ShiftNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        public static final class ShiftNodeGen
        extends ArrayNodes.ShiftNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeShiftIntegerFixnumInBounds_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeShiftLongFixnumInBounds_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeShiftFloatInBounds_;
            @CompilerDirectives.CompilationFinal
            private boolean excludePopIntegerFixnumInBoundsWithNum_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeShiftLongFixnumInBoundsWithNum_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeShiftFloatInBoundsWithNum_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeShiftIntegerFixnumInBoundsWithNumObj_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeShiftLongFixnumInBoundsWithNumObj_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeShiftFloatInBoundsWithNumObj_;
            @Node.Child
            private BaseNode_ specialization_;

            private ShiftNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                return this.specialization_.execute1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static DynamicObject expectDynamicObject(Object value) throws UnexpectedResultException {
                if (value instanceof DynamicObject) {
                    return (DynamicObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="shiftObjectWithNumObj(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftObjectWithNumObjNode_
            extends BaseNode_ {
                ShiftObjectWithNumObjNode_(ShiftNodeGen root) {
                    super(root, 23);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (ArrayGuards.isObjectArray(arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        return this.root.shiftObjectWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isObjectArray(arguments0Value_ = (DynamicObject)arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        return this.root.shiftObjectWithNumObj(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftObjectWithNumObjNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftFloatWithNumObj(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftFloatWithNumObjNode_
            extends BaseNode_ {
                ShiftFloatWithNumObjNode_(ShiftNodeGen root) {
                    super(root, 22);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (ArrayGuards.isDoubleArray(arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        return this.root.shiftFloatWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isDoubleArray(arguments0Value_ = (DynamicObject)arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        return this.root.shiftFloatWithNumObj(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftFloatWithNumObjNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftFloatInBoundsWithNumObj(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftFloatInBoundsWithNumObjNode_
            extends BaseNode_ {
                ShiftFloatInBoundsWithNumObjNode_(ShiftNodeGen root) {
                    super(root, 21);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == ShiftFloatWithNumObjNode_.class) {
                        this.removeSame("Contained by shiftFloatWithNumObj(VirtualFrame, DynamicObject, Object)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (ArrayGuards.isDoubleArray(arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        try {
                            return this.root.shiftFloatInBoundsWithNumObj(frameValue, arguments0Value, arguments1Value);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeShiftFloatInBoundsWithNumObj_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value, arguments1Value);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isDoubleArray(arguments0Value_ = (DynamicObject)arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        try {
                            return this.root.shiftFloatInBoundsWithNumObj(frameValue, arguments0Value_, arguments1Value);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeShiftFloatInBoundsWithNumObj_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftFloatInBoundsWithNumObjNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftLongFixnumWithNumObj(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftLongFixnumWithNumObjNode_
            extends BaseNode_ {
                ShiftLongFixnumWithNumObjNode_(ShiftNodeGen root) {
                    super(root, 20);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (ArrayGuards.isLongArray(arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        return this.root.shiftLongFixnumWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isLongArray(arguments0Value_ = (DynamicObject)arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        return this.root.shiftLongFixnumWithNumObj(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftLongFixnumWithNumObjNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftLongFixnumInBoundsWithNumObj(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftLongFixnumInBoundsWithNumObjNode_
            extends BaseNode_ {
                ShiftLongFixnumInBoundsWithNumObjNode_(ShiftNodeGen root) {
                    super(root, 19);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == ShiftLongFixnumWithNumObjNode_.class) {
                        this.removeSame("Contained by shiftLongFixnumWithNumObj(VirtualFrame, DynamicObject, Object)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (ArrayGuards.isLongArray(arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        try {
                            return this.root.shiftLongFixnumInBoundsWithNumObj(frameValue, arguments0Value, arguments1Value);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeShiftLongFixnumInBoundsWithNumObj_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value, arguments1Value);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isLongArray(arguments0Value_ = (DynamicObject)arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        try {
                            return this.root.shiftLongFixnumInBoundsWithNumObj(frameValue, arguments0Value_, arguments1Value);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeShiftLongFixnumInBoundsWithNumObj_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftLongFixnumInBoundsWithNumObjNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftIntegerFixnumWithNumObj(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftIntegerFixnumWithNumObjNode_
            extends BaseNode_ {
                ShiftIntegerFixnumWithNumObjNode_(ShiftNodeGen root) {
                    super(root, 18);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (ArrayGuards.isIntArray(arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        return this.root.shiftIntegerFixnumWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isIntArray(arguments0Value_ = (DynamicObject)arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        return this.root.shiftIntegerFixnumWithNumObj(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftIntegerFixnumWithNumObjNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftIntegerFixnumInBoundsWithNumObj(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftIntegerFixnumInBoundsWithNumObjNode_
            extends BaseNode_ {
                ShiftIntegerFixnumInBoundsWithNumObjNode_(ShiftNodeGen root) {
                    super(root, 17);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == ShiftIntegerFixnumWithNumObjNode_.class) {
                        this.removeSame("Contained by shiftIntegerFixnumWithNumObj(VirtualFrame, DynamicObject, Object)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (ArrayGuards.isIntArray(arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        try {
                            return this.root.shiftIntegerFixnumInBoundsWithNumObj(frameValue, arguments0Value, arguments1Value);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeShiftIntegerFixnumInBoundsWithNumObj_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value, arguments1Value);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isIntArray(arguments0Value_ = (DynamicObject)arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        try {
                            return this.root.shiftIntegerFixnumInBoundsWithNumObj(frameValue, arguments0Value_, arguments1Value);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeShiftIntegerFixnumInBoundsWithNumObj_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftIntegerFixnumInBoundsWithNumObjNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftObjectWithNum(VirtualFrame, DynamicObject, int)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftObjectWithNumNode_
            extends BaseNode_ {
                ShiftObjectWithNumNode_(ShiftNodeGen root) {
                    super(root, 16);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (ArrayGuards.isObjectArray(arguments0Value_)) {
                        return this.root.shiftObjectWithNum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isObjectArray(arguments0Value)) {
                            return this.root.shiftObjectWithNum(frameValue, arguments0Value, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_)) {
                            return this.root.shiftObjectWithNum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftObjectWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftFloatWithNum(VirtualFrame, DynamicObject, int)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftFloatWithNumNode_
            extends BaseNode_ {
                ShiftFloatWithNumNode_(ShiftNodeGen root) {
                    super(root, 15);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                        return this.root.shiftFloatWithNum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value)) {
                            return this.root.shiftFloatWithNum(frameValue, arguments0Value, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                            return this.root.shiftFloatWithNum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftFloatWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftFloatInBoundsWithNum(VirtualFrame, DynamicObject, int)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftFloatInBoundsWithNumNode_
            extends BaseNode_ {
                ShiftFloatInBoundsWithNumNode_(ShiftNodeGen root) {
                    super(root, 14);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == ShiftFloatWithNumNode_.class) {
                        this.removeSame("Contained by shiftFloatWithNum(VirtualFrame, DynamicObject, int)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return ShiftNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ShiftNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                        try {
                            return this.root.shiftFloatInBoundsWithNum(frameValue, arguments0Value_, arguments1Value_);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeShiftFloatInBoundsWithNum_ = true;
                            return ShiftNodeGen.expectDynamicObject(this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_));
                        }
                    }
                    return ShiftNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value)) {
                            try {
                                return this.root.shiftFloatInBoundsWithNum(frameValue, arguments0Value, arguments1Value_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludeShiftFloatInBoundsWithNum_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value, arguments1Value_);
                            }
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                            try {
                                return this.root.shiftFloatInBoundsWithNum(frameValue, arguments0Value_, arguments1Value_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludeShiftFloatInBoundsWithNum_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_);
                            }
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftFloatInBoundsWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftLongFixnumWithNum(VirtualFrame, DynamicObject, int)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftLongFixnumWithNumNode_
            extends BaseNode_ {
                ShiftLongFixnumWithNumNode_(ShiftNodeGen root) {
                    super(root, 13);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (ArrayGuards.isLongArray(arguments0Value_)) {
                        return this.root.shiftLongFixnumWithNum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value)) {
                            return this.root.shiftLongFixnumWithNum(frameValue, arguments0Value, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value_)) {
                            return this.root.shiftLongFixnumWithNum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftLongFixnumWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftLongFixnumInBoundsWithNum(VirtualFrame, DynamicObject, int)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftLongFixnumInBoundsWithNumNode_
            extends BaseNode_ {
                ShiftLongFixnumInBoundsWithNumNode_(ShiftNodeGen root) {
                    super(root, 12);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == ShiftLongFixnumWithNumNode_.class) {
                        this.removeSame("Contained by shiftLongFixnumWithNum(VirtualFrame, DynamicObject, int)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return ShiftNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ShiftNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (ArrayGuards.isLongArray(arguments0Value_)) {
                        try {
                            return this.root.shiftLongFixnumInBoundsWithNum(frameValue, arguments0Value_, arguments1Value_);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeShiftLongFixnumInBoundsWithNum_ = true;
                            return ShiftNodeGen.expectDynamicObject(this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_));
                        }
                    }
                    return ShiftNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value)) {
                            try {
                                return this.root.shiftLongFixnumInBoundsWithNum(frameValue, arguments0Value, arguments1Value_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludeShiftLongFixnumInBoundsWithNum_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value, arguments1Value_);
                            }
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value_)) {
                            try {
                                return this.root.shiftLongFixnumInBoundsWithNum(frameValue, arguments0Value_, arguments1Value_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludeShiftLongFixnumInBoundsWithNum_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_);
                            }
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftLongFixnumInBoundsWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="popIntegerFixnumWithNum(VirtualFrame, DynamicObject, int)", value=ArrayNodes.ShiftNode.class)
            private static final class PopIntegerFixnumWithNumNode_
            extends BaseNode_ {
                PopIntegerFixnumWithNumNode_(ShiftNodeGen root) {
                    super(root, 11);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (ArrayGuards.isIntArray(arguments0Value_)) {
                        return this.root.popIntegerFixnumWithNum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value)) {
                            return this.root.popIntegerFixnumWithNum(frameValue, arguments0Value, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_)) {
                            return this.root.popIntegerFixnumWithNum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new PopIntegerFixnumWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="popIntegerFixnumInBoundsWithNum(VirtualFrame, DynamicObject, int)", value=ArrayNodes.ShiftNode.class)
            private static final class PopIntegerFixnumInBoundsWithNumNode_
            extends BaseNode_ {
                PopIntegerFixnumInBoundsWithNumNode_(ShiftNodeGen root) {
                    super(root, 10);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == PopIntegerFixnumWithNumNode_.class) {
                        this.removeSame("Contained by popIntegerFixnumWithNum(VirtualFrame, DynamicObject, int)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return ShiftNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ShiftNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (ArrayGuards.isIntArray(arguments0Value_)) {
                        try {
                            return this.root.popIntegerFixnumInBoundsWithNum(frameValue, arguments0Value_, arguments1Value_);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludePopIntegerFixnumInBoundsWithNum_ = true;
                            return ShiftNodeGen.expectDynamicObject(this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_));
                        }
                    }
                    return ShiftNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value)) {
                            try {
                                return this.root.popIntegerFixnumInBoundsWithNum(frameValue, arguments0Value, arguments1Value_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludePopIntegerFixnumInBoundsWithNum_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value, arguments1Value_);
                            }
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_)) {
                            try {
                                return this.root.popIntegerFixnumInBoundsWithNum(frameValue, arguments0Value_, arguments1Value_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludePopIntegerFixnumInBoundsWithNum_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_);
                            }
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new PopIntegerFixnumInBoundsWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftNilWithNum(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftNilWithNumNode_
            extends BaseNode_ {
                ShiftNilWithNumNode_(ShiftNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (ArrayGuards.isEmptyArray(arguments0Value) && RubyGuards.wasProvided(arguments1Value)) {
                        return this.root.shiftNilWithNum(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isEmptyArray(arguments0Value_ = (DynamicObject)arguments0Value) && RubyGuards.wasProvided(arguments1Value)) {
                        return this.root.shiftNilWithNum(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftNilWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftObject(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftObjectNode_
            extends BaseNode_ {
                ShiftObjectNode_(ShiftNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof NotProvided) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isObjectArray(arguments0Value)) {
                            return this.root.shiftObject(frameValue, arguments0Value, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_)) {
                            return this.root.shiftObject(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftFloat(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftFloatNode_
            extends BaseNode_ {
                ShiftFloatNode_(ShiftNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof NotProvided) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value)) {
                            return this.root.shiftFloat(frameValue, arguments0Value, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                            return this.root.shiftFloat(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftFloatNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftFloatInBounds(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftFloatInBoundsNode_
            extends BaseNode_ {
                ShiftFloatInBoundsNode_(ShiftNodeGen root) {
                    super(root, 6);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == ShiftFloatNode_.class) {
                        this.removeSame("Contained by shiftFloat(VirtualFrame, DynamicObject, NotProvided)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return ShiftNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ShiftNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                        try {
                            return this.root.shiftFloatInBounds(frameValue, arguments0Value_, arguments1Value_);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeShiftFloatInBounds_ = true;
                            return ShiftNodeGen.expectDouble(this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_));
                        }
                    }
                    return ShiftNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof NotProvided) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value)) {
                            try {
                                return this.root.shiftFloatInBounds(frameValue, arguments0Value, arguments1Value_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludeShiftFloatInBounds_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value, arguments1Value_);
                            }
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                            try {
                                return this.root.shiftFloatInBounds(frameValue, arguments0Value_, arguments1Value_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludeShiftFloatInBounds_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_);
                            }
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftFloatInBoundsNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftLongFixnum(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftLongFixnumNode_
            extends BaseNode_ {
                ShiftLongFixnumNode_(ShiftNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof NotProvided) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value)) {
                            return this.root.shiftLongFixnum(frameValue, arguments0Value, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value_)) {
                            return this.root.shiftLongFixnum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftLongFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftLongFixnumInBounds(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftLongFixnumInBoundsNode_
            extends BaseNode_ {
                ShiftLongFixnumInBoundsNode_(ShiftNodeGen root) {
                    super(root, 4);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == ShiftLongFixnumNode_.class) {
                        this.removeSame("Contained by shiftLongFixnum(VirtualFrame, DynamicObject, NotProvided)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return ShiftNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ShiftNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (ArrayGuards.isLongArray(arguments0Value_)) {
                        try {
                            return this.root.shiftLongFixnumInBounds(frameValue, arguments0Value_, arguments1Value_);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeShiftLongFixnumInBounds_ = true;
                            return ShiftNodeGen.expectLong(this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_));
                        }
                    }
                    return ShiftNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof NotProvided) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value)) {
                            try {
                                return this.root.shiftLongFixnumInBounds(frameValue, arguments0Value, arguments1Value_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludeShiftLongFixnumInBounds_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value, arguments1Value_);
                            }
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value_)) {
                            try {
                                return this.root.shiftLongFixnumInBounds(frameValue, arguments0Value_, arguments1Value_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludeShiftLongFixnumInBounds_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_);
                            }
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftLongFixnumInBoundsNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftIntegerFixnum(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftIntegerFixnumNode_
            extends BaseNode_ {
                ShiftIntegerFixnumNode_(ShiftNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof NotProvided) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value)) {
                            return this.root.shiftIntegerFixnum(frameValue, arguments0Value, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_)) {
                            return this.root.shiftIntegerFixnum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftIntegerFixnumInBounds(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftIntegerFixnumInBoundsNode_
            extends BaseNode_ {
                ShiftIntegerFixnumInBoundsNode_(ShiftNodeGen root) {
                    super(root, 2);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == ShiftIntegerFixnumNode_.class) {
                        this.removeSame("Contained by shiftIntegerFixnum(VirtualFrame, DynamicObject, NotProvided)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return ShiftNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ShiftNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (ArrayGuards.isIntArray(arguments0Value_)) {
                        try {
                            return this.root.shiftIntegerFixnumInBounds(frameValue, arguments0Value_, arguments1Value_);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeShiftIntegerFixnumInBounds_ = true;
                            return ShiftNodeGen.expectInteger(this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_));
                        }
                    }
                    return ShiftNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof NotProvided) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value)) {
                            try {
                                return this.root.shiftIntegerFixnumInBounds(frameValue, arguments0Value, arguments1Value_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludeShiftIntegerFixnumInBounds_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value, arguments1Value_);
                            }
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_)) {
                            try {
                                return this.root.shiftIntegerFixnumInBounds(frameValue, arguments0Value_, arguments1Value_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludeShiftIntegerFixnumInBounds_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_);
                            }
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftIntegerFixnumInBoundsNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftNil(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftNilNode_
            extends BaseNode_ {
                ShiftNilNode_(ShiftNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof NotProvided) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isEmptyArray(arguments0Value)) {
                            return this.root.shiftNil(frameValue, arguments0Value, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (ArrayGuards.isEmptyArray(arguments0Value_)) {
                            return this.root.shiftNil(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftNilNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ShiftNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ShiftNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ShiftNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ShiftNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ShiftNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ShiftNodeGen root;

                BaseNode_(ShiftNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    return this.execute_(frameValue, arguments0Value, arguments1Value);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ShiftNodeGen.expectDynamicObject(this.execute0(frameValue));
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ShiftNodeGen.expectDouble(this.execute0(frameValue));
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ShiftNodeGen.expectInteger(this.execute0(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ShiftNodeGen.expectLong(this.execute0(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments1Value instanceof NotProvided) {
                            if (ArrayGuards.isEmptyArray(arguments0Value_)) {
                                return ShiftNilNode_.create(this.root);
                            }
                            if (ArrayGuards.isIntArray(arguments0Value_) && !this.root.excludeShiftIntegerFixnumInBounds_) {
                                return ShiftIntegerFixnumInBoundsNode_.create(this.root);
                            }
                            if (ArrayGuards.isIntArray(arguments0Value_)) {
                                this.root.excludeShiftIntegerFixnumInBounds_ = true;
                                return ShiftIntegerFixnumNode_.create(this.root);
                            }
                            if (ArrayGuards.isLongArray(arguments0Value_) && !this.root.excludeShiftLongFixnumInBounds_) {
                                return ShiftLongFixnumInBoundsNode_.create(this.root);
                            }
                            if (ArrayGuards.isLongArray(arguments0Value_)) {
                                this.root.excludeShiftLongFixnumInBounds_ = true;
                                return ShiftLongFixnumNode_.create(this.root);
                            }
                            if (ArrayGuards.isDoubleArray(arguments0Value_) && !this.root.excludeShiftFloatInBounds_) {
                                return ShiftFloatInBoundsNode_.create(this.root);
                            }
                            if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                                this.root.excludeShiftFloatInBounds_ = true;
                                return ShiftFloatNode_.create(this.root);
                            }
                            if (ArrayGuards.isObjectArray(arguments0Value_)) {
                                return ShiftObjectNode_.create(this.root);
                            }
                        }
                        if (ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return ShiftNilWithNumNode_.create(this.root);
                        }
                        if (arguments1Value instanceof Integer) {
                            if (ArrayGuards.isIntArray(arguments0Value_) && !this.root.excludePopIntegerFixnumInBoundsWithNum_) {
                                return PopIntegerFixnumInBoundsWithNumNode_.create(this.root);
                            }
                            if (ArrayGuards.isIntArray(arguments0Value_)) {
                                this.root.excludePopIntegerFixnumInBoundsWithNum_ = true;
                                return PopIntegerFixnumWithNumNode_.create(this.root);
                            }
                            if (ArrayGuards.isLongArray(arguments0Value_) && !this.root.excludeShiftLongFixnumInBoundsWithNum_) {
                                return ShiftLongFixnumInBoundsWithNumNode_.create(this.root);
                            }
                            if (ArrayGuards.isLongArray(arguments0Value_)) {
                                this.root.excludeShiftLongFixnumInBoundsWithNum_ = true;
                                return ShiftLongFixnumWithNumNode_.create(this.root);
                            }
                            if (ArrayGuards.isDoubleArray(arguments0Value_) && !this.root.excludeShiftFloatInBoundsWithNum_) {
                                return ShiftFloatInBoundsWithNumNode_.create(this.root);
                            }
                            if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                                this.root.excludeShiftFloatInBoundsWithNum_ = true;
                                return ShiftFloatWithNumNode_.create(this.root);
                            }
                            if (ArrayGuards.isObjectArray(arguments0Value_)) {
                                return ShiftObjectWithNumNode_.create(this.root);
                            }
                        }
                        if (ArrayGuards.isIntArray(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value) && !this.root.excludeShiftIntegerFixnumInBoundsWithNumObj_) {
                            return ShiftIntegerFixnumInBoundsWithNumObjNode_.create(this.root);
                        }
                        if (ArrayGuards.isIntArray(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            this.root.excludeShiftIntegerFixnumInBoundsWithNumObj_ = true;
                            return ShiftIntegerFixnumWithNumObjNode_.create(this.root);
                        }
                        if (ArrayGuards.isLongArray(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value) && !this.root.excludeShiftLongFixnumInBoundsWithNumObj_) {
                            return ShiftLongFixnumInBoundsWithNumObjNode_.create(this.root);
                        }
                        if (ArrayGuards.isLongArray(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            this.root.excludeShiftLongFixnumInBoundsWithNumObj_ = true;
                            return ShiftLongFixnumWithNumObjNode_.create(this.root);
                        }
                        if (ArrayGuards.isDoubleArray(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value) && !this.root.excludeShiftFloatInBoundsWithNumObj_) {
                            return ShiftFloatInBoundsWithNumObjNode_.create(this.root);
                        }
                        if (ArrayGuards.isDoubleArray(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            this.root.excludeShiftFloatInBoundsWithNumObj_ = true;
                            return ShiftFloatWithNumObjNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            return ShiftObjectWithNumObjNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.SelectNode.class)
    public static final class SelectNodeFactory
    extends NodeFactoryBase<ArrayNodes.SelectNode> {
        private static SelectNodeFactory selectNodeFactoryInstance;

        private SelectNodeFactory() {
            super(ArrayNodes.SelectNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.SelectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SelectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.SelectNode> getInstance() {
            if (selectNodeFactoryInstance == null) {
                selectNodeFactoryInstance = new SelectNodeFactory();
            }
            return selectNodeFactoryInstance;
        }

        public static ArrayNodes.SelectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SelectNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.SelectNode.class)
        public static final class SelectNodeGen
        extends ArrayNodes.SelectNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private SelectNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="selectFixnumInteger(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.SelectNode.class)
            private static final class SelectFixnumIntegerNode_
            extends BaseNode_ {
                SelectFixnumIntegerNode_(SelectNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.selectFixnumInteger(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SelectNodeGen root) {
                    return new SelectFixnumIntegerNode_(root);
                }
            }

            @GeneratedBy(methodName="selectObject(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.SelectNode.class)
            private static final class SelectObjectNode_
            extends BaseNode_ {
                SelectObjectNode_(SelectNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.selectObject(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SelectNodeGen root) {
                    return new SelectObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="selectNull(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.SelectNode.class)
            private static final class SelectNullNode_
            extends BaseNode_ {
                SelectNullNode_(SelectNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.selectNull(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SelectNodeGen root) {
                    return new SelectNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.SelectNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SelectNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SelectNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.SelectNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SelectNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SelectNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.SelectNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SelectNodeGen root;

                BaseNode_(SelectNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return SelectNullNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return SelectObjectNode_.create(this.root);
                        }
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return SelectFixnumIntegerNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
    public static final class ReplaceNodeFactory
    extends NodeFactoryBase<ArrayNodes.ReplaceNode> {
        private static ReplaceNodeFactory replaceNodeFactoryInstance;

        private ReplaceNodeFactory() {
            super(ArrayNodes.ReplaceNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.ReplaceNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ReplaceNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.ReplaceNode> getInstance() {
            if (replaceNodeFactoryInstance == null) {
                replaceNodeFactoryInstance = new ReplaceNodeFactory();
            }
            return replaceNodeFactoryInstance;
        }

        public static ArrayNodes.ReplaceNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode other) {
            return new ReplaceNodeGen(context, sourceSection, array, other);
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        public static final class ReplaceNodeGen
        extends ArrayNodes.ReplaceNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode array_;
            @Node.Child
            private RubyNode other_;
            @Node.Child
            private BaseNode_ specialization_;

            private ReplaceNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode other) {
                super(context, sourceSection);
                this.array_ = array;
                this.other_ = this.coerceOtherToAry(other);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="replaceObject(DynamicObject, DynamicObject)", value=ArrayNodes.ReplaceNode.class)
            private static final class ReplaceObjectNode_
            extends BaseNode_ {
                ReplaceObjectNode_(ReplaceNodeGen root) {
                    super(root, 5);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                    if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyArray(otherValue_) && ArrayGuards.isObjectArray(otherValue_)) {
                            return this.root.replaceObject(arrayValue_, otherValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arrayValue, otherValue);
                }

                static BaseNode_ create(ReplaceNodeGen root) {
                    return new ReplaceObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="replaceFloat(DynamicObject, DynamicObject)", value=ArrayNodes.ReplaceNode.class)
            private static final class ReplaceFloatNode_
            extends BaseNode_ {
                ReplaceFloatNode_(ReplaceNodeGen root) {
                    super(root, 4);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                    if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyArray(otherValue_) && ArrayGuards.isDoubleArray(otherValue_)) {
                            return this.root.replaceFloat(arrayValue_, otherValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arrayValue, otherValue);
                }

                static BaseNode_ create(ReplaceNodeGen root) {
                    return new ReplaceFloatNode_(root);
                }
            }

            @GeneratedBy(methodName="replaceLongFixnum(DynamicObject, DynamicObject)", value=ArrayNodes.ReplaceNode.class)
            private static final class ReplaceLongFixnumNode_
            extends BaseNode_ {
                ReplaceLongFixnumNode_(ReplaceNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                    if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyArray(otherValue_) && ArrayGuards.isLongArray(otherValue_)) {
                            return this.root.replaceLongFixnum(arrayValue_, otherValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arrayValue, otherValue);
                }

                static BaseNode_ create(ReplaceNodeGen root) {
                    return new ReplaceLongFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="replaceIntegerFixnum(DynamicObject, DynamicObject)", value=ArrayNodes.ReplaceNode.class)
            private static final class ReplaceIntegerFixnumNode_
            extends BaseNode_ {
                ReplaceIntegerFixnumNode_(ReplaceNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                    if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyArray(otherValue_) && ArrayGuards.isIntArray(otherValue_)) {
                            return this.root.replaceIntegerFixnum(arrayValue_, otherValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arrayValue, otherValue);
                }

                static BaseNode_ create(ReplaceNodeGen root) {
                    return new ReplaceIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="replace(DynamicObject, DynamicObject)", value=ArrayNodes.ReplaceNode.class)
            private static final class ReplaceNode_
            extends BaseNode_ {
                ReplaceNode_(ReplaceNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                    if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyArray(otherValue_) && ArrayGuards.isNullArray(otherValue_)) {
                            return this.root.replace(arrayValue_, otherValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arrayValue, otherValue);
                }

                static BaseNode_ create(ReplaceNodeGen root) {
                    return new ReplaceNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ReplaceNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object otherValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, otherValue));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                    return this.getNext().executeDynamicObject_(frameValue, arrayValue, otherValue);
                }

                static BaseNode_ create(ReplaceNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ReplaceNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arrayValue, otherValue);
                }

                static BaseNode_ create(ReplaceNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ReplaceNodeGen root;

                BaseNode_(ReplaceNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.array_, this.root.other_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object otherValue) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arrayValue, otherValue);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arrayValue_ = this.root.array_.execute(frameValue);
                    Object otherValue_ = this.root.other_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arrayValue_, otherValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object otherValue) {
                    if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyArray(otherValue_) && ArrayGuards.isNullArray(otherValue_)) {
                            return ReplaceNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyArray(otherValue_) && ArrayGuards.isIntArray(otherValue_)) {
                            return ReplaceIntegerFixnumNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyArray(otherValue_) && ArrayGuards.isLongArray(otherValue_)) {
                            return ReplaceLongFixnumNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyArray(otherValue_) && ArrayGuards.isDoubleArray(otherValue_)) {
                            return ReplaceFloatNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyArray(otherValue_) && ArrayGuards.isObjectArray(otherValue_)) {
                            return ReplaceObjectNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
    public static final class RejectInPlaceNodeFactory
    extends NodeFactoryBase<ArrayNodes.RejectInPlaceNode> {
        private static RejectInPlaceNodeFactory rejectInPlaceNodeFactoryInstance;

        private RejectInPlaceNodeFactory() {
            super(ArrayNodes.RejectInPlaceNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.RejectInPlaceNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RejectInPlaceNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.RejectInPlaceNode> getInstance() {
            if (rejectInPlaceNodeFactoryInstance == null) {
                rejectInPlaceNodeFactoryInstance = new RejectInPlaceNodeFactory();
            }
            return rejectInPlaceNodeFactoryInstance;
        }

        public static ArrayNodes.RejectInPlaceNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RejectInPlaceNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
        public static final class RejectInPlaceNodeGen
        extends ArrayNodes.RejectInPlaceNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private RejectInPlaceNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="rejectInPlaceObject(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.RejectInPlaceNode.class)
            private static final class RejectInPlaceObjectNode_
            extends BaseNode_ {
                RejectInPlaceObjectNode_(RejectInPlaceNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.rejectInPlaceObject(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectInPlaceNodeGen root) {
                    return new RejectInPlaceObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="rejectInPlaceDouble(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.RejectInPlaceNode.class)
            private static final class RejectInPlaceDoubleNode_
            extends BaseNode_ {
                RejectInPlaceDoubleNode_(RejectInPlaceNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.rejectInPlaceDouble(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectInPlaceNodeGen root) {
                    return new RejectInPlaceDoubleNode_(root);
                }
            }

            @GeneratedBy(methodName="rejectInPlaceLong(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.RejectInPlaceNode.class)
            private static final class RejectInPlaceLongNode_
            extends BaseNode_ {
                RejectInPlaceLongNode_(RejectInPlaceNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.rejectInPlaceLong(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectInPlaceNodeGen root) {
                    return new RejectInPlaceLongNode_(root);
                }
            }

            @GeneratedBy(methodName="rejectInPlaceInt(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.RejectInPlaceNode.class)
            private static final class RejectInPlaceIntNode_
            extends BaseNode_ {
                RejectInPlaceIntNode_(RejectInPlaceNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.rejectInPlaceInt(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectInPlaceNodeGen root) {
                    return new RejectInPlaceIntNode_(root);
                }
            }

            @GeneratedBy(methodName="rejectInPlaceNull(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.RejectInPlaceNode.class)
            private static final class RejectInPlaceNullNode_
            extends BaseNode_ {
                RejectInPlaceNullNode_(RejectInPlaceNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.rejectInPlaceNull(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectInPlaceNodeGen root) {
                    return new RejectInPlaceNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RejectInPlaceNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectInPlaceNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RejectInPlaceNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectInPlaceNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final RejectInPlaceNodeGen root;

                BaseNode_(RejectInPlaceNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return RejectInPlaceNullNode_.create(this.root);
                        }
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return RejectInPlaceIntNode_.create(this.root);
                        }
                        if (ArrayGuards.isLongArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return RejectInPlaceLongNode_.create(this.root);
                        }
                        if (ArrayGuards.isDoubleArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return RejectInPlaceDoubleNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return RejectInPlaceObjectNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
    public static final class DeleteIfNodeFactory
    extends NodeFactoryBase<ArrayNodes.DeleteIfNode> {
        private static DeleteIfNodeFactory deleteIfNodeFactoryInstance;

        private DeleteIfNodeFactory() {
            super(ArrayNodes.DeleteIfNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.DeleteIfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DeleteIfNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.DeleteIfNode> getInstance() {
            if (deleteIfNodeFactoryInstance == null) {
                deleteIfNodeFactoryInstance = new DeleteIfNodeFactory();
            }
            return deleteIfNodeFactoryInstance;
        }

        public static ArrayNodes.DeleteIfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DeleteIfNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
        public static final class DeleteIfNodeGen
        extends ArrayNodes.DeleteIfNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private DeleteIfNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="rejectInPlaceObject(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.DeleteIfNode.class)
            private static final class RejectInPlaceObjectNode_
            extends BaseNode_ {
                RejectInPlaceObjectNode_(DeleteIfNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.rejectInPlaceObject(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteIfNodeGen root) {
                    return new RejectInPlaceObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="rejectInPlaceDouble(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.DeleteIfNode.class)
            private static final class RejectInPlaceDoubleNode_
            extends BaseNode_ {
                RejectInPlaceDoubleNode_(DeleteIfNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.rejectInPlaceDouble(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteIfNodeGen root) {
                    return new RejectInPlaceDoubleNode_(root);
                }
            }

            @GeneratedBy(methodName="rejectInPlaceLong(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.DeleteIfNode.class)
            private static final class RejectInPlaceLongNode_
            extends BaseNode_ {
                RejectInPlaceLongNode_(DeleteIfNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.rejectInPlaceLong(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteIfNodeGen root) {
                    return new RejectInPlaceLongNode_(root);
                }
            }

            @GeneratedBy(methodName="rejectInPlaceInt(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.DeleteIfNode.class)
            private static final class RejectInPlaceIntNode_
            extends BaseNode_ {
                RejectInPlaceIntNode_(DeleteIfNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.rejectInPlaceInt(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteIfNodeGen root) {
                    return new RejectInPlaceIntNode_(root);
                }
            }

            @GeneratedBy(methodName="rejectInPlaceNull(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.DeleteIfNode.class)
            private static final class RejectInPlaceNullNode_
            extends BaseNode_ {
                RejectInPlaceNullNode_(DeleteIfNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.rejectInPlaceNull(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteIfNodeGen root) {
                    return new RejectInPlaceNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DeleteIfNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteIfNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DeleteIfNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteIfNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final DeleteIfNodeGen root;

                BaseNode_(DeleteIfNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return RejectInPlaceNullNode_.create(this.root);
                        }
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return RejectInPlaceIntNode_.create(this.root);
                        }
                        if (ArrayGuards.isLongArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return RejectInPlaceLongNode_.create(this.root);
                        }
                        if (ArrayGuards.isDoubleArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return RejectInPlaceDoubleNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return RejectInPlaceObjectNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.RejectNode.class)
    public static final class RejectNodeFactory
    extends NodeFactoryBase<ArrayNodes.RejectNode> {
        private static RejectNodeFactory rejectNodeFactoryInstance;

        private RejectNodeFactory() {
            super(ArrayNodes.RejectNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.RejectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RejectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.RejectNode> getInstance() {
            if (rejectNodeFactoryInstance == null) {
                rejectNodeFactoryInstance = new RejectNodeFactory();
            }
            return rejectNodeFactoryInstance;
        }

        public static ArrayNodes.RejectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RejectNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.RejectNode.class)
        public static final class RejectNodeGen
        extends ArrayNodes.RejectNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private RejectNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="selectFixnumInteger(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.RejectNode.class)
            private static final class SelectFixnumIntegerNode_
            extends BaseNode_ {
                SelectFixnumIntegerNode_(RejectNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.selectFixnumInteger(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectNodeGen root) {
                    return new SelectFixnumIntegerNode_(root);
                }
            }

            @GeneratedBy(methodName="selectObject(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.RejectNode.class)
            private static final class SelectObjectNode_
            extends BaseNode_ {
                SelectObjectNode_(RejectNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.selectObject(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectNodeGen root) {
                    return new SelectObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="selectNull(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.RejectNode.class)
            private static final class SelectNullNode_
            extends BaseNode_ {
                SelectNullNode_(RejectNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.selectNull(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectNodeGen root) {
                    return new SelectNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.RejectNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RejectNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.RejectNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RejectNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.RejectNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final RejectNodeGen root;

                BaseNode_(RejectNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return SelectNullNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return SelectObjectNode_.create(this.root);
                        }
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return SelectFixnumIntegerNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PushOneNode.class)
    public static final class PushOneNodeFactory
    extends NodeFactoryBase<ArrayNodes.PushOneNode> {
        private static PushOneNodeFactory pushOneNodeFactoryInstance;

        private PushOneNodeFactory() {
            super(ArrayNodes.PushOneNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.PushOneNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PushOneNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.PushOneNode> getInstance() {
            if (pushOneNodeFactoryInstance == null) {
                pushOneNodeFactoryInstance = new PushOneNodeFactory();
            }
            return pushOneNodeFactoryInstance;
        }

        public static ArrayNodes.PushOneNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PushOneNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.PushOneNode.class)
        public static final class PushOneNodeGen
        extends ArrayNodes.PushOneNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private PushOneNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="pushObjectObject(DynamicObject, Object)", value=ArrayNodes.PushOneNode.class)
            private static final class PushObjectObjectNode_
            extends BaseNode_ {
                PushObjectObjectNode_(PushOneNodeGen root) {
                    super(root, 4);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isObjectArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.pushObjectObject(arguments0Value_, arguments1Value);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PushOneNodeGen root) {
                    return new PushObjectObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="pushIntegerFixnumObject(DynamicObject, Object)", value=ArrayNodes.PushOneNode.class)
            private static final class PushIntegerFixnumObjectNode_
            extends BaseNode_ {
                PushIntegerFixnumObjectNode_(PushOneNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isIntArray(arguments0Value_ = (DynamicObject)arguments0Value) && !RubyGuards.isInteger(arguments1Value)) {
                        return this.root.pushIntegerFixnumObject(arguments0Value_, arguments1Value);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PushOneNodeGen root) {
                    return new PushIntegerFixnumObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="pushIntegerFixnumIntegerFixnum(DynamicObject, int)", value=ArrayNodes.PushOneNode.class)
            private static final class PushIntegerFixnumIntegerFixnumNode_
            extends BaseNode_ {
                PushIntegerFixnumIntegerFixnumNode_(PushOneNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (ArrayGuards.isIntArray(arguments0Value_)) {
                        return this.root.pushIntegerFixnumIntegerFixnum(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_)) {
                            return this.root.pushIntegerFixnumIntegerFixnum(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PushOneNodeGen root) {
                    return new PushIntegerFixnumIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="pushEmpty(DynamicObject, Object)", value=ArrayNodes.PushOneNode.class)
            private static final class PushEmptyNode_
            extends BaseNode_ {
                PushEmptyNode_(PushOneNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isNullArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.pushEmpty(arguments0Value_, arguments1Value);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PushOneNodeGen root) {
                    return new PushEmptyNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PushOneNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PushOneNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PushOneNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PushOneNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PushOneNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PushOneNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PushOneNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final PushOneNodeGen root;

                BaseNode_(PushOneNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return PushEmptyNode_.create(this.root);
                        }
                        if (arguments1Value instanceof Integer && ArrayGuards.isIntArray(arguments0Value_)) {
                            return PushIntegerFixnumIntegerFixnumNode_.create(this.root);
                        }
                        if (ArrayGuards.isIntArray(arguments0Value_) && !RubyGuards.isInteger(arguments1Value)) {
                            return PushIntegerFixnumObjectNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(arguments0Value_)) {
                            return PushObjectObjectNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PushNode.class)
    public static final class PushNodeFactory
    extends NodeFactoryBase<ArrayNodes.PushNode> {
        private static PushNodeFactory pushNodeFactoryInstance;

        private PushNodeFactory() {
            super(ArrayNodes.PushNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.PushNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PushNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.PushNode> getInstance() {
            if (pushNodeFactoryInstance == null) {
                pushNodeFactoryInstance = new PushNodeFactory();
            }
            return pushNodeFactoryInstance;
        }

        public static ArrayNodes.PushNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PushNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        public static final class PushNodeGen
        extends ArrayNodes.PushNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private PushNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="pushObject(VirtualFrame, DynamicObject, Object, Object[])", value=ArrayNodes.PushNode.class)
            private static final class PushObjectNode_
            extends BaseNode_ {
                PushObjectNode_(PushNodeGen root) {
                    super(root, 11);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_)) {
                            return this.root.pushObject(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PushObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="pushFloat(VirtualFrame, DynamicObject, Object, Object[])", value=ArrayNodes.PushNode.class)
            private static final class PushFloatNode_
            extends BaseNode_ {
                PushFloatNode_(PushNodeGen root) {
                    super(root, 10);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                            return this.root.pushFloat(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PushFloatNode_(root);
                }
            }

            @GeneratedBy(methodName="pushLongFixnumSingleLongFixnum(DynamicObject, long, Object[])", value=ArrayNodes.PushNode.class)
            private static final class PushLongFixnumSingleLongFixnumNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                PushLongFixnumSingleLongFixnumNode_(PushNodeGen root, Object arguments1Value) {
                    super(root, 9);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((PushLongFixnumSingleLongFixnumNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    Object[] arguments2Value_;
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeObjectArray(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (ArrayGuards.isLongArray(arguments0Value_) && arguments2Value_.length == 0) {
                        return this.root.pushLongFixnumSingleLongFixnum(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType) && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (ArrayGuards.isLongArray(arguments0Value_) && arguments2Value_.length == 0) {
                            return this.root.pushLongFixnumSingleLongFixnum(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root, Object arguments1Value) {
                    return new PushLongFixnumSingleLongFixnumNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="pushLongFixnumSingleIntegerFixnum(DynamicObject, int, Object[])", value=ArrayNodes.PushNode.class)
            private static final class PushLongFixnumSingleIntegerFixnumNode_
            extends BaseNode_ {
                PushLongFixnumSingleIntegerFixnumNode_(PushNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    Object[] arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeObjectArray(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (ArrayGuards.isLongArray(arguments0Value_) && arguments2Value_.length == 0) {
                        return this.root.pushLongFixnumSingleIntegerFixnum(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (ArrayGuards.isLongArray(arguments0Value_) && arguments2Value_.length == 0) {
                            return this.root.pushLongFixnumSingleIntegerFixnum(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PushLongFixnumSingleIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="pushIntegerFixnum(VirtualFrame, DynamicObject, Object, Object[])", value=ArrayNodes.PushNode.class)
            private static final class PushIntegerFixnumNode_
            extends BaseNode_ {
                PushIntegerFixnumNode_(PushNodeGen root) {
                    super(root, 7);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && arguments2Value_.length != 0) {
                            return this.root.pushIntegerFixnum(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PushIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="pushIntegerFixnumSingleOther(DynamicObject, Object, Object[])", value=ArrayNodes.PushNode.class)
            private static final class PushIntegerFixnumSingleOtherNode_
            extends BaseNode_ {
                PushIntegerFixnumSingleOtherNode_(PushNodeGen root) {
                    super(root, 6);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && arguments2Value_.length == 0 && !RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value)) {
                            return this.root.pushIntegerFixnumSingleOther(arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PushIntegerFixnumSingleOtherNode_(root);
                }
            }

            @GeneratedBy(methodName="pushIntegerFixnumSingleIntegerFixnum(DynamicObject, int, Object[])", value=ArrayNodes.PushNode.class)
            private static final class PushIntegerFixnumSingleIntegerFixnumNode_
            extends BaseNode_ {
                PushIntegerFixnumSingleIntegerFixnumNode_(PushNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    Object[] arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeObjectArray(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (ArrayGuards.isIntArray(arguments0Value_) && arguments2Value_.length == 0) {
                        return this.root.pushIntegerFixnumSingleIntegerFixnum(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && arguments2Value_.length == 0) {
                            return this.root.pushIntegerFixnumSingleIntegerFixnum(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PushIntegerFixnumSingleIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="pushEmptySingleIntegerFixnum(VirtualFrame, DynamicObject, Object, Object[])", value=ArrayNodes.PushNode.class)
            private static final class PushEmptySingleIntegerFixnumNode_
            extends BaseNode_ {
                PushEmptySingleIntegerFixnumNode_(PushNodeGen root) {
                    super(root, 4);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (!ArrayGuards.isNullArray(arguments0Value_) && ArrayGuards.isEmptyArray(arguments0Value_)) {
                            return this.root.pushEmptySingleIntegerFixnum(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PushEmptySingleIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="pushNullEmptyObjects(VirtualFrame, DynamicObject, Object, Object[])", value=ArrayNodes.PushNode.class)
            private static final class PushNullEmptyObjectsNode_
            extends BaseNode_ {
                PushNullEmptyObjectsNode_(PushNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return this.root.pushNullEmptyObjects(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PushNullEmptyObjectsNode_(root);
                }
            }

            @GeneratedBy(methodName="pushNullEmptySingleIntegerLong(DynamicObject, long, Object[])", value=ArrayNodes.PushNode.class)
            private static final class PushNullEmptySingleIntegerLongNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                PushNullEmptySingleIntegerLongNode_(PushNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((PushNullEmptySingleIntegerLongNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    Object[] arguments2Value_;
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeObjectArray(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (ArrayGuards.isNullArray(arguments0Value_) && arguments2Value_.length == 0) {
                        return this.root.pushNullEmptySingleIntegerLong(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType) && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && arguments2Value_.length == 0) {
                            return this.root.pushNullEmptySingleIntegerLong(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root, Object arguments1Value) {
                    return new PushNullEmptySingleIntegerLongNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="pushNullEmptySingleIntegerFixnum(DynamicObject, int, Object[])", value=ArrayNodes.PushNode.class)
            private static final class PushNullEmptySingleIntegerFixnumNode_
            extends BaseNode_ {
                PushNullEmptySingleIntegerFixnumNode_(PushNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    Object[] arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeObjectArray(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (ArrayGuards.isNullArray(arguments0Value_) && arguments2Value_.length == 0) {
                        return this.root.pushNullEmptySingleIntegerFixnum(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && arguments2Value_.length == 0) {
                            return this.root.pushNullEmptySingleIntegerFixnum(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PushNullEmptySingleIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PushNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PushNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PushNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PushNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PushNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final PushNodeGen root;

                BaseNode_(PushNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (arguments1Value instanceof Integer && ArrayGuards.isNullArray(arguments0Value_) && arguments2Value_.length == 0) {
                            return PushNullEmptySingleIntegerFixnumNode_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && ArrayGuards.isNullArray(arguments0Value_) && arguments2Value_.length == 0) {
                            return PushNullEmptySingleIntegerLongNode_.create(this.root, arguments1Value);
                        }
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return PushNullEmptyObjectsNode_.create(this.root);
                        }
                        if (ArrayGuards.isEmptyArray(arguments0Value_)) {
                            return PushEmptySingleIntegerFixnumNode_.create(this.root);
                        }
                        if (arguments1Value instanceof Integer && ArrayGuards.isIntArray(arguments0Value_) && arguments2Value_.length == 0) {
                            return PushIntegerFixnumSingleIntegerFixnumNode_.create(this.root);
                        }
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && arguments2Value_.length == 0 && !RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value)) {
                            return PushIntegerFixnumSingleOtherNode_.create(this.root);
                        }
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && arguments2Value_.length != 0) {
                            return PushIntegerFixnumNode_.create(this.root);
                        }
                        if (arguments1Value instanceof Integer && ArrayGuards.isLongArray(arguments0Value_) && arguments2Value_.length == 0) {
                            return PushLongFixnumSingleIntegerFixnumNode_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && ArrayGuards.isLongArray(arguments0Value_) && arguments2Value_.length == 0) {
                            return PushLongFixnumSingleLongFixnumNode_.create(this.root, arguments1Value);
                        }
                        if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                            return PushFloatNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(arguments0Value_)) {
                            return PushObjectNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    throw new UnexpectedResultException(arguments1Value_);
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.LeftShiftNode.class)
    public static final class LeftShiftNodeFactory
    extends NodeFactoryBase<ArrayNodes.LeftShiftNode> {
        private static LeftShiftNodeFactory leftShiftNodeFactoryInstance;

        private LeftShiftNodeFactory() {
            super(ArrayNodes.LeftShiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.LeftShiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LeftShiftNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.LeftShiftNode> getInstance() {
            if (leftShiftNodeFactoryInstance == null) {
                leftShiftNodeFactoryInstance = new LeftShiftNodeFactory();
            }
            return leftShiftNodeFactoryInstance;
        }

        public static ArrayNodes.LeftShiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LeftShiftNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.LeftShiftNode.class)
        public static final class LeftShiftNodeGen
        extends ArrayNodes.LeftShiftNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private LeftShiftNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.leftShift(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PopNode.class)
    public static final class PopNodeFactory
    extends NodeFactoryBase<ArrayNodes.PopNode> {
        private static PopNodeFactory popNodeFactoryInstance;

        private PopNodeFactory() {
            super(ArrayNodes.PopNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.PopNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PopNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.PopNode> getInstance() {
            if (popNodeFactoryInstance == null) {
                popNodeFactoryInstance = new PopNodeFactory();
            }
            return popNodeFactoryInstance;
        }

        public static ArrayNodes.PopNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PopNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        public static final class PopNodeGen
        extends ArrayNodes.PopNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private boolean excludePopIntegerFixnumInBoundsWithNum_;
            @CompilerDirectives.CompilationFinal
            private boolean excludePopLongFixnumInBoundsWithNum_;
            @CompilerDirectives.CompilationFinal
            private boolean excludePopFloatInBoundsWithNum_;
            @CompilerDirectives.CompilationFinal
            private boolean excludePopIntegerFixnumInBoundsWithNumObj_;
            @CompilerDirectives.CompilationFinal
            private boolean excludePopLongFixnumInBoundsWithNumObj_;
            @CompilerDirectives.CompilationFinal
            private boolean excludePopFloatInBoundsWithNumObj_;
            @Node.Child
            private BaseNode_ specialization_;

            private PopNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static DynamicObject expectDynamicObject(Object value) throws UnexpectedResultException {
                if (value instanceof DynamicObject) {
                    return (DynamicObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="popObjectWithNumObj(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.PopNode.class)
            private static final class PopObjectWithNumObjNode_
            extends BaseNode_ {
                PopObjectWithNumObjNode_(PopNodeGen root) {
                    super(root, 16);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isObjectArray(arguments0Value_ = (DynamicObject)arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        return this.root.popObjectWithNumObj(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopObjectWithNumObjNode_(root);
                }
            }

            @GeneratedBy(methodName="popFloatWithNumObj(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.PopNode.class)
            private static final class PopFloatWithNumObjNode_
            extends BaseNode_ {
                PopFloatWithNumObjNode_(PopNodeGen root) {
                    super(root, 15);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isDoubleArray(arguments0Value_ = (DynamicObject)arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        return this.root.popFloatWithNumObj(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopFloatWithNumObjNode_(root);
                }
            }

            @GeneratedBy(methodName="popFloatInBoundsWithNumObj(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.PopNode.class)
            private static final class PopFloatInBoundsWithNumObjNode_
            extends BaseNode_ {
                PopFloatInBoundsWithNumObjNode_(PopNodeGen root) {
                    super(root, 14);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == PopFloatWithNumObjNode_.class) {
                        this.removeSame("Contained by popFloatWithNumObj(VirtualFrame, DynamicObject, Object)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isDoubleArray(arguments0Value_ = (DynamicObject)arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        try {
                            return this.root.popFloatInBoundsWithNumObj(frameValue, arguments0Value_, arguments1Value);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludePopFloatInBoundsWithNumObj_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopFloatInBoundsWithNumObjNode_(root);
                }
            }

            @GeneratedBy(methodName="popLongFixnumWithNumObj(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.PopNode.class)
            private static final class PopLongFixnumWithNumObjNode_
            extends BaseNode_ {
                PopLongFixnumWithNumObjNode_(PopNodeGen root) {
                    super(root, 13);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isLongArray(arguments0Value_ = (DynamicObject)arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        return this.root.popLongFixnumWithNumObj(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopLongFixnumWithNumObjNode_(root);
                }
            }

            @GeneratedBy(methodName="popLongFixnumInBoundsWithNumObj(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.PopNode.class)
            private static final class PopLongFixnumInBoundsWithNumObjNode_
            extends BaseNode_ {
                PopLongFixnumInBoundsWithNumObjNode_(PopNodeGen root) {
                    super(root, 12);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == PopLongFixnumWithNumObjNode_.class) {
                        this.removeSame("Contained by popLongFixnumWithNumObj(VirtualFrame, DynamicObject, Object)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isLongArray(arguments0Value_ = (DynamicObject)arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        try {
                            return this.root.popLongFixnumInBoundsWithNumObj(frameValue, arguments0Value_, arguments1Value);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludePopLongFixnumInBoundsWithNumObj_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopLongFixnumInBoundsWithNumObjNode_(root);
                }
            }

            @GeneratedBy(methodName="popIntegerFixnumWithNumObj(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.PopNode.class)
            private static final class PopIntegerFixnumWithNumObjNode_
            extends BaseNode_ {
                PopIntegerFixnumWithNumObjNode_(PopNodeGen root) {
                    super(root, 11);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isIntArray(arguments0Value_ = (DynamicObject)arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        return this.root.popIntegerFixnumWithNumObj(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopIntegerFixnumWithNumObjNode_(root);
                }
            }

            @GeneratedBy(methodName="popIntegerFixnumInBoundsWithNumObj(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.PopNode.class)
            private static final class PopIntegerFixnumInBoundsWithNumObjNode_
            extends BaseNode_ {
                PopIntegerFixnumInBoundsWithNumObjNode_(PopNodeGen root) {
                    super(root, 10);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == PopIntegerFixnumWithNumObjNode_.class) {
                        this.removeSame("Contained by popIntegerFixnumWithNumObj(VirtualFrame, DynamicObject, Object)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isIntArray(arguments0Value_ = (DynamicObject)arguments0Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                        try {
                            return this.root.popIntegerFixnumInBoundsWithNumObj(frameValue, arguments0Value_, arguments1Value);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludePopIntegerFixnumInBoundsWithNumObj_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopIntegerFixnumInBoundsWithNumObjNode_(root);
                }
            }

            @GeneratedBy(methodName="popObjectWithNum(VirtualFrame, DynamicObject, int)", value=ArrayNodes.PopNode.class)
            private static final class PopObjectWithNumNode_
            extends BaseNode_ {
                PopObjectWithNumNode_(PopNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (ArrayGuards.isObjectArray(arguments0Value_)) {
                        return this.root.popObjectWithNum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_)) {
                            return this.root.popObjectWithNum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopObjectWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="popFloatWithNum(VirtualFrame, DynamicObject, int)", value=ArrayNodes.PopNode.class)
            private static final class PopFloatWithNumNode_
            extends BaseNode_ {
                PopFloatWithNumNode_(PopNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                        return this.root.popFloatWithNum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                            return this.root.popFloatWithNum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopFloatWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="popFloatInBoundsWithNum(VirtualFrame, DynamicObject, int)", value=ArrayNodes.PopNode.class)
            private static final class PopFloatInBoundsWithNumNode_
            extends BaseNode_ {
                PopFloatInBoundsWithNumNode_(PopNodeGen root) {
                    super(root, 7);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == PopFloatWithNumNode_.class) {
                        this.removeSame("Contained by popFloatWithNum(VirtualFrame, DynamicObject, int)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return PopNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return PopNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                        try {
                            return this.root.popFloatInBoundsWithNum(frameValue, arguments0Value_, arguments1Value_);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludePopFloatInBoundsWithNum_ = true;
                            return PopNodeGen.expectDynamicObject(this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_));
                        }
                    }
                    return PopNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                            try {
                                return this.root.popFloatInBoundsWithNum(frameValue, arguments0Value_, arguments1Value_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludePopFloatInBoundsWithNum_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_);
                            }
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopFloatInBoundsWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="popLongFixnumWithNum(VirtualFrame, DynamicObject, int)", value=ArrayNodes.PopNode.class)
            private static final class PopLongFixnumWithNumNode_
            extends BaseNode_ {
                PopLongFixnumWithNumNode_(PopNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (ArrayGuards.isLongArray(arguments0Value_)) {
                        return this.root.popLongFixnumWithNum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value_)) {
                            return this.root.popLongFixnumWithNum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopLongFixnumWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="popLongFixnumInBoundsWithNum(VirtualFrame, DynamicObject, int)", value=ArrayNodes.PopNode.class)
            private static final class PopLongFixnumInBoundsWithNumNode_
            extends BaseNode_ {
                PopLongFixnumInBoundsWithNumNode_(PopNodeGen root) {
                    super(root, 5);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == PopLongFixnumWithNumNode_.class) {
                        this.removeSame("Contained by popLongFixnumWithNum(VirtualFrame, DynamicObject, int)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return PopNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return PopNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (ArrayGuards.isLongArray(arguments0Value_)) {
                        try {
                            return this.root.popLongFixnumInBoundsWithNum(frameValue, arguments0Value_, arguments1Value_);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludePopLongFixnumInBoundsWithNum_ = true;
                            return PopNodeGen.expectDynamicObject(this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_));
                        }
                    }
                    return PopNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value_)) {
                            try {
                                return this.root.popLongFixnumInBoundsWithNum(frameValue, arguments0Value_, arguments1Value_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludePopLongFixnumInBoundsWithNum_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_);
                            }
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopLongFixnumInBoundsWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="popIntegerFixnumWithNum(VirtualFrame, DynamicObject, int)", value=ArrayNodes.PopNode.class)
            private static final class PopIntegerFixnumWithNumNode_
            extends BaseNode_ {
                PopIntegerFixnumWithNumNode_(PopNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (ArrayGuards.isIntArray(arguments0Value_)) {
                        return this.root.popIntegerFixnumWithNum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_)) {
                            return this.root.popIntegerFixnumWithNum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopIntegerFixnumWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="popIntegerFixnumInBoundsWithNum(VirtualFrame, DynamicObject, int)", value=ArrayNodes.PopNode.class)
            private static final class PopIntegerFixnumInBoundsWithNumNode_
            extends BaseNode_ {
                PopIntegerFixnumInBoundsWithNumNode_(PopNodeGen root) {
                    super(root, 3);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == PopIntegerFixnumWithNumNode_.class) {
                        this.removeSame("Contained by popIntegerFixnumWithNum(VirtualFrame, DynamicObject, int)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return PopNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return PopNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (ArrayGuards.isIntArray(arguments0Value_)) {
                        try {
                            return this.root.popIntegerFixnumInBoundsWithNum(frameValue, arguments0Value_, arguments1Value_);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludePopIntegerFixnumInBoundsWithNum_ = true;
                            return PopNodeGen.expectDynamicObject(this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_));
                        }
                    }
                    return PopNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_)) {
                            try {
                                return this.root.popIntegerFixnumInBoundsWithNum(frameValue, arguments0Value_, arguments1Value_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludePopIntegerFixnumInBoundsWithNum_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_, arguments1Value_);
                            }
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopIntegerFixnumInBoundsWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="popNilWithNum(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.PopNode.class)
            private static final class PopNilWithNumNode_
            extends BaseNode_ {
                PopNilWithNumNode_(PopNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isEmptyArray(arguments0Value_ = (DynamicObject)arguments0Value) && RubyGuards.wasProvided(arguments1Value)) {
                        return this.root.popNilWithNum(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopNilWithNumNode_(root);
                }
            }

            @GeneratedBy(methodName="pop(DynamicObject, NotProvided)", value=ArrayNodes.PopNode.class)
            private static final class PopNode_
            extends BaseNode_ {
                PopNode_(PopNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.pop(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PopNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PopNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PopNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PopNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PopNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final PopNodeGen root;

                BaseNode_(PopNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    return PopNodeGen.expectDynamicObject(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments1Value instanceof NotProvided) {
                            return PopNode_.create(this.root);
                        }
                        if (ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return PopNilWithNumNode_.create(this.root);
                        }
                        if (arguments1Value instanceof Integer) {
                            if (ArrayGuards.isIntArray(arguments0Value_) && !this.root.excludePopIntegerFixnumInBoundsWithNum_) {
                                return PopIntegerFixnumInBoundsWithNumNode_.create(this.root);
                            }
                            if (ArrayGuards.isIntArray(arguments0Value_)) {
                                this.root.excludePopIntegerFixnumInBoundsWithNum_ = true;
                                return PopIntegerFixnumWithNumNode_.create(this.root);
                            }
                            if (ArrayGuards.isLongArray(arguments0Value_) && !this.root.excludePopLongFixnumInBoundsWithNum_) {
                                return PopLongFixnumInBoundsWithNumNode_.create(this.root);
                            }
                            if (ArrayGuards.isLongArray(arguments0Value_)) {
                                this.root.excludePopLongFixnumInBoundsWithNum_ = true;
                                return PopLongFixnumWithNumNode_.create(this.root);
                            }
                            if (ArrayGuards.isDoubleArray(arguments0Value_) && !this.root.excludePopFloatInBoundsWithNum_) {
                                return PopFloatInBoundsWithNumNode_.create(this.root);
                            }
                            if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                                this.root.excludePopFloatInBoundsWithNum_ = true;
                                return PopFloatWithNumNode_.create(this.root);
                            }
                            if (ArrayGuards.isObjectArray(arguments0Value_)) {
                                return PopObjectWithNumNode_.create(this.root);
                            }
                        }
                        if (ArrayGuards.isIntArray(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value) && !this.root.excludePopIntegerFixnumInBoundsWithNumObj_) {
                            return PopIntegerFixnumInBoundsWithNumObjNode_.create(this.root);
                        }
                        if (ArrayGuards.isIntArray(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            this.root.excludePopIntegerFixnumInBoundsWithNumObj_ = true;
                            return PopIntegerFixnumWithNumObjNode_.create(this.root);
                        }
                        if (ArrayGuards.isLongArray(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value) && !this.root.excludePopLongFixnumInBoundsWithNumObj_) {
                            return PopLongFixnumInBoundsWithNumObjNode_.create(this.root);
                        }
                        if (ArrayGuards.isLongArray(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            this.root.excludePopLongFixnumInBoundsWithNumObj_ = true;
                            return PopLongFixnumWithNumObjNode_.create(this.root);
                        }
                        if (ArrayGuards.isDoubleArray(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value) && !this.root.excludePopFloatInBoundsWithNumObj_) {
                            return PopFloatInBoundsWithNumObjNode_.create(this.root);
                        }
                        if (ArrayGuards.isDoubleArray(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            this.root.excludePopFloatInBoundsWithNumObj_ = true;
                            return PopFloatWithNumObjNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            return PopObjectWithNumObjNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PackNode.class)
    public static final class PackNodeFactory
    extends NodeFactoryBase<ArrayNodes.PackNode> {
        private static PackNodeFactory packNodeFactoryInstance;

        private PackNodeFactory() {
            super(ArrayNodes.PackNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.PackNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PackNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.PackNode> getInstance() {
            if (packNodeFactoryInstance == null) {
                packNodeFactoryInstance = new PackNodeFactory();
            }
            return packNodeFactoryInstance;
        }

        public static ArrayNodes.PackNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PackNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.PackNode.class)
        public static final class PackNodeGen
        extends ArrayNodes.PackNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private boolean excludePackCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private PackNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="pack(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.PackNode.class)
            private static final class Pack3Node_
            extends BaseNode_ {
                Pack3Node_(PackNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!(RubyGuards.isRubyString(arguments1Value) || RubyGuards.isBoolean(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || this.root.isNil(arguments1Value))) {
                            return this.root.pack(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PackNodeGen root) {
                    return new Pack3Node_(root);
                }
            }

            @GeneratedBy(methodName="packNil(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.PackNode.class)
            private static final class PackNilNode_
            extends BaseNode_ {
                PackNilNode_(PackNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (this.root.isNil(arguments1Value)) {
                            return this.root.packNil(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PackNodeGen root) {
                    return new PackNilNode_(root);
                }
            }

            @GeneratedBy(methodName="pack(VirtualFrame, DynamicObject, long)", value=ArrayNodes.PackNode.class)
            private static final class Pack2Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Pack2Node_(PackNodeGen root, Object arguments1Value) {
                    super(root, 5);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Pack2Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                            return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.pack(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.pack(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PackNodeGen root, Object arguments1Value) {
                    return new Pack2Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="pack(VirtualFrame, DynamicObject, int)", value=ArrayNodes.PackNode.class)
            private static final class Pack1Node_
            extends BaseNode_ {
                Pack1Node_(PackNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.pack(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.pack(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PackNodeGen root) {
                    return new Pack1Node_(root);
                }
            }

            @GeneratedBy(methodName="pack(VirtualFrame, DynamicObject, boolean)", value=ArrayNodes.PackNode.class)
            private static final class Pack0Node_
            extends BaseNode_ {
                Pack0Node_(PackNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    boolean arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.pack(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Boolean) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        boolean arguments1Value_ = (Boolean)arguments1Value;
                        return this.root.pack(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PackNodeGen root) {
                    return new Pack0Node_(root);
                }
            }

            @GeneratedBy(methodName="packUncached(VirtualFrame, DynamicObject, DynamicObject, IndirectCallNode)", value=ArrayNodes.PackNode.class)
            private static final class PackUncachedNode_
            extends BaseNode_ {
                @Node.Child
                private IndirectCallNode callPackNode;

                PackUncachedNode_(PackNodeGen root, IndirectCallNode callPackNode) {
                    super(root, 2);
                    this.callPackNode = callPackNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.packUncached(frameValue, arguments0Value_, arguments1Value_, this.callPackNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PackNodeGen root, IndirectCallNode callPackNode) {
                    return new PackUncachedNode_(root, callPackNode);
                }
            }

            @GeneratedBy(methodName="packCached(VirtualFrame, DynamicObject, DynamicObject, ByteList, DirectCallNode)", value=ArrayNodes.PackNode.class)
            private static final class PackCachedNode_
            extends BaseNode_ {
                private final ByteList cachedFormat;
                @Node.Child
                private DirectCallNode callPackNode;

                PackCachedNode_(PackNodeGen root, ByteList cachedFormat, DirectCallNode callPackNode) {
                    super(root, 1);
                    this.cachedFormat = cachedFormat;
                    this.callPackNode = callPackNode;
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == PackUncachedNode_.class) {
                        this.removeSame("Contained by packUncached(VirtualFrame, DynamicObject, DynamicObject, IndirectCallNode)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments1Value_;
                    return arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value) && StringCachingGuards.byteListsEqual(arguments1Value_, this.cachedFormat);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_) && StringCachingGuards.byteListsEqual(arguments1Value_, this.cachedFormat)) {
                            return this.root.packCached(frameValue, arguments0Value_, arguments1Value_, this.cachedFormat, this.callPackNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PackNodeGen root, ByteList cachedFormat, DirectCallNode callPackNode) {
                    return new PackCachedNode_(root, cachedFormat, callPackNode);
                }
            }

            @GeneratedBy(value=ArrayNodes.PackNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PackNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PackNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PackNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PackNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PackNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PackNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final PackNodeGen root;

                BaseNode_(PackNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (arguments1Value instanceof DynamicObject) {
                            DirectCallNode callPackNode1;
                            BaseNode_ s;
                            DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                            ByteList cachedFormat1 = StringCachingGuards.privatizeByteList(arguments1Value_);
                            if (RubyGuards.isRubyString(arguments1Value_) && StringCachingGuards.byteListsEqual(arguments1Value_, cachedFormat1) && !this.root.excludePackCached_ && this.countSame(s = PackCachedNode_.create(this.root, cachedFormat1, callPackNode1 = DirectCallNode.create((CallTarget)this.root.compileFormat(arguments1Value_)))) < this.root.getCacheLimit()) {
                                return s;
                            }
                            if (RubyGuards.isRubyString(arguments1Value_)) {
                                IndirectCallNode callPackNode2 = IndirectCallNode.create();
                                this.root.excludePackCached_ = true;
                                return PackUncachedNode_.create(this.root, callPackNode2);
                            }
                        }
                        if (arguments1Value instanceof Boolean) {
                            return Pack0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof Integer) {
                            return Pack1Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Pack2Node_.create(this.root, arguments1Value);
                        }
                        if (this.root.isNil(arguments1Value)) {
                            return PackNilNode_.create(this.root);
                        }
                        if (!(RubyGuards.isRubyString(arguments1Value) || RubyGuards.isBoolean(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || this.root.isNil(arguments1Value))) {
                            return Pack3Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Boolean.TYPE) {
                        return this.root.arguments1_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MinBlockNode.class)
    public static final class MinBlockNodeFactory
    extends NodeFactoryBase<ArrayNodes.MinBlockNode> {
        private static MinBlockNodeFactory minBlockNodeFactoryInstance;

        private MinBlockNodeFactory() {
            super(ArrayNodes.MinBlockNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MinBlockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MinBlockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.MinBlockNode> getInstance() {
            if (minBlockNodeFactoryInstance == null) {
                minBlockNodeFactoryInstance = new MinBlockNodeFactory();
            }
            return minBlockNodeFactoryInstance;
        }

        public static ArrayNodes.MinBlockNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MinBlockNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.MinBlockNode.class)
        public static final class MinBlockNodeGen
        extends ArrayNodes.MinBlockNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private MinBlockNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.min(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MinNode.class)
    public static final class MinNodeFactory
    extends NodeFactoryBase<ArrayNodes.MinNode> {
        private static MinNodeFactory minNodeFactoryInstance;

        private MinNodeFactory() {
            super(ArrayNodes.MinNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MinNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MinNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.MinNode> getInstance() {
            if (minNodeFactoryInstance == null) {
                minNodeFactoryInstance = new MinNodeFactory();
            }
            return minNodeFactoryInstance;
        }

        public static ArrayNodes.MinNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MinNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.MinNode.class)
        public static final class MinNodeGen
        extends ArrayNodes.MinNode {
            @Node.Child
            private RubyNode arguments0_;

            private MinNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.min(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MaxBlockNode.class)
    public static final class MaxBlockNodeFactory
    extends NodeFactoryBase<ArrayNodes.MaxBlockNode> {
        private static MaxBlockNodeFactory maxBlockNodeFactoryInstance;

        private MaxBlockNodeFactory() {
            super(ArrayNodes.MaxBlockNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MaxBlockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MaxBlockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.MaxBlockNode> getInstance() {
            if (maxBlockNodeFactoryInstance == null) {
                maxBlockNodeFactoryInstance = new MaxBlockNodeFactory();
            }
            return maxBlockNodeFactoryInstance;
        }

        public static ArrayNodes.MaxBlockNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MaxBlockNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.MaxBlockNode.class)
        public static final class MaxBlockNodeGen
        extends ArrayNodes.MaxBlockNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private MaxBlockNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.max(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MaxNode.class)
    public static final class MaxNodeFactory
    extends NodeFactoryBase<ArrayNodes.MaxNode> {
        private static MaxNodeFactory maxNodeFactoryInstance;

        private MaxNodeFactory() {
            super(ArrayNodes.MaxNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MaxNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MaxNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.MaxNode> getInstance() {
            if (maxNodeFactoryInstance == null) {
                maxNodeFactoryInstance = new MaxNodeFactory();
            }
            return maxNodeFactoryInstance;
        }

        public static ArrayNodes.MaxNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MaxNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.MaxNode.class)
        public static final class MaxNodeGen
        extends ArrayNodes.MaxNode {
            @Node.Child
            private RubyNode arguments0_;

            private MaxNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.max(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
    public static final class MapInPlaceNodeFactory
    extends NodeFactoryBase<ArrayNodes.MapInPlaceNode> {
        private static MapInPlaceNodeFactory mapInPlaceNodeFactoryInstance;

        private MapInPlaceNodeFactory() {
            super(ArrayNodes.MapInPlaceNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MapInPlaceNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MapInPlaceNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.MapInPlaceNode> getInstance() {
            if (mapInPlaceNodeFactoryInstance == null) {
                mapInPlaceNodeFactoryInstance = new MapInPlaceNodeFactory();
            }
            return mapInPlaceNodeFactoryInstance;
        }

        public static ArrayNodes.MapInPlaceNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MapInPlaceNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
        public static final class MapInPlaceNodeGen
        extends ArrayNodes.MapInPlaceNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private MapInPlaceNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="mapInPlaceObject(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.MapInPlaceNode.class)
            private static final class MapInPlaceObjectNode_
            extends BaseNode_ {
                MapInPlaceObjectNode_(MapInPlaceNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.mapInPlaceObject(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapInPlaceNodeGen root) {
                    return new MapInPlaceObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="mapInPlaceFixnumInteger(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.MapInPlaceNode.class)
            private static final class MapInPlaceFixnumIntegerNode_
            extends BaseNode_ {
                MapInPlaceFixnumIntegerNode_(MapInPlaceNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.mapInPlaceFixnumInteger(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapInPlaceNodeGen root) {
                    return new MapInPlaceFixnumIntegerNode_(root);
                }
            }

            @GeneratedBy(methodName="mapInPlaceNull(DynamicObject, DynamicObject)", value=ArrayNodes.MapInPlaceNode.class)
            private static final class MapInPlaceNullNode_
            extends BaseNode_ {
                MapInPlaceNullNode_(MapInPlaceNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.mapInPlaceNull(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapInPlaceNodeGen root) {
                    return new MapInPlaceNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MapInPlaceNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapInPlaceNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MapInPlaceNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapInPlaceNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final MapInPlaceNodeGen root;

                BaseNode_(MapInPlaceNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return MapInPlaceNullNode_.create(this.root);
                        }
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return MapInPlaceFixnumIntegerNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return MapInPlaceObjectNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MapNode.class)
    public static final class MapNodeFactory
    extends NodeFactoryBase<ArrayNodes.MapNode> {
        private static MapNodeFactory mapNodeFactoryInstance;

        private MapNodeFactory() {
            super(ArrayNodes.MapNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MapNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MapNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.MapNode> getInstance() {
            if (mapNodeFactoryInstance == null) {
                mapNodeFactoryInstance = new MapNodeFactory();
            }
            return mapNodeFactoryInstance;
        }

        public static ArrayNodes.MapNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MapNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        public static final class MapNodeGen
        extends ArrayNodes.MapNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private MapNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="mapObject(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.MapNode.class)
            private static final class MapObjectNode_
            extends BaseNode_ {
                MapObjectNode_(MapNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.mapObject(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new MapObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="mapFloat(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.MapNode.class)
            private static final class MapFloatNode_
            extends BaseNode_ {
                MapFloatNode_(MapNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.mapFloat(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new MapFloatNode_(root);
                }
            }

            @GeneratedBy(methodName="mapLongFixnum(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.MapNode.class)
            private static final class MapLongFixnumNode_
            extends BaseNode_ {
                MapLongFixnumNode_(MapNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.mapLongFixnum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new MapLongFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="mapIntegerFixnum(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.MapNode.class)
            private static final class MapIntegerFixnumNode_
            extends BaseNode_ {
                MapIntegerFixnumNode_(MapNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.mapIntegerFixnum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new MapIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="mapNull(DynamicObject, DynamicObject)", value=ArrayNodes.MapNode.class)
            private static final class MapNullNode_
            extends BaseNode_ {
                MapNullNode_(MapNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.mapNull(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new MapNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MapNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MapNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MapNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MapNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MapNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final MapNodeGen root;

                BaseNode_(MapNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return MapNullNode_.create(this.root);
                        }
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return MapIntegerFixnumNode_.create(this.root);
                        }
                        if (ArrayGuards.isLongArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return MapLongFixnumNode_.create(this.root);
                        }
                        if (ArrayGuards.isDoubleArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return MapFloatNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return MapObjectNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InsertNode.class)
    public static final class InsertNodeFactory
    extends NodeFactoryBase<ArrayNodes.InsertNode> {
        private static InsertNodeFactory insertNodeFactoryInstance;

        private InsertNodeFactory() {
            super(ArrayNodes.InsertNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.InsertNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InsertNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.InsertNode> getInstance() {
            if (insertNodeFactoryInstance == null) {
                insertNodeFactoryInstance = new InsertNodeFactory();
            }
            return insertNodeFactoryInstance;
        }

        public static ArrayNodes.InsertNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InsertNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.InsertNode.class)
        public static final class InsertNodeGen
        extends ArrayNodes.InsertNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private InsertNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="insertBoxed(VirtualFrame, DynamicObject, Object, Object, Object[])", value=ArrayNodes.InsertNode.class)
            private static final class InsertBoxedNode_
            extends BaseNode_ {
                InsertBoxedNode_(InsertNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments3Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments3Value_ = (Object[])arguments3Value;
                        return this.root.insertBoxed(frameValue, arguments0Value_, arguments1Value, arguments2Value, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InsertNodeGen root) {
                    return new InsertBoxedNode_(root);
                }
            }

            @GeneratedBy(methodName="insert(VirtualFrame, DynamicObject, int, int, Object[])", value=ArrayNodes.InsertNode.class)
            private static final class InsertNode_
            extends BaseNode_ {
                InsertNode_(InsertNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    Object[] arguments3Value_;
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeObjectArray(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    if (ArrayGuards.isIntArray(arguments0Value_) && arguments3Value_.length == 0 && arguments1Value_ >= 0 && ArrayNodes.InsertNode.isIndexSmallerThanSize(arguments1Value_, arguments0Value_) && ArrayNodes.InsertNode.hasRoomForOneExtra(arguments0Value_)) {
                        return this.root.insert(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof Integer && arguments3Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        int arguments2Value_ = (Integer)arguments2Value;
                        Object[] arguments3Value_ = (Object[])arguments3Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && arguments3Value_.length == 0 && arguments1Value_ >= 0 && ArrayNodes.InsertNode.isIndexSmallerThanSize(arguments1Value_, arguments0Value_) && ArrayNodes.InsertNode.hasRoomForOneExtra(arguments0Value_)) {
                            return this.root.insert(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InsertNodeGen root) {
                    return new InsertNode_(root);
                }
            }

            @GeneratedBy(methodName="insertNull(DynamicObject, int, Object, Object[])", value=ArrayNodes.InsertNode.class)
            private static final class InsertNullNode_
            extends BaseNode_ {
                InsertNullNode_(InsertNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    Object[] arguments3Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    try {
                        arguments3Value_ = this.root.arguments3_.executeObjectArray(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.wasProvided(arguments2Value_) && arguments3Value_.length == 0) {
                        return this.root.insertNull(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments3Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        Object[] arguments3Value_ = (Object[])arguments3Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.wasProvided(arguments2Value) && arguments3Value_.length == 0) {
                            return this.root.insertNull(arguments0Value_, arguments1Value_, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InsertNodeGen root) {
                    return new InsertNullNode_(root);
                }
            }

            @GeneratedBy(methodName="insertMissingValue(VirtualFrame, DynamicObject, Object, NotProvided, Object[])", value=ArrayNodes.InsertNode.class)
            private static final class InsertMissingValueNode_
            extends BaseNode_ {
                InsertMissingValueNode_(InsertNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        Object[] arguments3Value_ = (Object[])arguments3Value;
                        return this.root.insertMissingValue(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InsertNodeGen root) {
                    return new InsertMissingValueNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InsertNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InsertNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InsertNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InsertNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InsertNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InsertNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InsertNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InsertNodeGen root;

                BaseNode_(InsertNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments3Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments3Value_ = (Object[])arguments3Value;
                        if (arguments2Value instanceof NotProvided) {
                            return InsertMissingValueNode_.create(this.root);
                        }
                        if (arguments1Value instanceof Integer) {
                            int arguments1Value_ = (Integer)arguments1Value;
                            if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.wasProvided(arguments2Value) && arguments3Value_.length == 0) {
                                return InsertNullNode_.create(this.root);
                            }
                            if (arguments2Value instanceof Integer && ArrayGuards.isIntArray(arguments0Value_) && arguments3Value_.length == 0 && arguments1Value_ >= 0 && ArrayNodes.InsertNode.isIndexSmallerThanSize(arguments1Value_, arguments0Value_) && ArrayNodes.InsertNode.hasRoomForOneExtra(arguments0Value_)) {
                                return InsertNode_.create(this.root);
                            }
                        }
                        return InsertBoxedNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InjectNode.class)
    public static final class InjectNodeFactory
    extends NodeFactoryBase<ArrayNodes.InjectNode> {
        private static InjectNodeFactory injectNodeFactoryInstance;

        private InjectNodeFactory() {
            super(ArrayNodes.InjectNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.InjectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InjectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.InjectNode> getInstance() {
            if (injectNodeFactoryInstance == null) {
                injectNodeFactoryInstance = new InjectNodeFactory();
            }
            return injectNodeFactoryInstance;
        }

        public static ArrayNodes.InjectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InjectNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        public static final class InjectNodeGen
        extends ArrayNodes.InjectNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @Node.Child
            private BaseNode_ specialization_;

            private InjectNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="injectSymbolObjectArray(VirtualFrame, DynamicObject, DynamicObject, NotProvided, NotProvided)", value=ArrayNodes.InjectNode.class)
            private static final class InjectSymbolObjectArray1Node_
            extends BaseNode_ {
                InjectSymbolObjectArray1Node_(InjectNodeGen root) {
                    super(root, 22);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && ArrayGuards.isObjectArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_)) {
                            return this.root.injectSymbolObjectArray(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectSymbolObjectArray1Node_(root);
                }
            }

            @GeneratedBy(methodName="injectSymbolObjectArray(VirtualFrame, DynamicObject, Object, DynamicObject, NotProvided)", value=ArrayNodes.InjectNode.class)
            private static final class InjectSymbolObjectArray0Node_
            extends BaseNode_ {
                InjectSymbolObjectArray0Node_(InjectNodeGen root) {
                    super(root, 21);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubySymbol(arguments2Value_) && ArrayGuards.isObjectArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.injectSymbolObjectArray(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectSymbolObjectArray0Node_(root);
                }
            }

            @GeneratedBy(methodName="injectSymbolDoubleArray(VirtualFrame, DynamicObject, DynamicObject, NotProvided, NotProvided)", value=ArrayNodes.InjectNode.class)
            private static final class InjectSymbolDoubleArray1Node_
            extends BaseNode_ {
                InjectSymbolDoubleArray1Node_(InjectNodeGen root) {
                    super(root, 20);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && ArrayGuards.isDoubleArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_)) {
                            return this.root.injectSymbolDoubleArray(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectSymbolDoubleArray1Node_(root);
                }
            }

            @GeneratedBy(methodName="injectSymbolDoubleArray(VirtualFrame, DynamicObject, Object, DynamicObject, NotProvided)", value=ArrayNodes.InjectNode.class)
            private static final class InjectSymbolDoubleArray0Node_
            extends BaseNode_ {
                InjectSymbolDoubleArray0Node_(InjectNodeGen root) {
                    super(root, 19);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubySymbol(arguments2Value_) && ArrayGuards.isDoubleArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.injectSymbolDoubleArray(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectSymbolDoubleArray0Node_(root);
                }
            }

            @GeneratedBy(methodName="injectSymbolLongArray(VirtualFrame, DynamicObject, DynamicObject, NotProvided, NotProvided)", value=ArrayNodes.InjectNode.class)
            private static final class InjectSymbolLongArray1Node_
            extends BaseNode_ {
                InjectSymbolLongArray1Node_(InjectNodeGen root) {
                    super(root, 18);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && ArrayGuards.isLongArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_)) {
                            return this.root.injectSymbolLongArray(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectSymbolLongArray1Node_(root);
                }
            }

            @GeneratedBy(methodName="injectSymbolLongArray(VirtualFrame, DynamicObject, Object, DynamicObject, NotProvided)", value=ArrayNodes.InjectNode.class)
            private static final class InjectSymbolLongArray0Node_
            extends BaseNode_ {
                InjectSymbolLongArray0Node_(InjectNodeGen root) {
                    super(root, 17);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubySymbol(arguments2Value_) && ArrayGuards.isLongArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.injectSymbolLongArray(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectSymbolLongArray0Node_(root);
                }
            }

            @GeneratedBy(methodName="injectSymbolIntArray(VirtualFrame, DynamicObject, DynamicObject, NotProvided, NotProvided)", value=ArrayNodes.InjectNode.class)
            private static final class InjectSymbolIntArray1Node_
            extends BaseNode_ {
                InjectSymbolIntArray1Node_(InjectNodeGen root) {
                    super(root, 16);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && ArrayGuards.isIntArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_)) {
                            return this.root.injectSymbolIntArray(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectSymbolIntArray1Node_(root);
                }
            }

            @GeneratedBy(methodName="injectSymbolIntArray(VirtualFrame, DynamicObject, Object, DynamicObject, NotProvided)", value=ArrayNodes.InjectNode.class)
            private static final class InjectSymbolIntArray0Node_
            extends BaseNode_ {
                InjectSymbolIntArray0Node_(InjectNodeGen root) {
                    super(root, 15);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubySymbol(arguments2Value_) && ArrayGuards.isIntArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.injectSymbolIntArray(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectSymbolIntArray0Node_(root);
                }
            }

            @GeneratedBy(methodName="injectSymbolEmptyArray(VirtualFrame, DynamicObject, DynamicObject, NotProvided, NotProvided)", value=ArrayNodes.InjectNode.class)
            private static final class InjectSymbolEmptyArray1Node_
            extends BaseNode_ {
                InjectSymbolEmptyArray1Node_(InjectNodeGen root) {
                    super(root, 14);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && ArrayGuards.isEmptyArray(arguments0Value_)) {
                            return this.root.injectSymbolEmptyArray(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectSymbolEmptyArray1Node_(root);
                }
            }

            @GeneratedBy(methodName="injectSymbolEmptyArray(VirtualFrame, DynamicObject, Object, DynamicObject, NotProvided)", value=ArrayNodes.InjectNode.class)
            private static final class InjectSymbolEmptyArray0Node_
            extends BaseNode_ {
                InjectSymbolEmptyArray0Node_(InjectNodeGen root) {
                    super(root, 13);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubySymbol(arguments2Value_) && ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.injectSymbolEmptyArray(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectSymbolEmptyArray0Node_(root);
                }
            }

            @GeneratedBy(methodName="injectNullNoInitial(VirtualFrame, DynamicObject, NotProvided, NotProvided, DynamicObject)", value=ArrayNodes.InjectNode.class)
            private static final class InjectNullNoInitialNode_
            extends BaseNode_ {
                InjectNullNoInitialNode_(InjectNodeGen root) {
                    super(root, 12);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.injectNullNoInitial(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectNullNoInitialNode_(root);
                }
            }

            @GeneratedBy(methodName="injectNull(VirtualFrame, DynamicObject, Object, NotProvided, DynamicObject)", value=ArrayNodes.InjectNode.class)
            private static final class InjectNullNode_
            extends BaseNode_ {
                InjectNullNode_(InjectNodeGen root) {
                    super(root, 11);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.injectNull(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectNullNode_(root);
                }
            }

            @GeneratedBy(methodName="injectObjectNoInitial(VirtualFrame, DynamicObject, NotProvided, NotProvided, DynamicObject)", value=ArrayNodes.InjectNode.class)
            private static final class InjectObjectNoInitialNode_
            extends BaseNode_ {
                InjectObjectNoInitialNode_(InjectNodeGen root) {
                    super(root, 10);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.injectObjectNoInitial(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectObjectNoInitialNode_(root);
                }
            }

            @GeneratedBy(methodName="injectObject(VirtualFrame, DynamicObject, Object, NotProvided, DynamicObject)", value=ArrayNodes.InjectNode.class)
            private static final class InjectObjectNode_
            extends BaseNode_ {
                InjectObjectNode_(InjectNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.injectObject(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="injectFloatNoInitial(VirtualFrame, DynamicObject, NotProvided, NotProvided, DynamicObject)", value=ArrayNodes.InjectNode.class)
            private static final class InjectFloatNoInitialNode_
            extends BaseNode_ {
                InjectFloatNoInitialNode_(InjectNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.injectFloatNoInitial(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectFloatNoInitialNode_(root);
                }
            }

            @GeneratedBy(methodName="injectFloat(VirtualFrame, DynamicObject, Object, NotProvided, DynamicObject)", value=ArrayNodes.InjectNode.class)
            private static final class InjectFloatNode_
            extends BaseNode_ {
                InjectFloatNode_(InjectNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.injectFloat(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectFloatNode_(root);
                }
            }

            @GeneratedBy(methodName="injectLongFixnumNoInitial(VirtualFrame, DynamicObject, NotProvided, NotProvided, DynamicObject)", value=ArrayNodes.InjectNode.class)
            private static final class InjectLongFixnumNoInitialNode_
            extends BaseNode_ {
                InjectLongFixnumNoInitialNode_(InjectNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (ArrayGuards.isLongArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.injectLongFixnumNoInitial(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectLongFixnumNoInitialNode_(root);
                }
            }

            @GeneratedBy(methodName="injectLongFixnum(VirtualFrame, DynamicObject, Object, NotProvided, DynamicObject)", value=ArrayNodes.InjectNode.class)
            private static final class InjectLongFixnumNode_
            extends BaseNode_ {
                InjectLongFixnumNode_(InjectNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (ArrayGuards.isLongArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.injectLongFixnum(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectLongFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="injectIntegerFixnumNoInitial(VirtualFrame, DynamicObject, NotProvided, NotProvided, DynamicObject)", value=ArrayNodes.InjectNode.class)
            private static final class InjectIntegerFixnumNoInitialNode_
            extends BaseNode_ {
                InjectIntegerFixnumNoInitialNode_(InjectNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.injectIntegerFixnumNoInitial(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectIntegerFixnumNoInitialNode_(root);
                }
            }

            @GeneratedBy(methodName="injectIntegerFixnum(VirtualFrame, DynamicObject, Object, NotProvided, DynamicObject)", value=ArrayNodes.InjectNode.class)
            private static final class InjectIntegerFixnumNode_
            extends BaseNode_ {
                InjectIntegerFixnumNode_(InjectNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.injectIntegerFixnum(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="injectEmptyArrayNoInitial(VirtualFrame, DynamicObject, NotProvided, NotProvided, DynamicObject)", value=ArrayNodes.InjectNode.class)
            private static final class InjectEmptyArrayNoInitialNode_
            extends BaseNode_ {
                InjectEmptyArrayNoInitialNode_(InjectNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.injectEmptyArrayNoInitial(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectEmptyArrayNoInitialNode_(root);
                }
            }

            @GeneratedBy(methodName="injectEmptyArray(VirtualFrame, DynamicObject, Object, NotProvided, DynamicObject)", value=ArrayNodes.InjectNode.class)
            private static final class InjectEmptyArrayNode_
            extends BaseNode_ {
                InjectEmptyArrayNode_(InjectNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.injectEmptyArray(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectEmptyArrayNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InjectNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InjectNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InjectNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InjectNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InjectNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InjectNodeGen root;

                BaseNode_(InjectNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                            DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                            if (ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments3Value_)) {
                                return InjectEmptyArrayNode_.create(this.root);
                            }
                            if (arguments1Value instanceof NotProvided && ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.isRubyProc(arguments3Value_)) {
                                return InjectEmptyArrayNoInitialNode_.create(this.root);
                            }
                            if (ArrayGuards.isIntArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments3Value_)) {
                                return InjectIntegerFixnumNode_.create(this.root);
                            }
                            if (arguments1Value instanceof NotProvided && ArrayGuards.isIntArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.isRubyProc(arguments3Value_)) {
                                return InjectIntegerFixnumNoInitialNode_.create(this.root);
                            }
                            if (ArrayGuards.isLongArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments3Value_)) {
                                return InjectLongFixnumNode_.create(this.root);
                            }
                            if (arguments1Value instanceof NotProvided && ArrayGuards.isLongArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.isRubyProc(arguments3Value_)) {
                                return InjectLongFixnumNoInitialNode_.create(this.root);
                            }
                            if (ArrayGuards.isDoubleArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments3Value_)) {
                                return InjectFloatNode_.create(this.root);
                            }
                            if (arguments1Value instanceof NotProvided && ArrayGuards.isDoubleArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.isRubyProc(arguments3Value_)) {
                                return InjectFloatNoInitialNode_.create(this.root);
                            }
                            if (ArrayGuards.isObjectArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments3Value_)) {
                                return InjectObjectNode_.create(this.root);
                            }
                            if (arguments1Value instanceof NotProvided && ArrayGuards.isObjectArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.isRubyProc(arguments3Value_)) {
                                return InjectObjectNoInitialNode_.create(this.root);
                            }
                            if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments3Value_)) {
                                return InjectNullNode_.create(this.root);
                            }
                            if (arguments1Value instanceof NotProvided && ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments3Value_)) {
                                return InjectNullNoInitialNode_.create(this.root);
                            }
                        }
                        if (arguments3Value instanceof NotProvided) {
                            DynamicObject arguments1Value_;
                            DynamicObject arguments2Value_;
                            if (arguments2Value instanceof DynamicObject && RubyGuards.isRubySymbol(arguments2Value_ = (DynamicObject)arguments2Value) && ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                                return InjectSymbolEmptyArray0Node_.create(this.root);
                            }
                            if (arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && RubyGuards.isRubySymbol(arguments1Value_ = (DynamicObject)arguments1Value) && ArrayGuards.isEmptyArray(arguments0Value_)) {
                                return InjectSymbolEmptyArray1Node_.create(this.root);
                            }
                            if (arguments2Value instanceof DynamicObject && RubyGuards.isRubySymbol(arguments2Value_ = (DynamicObject)arguments2Value) && ArrayGuards.isIntArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                                return InjectSymbolIntArray0Node_.create(this.root);
                            }
                            if (arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && RubyGuards.isRubySymbol(arguments1Value_ = (DynamicObject)arguments1Value) && ArrayGuards.isIntArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_)) {
                                return InjectSymbolIntArray1Node_.create(this.root);
                            }
                            if (arguments2Value instanceof DynamicObject && RubyGuards.isRubySymbol(arguments2Value_ = (DynamicObject)arguments2Value) && ArrayGuards.isLongArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                                return InjectSymbolLongArray0Node_.create(this.root);
                            }
                            if (arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && RubyGuards.isRubySymbol(arguments1Value_ = (DynamicObject)arguments1Value) && ArrayGuards.isLongArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_)) {
                                return InjectSymbolLongArray1Node_.create(this.root);
                            }
                            if (arguments2Value instanceof DynamicObject && RubyGuards.isRubySymbol(arguments2Value_ = (DynamicObject)arguments2Value) && ArrayGuards.isDoubleArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                                return InjectSymbolDoubleArray0Node_.create(this.root);
                            }
                            if (arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && RubyGuards.isRubySymbol(arguments1Value_ = (DynamicObject)arguments1Value) && ArrayGuards.isDoubleArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_)) {
                                return InjectSymbolDoubleArray1Node_.create(this.root);
                            }
                            if (arguments2Value instanceof DynamicObject && RubyGuards.isRubySymbol(arguments2Value_ = (DynamicObject)arguments2Value) && ArrayGuards.isObjectArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                                return InjectSymbolObjectArray0Node_.create(this.root);
                            }
                            if (arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && RubyGuards.isRubySymbol(arguments1Value_ = (DynamicObject)arguments1Value) && ArrayGuards.isObjectArray(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_)) {
                                return InjectSymbolObjectArray1Node_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<ArrayNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(ArrayNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return InitializeCopyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        public static ArrayNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode from) {
            return new InitializeCopyNodeGen(context, sourceSection, self, from);
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        public static final class InitializeCopyNodeGen
        extends ArrayNodes.InitializeCopyNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode self_;
            @Node.Child
            private RubyNode from_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeCopyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode from) {
                super(context, sourceSection);
                this.self_ = self;
                this.from_ = this.coerceOtherToAry(from);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="initializeCopyObject(DynamicObject, DynamicObject)", value=ArrayNodes.InitializeCopyNode.class)
            private static final class InitializeCopyObjectNode_
            extends BaseNode_ {
                InitializeCopyObjectNode_(InitializeCopyNodeGen root) {
                    super(root, 5);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                    if (selfValue instanceof DynamicObject && fromValue instanceof DynamicObject) {
                        DynamicObject selfValue_ = (DynamicObject)selfValue;
                        DynamicObject fromValue_ = (DynamicObject)fromValue;
                        if (RubyGuards.isRubyArray(fromValue_) && ArrayGuards.isObjectArray(fromValue_)) {
                            return this.root.initializeCopyObject(selfValue_, fromValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, selfValue, fromValue);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new InitializeCopyObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="initializeCopyFloat(DynamicObject, DynamicObject)", value=ArrayNodes.InitializeCopyNode.class)
            private static final class InitializeCopyFloatNode_
            extends BaseNode_ {
                InitializeCopyFloatNode_(InitializeCopyNodeGen root) {
                    super(root, 4);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                    if (selfValue instanceof DynamicObject && fromValue instanceof DynamicObject) {
                        DynamicObject selfValue_ = (DynamicObject)selfValue;
                        DynamicObject fromValue_ = (DynamicObject)fromValue;
                        if (RubyGuards.isRubyArray(fromValue_) && ArrayGuards.isDoubleArray(fromValue_)) {
                            return this.root.initializeCopyFloat(selfValue_, fromValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, selfValue, fromValue);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new InitializeCopyFloatNode_(root);
                }
            }

            @GeneratedBy(methodName="initializeCopyLongFixnum(DynamicObject, DynamicObject)", value=ArrayNodes.InitializeCopyNode.class)
            private static final class InitializeCopyLongFixnumNode_
            extends BaseNode_ {
                InitializeCopyLongFixnumNode_(InitializeCopyNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                    if (selfValue instanceof DynamicObject && fromValue instanceof DynamicObject) {
                        DynamicObject selfValue_ = (DynamicObject)selfValue;
                        DynamicObject fromValue_ = (DynamicObject)fromValue;
                        if (RubyGuards.isRubyArray(fromValue_) && ArrayGuards.isLongArray(fromValue_)) {
                            return this.root.initializeCopyLongFixnum(selfValue_, fromValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, selfValue, fromValue);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new InitializeCopyLongFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="initializeCopyIntegerFixnum(DynamicObject, DynamicObject)", value=ArrayNodes.InitializeCopyNode.class)
            private static final class InitializeCopyIntegerFixnumNode_
            extends BaseNode_ {
                InitializeCopyIntegerFixnumNode_(InitializeCopyNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                    if (selfValue instanceof DynamicObject && fromValue instanceof DynamicObject) {
                        DynamicObject selfValue_ = (DynamicObject)selfValue;
                        DynamicObject fromValue_ = (DynamicObject)fromValue;
                        if (RubyGuards.isRubyArray(fromValue_) && ArrayGuards.isIntArray(fromValue_)) {
                            return this.root.initializeCopyIntegerFixnum(selfValue_, fromValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, selfValue, fromValue);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new InitializeCopyIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="initializeCopyNull(DynamicObject, DynamicObject)", value=ArrayNodes.InitializeCopyNode.class)
            private static final class InitializeCopyNullNode_
            extends BaseNode_ {
                InitializeCopyNullNode_(InitializeCopyNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                    if (selfValue instanceof DynamicObject && fromValue instanceof DynamicObject) {
                        DynamicObject selfValue_ = (DynamicObject)selfValue;
                        DynamicObject fromValue_ = (DynamicObject)fromValue;
                        if (RubyGuards.isRubyArray(fromValue_) && ArrayGuards.isNullArray(fromValue_)) {
                            return this.root.initializeCopyNull(selfValue_, fromValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, selfValue, fromValue);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new InitializeCopyNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeCopyNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object selfValue, Object fromValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, selfValue, fromValue));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                    return this.getNext().executeDynamicObject_(frameValue, selfValue, fromValue);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeCopyNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, selfValue, fromValue);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InitializeCopyNodeGen root;

                BaseNode_(InitializeCopyNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.self_, this.root.from_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object selfValue, Object fromValue) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, selfValue, fromValue);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object selfValue_ = this.root.self_.execute(frameValue);
                    Object fromValue_ = this.root.from_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, selfValue_, fromValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object selfValue, Object fromValue) {
                    if (selfValue instanceof DynamicObject && fromValue instanceof DynamicObject) {
                        DynamicObject fromValue_ = (DynamicObject)fromValue;
                        if (RubyGuards.isRubyArray(fromValue_) && ArrayGuards.isNullArray(fromValue_)) {
                            return InitializeCopyNullNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyArray(fromValue_) && ArrayGuards.isIntArray(fromValue_)) {
                            return InitializeCopyIntegerFixnumNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyArray(fromValue_) && ArrayGuards.isLongArray(fromValue_)) {
                            return InitializeCopyLongFixnumNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyArray(fromValue_) && ArrayGuards.isDoubleArray(fromValue_)) {
                            return InitializeCopyFloatNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyArray(fromValue_) && ArrayGuards.isObjectArray(fromValue_)) {
                            return InitializeCopyObjectNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<ArrayNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(ArrayNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static ArrayNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends ArrayNodes.InitializeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static DynamicObject expectDynamicObject(Object value) throws UnexpectedResultException {
                if (value instanceof DynamicObject) {
                    return (DynamicObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="initialize(DynamicObject, DynamicObject, NotProvided, DynamicObject)", value=ArrayNodes.InitializeNode.class)
            private static final class Initialize13Node_
            extends BaseNode_ {
                Initialize13Node_(InitializeNodeGen root) {
                    super(root, 22);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (RubyGuards.isRubyArray(arguments1Value_) && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize13Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, DynamicObject, NotProvided, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class Initialize12Node_
            extends BaseNode_ {
                Initialize12Node_(InitializeNodeGen root) {
                    super(root, 21);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubyArray(arguments1Value_)) {
                            return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize12Node_(root);
                }
            }

            @GeneratedBy(methodName="initializeNegative(VirtualFrame, DynamicObject, int, NotProvided, DynamicObject)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeNegative7Node_
            extends BaseNode_ {
                InitializeNegative7Node_(InitializeNodeGen root) {
                    super(root, 20);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject arguments3Value_;
                    NotProvided arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    if (arguments1Value_ < 0 && RubyGuards.isRubyProc(arguments3Value_)) {
                        return this.root.initializeNegative(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (arguments1Value_ < 0 && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.initializeNegative(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new InitializeNegative7Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(VirtualFrame, DynamicObject, int, NotProvided, DynamicObject)", value=ArrayNodes.InitializeNode.class)
            private static final class Initialize11Node_
            extends BaseNode_ {
                Initialize11Node_(InitializeNodeGen root) {
                    super(root, 19);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject arguments3Value_;
                    NotProvided arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    if (arguments1Value_ >= 0 && RubyGuards.isRubyProc(arguments3Value_)) {
                        return this.root.initialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (arguments1Value_ >= 0 && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.initialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize11Node_(root);
                }
            }

            @GeneratedBy(methodName="initializeNegative(VirtualFrame, DynamicObject, int, Object, DynamicObject)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeNegative6Node_
            extends BaseNode_ {
                InitializeNegative6Node_(InitializeNodeGen root) {
                    super(root, 18);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject arguments3Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    try {
                        arguments3Value_ = this.root.arguments3_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    if (RubyGuards.wasProvided(arguments2Value_) && arguments1Value_ < 0 && RubyGuards.isRubyProc(arguments3Value_)) {
                        return this.root.initializeNegative(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (RubyGuards.wasProvided(arguments2Value) && arguments1Value_ < 0 && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.initializeNegative(frameValue, arguments0Value_, arguments1Value_, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new InitializeNegative6Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(VirtualFrame, DynamicObject, int, Object, DynamicObject)", value=ArrayNodes.InitializeNode.class)
            private static final class Initialize10Node_
            extends BaseNode_ {
                Initialize10Node_(InitializeNodeGen root) {
                    super(root, 17);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject arguments3Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    try {
                        arguments3Value_ = this.root.arguments3_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    if (RubyGuards.wasProvided(arguments2Value_) && arguments1Value_ >= 0 && RubyGuards.isRubyProc(arguments3Value_)) {
                        return this.root.initialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (RubyGuards.wasProvided(arguments2Value) && arguments1Value_ >= 0 && RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.initialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize10Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(VirtualFrame, DynamicObject, Object, Object, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class Initialize9Node_
            extends BaseNode_ {
                Initialize9Node_(InitializeNodeGen root) {
                    super(root, 16);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.wasProvided(arguments1Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments2Value)) {
                            return this.root.initialize(frameValue, arguments0Value_, arguments1Value, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize9Node_(root);
                }
            }

            @GeneratedBy(methodName="initializeNegative(DynamicObject, int, Object, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeNegative5Node_
            extends BaseNode_ {
                InitializeNegative5Node_(InitializeNodeGen root) {
                    super(root, 15);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments3Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (RubyGuards.wasProvided(arguments2Value_) && arguments1Value_ < 0) {
                        return this.root.initializeNegative(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.wasProvided(arguments2Value) && arguments1Value_ < 0) {
                            return this.root.initializeNegative(arguments0Value_, arguments1Value_, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new InitializeNegative5Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, int, Object, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class Initialize8Node_
            extends BaseNode_ {
                Initialize8Node_(InitializeNodeGen root) {
                    super(root, 14);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments3Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (RubyGuards.wasProvided(arguments2Value_) && arguments1Value_ >= 0) {
                        return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.wasProvided(arguments2Value) && arguments1Value_ >= 0) {
                            return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize8Node_(root);
                }
            }

            @GeneratedBy(methodName="initializeNegative(DynamicObject, int, double, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeNegative4Node_
            extends BaseNode_ {
                InitializeNegative4Node_(InitializeNodeGen root) {
                    super(root, 13);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments3Value_;
                    double arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments1Value_ < 0) {
                        return this.root.initializeNegative(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof Double && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        double arguments2Value_ = (Double)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ < 0) {
                            return this.root.initializeNegative(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new InitializeNegative4Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, int, double, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class Initialize7Node_
            extends BaseNode_ {
                Initialize7Node_(InitializeNodeGen root) {
                    super(root, 12);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments3Value_;
                    double arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments1Value_ >= 0) {
                        return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof Double && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        double arguments2Value_ = (Double)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ >= 0) {
                            return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize7Node_(root);
                }
            }

            @GeneratedBy(methodName="initializeNegative(DynamicObject, int, long, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeNegative3Node_
            extends BaseNode_ {
                private final Class<?> arguments2ImplicitType;

                InitializeNegative3Node_(InitializeNodeGen root, Object arguments2Value) {
                    super(root, 11);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitLongClass(arguments2Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments2ImplicitType == ((InitializeNegative3Node_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments3Value_;
                    long arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        arguments2Value_ = this.executeArguments2Long_((Frame)frameValue, this.arguments2ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments1Value_ < 0) {
                        return this.root.initializeNegative(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && RubyTypesGen.isImplicitLong(arguments2Value, this.arguments2ImplicitType) && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        long arguments2Value_ = RubyTypesGen.asImplicitLong(arguments2Value, this.arguments2ImplicitType);
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ < 0) {
                            return this.root.initializeNegative(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root, Object arguments2Value) {
                    return new InitializeNegative3Node_(root, arguments2Value);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, int, long, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class Initialize6Node_
            extends BaseNode_ {
                private final Class<?> arguments2ImplicitType;

                Initialize6Node_(InitializeNodeGen root, Object arguments2Value) {
                    super(root, 10);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitLongClass(arguments2Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments2ImplicitType == ((Initialize6Node_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments3Value_;
                    long arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        arguments2Value_ = this.executeArguments2Long_((Frame)frameValue, this.arguments2ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments1Value_ >= 0) {
                        return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && RubyTypesGen.isImplicitLong(arguments2Value, this.arguments2ImplicitType) && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        long arguments2Value_ = RubyTypesGen.asImplicitLong(arguments2Value, this.arguments2ImplicitType);
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ >= 0) {
                            return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root, Object arguments2Value) {
                    return new Initialize6Node_(root, arguments2Value);
                }
            }

            @GeneratedBy(methodName="initializeNegative(DynamicObject, int, int, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeNegative2Node_
            extends BaseNode_ {
                InitializeNegative2Node_(InitializeNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments3Value_;
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments1Value_ < 0) {
                        return this.root.initializeNegative(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof Integer && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        int arguments2Value_ = (Integer)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ < 0) {
                            return this.root.initializeNegative(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new InitializeNegative2Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, int, int, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class Initialize5Node_
            extends BaseNode_ {
                Initialize5Node_(InitializeNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments3Value_;
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments1Value_ >= 0) {
                        return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof Integer && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        int arguments2Value_ = (Integer)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ >= 0) {
                            return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize5Node_(root);
                }
            }

            @GeneratedBy(methodName="initializeNegative(DynamicObject, long, NotProvided, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeNegative1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                InitializeNegative1Node_(InitializeNodeGen root, Object arguments1Value) {
                    super(root, 7);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((InitializeNegative1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments3Value_;
                    NotProvided arguments2Value_;
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments1Value_ < 0L) {
                        return this.root.initializeNegative(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType) && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ < 0L) {
                            return this.root.initializeNegative(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root, Object arguments1Value) {
                    return new InitializeNegative1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, long, NotProvided, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class Initialize4Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Initialize4Node_(InitializeNodeGen root, Object arguments1Value) {
                    super(root, 6);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Initialize4Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments3Value_;
                    NotProvided arguments2Value_;
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments1Value_ >= 0L) {
                        return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType) && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ >= 0L) {
                            return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root, Object arguments1Value) {
                    return new Initialize4Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="initializeNegative(DynamicObject, int, NotProvided, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeNegative0Node_
            extends BaseNode_ {
                InitializeNegative0Node_(InitializeNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments3Value_;
                    NotProvided arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments1Value_ < 0) {
                        return this.root.initializeNegative(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ < 0) {
                            return this.root.initializeNegative(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new InitializeNegative0Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, int, NotProvided, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class Initialize3Node_
            extends BaseNode_ {
                Initialize3Node_(InitializeNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments3Value_;
                    NotProvided arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments1Value_ >= 0) {
                        return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ >= 0) {
                            return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize3Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, NotProvided, NotProvided, DynamicObject)", value=ArrayNodes.InitializeNode.class)
            private static final class Initialize2Node_
            extends BaseNode_ {
                Initialize2Node_(InitializeNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (RubyGuards.isRubyProc(arguments3Value_)) {
                            return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize2Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, NotProvided, NotProvided, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class Initialize1Node_
            extends BaseNode_ {
                Initialize1Node_(InitializeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize1Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(VirtualFrame, DynamicObject, Object, NotProvided, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class Initialize0Node_
            extends BaseNode_ {
                Initialize0Node_(InitializeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments1Value) && !RubyGuards.isRubyArray(arguments1Value)) {
                            return this.root.initialize(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize0Node_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InitializeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InitializeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InitializeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InitializeNodeGen root;

                BaseNode_(InitializeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    return InitializeNodeGen.expectDynamicObject(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments3Value_;
                        if (arguments2Value instanceof NotProvided) {
                            DynamicObject arguments3Value_2;
                            if (arguments3Value instanceof NotProvided) {
                                if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments1Value) && !RubyGuards.isRubyArray(arguments1Value)) {
                                    return Initialize0Node_.create(this.root);
                                }
                                if (arguments1Value instanceof NotProvided) {
                                    return Initialize1Node_.create(this.root);
                                }
                            }
                            if (arguments1Value instanceof NotProvided && arguments3Value instanceof DynamicObject && RubyGuards.isRubyProc(arguments3Value_2 = (DynamicObject)arguments3Value)) {
                                return Initialize2Node_.create(this.root);
                            }
                            if (arguments3Value instanceof NotProvided) {
                                if (arguments1Value instanceof Integer) {
                                    int arguments1Value_ = (Integer)arguments1Value;
                                    if (arguments1Value_ >= 0) {
                                        return Initialize3Node_.create(this.root);
                                    }
                                    if (arguments1Value_ < 0) {
                                        return InitializeNegative0Node_.create(this.root);
                                    }
                                }
                                if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                                    long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value);
                                    if (arguments1Value_ >= 0L) {
                                        return Initialize4Node_.create(this.root, arguments1Value);
                                    }
                                    if (arguments1Value_ < 0L) {
                                        return InitializeNegative1Node_.create(this.root, arguments1Value);
                                    }
                                }
                            }
                        }
                        if (arguments3Value instanceof NotProvided) {
                            if (arguments1Value instanceof Integer) {
                                int arguments1Value_ = (Integer)arguments1Value;
                                if (arguments2Value instanceof Integer) {
                                    if (arguments1Value_ >= 0) {
                                        return Initialize5Node_.create(this.root);
                                    }
                                    if (arguments1Value_ < 0) {
                                        return InitializeNegative2Node_.create(this.root);
                                    }
                                }
                                if (RubyTypesGen.isImplicitLong(arguments2Value)) {
                                    if (arguments1Value_ >= 0) {
                                        return Initialize6Node_.create(this.root, arguments2Value);
                                    }
                                    if (arguments1Value_ < 0) {
                                        return InitializeNegative3Node_.create(this.root, arguments2Value);
                                    }
                                }
                                if (arguments2Value instanceof Double) {
                                    if (arguments1Value_ >= 0) {
                                        return Initialize7Node_.create(this.root);
                                    }
                                    if (arguments1Value_ < 0) {
                                        return InitializeNegative4Node_.create(this.root);
                                    }
                                }
                                if (RubyGuards.wasProvided(arguments2Value) && arguments1Value_ >= 0) {
                                    return Initialize8Node_.create(this.root);
                                }
                                if (RubyGuards.wasProvided(arguments2Value) && arguments1Value_ < 0) {
                                    return InitializeNegative5Node_.create(this.root);
                                }
                            }
                            if (RubyGuards.wasProvided(arguments1Value) && !RubyGuards.isInteger(arguments1Value) && RubyGuards.wasProvided(arguments2Value)) {
                                return Initialize9Node_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof Integer && arguments3Value instanceof DynamicObject) {
                            int arguments1Value_ = (Integer)arguments1Value;
                            arguments3Value_ = (DynamicObject)arguments3Value;
                            if (RubyGuards.wasProvided(arguments2Value) && arguments1Value_ >= 0 && RubyGuards.isRubyProc(arguments3Value_)) {
                                return Initialize10Node_.create(this.root);
                            }
                            if (RubyGuards.wasProvided(arguments2Value) && arguments1Value_ < 0 && RubyGuards.isRubyProc(arguments3Value_)) {
                                return InitializeNegative6Node_.create(this.root);
                            }
                            if (arguments2Value instanceof NotProvided) {
                                if (arguments1Value_ >= 0 && RubyGuards.isRubyProc(arguments3Value_)) {
                                    return Initialize11Node_.create(this.root);
                                }
                                if (arguments1Value_ < 0 && RubyGuards.isRubyProc(arguments3Value_)) {
                                    return InitializeNegative7Node_.create(this.root);
                                }
                            }
                        }
                        if (arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                            DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                            if (arguments3Value instanceof NotProvided && RubyGuards.isRubyArray(arguments1Value_)) {
                                return Initialize12Node_.create(this.root);
                            }
                            if (arguments3Value instanceof DynamicObject) {
                                arguments3Value_ = (DynamicObject)arguments3Value;
                                if (RubyGuards.isRubyArray(arguments1Value_) && RubyGuards.isRubyProc(arguments3Value_)) {
                                    return Initialize13Node_.create(this.root);
                                }
                            }
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    throw new UnexpectedResultException(arguments1Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Double.TYPE) {
                        return this.root.arguments2_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ == Long.TYPE) {
                        return this.root.arguments2_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }

                protected final long executeArguments2Long_(Frame frameValue, Class<?> arguments2ImplicitType) throws UnexpectedResultException {
                    if (arguments2ImplicitType == Long.TYPE) {
                        return this.root.arguments2_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments2ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments2_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments2Value_ = this.executeArguments2_(frameValue);
                    throw new UnexpectedResultException(arguments2Value_);
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.IncludeNode.class)
    public static final class IncludeNodeFactory
    extends NodeFactoryBase<ArrayNodes.IncludeNode> {
        private static IncludeNodeFactory includeNodeFactoryInstance;

        private IncludeNodeFactory() {
            super(ArrayNodes.IncludeNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.IncludeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IncludeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.IncludeNode> getInstance() {
            if (includeNodeFactoryInstance == null) {
                includeNodeFactoryInstance = new IncludeNodeFactory();
            }
            return includeNodeFactoryInstance;
        }

        public static ArrayNodes.IncludeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IncludeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        public static final class IncludeNodeGen
        extends ArrayNodes.IncludeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private IncludeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="includeObject(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.IncludeNode.class)
            private static final class IncludeObjectNode_
            extends BaseNode_ {
                IncludeObjectNode_(IncludeNodeGen root) {
                    super(root, 5);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    if (ArrayGuards.isObjectArray(arguments0Value_)) {
                        return this.root.includeObject(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isObjectArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.includeObject(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IncludeNodeGen root) {
                    return new IncludeObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="includeFloat(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.IncludeNode.class)
            private static final class IncludeFloatNode_
            extends BaseNode_ {
                IncludeFloatNode_(IncludeNodeGen root) {
                    super(root, 4);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                        return this.root.includeFloat(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isDoubleArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.includeFloat(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IncludeNodeGen root) {
                    return new IncludeFloatNode_(root);
                }
            }

            @GeneratedBy(methodName="includeLongFixnum(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.IncludeNode.class)
            private static final class IncludeLongFixnumNode_
            extends BaseNode_ {
                IncludeLongFixnumNode_(IncludeNodeGen root) {
                    super(root, 3);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    if (ArrayGuards.isLongArray(arguments0Value_)) {
                        return this.root.includeLongFixnum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isLongArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.includeLongFixnum(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IncludeNodeGen root) {
                    return new IncludeLongFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="includeIntegerFixnum(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.IncludeNode.class)
            private static final class IncludeIntegerFixnumNode_
            extends BaseNode_ {
                IncludeIntegerFixnumNode_(IncludeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    if (ArrayGuards.isIntArray(arguments0Value_)) {
                        return this.root.includeIntegerFixnum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isIntArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.includeIntegerFixnum(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IncludeNodeGen root) {
                    return new IncludeIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="includeNull(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.IncludeNode.class)
            private static final class IncludeNullNode_
            extends BaseNode_ {
                IncludeNullNode_(IncludeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    if (ArrayGuards.isNullArray(arguments0Value_)) {
                        return this.root.includeNull(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isNullArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.includeNull(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IncludeNodeGen root) {
                    return new IncludeNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IncludeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(IncludeNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IncludeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IncludeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(IncludeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IncludeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IncludeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final IncludeNodeGen root;

                BaseNode_(IncludeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return IncludeNullNode_.create(this.root);
                        }
                        if (ArrayGuards.isIntArray(arguments0Value_)) {
                            return IncludeIntegerFixnumNode_.create(this.root);
                        }
                        if (ArrayGuards.isLongArray(arguments0Value_)) {
                            return IncludeLongFixnumNode_.create(this.root);
                        }
                        if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                            return IncludeFloatNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(arguments0Value_)) {
                            return IncludeObjectNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
    public static final class EachWithIndexNodeFactory
    extends NodeFactoryBase<ArrayNodes.EachWithIndexNode> {
        private static EachWithIndexNodeFactory eachWithIndexNodeFactoryInstance;

        private EachWithIndexNodeFactory() {
            super(ArrayNodes.EachWithIndexNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.EachWithIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachWithIndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.EachWithIndexNode> getInstance() {
            if (eachWithIndexNodeFactoryInstance == null) {
                eachWithIndexNodeFactoryInstance = new EachWithIndexNodeFactory();
            }
            return eachWithIndexNodeFactoryInstance;
        }

        public static ArrayNodes.EachWithIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EachWithIndexNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        public static final class EachWithIndexNodeGen
        extends ArrayNodes.EachWithIndexNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EachWithIndexNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="eachWithIndexObject(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.EachWithIndexNode.class)
            private static final class EachWithIndexObject1Node_
            extends BaseNode_ {
                EachWithIndexObject1Node_(EachWithIndexNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.eachWithIndexObject(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachWithIndexNodeGen root) {
                    return new EachWithIndexObject1Node_(root);
                }
            }

            @GeneratedBy(methodName="eachWithIndexObject(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.EachWithIndexNode.class)
            private static final class EachWithIndexObject0Node_
            extends BaseNode_ {
                EachWithIndexObject0Node_(EachWithIndexNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachWithIndexObject(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachWithIndexNodeGen root) {
                    return new EachWithIndexObject0Node_(root);
                }
            }

            @GeneratedBy(methodName="eachWithIndexDouble(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.EachWithIndexNode.class)
            private static final class EachWithIndexDoubleNode_
            extends BaseNode_ {
                EachWithIndexDoubleNode_(EachWithIndexNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachWithIndexDouble(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachWithIndexNodeGen root) {
                    return new EachWithIndexDoubleNode_(root);
                }
            }

            @GeneratedBy(methodName="eachWithIndexLong(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.EachWithIndexNode.class)
            private static final class EachWithIndexLongNode_
            extends BaseNode_ {
                EachWithIndexLongNode_(EachWithIndexNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachWithIndexLong(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachWithIndexNodeGen root) {
                    return new EachWithIndexLongNode_(root);
                }
            }

            @GeneratedBy(methodName="eachWithIndexInt(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.EachWithIndexNode.class)
            private static final class EachWithIndexIntNode_
            extends BaseNode_ {
                EachWithIndexIntNode_(EachWithIndexNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachWithIndexInt(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachWithIndexNodeGen root) {
                    return new EachWithIndexIntNode_(root);
                }
            }

            @GeneratedBy(methodName="eachWithEmpty(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.EachWithIndexNode.class)
            private static final class EachWithEmptyNode_
            extends BaseNode_ {
                EachWithEmptyNode_(EachWithIndexNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachWithEmpty(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachWithIndexNodeGen root) {
                    return new EachWithEmptyNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EachWithIndexNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachWithIndexNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EachWithIndexNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachWithIndexNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final EachWithIndexNodeGen root;

                BaseNode_(EachWithIndexNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments1Value instanceof DynamicObject) {
                            DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                            if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return EachWithEmptyNode_.create(this.root);
                            }
                            if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return EachWithIndexIntNode_.create(this.root);
                            }
                            if (ArrayGuards.isLongArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return EachWithIndexLongNode_.create(this.root);
                            }
                            if (ArrayGuards.isDoubleArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return EachWithIndexDoubleNode_.create(this.root);
                            }
                            if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return EachWithIndexObject0Node_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof NotProvided) {
                            return EachWithIndexObject1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.EachNode.class)
    public static final class EachNodeFactory
    extends NodeFactoryBase<ArrayNodes.EachNode> {
        private static EachNodeFactory eachNodeFactoryInstance;

        private EachNodeFactory() {
            super(ArrayNodes.EachNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.EachNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.EachNode> getInstance() {
            if (eachNodeFactoryInstance == null) {
                eachNodeFactoryInstance = new EachNodeFactory();
            }
            return eachNodeFactoryInstance;
        }

        public static ArrayNodes.EachNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EachNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        public static final class EachNodeGen
        extends ArrayNodes.EachNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EachNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="eachObject(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.EachNode.class)
            private static final class EachObjectNode_
            extends BaseNode_ {
                EachObjectNode_(EachNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachObject(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="eachFloat(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.EachNode.class)
            private static final class EachFloatNode_
            extends BaseNode_ {
                EachFloatNode_(EachNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachFloat(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachFloatNode_(root);
                }
            }

            @GeneratedBy(methodName="eachLongFixnum(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.EachNode.class)
            private static final class EachLongFixnumNode_
            extends BaseNode_ {
                EachLongFixnumNode_(EachNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachLongFixnum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachLongFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="eachIntegerFixnum(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.EachNode.class)
            private static final class EachIntegerFixnumNode_
            extends BaseNode_ {
                EachIntegerFixnumNode_(EachNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachIntegerFixnum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="eachNull(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.EachNode.class)
            private static final class EachNullNode_
            extends BaseNode_ {
                EachNullNode_(EachNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachNull(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachNullNode_(root);
                }
            }

            @GeneratedBy(methodName="eachEnumerator(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.EachNode.class)
            private static final class EachEnumeratorNode_
            extends BaseNode_ {
                EachEnumeratorNode_(EachNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.eachEnumerator(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachEnumeratorNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.EachNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EachNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.EachNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EachNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.EachNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final EachNodeGen root;

                BaseNode_(EachNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments1Value instanceof NotProvided) {
                            return EachEnumeratorNode_.create(this.root);
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                            if (ArrayGuards.isNullArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return EachNullNode_.create(this.root);
                            }
                            if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return EachIntegerFixnumNode_.create(this.root);
                            }
                            if (ArrayGuards.isLongArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return EachLongFixnumNode_.create(this.root);
                            }
                            if (ArrayGuards.isDoubleArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return EachFloatNode_.create(this.root);
                            }
                            if (ArrayGuards.isObjectArray(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return EachObjectNode_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
    public static final class DeleteAtNodeFactory
    extends NodeFactoryBase<ArrayNodes.DeleteAtNode> {
        private static DeleteAtNodeFactory deleteAtNodeFactoryInstance;

        private DeleteAtNodeFactory() {
            super(ArrayNodes.DeleteAtNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.DeleteAtNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return DeleteAtNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.DeleteAtNode> getInstance() {
            if (deleteAtNodeFactoryInstance == null) {
                deleteAtNodeFactoryInstance = new DeleteAtNodeFactory();
            }
            return deleteAtNodeFactoryInstance;
        }

        public static ArrayNodes.DeleteAtNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
            return new DeleteAtNodeGen(context, sourceSection, array, index);
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        public static final class DeleteAtNodeGen
        extends ArrayNodes.DeleteAtNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode array_;
            @Node.Child
            private RubyNode index_;
            @CompilerDirectives.CompilationFinal
            private Class<?> indexType_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeDeleteAtIntegerFixnumInBounds_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeDeleteAtLongFixnumInBounds_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeDeleteAtFloatInBounds_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeDeleteAtObjectInBounds_;
            @Node.Child
            private BaseNode_ specialization_;

            private DeleteAtNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
                super(context, sourceSection);
                this.array_ = array;
                this.index_ = this.coerceOtherToInt(index);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="deleteAtNullOrEmpty(DynamicObject, int)", value=ArrayNodes.DeleteAtNode.class)
            private static final class DeleteAtNullOrEmptyNode_
            extends BaseNode_ {
                DeleteAtNullOrEmptyNode_(DeleteAtNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int indexValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), indexValue);
                    }
                    try {
                        indexValue_ = this.root.index_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arrayValue_, ex.getResult());
                    }
                    if (ArrayGuards.isEmptyArray(arrayValue_)) {
                        return this.root.deleteAtNullOrEmpty(arrayValue_, indexValue_);
                    }
                    return this.getNext().execute_(frameValue, arrayValue_, indexValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    if (arrayValue instanceof DynamicObject && indexValue instanceof Integer) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int indexValue_ = (Integer)indexValue;
                        if (ArrayGuards.isEmptyArray(arrayValue_)) {
                            return this.root.deleteAtNullOrEmpty(arrayValue_, indexValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(DeleteAtNodeGen root) {
                    return new DeleteAtNullOrEmptyNode_(root);
                }
            }

            @GeneratedBy(methodName="deleteAtObject(DynamicObject, int)", value=ArrayNodes.DeleteAtNode.class)
            private static final class DeleteAtObjectNode_
            extends BaseNode_ {
                DeleteAtObjectNode_(DeleteAtNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int indexValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), indexValue);
                    }
                    try {
                        indexValue_ = this.root.index_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arrayValue_, ex.getResult());
                    }
                    if (ArrayGuards.isObjectArray(arrayValue_)) {
                        return this.root.deleteAtObject(arrayValue_, indexValue_);
                    }
                    return this.getNext().execute_(frameValue, arrayValue_, indexValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    if (arrayValue instanceof DynamicObject && indexValue instanceof Integer) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int indexValue_ = (Integer)indexValue;
                        if (ArrayGuards.isObjectArray(arrayValue_)) {
                            return this.root.deleteAtObject(arrayValue_, indexValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(DeleteAtNodeGen root) {
                    return new DeleteAtObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="deleteAtObjectInBounds(DynamicObject, int)", value=ArrayNodes.DeleteAtNode.class)
            private static final class DeleteAtObjectInBoundsNode_
            extends BaseNode_ {
                DeleteAtObjectInBoundsNode_(DeleteAtNodeGen root) {
                    super(root, 7);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue) {
                    if (newNode.getClass() == DeleteAtObjectNode_.class) {
                        this.removeSame("Contained by deleteAtObject(DynamicObject, int)");
                    }
                    return super.merge(newNode, frameValue, arrayValue, indexValue);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int indexValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), indexValue);
                    }
                    try {
                        indexValue_ = this.root.index_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arrayValue_, ex.getResult());
                    }
                    if (ArrayGuards.isObjectArray(arrayValue_)) {
                        try {
                            return this.root.deleteAtObjectInBounds(arrayValue_, indexValue_);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeDeleteAtObjectInBounds_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, arrayValue_, indexValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue_, indexValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    if (arrayValue instanceof DynamicObject && indexValue instanceof Integer) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int indexValue_ = (Integer)indexValue;
                        if (ArrayGuards.isObjectArray(arrayValue_)) {
                            try {
                                return this.root.deleteAtObjectInBounds(arrayValue_, indexValue_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludeDeleteAtObjectInBounds_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arrayValue_, indexValue_);
                            }
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(DeleteAtNodeGen root) {
                    return new DeleteAtObjectInBoundsNode_(root);
                }
            }

            @GeneratedBy(methodName="deleteAtFloat(DynamicObject, int)", value=ArrayNodes.DeleteAtNode.class)
            private static final class DeleteAtFloatNode_
            extends BaseNode_ {
                DeleteAtFloatNode_(DeleteAtNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int indexValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), indexValue);
                    }
                    try {
                        indexValue_ = this.root.index_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arrayValue_, ex.getResult());
                    }
                    if (ArrayGuards.isDoubleArray(arrayValue_)) {
                        return this.root.deleteAtFloat(arrayValue_, indexValue_);
                    }
                    return this.getNext().execute_(frameValue, arrayValue_, indexValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    if (arrayValue instanceof DynamicObject && indexValue instanceof Integer) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int indexValue_ = (Integer)indexValue;
                        if (ArrayGuards.isDoubleArray(arrayValue_)) {
                            return this.root.deleteAtFloat(arrayValue_, indexValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(DeleteAtNodeGen root) {
                    return new DeleteAtFloatNode_(root);
                }
            }

            @GeneratedBy(methodName="deleteAtFloatInBounds(DynamicObject, int)", value=ArrayNodes.DeleteAtNode.class)
            private static final class DeleteAtFloatInBoundsNode_
            extends BaseNode_ {
                DeleteAtFloatInBoundsNode_(DeleteAtNodeGen root) {
                    super(root, 5);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue) {
                    if (newNode.getClass() == DeleteAtFloatNode_.class) {
                        this.removeSame("Contained by deleteAtFloat(DynamicObject, int)");
                    }
                    return super.merge(newNode, frameValue, arrayValue, indexValue);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    int indexValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_((Frame)frameValue);
                        return DeleteAtNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), indexValue));
                    }
                    try {
                        indexValue_ = this.root.index_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return DeleteAtNodeGen.expectDouble(this.getNext().execute_(frameValue, arrayValue_, ex.getResult()));
                    }
                    if (ArrayGuards.isDoubleArray(arrayValue_)) {
                        try {
                            return this.root.deleteAtFloatInBounds(arrayValue_, indexValue_);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeDeleteAtFloatInBounds_ = true;
                            return DeleteAtNodeGen.expectDouble(this.remove("threw rewrite exception", (Frame)frameValue, arrayValue_, indexValue_));
                        }
                    }
                    return DeleteAtNodeGen.expectDouble(this.getNext().execute_(frameValue, arrayValue_, indexValue_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    if (arrayValue instanceof DynamicObject && indexValue instanceof Integer) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int indexValue_ = (Integer)indexValue;
                        if (ArrayGuards.isDoubleArray(arrayValue_)) {
                            try {
                                return this.root.deleteAtFloatInBounds(arrayValue_, indexValue_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludeDeleteAtFloatInBounds_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arrayValue_, indexValue_);
                            }
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(DeleteAtNodeGen root) {
                    return new DeleteAtFloatInBoundsNode_(root);
                }
            }

            @GeneratedBy(methodName="deleteAtLongFixnum(DynamicObject, int)", value=ArrayNodes.DeleteAtNode.class)
            private static final class DeleteAtLongFixnumNode_
            extends BaseNode_ {
                DeleteAtLongFixnumNode_(DeleteAtNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int indexValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), indexValue);
                    }
                    try {
                        indexValue_ = this.root.index_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arrayValue_, ex.getResult());
                    }
                    if (ArrayGuards.isLongArray(arrayValue_)) {
                        return this.root.deleteAtLongFixnum(arrayValue_, indexValue_);
                    }
                    return this.getNext().execute_(frameValue, arrayValue_, indexValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    if (arrayValue instanceof DynamicObject && indexValue instanceof Integer) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int indexValue_ = (Integer)indexValue;
                        if (ArrayGuards.isLongArray(arrayValue_)) {
                            return this.root.deleteAtLongFixnum(arrayValue_, indexValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(DeleteAtNodeGen root) {
                    return new DeleteAtLongFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="deleteAtLongFixnumInBounds(DynamicObject, int)", value=ArrayNodes.DeleteAtNode.class)
            private static final class DeleteAtLongFixnumInBoundsNode_
            extends BaseNode_ {
                DeleteAtLongFixnumInBoundsNode_(DeleteAtNodeGen root) {
                    super(root, 3);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue) {
                    if (newNode.getClass() == DeleteAtLongFixnumNode_.class) {
                        this.removeSame("Contained by deleteAtLongFixnum(DynamicObject, int)");
                    }
                    return super.merge(newNode, frameValue, arrayValue, indexValue);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    int indexValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_((Frame)frameValue);
                        return DeleteAtNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), indexValue));
                    }
                    try {
                        indexValue_ = this.root.index_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return DeleteAtNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, ex.getResult()));
                    }
                    if (ArrayGuards.isLongArray(arrayValue_)) {
                        try {
                            return this.root.deleteAtLongFixnumInBounds(arrayValue_, indexValue_);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeDeleteAtLongFixnumInBounds_ = true;
                            return DeleteAtNodeGen.expectLong(this.remove("threw rewrite exception", (Frame)frameValue, arrayValue_, indexValue_));
                        }
                    }
                    return DeleteAtNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, indexValue_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    if (arrayValue instanceof DynamicObject && indexValue instanceof Integer) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int indexValue_ = (Integer)indexValue;
                        if (ArrayGuards.isLongArray(arrayValue_)) {
                            try {
                                return this.root.deleteAtLongFixnumInBounds(arrayValue_, indexValue_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludeDeleteAtLongFixnumInBounds_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arrayValue_, indexValue_);
                            }
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(DeleteAtNodeGen root) {
                    return new DeleteAtLongFixnumInBoundsNode_(root);
                }
            }

            @GeneratedBy(methodName="deleteAtIntegerFixnum(DynamicObject, int)", value=ArrayNodes.DeleteAtNode.class)
            private static final class DeleteAtIntegerFixnumNode_
            extends BaseNode_ {
                DeleteAtIntegerFixnumNode_(DeleteAtNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int indexValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), indexValue);
                    }
                    try {
                        indexValue_ = this.root.index_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arrayValue_, ex.getResult());
                    }
                    if (ArrayGuards.isIntArray(arrayValue_)) {
                        return this.root.deleteAtIntegerFixnum(arrayValue_, indexValue_);
                    }
                    return this.getNext().execute_(frameValue, arrayValue_, indexValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    if (arrayValue instanceof DynamicObject && indexValue instanceof Integer) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int indexValue_ = (Integer)indexValue;
                        if (ArrayGuards.isIntArray(arrayValue_)) {
                            return this.root.deleteAtIntegerFixnum(arrayValue_, indexValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(DeleteAtNodeGen root) {
                    return new DeleteAtIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="deleteAtIntegerFixnumInBounds(DynamicObject, int)", value=ArrayNodes.DeleteAtNode.class)
            private static final class DeleteAtIntegerFixnumInBoundsNode_
            extends BaseNode_ {
                DeleteAtIntegerFixnumInBoundsNode_(DeleteAtNodeGen root) {
                    super(root, 1);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue) {
                    if (newNode.getClass() == DeleteAtIntegerFixnumNode_.class) {
                        this.removeSame("Contained by deleteAtIntegerFixnum(DynamicObject, int)");
                    }
                    return super.merge(newNode, frameValue, arrayValue, indexValue);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int indexValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_((Frame)frameValue);
                        return DeleteAtNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), indexValue));
                    }
                    try {
                        indexValue_ = this.root.index_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return DeleteAtNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, ex.getResult()));
                    }
                    if (ArrayGuards.isIntArray(arrayValue_)) {
                        try {
                            return this.root.deleteAtIntegerFixnumInBounds(arrayValue_, indexValue_);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeDeleteAtIntegerFixnumInBounds_ = true;
                            return DeleteAtNodeGen.expectInteger(this.remove("threw rewrite exception", (Frame)frameValue, arrayValue_, indexValue_));
                        }
                    }
                    return DeleteAtNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, indexValue_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    if (arrayValue instanceof DynamicObject && indexValue instanceof Integer) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int indexValue_ = (Integer)indexValue;
                        if (ArrayGuards.isIntArray(arrayValue_)) {
                            try {
                                return this.root.deleteAtIntegerFixnumInBounds(arrayValue_, indexValue_);
                            }
                            catch (UnexpectedResultException ex) {
                                this.root.excludeDeleteAtIntegerFixnumInBounds_ = true;
                                return this.remove("threw rewrite exception", (Frame)frameValue, arrayValue_, indexValue_);
                            }
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(DeleteAtNodeGen root) {
                    return new DeleteAtIntegerFixnumInBoundsNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DeleteAtNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, indexValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    return this.getNext().execute_(frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(DeleteAtNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DeleteAtNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    return this.uninitialized((Frame)frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(DeleteAtNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final DeleteAtNodeGen root;

                BaseNode_(DeleteAtNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.array_, this.root.index_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object indexValue) {
                    return this.execute_((VirtualFrame)frameValue, arrayValue, indexValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arrayValue_ = this.root.array_.execute(frameValue);
                    Object indexValue_ = this.executeIndex_((Frame)frameValue);
                    return this.execute_(frameValue, arrayValue_, indexValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return DeleteAtNodeGen.expectDouble(this.execute(frameValue));
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return DeleteAtNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return DeleteAtNodeGen.expectLong(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object indexValue) {
                    if (arrayValue instanceof DynamicObject && indexValue instanceof Integer) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        if (ArrayGuards.isIntArray(arrayValue_) && !this.root.excludeDeleteAtIntegerFixnumInBounds_) {
                            return DeleteAtIntegerFixnumInBoundsNode_.create(this.root);
                        }
                        if (ArrayGuards.isIntArray(arrayValue_)) {
                            this.root.excludeDeleteAtIntegerFixnumInBounds_ = true;
                            return DeleteAtIntegerFixnumNode_.create(this.root);
                        }
                        if (ArrayGuards.isLongArray(arrayValue_) && !this.root.excludeDeleteAtLongFixnumInBounds_) {
                            return DeleteAtLongFixnumInBoundsNode_.create(this.root);
                        }
                        if (ArrayGuards.isLongArray(arrayValue_)) {
                            this.root.excludeDeleteAtLongFixnumInBounds_ = true;
                            return DeleteAtLongFixnumNode_.create(this.root);
                        }
                        if (ArrayGuards.isDoubleArray(arrayValue_) && !this.root.excludeDeleteAtFloatInBounds_) {
                            return DeleteAtFloatInBoundsNode_.create(this.root);
                        }
                        if (ArrayGuards.isDoubleArray(arrayValue_)) {
                            this.root.excludeDeleteAtFloatInBounds_ = true;
                            return DeleteAtFloatNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(arrayValue_) && !this.root.excludeDeleteAtObjectInBounds_) {
                            return DeleteAtObjectInBoundsNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(arrayValue_)) {
                            this.root.excludeDeleteAtObjectInBounds_ = true;
                            return DeleteAtObjectNode_.create(this.root);
                        }
                        if (ArrayGuards.isEmptyArray(arrayValue_)) {
                            return DeleteAtNullOrEmptyNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeIndex_(Frame frameValue) {
                    Object object;
                    Class indexType_ = this.root.indexType_;
                    if (indexType_ == Integer.TYPE) {
                        return this.root.index_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.indexType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.indexType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.indexType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.DeleteNode.class)
    public static final class DeleteNodeFactory
    extends NodeFactoryBase<ArrayNodes.DeleteNode> {
        private static DeleteNodeFactory deleteNodeFactoryInstance;

        private DeleteNodeFactory() {
            super(ArrayNodes.DeleteNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.DeleteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DeleteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.DeleteNode> getInstance() {
            if (deleteNodeFactoryInstance == null) {
                deleteNodeFactoryInstance = new DeleteNodeFactory();
            }
            return deleteNodeFactoryInstance;
        }

        public static ArrayNodes.DeleteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DeleteNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.DeleteNode.class)
        public static final class DeleteNodeGen
        extends ArrayNodes.DeleteNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private DeleteNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="deleteNull(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.DeleteNode.class)
            private static final class DeleteNullNode_
            extends BaseNode_ {
                DeleteNullNode_(DeleteNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isNullArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.deleteNull(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new DeleteNullNode_(root);
                }
            }

            @GeneratedBy(methodName="deleteObject(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.DeleteNode.class)
            private static final class DeleteObjectNode_
            extends BaseNode_ {
                DeleteObjectNode_(DeleteNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isObjectArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.deleteObject(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new DeleteObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="deleteIntegerFixnum(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.DeleteNode.class)
            private static final class DeleteIntegerFixnumNode_
            extends BaseNode_ {
                DeleteIntegerFixnumNode_(DeleteNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isIntArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.deleteIntegerFixnum(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new DeleteIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DeleteNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DeleteNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final DeleteNodeGen root;

                BaseNode_(DeleteNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isIntArray(arguments0Value_)) {
                            return DeleteIntegerFixnumNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(arguments0Value_)) {
                            return DeleteObjectNode_.create(this.root);
                        }
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return DeleteNullNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ConcatNode.class)
    public static final class ConcatNodeFactory
    extends NodeFactoryBase<ArrayNodes.ConcatNode> {
        private static ConcatNodeFactory concatNodeFactoryInstance;

        private ConcatNodeFactory() {
            super(ArrayNodes.ConcatNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.ConcatNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ConcatNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.ConcatNode> getInstance() {
            if (concatNodeFactoryInstance == null) {
                concatNodeFactoryInstance = new ConcatNodeFactory();
            }
            return concatNodeFactoryInstance;
        }

        public static ArrayNodes.ConcatNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode other) {
            return new ConcatNodeGen(context, sourceSection, array, other);
        }

        @GeneratedBy(value=ArrayNodes.ConcatNode.class)
        public static final class ConcatNodeGen
        extends ArrayNodes.ConcatNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode array_;
            @Node.Child
            private RubyNode other_;
            @Node.Child
            private BaseNode_ specialization_;

            private ConcatNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode other) {
                super(context, sourceSection);
                this.array_ = array;
                this.other_ = this.coerceOtherToAry(other);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="concat(DynamicObject, DynamicObject)", value=ArrayNodes.ConcatNode.class)
            private static final class ConcatNode_
            extends BaseNode_ {
                ConcatNode_(ConcatNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                    if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyArray(otherValue_) && !ArrayGuards.isNullArray(otherValue_)) {
                            return this.root.concat(arrayValue_, otherValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arrayValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root) {
                    return new ConcatNode_(root);
                }
            }

            @GeneratedBy(methodName="concatNull(DynamicObject, DynamicObject)", value=ArrayNodes.ConcatNode.class)
            private static final class ConcatNullNode_
            extends BaseNode_ {
                ConcatNullNode_(ConcatNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                    if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyArray(otherValue_) && ArrayGuards.isNullArray(otherValue_)) {
                            return this.root.concatNull(arrayValue_, otherValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arrayValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root) {
                    return new ConcatNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ConcatNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ConcatNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object otherValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, otherValue));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                    return this.getNext().executeDynamicObject_(frameValue, arrayValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ConcatNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ConcatNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arrayValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ConcatNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ConcatNodeGen root;

                BaseNode_(ConcatNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.array_, this.root.other_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object otherValue) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arrayValue, otherValue);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arrayValue_ = this.root.array_.execute(frameValue);
                    Object otherValue_ = this.root.other_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arrayValue_, otherValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object otherValue) {
                    if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyArray(otherValue_) && ArrayGuards.isNullArray(otherValue_)) {
                            return ConcatNullNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyArray(otherValue_) && !ArrayGuards.isNullArray(otherValue_)) {
                            return ConcatNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.CompactBangNode.class)
    public static final class CompactBangNodeFactory
    extends NodeFactoryBase<ArrayNodes.CompactBangNode> {
        private static CompactBangNodeFactory compactBangNodeFactoryInstance;

        private CompactBangNodeFactory() {
            super(ArrayNodes.CompactBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.CompactBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompactBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.CompactBangNode> getInstance() {
            if (compactBangNodeFactoryInstance == null) {
                compactBangNodeFactoryInstance = new CompactBangNodeFactory();
            }
            return compactBangNodeFactoryInstance;
        }

        public static ArrayNodes.CompactBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CompactBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.CompactBangNode.class)
        public static final class CompactBangNodeGen
        extends ArrayNodes.CompactBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private CompactBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="compactObjects(DynamicObject)", value=ArrayNodes.CompactBangNode.class)
            private static final class CompactObjectsNode_
            extends BaseNode_ {
                CompactObjectsNode_(CompactBangNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isObjectArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.compactObjects(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactBangNodeGen root) {
                    return new CompactObjectsNode_(root);
                }
            }

            @GeneratedBy(methodName="compactNotObjects(DynamicObject)", value=ArrayNodes.CompactBangNode.class)
            private static final class CompactNotObjectsNode_
            extends BaseNode_ {
                CompactNotObjectsNode_(CompactBangNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !ArrayGuards.isObjectArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.compactNotObjects(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactBangNodeGen root) {
                    return new CompactNotObjectsNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.CompactBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CompactBangNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.CompactBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CompactBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.CompactBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final CompactBangNodeGen root;

                BaseNode_(CompactBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!ArrayGuards.isObjectArray(arguments0Value_)) {
                            return CompactNotObjectsNode_.create(this.root);
                        }
                        return CompactObjectsNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.CompactNode.class)
    public static final class CompactNodeFactory
    extends NodeFactoryBase<ArrayNodes.CompactNode> {
        private static CompactNodeFactory compactNodeFactoryInstance;

        private CompactNodeFactory() {
            super(ArrayNodes.CompactNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.CompactNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompactNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.CompactNode> getInstance() {
            if (compactNodeFactoryInstance == null) {
                compactNodeFactoryInstance = new CompactNodeFactory();
            }
            return compactNodeFactoryInstance;
        }

        public static ArrayNodes.CompactNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CompactNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.CompactNode.class)
        public static final class CompactNodeGen
        extends ArrayNodes.CompactNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private CompactNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="compactNull(DynamicObject)", value=ArrayNodes.CompactNode.class)
            private static final class CompactNullNode_
            extends BaseNode_ {
                CompactNullNode_(CompactNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isNullArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.compactNull(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactNodeGen root) {
                    return new CompactNullNode_(root);
                }
            }

            @GeneratedBy(methodName="compactObjects(DynamicObject)", value=ArrayNodes.CompactNode.class)
            private static final class CompactObjectsNode_
            extends BaseNode_ {
                CompactObjectsNode_(CompactNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isObjectArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.compactObjects(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactNodeGen root) {
                    return new CompactObjectsNode_(root);
                }
            }

            @GeneratedBy(methodName="compactDouble(DynamicObject)", value=ArrayNodes.CompactNode.class)
            private static final class CompactDoubleNode_
            extends BaseNode_ {
                CompactDoubleNode_(CompactNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isDoubleArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.compactDouble(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactNodeGen root) {
                    return new CompactDoubleNode_(root);
                }
            }

            @GeneratedBy(methodName="compactLong(DynamicObject)", value=ArrayNodes.CompactNode.class)
            private static final class CompactLongNode_
            extends BaseNode_ {
                CompactLongNode_(CompactNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isLongArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.compactLong(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactNodeGen root) {
                    return new CompactLongNode_(root);
                }
            }

            @GeneratedBy(methodName="compactInt(DynamicObject)", value=ArrayNodes.CompactNode.class)
            private static final class CompactIntNode_
            extends BaseNode_ {
                CompactIntNode_(CompactNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isIntArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.compactInt(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactNodeGen root) {
                    return new CompactIntNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.CompactNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CompactNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.CompactNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CompactNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.CompactNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final CompactNodeGen root;

                BaseNode_(CompactNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isIntArray(arguments0Value_)) {
                            return CompactIntNode_.create(this.root);
                        }
                        if (ArrayGuards.isLongArray(arguments0Value_)) {
                            return CompactLongNode_.create(this.root);
                        }
                        if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                            return CompactDoubleNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(arguments0Value_)) {
                            return CompactObjectsNode_.create(this.root);
                        }
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return CompactNullNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ClearNode.class)
    public static final class ClearNodeFactory
    extends NodeFactoryBase<ArrayNodes.ClearNode> {
        private static ClearNodeFactory clearNodeFactoryInstance;

        private ClearNodeFactory() {
            super(ArrayNodes.ClearNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.ClearNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClearNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.ClearNode> getInstance() {
            if (clearNodeFactoryInstance == null) {
                clearNodeFactoryInstance = new ClearNodeFactory();
            }
            return clearNodeFactoryInstance;
        }

        public static ArrayNodes.ClearNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ClearNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.ClearNode.class)
        public static final class ClearNodeGen
        extends ArrayNodes.ClearNode {
            @Node.Child
            private RubyNode arguments0_;

            private ClearNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyArray(arguments0Value_)) {
                    return this.clear(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.AtNode.class)
    public static final class AtNodeFactory
    extends NodeFactoryBase<ArrayNodes.AtNode> {
        private static AtNodeFactory atNodeFactoryInstance;

        private AtNodeFactory() {
            super(ArrayNodes.AtNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.AtNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return AtNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.AtNode> getInstance() {
            if (atNodeFactoryInstance == null) {
                atNodeFactoryInstance = new AtNodeFactory();
            }
            return atNodeFactoryInstance;
        }

        public static ArrayNodes.AtNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
            return new AtNodeGen(context, sourceSection, array, index);
        }

        @GeneratedBy(value=ArrayNodes.AtNode.class)
        public static final class AtNodeGen
        extends ArrayNodes.AtNode {
            @Node.Child
            private RubyNode array_;
            @Node.Child
            private RubyNode index_;

            private AtNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
                super(context, sourceSection);
                this.array_ = array;
                this.index_ = this.coerceOtherToInt(index);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int indexValue_;
                DynamicObject arrayValue_;
                try {
                    arrayValue_ = this.array_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue = this.index_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), indexValue);
                }
                try {
                    indexValue_ = this.index_.executeInteger(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arrayValue_, ex.getResult());
                }
                return this.at(frameValue, arrayValue_, indexValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arrayValue, Object indexValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.array_, this.index_}, new Object[]{arrayValue, indexValue});
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
    public static final class IndexSetNodeFactory
    extends NodeFactoryBase<ArrayNodes.IndexSetNode> {
        private static IndexSetNodeFactory indexSetNodeFactoryInstance;

        private IndexSetNodeFactory() {
            super(ArrayNodes.IndexSetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.IndexSetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IndexSetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.IndexSetNode> getInstance() {
            if (indexSetNodeFactoryInstance == null) {
                indexSetNodeFactoryInstance = new IndexSetNodeFactory();
            }
            return indexSetNodeFactoryInstance;
        }

        public static ArrayNodes.IndexSetNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IndexSetNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        public static final class IndexSetNodeGen
        extends ArrayNodes.IndexSetNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private IndexSetNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="setIntegerFixnumRange(VirtualFrame, DynamicObject, DynamicObject, DynamicObject, NotProvided)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetIntegerFixnumRangeNode_
            extends BaseNode_ {
                SetIntegerFixnumRangeNode_(IndexSetNodeGen root) {
                    super(root, 13);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyArray(arguments2Value_) && ArrayGuards.isIntArray(arguments2Value_) && RubyGuards.isIntegerFixnumRange(arguments1Value_)) {
                            return this.root.setIntegerFixnumRange(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new SetIntegerFixnumRangeNode_(root);
                }
            }

            @GeneratedBy(methodName="setRangeArray(VirtualFrame, DynamicObject, DynamicObject, DynamicObject, NotProvided)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetRangeArrayNode_
            extends BaseNode_ {
                SetRangeArrayNode_(IndexSetNodeGen root) {
                    super(root, 12);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubyArray(arguments2Value_) && (!ArrayGuards.isIntArray(arguments0Value_) || !ArrayGuards.isIntArray(arguments2Value_)) && RubyGuards.isIntegerFixnumRange(arguments1Value_)) {
                            return this.root.setRangeArray(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new SetRangeArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="setRange(VirtualFrame, DynamicObject, DynamicObject, Object, NotProvided)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetRangeNode_
            extends BaseNode_ {
                SetRangeNode_(IndexSetNodeGen root) {
                    super(root, 11);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (!RubyGuards.isRubyArray(arguments2Value) && RubyGuards.isIntegerFixnumRange(arguments1Value_)) {
                            return this.root.setRange(frameValue, arguments0Value_, arguments1Value_, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new SetRangeNode_(root);
                }
            }

            @GeneratedBy(methodName="setOtherArray(VirtualFrame, DynamicObject, int, int, DynamicObject)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetOtherArray3Node_
            extends BaseNode_ {
                SetOtherArray3Node_(IndexSetNodeGen root) {
                    super(root, 10);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject arguments3Value_;
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyArray(arguments3Value_)) {
                        return this.root.setOtherArray(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof Integer && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        int arguments2Value_ = (Integer)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (RubyGuards.isRubyArray(arguments3Value_)) {
                            return this.root.setOtherArray(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new SetOtherArray3Node_(root);
                }
            }

            @GeneratedBy(methodName="setOtherArray(VirtualFrame, DynamicObject, Object, Object, DynamicObject)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetOtherArray2Node_
            extends BaseNode_ {
                SetOtherArray2Node_(IndexSetNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isInteger(arguments2Value) && RubyGuards.isRubyArray(arguments3Value_)) {
                            return this.root.setOtherArray(frameValue, arguments0Value_, arguments1Value, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new SetOtherArray2Node_(root);
                }
            }

            @GeneratedBy(methodName="setOtherArray(VirtualFrame, DynamicObject, int, Object, DynamicObject)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetOtherArray1Node_
            extends BaseNode_ {
                SetOtherArray1Node_(IndexSetNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject arguments3Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    try {
                        arguments3Value_ = this.root.arguments3_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    if (!RubyGuards.isInteger(arguments2Value_) && RubyGuards.isRubyArray(arguments3Value_)) {
                        return this.root.setOtherArray(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (!RubyGuards.isInteger(arguments2Value) && RubyGuards.isRubyArray(arguments3Value_)) {
                            return this.root.setOtherArray(frameValue, arguments0Value_, arguments1Value_, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new SetOtherArray1Node_(root);
                }
            }

            @GeneratedBy(methodName="setOtherArray(VirtualFrame, DynamicObject, Object, int, DynamicObject)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetOtherArray0Node_
            extends BaseNode_ {
                SetOtherArray0Node_(IndexSetNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject arguments3Value_;
                    int arguments2Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    try {
                        arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    if (!RubyGuards.isInteger(arguments1Value_) && RubyGuards.isRubyArray(arguments3Value_)) {
                        return this.root.setOtherArray(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof Integer && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments2Value_ = (Integer)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (!RubyGuards.isInteger(arguments1Value) && RubyGuards.isRubyArray(arguments3Value_)) {
                            return this.root.setOtherArray(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new SetOtherArray0Node_(root);
                }
            }

            @GeneratedBy(methodName="setObject(VirtualFrame, DynamicObject, int, int, Object)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetObject3Node_
            extends BaseNode_ {
                SetObject3Node_(IndexSetNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
                    }
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    if (!RubyGuards.isRubyArray(arguments3Value_) && RubyGuards.wasProvided(arguments3Value_)) {
                        return this.root.setObject(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        int arguments2Value_ = (Integer)arguments2Value;
                        if (!RubyGuards.isRubyArray(arguments3Value) && RubyGuards.wasProvided(arguments3Value)) {
                            return this.root.setObject(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new SetObject3Node_(root);
                }
            }

            @GeneratedBy(methodName="setObject(VirtualFrame, DynamicObject, Object, Object, Object)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetObject2Node_
            extends BaseNode_ {
                SetObject2Node_(IndexSetNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!RubyGuards.isRubyArray(arguments3Value) && RubyGuards.wasProvided(arguments3Value) && !RubyGuards.isInteger(arguments1Value) && !RubyGuards.isInteger(arguments2Value)) {
                            return this.root.setObject(frameValue, arguments0Value_, arguments1Value, arguments2Value, arguments3Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new SetObject2Node_(root);
                }
            }

            @GeneratedBy(methodName="setObject(VirtualFrame, DynamicObject, Object, int, Object)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetObject1Node_
            extends BaseNode_ {
                SetObject1Node_(IndexSetNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments2Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    try {
                        arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
                    }
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    if (!RubyGuards.isRubyArray(arguments3Value_) && RubyGuards.wasProvided(arguments3Value_) && !RubyGuards.isInteger(arguments1Value_)) {
                        return this.root.setObject(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments2Value_ = (Integer)arguments2Value;
                        if (!RubyGuards.isRubyArray(arguments3Value) && RubyGuards.wasProvided(arguments3Value) && !RubyGuards.isInteger(arguments1Value)) {
                            return this.root.setObject(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new SetObject1Node_(root);
                }
            }

            @GeneratedBy(methodName="setObject(VirtualFrame, DynamicObject, int, Object, Object)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetObject0Node_
            extends BaseNode_ {
                SetObject0Node_(IndexSetNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    if (!RubyGuards.isRubyArray(arguments3Value_) && RubyGuards.wasProvided(arguments3Value_) && !RubyGuards.isInteger(arguments2Value_)) {
                        return this.root.setObject(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (!RubyGuards.isRubyArray(arguments3Value) && RubyGuards.wasProvided(arguments3Value) && !RubyGuards.isInteger(arguments2Value)) {
                            return this.root.setObject(frameValue, arguments0Value_, arguments1Value_, arguments2Value, arguments3Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new SetObject0Node_(root);
                }
            }

            @GeneratedBy(methodName="set(VirtualFrame, DynamicObject, int, Object, NotProvided)", value=ArrayNodes.IndexSetNode.class)
            private static final class Set1Node_
            extends BaseNode_ {
                Set1Node_(IndexSetNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    NotProvided arguments3Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    return this.root.set(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        return this.root.set(frameValue, arguments0Value_, arguments1Value_, arguments2Value, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new Set1Node_(root);
                }
            }

            @GeneratedBy(methodName="set(VirtualFrame, DynamicObject, Object, Object, NotProvided)", value=ArrayNodes.IndexSetNode.class)
            private static final class Set0Node_
            extends BaseNode_ {
                Set0Node_(IndexSetNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isIntegerFixnumRange(arguments1Value)) {
                            return this.root.set(frameValue, arguments0Value_, arguments1Value, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new Set0Node_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(IndexSetNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(IndexSetNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final IndexSetNodeGen root;

                BaseNode_(IndexSetNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments3Value instanceof NotProvided) {
                            if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isIntegerFixnumRange(arguments1Value)) {
                                return Set0Node_.create(this.root);
                            }
                            if (arguments1Value instanceof Integer) {
                                return Set1Node_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof Integer && !RubyGuards.isRubyArray(arguments3Value) && RubyGuards.wasProvided(arguments3Value) && !RubyGuards.isInteger(arguments2Value)) {
                            return SetObject0Node_.create(this.root);
                        }
                        if (arguments2Value instanceof Integer && !RubyGuards.isRubyArray(arguments3Value) && RubyGuards.wasProvided(arguments3Value) && !RubyGuards.isInteger(arguments1Value)) {
                            return SetObject1Node_.create(this.root);
                        }
                        if (!RubyGuards.isRubyArray(arguments3Value) && RubyGuards.wasProvided(arguments3Value) && !RubyGuards.isInteger(arguments1Value) && !RubyGuards.isInteger(arguments2Value)) {
                            return SetObject2Node_.create(this.root);
                        }
                        if (arguments1Value instanceof Integer && arguments2Value instanceof Integer && !RubyGuards.isRubyArray(arguments3Value) && RubyGuards.wasProvided(arguments3Value)) {
                            return SetObject3Node_.create(this.root);
                        }
                        if (arguments3Value instanceof DynamicObject) {
                            DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                            if (arguments2Value instanceof Integer && !RubyGuards.isInteger(arguments1Value) && RubyGuards.isRubyArray(arguments3Value_)) {
                                return SetOtherArray0Node_.create(this.root);
                            }
                            if (arguments1Value instanceof Integer && !RubyGuards.isInteger(arguments2Value) && RubyGuards.isRubyArray(arguments3Value_)) {
                                return SetOtherArray1Node_.create(this.root);
                            }
                            if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isInteger(arguments2Value) && RubyGuards.isRubyArray(arguments3Value_)) {
                                return SetOtherArray2Node_.create(this.root);
                            }
                            if (arguments1Value instanceof Integer && arguments2Value instanceof Integer && RubyGuards.isRubyArray(arguments3Value_)) {
                                return SetOtherArray3Node_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                            DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                            if (!RubyGuards.isRubyArray(arguments2Value) && RubyGuards.isIntegerFixnumRange(arguments1Value_)) {
                                return SetRangeNode_.create(this.root);
                            }
                            if (arguments2Value instanceof DynamicObject) {
                                DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                                if (RubyGuards.isRubyArray(arguments2Value_) && (!ArrayGuards.isIntArray(arguments0Value_) || !ArrayGuards.isIntArray(arguments2Value_)) && RubyGuards.isIntegerFixnumRange(arguments1Value_)) {
                                    return SetRangeArrayNode_.create(this.root);
                                }
                                if (ArrayGuards.isIntArray(arguments0Value_) && RubyGuards.isRubyArray(arguments2Value_) && ArrayGuards.isIntArray(arguments2Value_) && RubyGuards.isIntegerFixnumRange(arguments1Value_)) {
                                    return SetIntegerFixnumRangeNode_.create(this.root);
                                }
                            }
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.IndexNode.class)
    public static final class IndexNodeFactory
    extends NodeFactoryBase<ArrayNodes.IndexNode> {
        private static IndexNodeFactory indexNodeFactoryInstance;

        private IndexNodeFactory() {
            super(ArrayNodes.IndexNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.IndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.IndexNode> getInstance() {
            if (indexNodeFactoryInstance == null) {
                indexNodeFactoryInstance = new IndexNodeFactory();
            }
            return indexNodeFactoryInstance;
        }

        public static ArrayNodes.IndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IndexNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.IndexNode.class)
        public static final class IndexNodeGen
        extends ArrayNodes.IndexNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private IndexNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="fallbackSlice(VirtualFrame, DynamicObject, Object, Object)", value=ArrayNodes.IndexNode.class)
            private static final class FallbackSliceNode_
            extends BaseNode_ {
                FallbackSliceNode_(IndexNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!RubyGuards.isIntegerFixnumRange(arguments1Value) && RubyGuards.wasProvided(arguments2Value)) {
                            return this.root.fallbackSlice(frameValue, arguments0Value_, arguments1Value, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(IndexNodeGen root) {
                    return new FallbackSliceNode_(root);
                }
            }

            @GeneratedBy(methodName="fallbackIndex(VirtualFrame, DynamicObject, Object, NotProvided)", value=ArrayNodes.IndexNode.class)
            private static final class FallbackIndexNode_
            extends BaseNode_ {
                FallbackIndexNode_(IndexNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isIntegerFixnumRange(arguments1Value)) {
                            return this.root.fallbackIndex(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(IndexNodeGen root) {
                    return new FallbackIndexNode_(root);
                }
            }

            @GeneratedBy(methodName="slice(VirtualFrame, DynamicObject, DynamicObject, NotProvided)", value=ArrayNodes.IndexNode.class)
            private static final class Slice1Node_
            extends BaseNode_ {
                Slice1Node_(IndexNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isIntegerFixnumRange(arguments1Value_)) {
                            return this.root.slice(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(IndexNodeGen root) {
                    return new Slice1Node_(root);
                }
            }

            @GeneratedBy(methodName="slice(VirtualFrame, DynamicObject, int, int)", value=ArrayNodes.IndexNode.class)
            private static final class Slice0Node_
            extends BaseNode_ {
                Slice0Node_(IndexNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    return this.root.slice(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        int arguments2Value_ = (Integer)arguments2Value;
                        return this.root.slice(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(IndexNodeGen root) {
                    return new Slice0Node_(root);
                }
            }

            @GeneratedBy(methodName="index(VirtualFrame, DynamicObject, int, NotProvided)", value=ArrayNodes.IndexNode.class)
            private static final class IndexNode_
            extends BaseNode_ {
                IndexNode_(IndexNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    NotProvided arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    return this.root.index(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.index(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(IndexNodeGen root) {
                    return new IndexNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IndexNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(IndexNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(IndexNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IndexNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(IndexNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(IndexNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IndexNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final IndexNodeGen root;

                BaseNode_(IndexNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (arguments1Value instanceof Integer) {
                            if (arguments2Value instanceof NotProvided) {
                                return IndexNode_.create(this.root);
                            }
                            if (arguments2Value instanceof Integer) {
                                return Slice0Node_.create(this.root);
                            }
                        }
                        if (arguments2Value instanceof NotProvided) {
                            DynamicObject arguments1Value_;
                            if (arguments1Value instanceof DynamicObject && RubyGuards.isIntegerFixnumRange(arguments1Value_ = (DynamicObject)arguments1Value)) {
                                return Slice1Node_.create(this.root);
                            }
                            if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isIntegerFixnumRange(arguments1Value)) {
                                return FallbackIndexNode_.create(this.root);
                            }
                        }
                        if (!RubyGuards.isIntegerFixnumRange(arguments1Value) && RubyGuards.wasProvided(arguments2Value)) {
                            return FallbackSliceNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MulNode.class)
    public static final class MulNodeFactory
    extends NodeFactoryBase<ArrayNodes.MulNode> {
        private static MulNodeFactory mulNodeFactoryInstance;

        private MulNodeFactory() {
            super(ArrayNodes.MulNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MulNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MulNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.MulNode> getInstance() {
            if (mulNodeFactoryInstance == null) {
                mulNodeFactoryInstance = new MulNodeFactory();
            }
            return mulNodeFactoryInstance;
        }

        public static ArrayNodes.MulNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MulNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.MulNode.class)
        public static final class MulNodeGen
        extends ArrayNodes.MulNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private MulNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static DynamicObject expectDynamicObject(Object value) throws UnexpectedResultException {
                if (value instanceof DynamicObject) {
                    return (DynamicObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="mulObjectCount(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.MulNode.class)
            private static final class MulObjectCountNode_
            extends BaseNode_ {
                MulObjectCountNode_(MulNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!RubyGuards.isRubyString(arguments1Value)) {
                            return this.root.mulObjectCount(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new MulObjectCountNode_(root);
                }
            }

            @GeneratedBy(methodName="mulObject(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.MulNode.class)
            private static final class MulObject1Node_
            extends BaseNode_ {
                MulObject1Node_(MulNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.mulObject(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new MulObject1Node_(root);
                }
            }

            @GeneratedBy(methodName="mulObject(DynamicObject, int)", value=ArrayNodes.MulNode.class)
            private static final class MulObject0Node_
            extends BaseNode_ {
                MulObject0Node_(MulNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (ArrayGuards.isObjectArray(arguments0Value_)) {
                        return this.root.mulObject(arguments0Value_, arguments1Value_);
                    }
                    return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isObjectArray(arguments0Value_)) {
                            return this.root.mulObject(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new MulObject0Node_(root);
                }
            }

            @GeneratedBy(methodName="mulFloat(DynamicObject, int)", value=ArrayNodes.MulNode.class)
            private static final class MulFloatNode_
            extends BaseNode_ {
                MulFloatNode_(MulNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                        return this.root.mulFloat(arguments0Value_, arguments1Value_);
                    }
                    return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                            return this.root.mulFloat(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new MulFloatNode_(root);
                }
            }

            @GeneratedBy(methodName="mulLongFixnum(DynamicObject, int)", value=ArrayNodes.MulNode.class)
            private static final class MulLongFixnumNode_
            extends BaseNode_ {
                MulLongFixnumNode_(MulNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (ArrayGuards.isLongArray(arguments0Value_)) {
                        return this.root.mulLongFixnum(arguments0Value_, arguments1Value_);
                    }
                    return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isLongArray(arguments0Value_)) {
                            return this.root.mulLongFixnum(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new MulLongFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="mulIntegerFixnum(DynamicObject, int)", value=ArrayNodes.MulNode.class)
            private static final class MulIntegerFixnumNode_
            extends BaseNode_ {
                MulIntegerFixnumNode_(MulNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (ArrayGuards.isIntArray(arguments0Value_)) {
                        return this.root.mulIntegerFixnum(arguments0Value_, arguments1Value_);
                    }
                    return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isIntArray(arguments0Value_)) {
                            return this.root.mulIntegerFixnum(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new MulIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="mulEmpty(DynamicObject, int)", value=ArrayNodes.MulNode.class)
            private static final class MulEmptyNode_
            extends BaseNode_ {
                MulEmptyNode_(MulNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (ArrayGuards.isNullArray(arguments0Value_)) {
                        return this.root.mulEmpty(arguments0Value_, arguments1Value_);
                    }
                    return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return this.root.mulEmpty(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new MulEmptyNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MulNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MulNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MulNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MulNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MulNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final MulNodeGen root;

                BaseNode_(MulNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    return MulNodeGen.expectDynamicObject(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments1Value instanceof Integer) {
                            if (ArrayGuards.isNullArray(arguments0Value_)) {
                                return MulEmptyNode_.create(this.root);
                            }
                            if (ArrayGuards.isIntArray(arguments0Value_)) {
                                return MulIntegerFixnumNode_.create(this.root);
                            }
                            if (ArrayGuards.isLongArray(arguments0Value_)) {
                                return MulLongFixnumNode_.create(this.root);
                            }
                            if (ArrayGuards.isDoubleArray(arguments0Value_)) {
                                return MulFloatNode_.create(this.root);
                            }
                            if (ArrayGuards.isObjectArray(arguments0Value_)) {
                                return MulObject0Node_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            return MulObject1Node_.create(this.root);
                        }
                        if (!RubyGuards.isRubyString(arguments1Value)) {
                            return MulObjectCountNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.AddNode.class)
    public static final class AddNodeFactory
    extends NodeFactoryBase<ArrayNodes.AddNode> {
        private static AddNodeFactory addNodeFactoryInstance;

        private AddNodeFactory() {
            super(ArrayNodes.AddNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.AddNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return AddNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.AddNode> getInstance() {
            if (addNodeFactoryInstance == null) {
                addNodeFactoryInstance = new AddNodeFactory();
            }
            return addNodeFactoryInstance;
        }

        public static ArrayNodes.AddNode create(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
            return new AddNodeGen(context, sourceSection, a, b);
        }

        @GeneratedBy(value=ArrayNodes.AddNode.class)
        public static final class AddNodeGen
        extends ArrayNodes.AddNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode a_;
            @Node.Child
            private RubyNode b_;
            @Node.Child
            private BaseNode_ specialization_;

            private AddNodeGen(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
                super(context, sourceSection);
                this.a_ = a;
                this.b_ = this.coerceOtherToAry(b);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="addOtherEmpty(DynamicObject, DynamicObject)", value=ArrayNodes.AddNode.class)
            private static final class AddOtherEmptyNode_
            extends BaseNode_ {
                AddOtherEmptyNode_(AddNodeGen root) {
                    super(root, 13);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isEmptyArray(bValue_) && RubyGuards.isRubyArray(bValue_)) {
                            return this.root.addOtherEmpty(aValue_, bValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddOtherEmptyNode_(root);
                }
            }

            @GeneratedBy(methodName="addEmpty(DynamicObject, DynamicObject)", value=ArrayNodes.AddNode.class)
            private static final class AddEmptyNode_
            extends BaseNode_ {
                AddEmptyNode_(AddNodeGen root) {
                    super(root, 12);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isEmptyArray(aValue_) && RubyGuards.isRubyArray(bValue_)) {
                            return this.root.addEmpty(aValue_, bValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddEmptyNode_(root);
                }
            }

            @GeneratedBy(methodName="addObject(DynamicObject, DynamicObject)", value=ArrayNodes.AddNode.class)
            private static final class AddObjectNode_
            extends BaseNode_ {
                AddObjectNode_(AddNodeGen root) {
                    super(root, 11);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isObjectArray(aValue_) && RubyGuards.isRubyArray(bValue_) && !ArrayGuards.isObjectArray(bValue_)) {
                            return this.root.addObject(aValue_, bValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="addOtherObject(DynamicObject, DynamicObject)", value=ArrayNodes.AddNode.class)
            private static final class AddOtherObjectNode_
            extends BaseNode_ {
                AddOtherObjectNode_(AddNodeGen root) {
                    super(root, 10);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (!ArrayGuards.isObjectArray(aValue_) && RubyGuards.isRubyArray(bValue_) && ArrayGuards.isObjectArray(bValue_)) {
                            return this.root.addOtherObject(aValue_, bValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddOtherObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="addNullObject(DynamicObject, DynamicObject)", value=ArrayNodes.AddNode.class)
            private static final class AddNullObjectNode_
            extends BaseNode_ {
                AddNullObjectNode_(AddNodeGen root) {
                    super(root, 9);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isNullArray(aValue_) && RubyGuards.isRubyArray(bValue_) && ArrayGuards.isObjectArray(bValue_)) {
                            return this.root.addNullObject(aValue_, bValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddNullObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="addNullLongFixnum(DynamicObject, DynamicObject)", value=ArrayNodes.AddNode.class)
            private static final class AddNullLongFixnumNode_
            extends BaseNode_ {
                AddNullLongFixnumNode_(AddNodeGen root) {
                    super(root, 8);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isNullArray(aValue_) && RubyGuards.isRubyArray(bValue_) && ArrayGuards.isLongArray(bValue_)) {
                            return this.root.addNullLongFixnum(aValue_, bValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddNullLongFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="addNullIntegerFixnum(DynamicObject, DynamicObject)", value=ArrayNodes.AddNode.class)
            private static final class AddNullIntegerFixnumNode_
            extends BaseNode_ {
                AddNullIntegerFixnumNode_(AddNodeGen root) {
                    super(root, 7);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isNullArray(aValue_) && RubyGuards.isRubyArray(bValue_) && ArrayGuards.isIntArray(bValue_)) {
                            return this.root.addNullIntegerFixnum(aValue_, bValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddNullIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="addBothObject(DynamicObject, DynamicObject)", value=ArrayNodes.AddNode.class)
            private static final class AddBothObjectNode_
            extends BaseNode_ {
                AddBothObjectNode_(AddNodeGen root) {
                    super(root, 6);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isObjectArray(aValue_) && RubyGuards.isRubyArray(bValue_) && ArrayGuards.isObjectArray(bValue_)) {
                            return this.root.addBothObject(aValue_, bValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddBothObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="addBothFloat(DynamicObject, DynamicObject)", value=ArrayNodes.AddNode.class)
            private static final class AddBothFloatNode_
            extends BaseNode_ {
                AddBothFloatNode_(AddNodeGen root) {
                    super(root, 5);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isDoubleArray(aValue_) && RubyGuards.isRubyArray(bValue_) && ArrayGuards.isDoubleArray(bValue_)) {
                            return this.root.addBothFloat(aValue_, bValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddBothFloatNode_(root);
                }
            }

            @GeneratedBy(methodName="addBothLongFixnum(DynamicObject, DynamicObject)", value=ArrayNodes.AddNode.class)
            private static final class AddBothLongFixnumNode_
            extends BaseNode_ {
                AddBothLongFixnumNode_(AddNodeGen root) {
                    super(root, 4);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isLongArray(aValue_) && ArrayGuards.isLongArray(bValue_)) {
                            return this.root.addBothLongFixnum(aValue_, bValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddBothLongFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="addBothIntegerFixnum(DynamicObject, DynamicObject)", value=ArrayNodes.AddNode.class)
            private static final class AddBothIntegerFixnumNode_
            extends BaseNode_ {
                AddBothIntegerFixnumNode_(AddNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isIntArray(aValue_) && ArrayGuards.isIntArray(bValue_)) {
                            return this.root.addBothIntegerFixnum(aValue_, bValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddBothIntegerFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="addObjectNull(DynamicObject, DynamicObject)", value=ArrayNodes.AddNode.class)
            private static final class AddObjectNullNode_
            extends BaseNode_ {
                AddObjectNullNode_(AddNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isObjectArray(aValue_) && ArrayGuards.isNullArray(bValue_)) {
                            return this.root.addObjectNull(aValue_, bValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddObjectNullNode_(root);
                }
            }

            @GeneratedBy(methodName="addNull(DynamicObject, DynamicObject)", value=ArrayNodes.AddNode.class)
            private static final class AddNullNode_
            extends BaseNode_ {
                AddNullNode_(AddNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isNullArray(aValue_) && ArrayGuards.isNullArray(bValue_)) {
                            return this.root.addNull(aValue_, bValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.AddNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(AddNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object aValue, Object bValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, aValue, bValue));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.AddNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AddNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.AddNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final AddNodeGen root;

                BaseNode_(AddNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.a_, this.root.b_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object aValue, Object bValue) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, aValue, bValue);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object aValue_ = this.root.a_.execute(frameValue);
                    Object bValue_ = this.root.b_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, aValue_, bValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isNullArray(aValue_) && ArrayGuards.isNullArray(bValue_)) {
                            return AddNullNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(aValue_) && ArrayGuards.isNullArray(bValue_)) {
                            return AddObjectNullNode_.create(this.root);
                        }
                        if (ArrayGuards.isIntArray(aValue_) && ArrayGuards.isIntArray(bValue_)) {
                            return AddBothIntegerFixnumNode_.create(this.root);
                        }
                        if (ArrayGuards.isLongArray(aValue_) && ArrayGuards.isLongArray(bValue_)) {
                            return AddBothLongFixnumNode_.create(this.root);
                        }
                        if (ArrayGuards.isDoubleArray(aValue_) && RubyGuards.isRubyArray(bValue_) && ArrayGuards.isDoubleArray(bValue_)) {
                            return AddBothFloatNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(aValue_) && RubyGuards.isRubyArray(bValue_) && ArrayGuards.isObjectArray(bValue_)) {
                            return AddBothObjectNode_.create(this.root);
                        }
                        if (ArrayGuards.isNullArray(aValue_) && RubyGuards.isRubyArray(bValue_) && ArrayGuards.isIntArray(bValue_)) {
                            return AddNullIntegerFixnumNode_.create(this.root);
                        }
                        if (ArrayGuards.isNullArray(aValue_) && RubyGuards.isRubyArray(bValue_) && ArrayGuards.isLongArray(bValue_)) {
                            return AddNullLongFixnumNode_.create(this.root);
                        }
                        if (ArrayGuards.isNullArray(aValue_) && RubyGuards.isRubyArray(bValue_) && ArrayGuards.isObjectArray(bValue_)) {
                            return AddNullObjectNode_.create(this.root);
                        }
                        if (!ArrayGuards.isObjectArray(aValue_) && RubyGuards.isRubyArray(bValue_) && ArrayGuards.isObjectArray(bValue_)) {
                            return AddOtherObjectNode_.create(this.root);
                        }
                        if (ArrayGuards.isObjectArray(aValue_) && RubyGuards.isRubyArray(bValue_) && !ArrayGuards.isObjectArray(bValue_)) {
                            return AddObjectNode_.create(this.root);
                        }
                        if (ArrayGuards.isEmptyArray(aValue_) && RubyGuards.isRubyArray(bValue_)) {
                            return AddEmptyNode_.create(this.root);
                        }
                        if (ArrayGuards.isEmptyArray(bValue_) && RubyGuards.isRubyArray(bValue_)) {
                            return AddOtherEmptyNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<ArrayNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(ArrayNodes.AllocateNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.AllocateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllocateNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static ArrayNodes.AllocateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AllocateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends ArrayNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;

            private AllocateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }
}

