/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.objects.AllocateObjectNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArrayDupNode
extends RubyNode {
    @Node.Child
    private AllocateObjectNode allocateNode;

    public ArrayDupNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.allocateNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
    }

    public abstract DynamicObject executeDup(VirtualFrame var1, DynamicObject var2);

    @Specialization(guards={"isRubyArray(from)", "isNullArray(from)"})
    public DynamicObject dupNull(DynamicObject from) {
        return this.allocateNode.allocate(this.getContext().getCoreLibrary().getArrayClass(), null, 0);
    }

    @Specialization(guards={"isRubyArray(from)", "isIntArray(from)"})
    public DynamicObject dupIntegerFixnum(DynamicObject from) {
        return this.allocateNode.allocate(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((int[])Layouts.ARRAY.getStore(from), Layouts.ARRAY.getSize(from)), Layouts.ARRAY.getSize(from));
    }

    @Specialization(guards={"isRubyArray(from)", "isLongArray(from)"})
    public DynamicObject dupLongFixnum(DynamicObject from) {
        return this.allocateNode.allocate(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((long[])Layouts.ARRAY.getStore(from), Layouts.ARRAY.getSize(from)), Layouts.ARRAY.getSize(from));
    }

    @Specialization(guards={"isRubyArray(from)", "isDoubleArray(from)"})
    public DynamicObject dupFloat(DynamicObject from) {
        return this.allocateNode.allocate(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((double[])Layouts.ARRAY.getStore(from), Layouts.ARRAY.getSize(from)), Layouts.ARRAY.getSize(from));
    }

    @Specialization(guards={"isRubyArray(from)", "isObjectArray(from)"})
    public DynamicObject dupObject(DynamicObject from) {
        return this.allocateNode.allocate(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((Object[])Layouts.ARRAY.getStore(from), Layouts.ARRAY.getSize(from)), Layouts.ARRAY.getSize(from));
    }
}

