/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.TruffleInteropNodes;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=TruffleInteropNodes.class)
public final class TruffleInteropNodesFactory {
    public static List<NodeFactory<? extends CoreMethodArrayArgumentsNode>> getFactories() {
        return Arrays.asList(InteropToRubyNodeFactory.getInstance(), IsExecutableNodeFactory.getInstance(), IsBoxedPrimitiveNodeFactory.getInstance(), IsNullNodeFactory.getInstance(), HasSizePropertyNodeFactory.getInstance(), ReadPropertyNodeFactory.getInstance(), WritePropertyNodeFactory.getInstance(), UnboxValueNodeFactory.getInstance(), ExecuteNodeFactory.getInstance(), GetSizeNodeFactory.getInstance());
    }

    @GeneratedBy(value=TruffleInteropNodes.GetSizeNode.class)
    public static final class GetSizeNodeFactory
    extends NodeFactoryBase<TruffleInteropNodes.GetSizeNode> {
        private static GetSizeNodeFactory getSizeNodeFactoryInstance;

        private GetSizeNodeFactory() {
            super(TruffleInteropNodes.GetSizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TruffleInteropNodes.GetSizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetSizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleInteropNodes.GetSizeNode> getInstance() {
            if (getSizeNodeFactoryInstance == null) {
                getSizeNodeFactoryInstance = new GetSizeNodeFactory();
            }
            return getSizeNodeFactoryInstance;
        }

        public static TruffleInteropNodes.GetSizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GetSizeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TruffleInteropNodes.GetSizeNode.class)
        public static final class GetSizeNodeGen
        extends TruffleInteropNodes.GetSizeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private GetSizeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="executeForeign(VirtualFrame, TruffleObject)", value=TruffleInteropNodes.GetSizeNode.class)
            private static final class ExecuteForeign1Node_
            extends BaseNode_ {
                ExecuteForeign1Node_(GetSizeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        return this.root.executeForeign(frameValue, arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GetSizeNodeGen root) {
                    return new ExecuteForeign1Node_(root);
                }
            }

            @GeneratedBy(methodName="executeForeign(VirtualFrame, String)", value=TruffleInteropNodes.GetSizeNode.class)
            private static final class ExecuteForeign0Node_
            extends BaseNode_ {
                ExecuteForeign0Node_(GetSizeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof String) {
                        String arguments0Value_ = (String)arguments0Value;
                        return this.root.executeForeign(frameValue, arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GetSizeNodeGen root) {
                    return new ExecuteForeign0Node_(root);
                }
            }

            @GeneratedBy(value=TruffleInteropNodes.GetSizeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GetSizeNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GetSizeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=TruffleInteropNodes.GetSizeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GetSizeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(GetSizeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=TruffleInteropNodes.GetSizeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final GetSizeNodeGen root;

                BaseNode_(GetSizeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof String) {
                        return ExecuteForeign0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof TruffleObject) {
                        return ExecuteForeign1Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=TruffleInteropNodes.ExecuteNode.class)
    public static final class ExecuteNodeFactory
    extends NodeFactoryBase<TruffleInteropNodes.ExecuteNode> {
        private static ExecuteNodeFactory executeNodeFactoryInstance;

        private ExecuteNodeFactory() {
            super(TruffleInteropNodes.ExecuteNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TruffleInteropNodes.ExecuteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExecuteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleInteropNodes.ExecuteNode> getInstance() {
            if (executeNodeFactoryInstance == null) {
                executeNodeFactoryInstance = new ExecuteNodeFactory();
            }
            return executeNodeFactoryInstance;
        }

        public static TruffleInteropNodes.ExecuteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ExecuteNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TruffleInteropNodes.ExecuteNode.class)
        public static final class ExecuteNodeGen
        extends TruffleInteropNodes.ExecuteNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private ExecuteNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                TruffleObject arguments0Value_;
                try {
                    arguments0Value_ = ExecuteNodeGen.expectTruffleObject(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.executeForeign(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }

            private static TruffleObject expectTruffleObject(Object value) throws UnexpectedResultException {
                if (value instanceof TruffleObject) {
                    return (TruffleObject)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=TruffleInteropNodes.UnboxValueNode.class)
    public static final class UnboxValueNodeFactory
    extends NodeFactoryBase<TruffleInteropNodes.UnboxValueNode> {
        private static UnboxValueNodeFactory unboxValueNodeFactoryInstance;

        private UnboxValueNodeFactory() {
            super(TruffleInteropNodes.UnboxValueNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TruffleInteropNodes.UnboxValueNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UnboxValueNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleInteropNodes.UnboxValueNode> getInstance() {
            if (unboxValueNodeFactoryInstance == null) {
                unboxValueNodeFactoryInstance = new UnboxValueNodeFactory();
            }
            return unboxValueNodeFactoryInstance;
        }

        public static TruffleInteropNodes.UnboxValueNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new UnboxValueNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TruffleInteropNodes.UnboxValueNode.class)
        public static final class UnboxValueNodeGen
        extends TruffleInteropNodes.UnboxValueNode {
            @Node.Child
            private RubyNode arguments0_;

            private UnboxValueNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                TruffleObject arguments0Value_;
                try {
                    arguments0Value_ = UnboxValueNodeGen.expectTruffleObject(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.executeForeign(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static TruffleObject expectTruffleObject(Object value) throws UnexpectedResultException {
                if (value instanceof TruffleObject) {
                    return (TruffleObject)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=TruffleInteropNodes.WritePropertyNode.class)
    public static final class WritePropertyNodeFactory
    extends NodeFactoryBase<TruffleInteropNodes.WritePropertyNode> {
        private static WritePropertyNodeFactory writePropertyNodeFactoryInstance;

        private WritePropertyNodeFactory() {
            super(TruffleInteropNodes.WritePropertyNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TruffleInteropNodes.WritePropertyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return WritePropertyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleInteropNodes.WritePropertyNode> getInstance() {
            if (writePropertyNodeFactoryInstance == null) {
                writePropertyNodeFactoryInstance = new WritePropertyNodeFactory();
            }
            return writePropertyNodeFactoryInstance;
        }

        public static TruffleInteropNodes.WritePropertyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new WritePropertyNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TruffleInteropNodes.WritePropertyNode.class)
        public static final class WritePropertyNodeGen
        extends TruffleInteropNodes.WritePropertyNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private WritePropertyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static TruffleObject expectTruffleObject(Object value) throws UnexpectedResultException {
                if (value instanceof TruffleObject) {
                    return (TruffleObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="executeForeignString(VirtualFrame, TruffleObject, DynamicObject, Object)", value=TruffleInteropNodes.WritePropertyNode.class)
            private static final class ExecuteForeignStringNode_
            extends BaseNode_ {
                ExecuteForeignStringNode_(WritePropertyNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.executeForeignString(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WritePropertyNodeGen root) {
                    return new ExecuteForeignStringNode_(root);
                }
            }

            @GeneratedBy(methodName="executeForeignSymbol(VirtualFrame, TruffleObject, DynamicObject, Object)", value=TruffleInteropNodes.WritePropertyNode.class)
            private static final class ExecuteForeignSymbolNode_
            extends BaseNode_ {
                ExecuteForeignSymbolNode_(WritePropertyNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_)) {
                            return this.root.executeForeignSymbol(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WritePropertyNodeGen root) {
                    return new ExecuteForeignSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="executeForeign(VirtualFrame, TruffleObject, long, Object)", value=TruffleInteropNodes.WritePropertyNode.class)
            private static final class ExecuteForeign1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                ExecuteForeign1Node_(WritePropertyNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((ExecuteForeign1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    TruffleObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = WritePropertyNodeGen.expectTruffleObject(this.root.arguments0_.execute(frameValue));
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                            Object arguments2Value = this.root.arguments2_.execute(frameValue);
                            return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments2Value = this.root.arguments2_.execute(frameValue);
                            return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                        }
                    }
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.root.executeForeign(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof TruffleObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.executeForeign(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WritePropertyNodeGen root, Object arguments1Value) {
                    return new ExecuteForeign1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="executeForeign(VirtualFrame, TruffleObject, int, Object)", value=TruffleInteropNodes.WritePropertyNode.class)
            private static final class ExecuteForeign0Node_
            extends BaseNode_ {
                ExecuteForeign0Node_(WritePropertyNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    TruffleObject arguments0Value_;
                    try {
                        arguments0Value_ = WritePropertyNodeGen.expectTruffleObject(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.root.executeForeign(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof Integer) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.executeForeign(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WritePropertyNodeGen root) {
                    return new ExecuteForeign0Node_(root);
                }
            }

            @GeneratedBy(value=TruffleInteropNodes.WritePropertyNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(WritePropertyNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WritePropertyNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=TruffleInteropNodes.WritePropertyNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(WritePropertyNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WritePropertyNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=TruffleInteropNodes.WritePropertyNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final WritePropertyNodeGen root;

                BaseNode_(WritePropertyNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        if (arguments1Value instanceof Integer) {
                            return ExecuteForeign0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return ExecuteForeign1Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                            if (RubyGuards.isRubySymbol(arguments1Value_)) {
                                return ExecuteForeignSymbolNode_.create(this.root);
                            }
                            if (RubyGuards.isRubyString(arguments1Value_)) {
                                return ExecuteForeignStringNode_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=TruffleInteropNodes.ReadPropertyNode.class)
    public static final class ReadPropertyNodeFactory
    extends NodeFactoryBase<TruffleInteropNodes.ReadPropertyNode> {
        private static ReadPropertyNodeFactory readPropertyNodeFactoryInstance;

        private ReadPropertyNodeFactory() {
            super(TruffleInteropNodes.ReadPropertyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TruffleInteropNodes.ReadPropertyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ReadPropertyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleInteropNodes.ReadPropertyNode> getInstance() {
            if (readPropertyNodeFactoryInstance == null) {
                readPropertyNodeFactoryInstance = new ReadPropertyNodeFactory();
            }
            return readPropertyNodeFactoryInstance;
        }

        public static TruffleInteropNodes.ReadPropertyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ReadPropertyNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TruffleInteropNodes.ReadPropertyNode.class)
        public static final class ReadPropertyNodeGen
        extends TruffleInteropNodes.ReadPropertyNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ReadPropertyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static TruffleObject expectTruffleObject(Object value) throws UnexpectedResultException {
                if (value instanceof TruffleObject) {
                    return (TruffleObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="executeForeignString(VirtualFrame, TruffleObject, DynamicObject)", value=TruffleInteropNodes.ReadPropertyNode.class)
            private static final class ExecuteForeignStringNode_
            extends BaseNode_ {
                ExecuteForeignStringNode_(ReadPropertyNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.executeForeignString(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReadPropertyNodeGen root) {
                    return new ExecuteForeignStringNode_(root);
                }
            }

            @GeneratedBy(methodName="executeForeignSymbol(VirtualFrame, TruffleObject, DynamicObject)", value=TruffleInteropNodes.ReadPropertyNode.class)
            private static final class ExecuteForeignSymbolNode_
            extends BaseNode_ {
                ExecuteForeignSymbolNode_(ReadPropertyNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_)) {
                            return this.root.executeForeignSymbol(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReadPropertyNodeGen root) {
                    return new ExecuteForeignSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="executeForeign(VirtualFrame, TruffleObject, long)", value=TruffleInteropNodes.ReadPropertyNode.class)
            private static final class ExecuteForeign1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                ExecuteForeign1Node_(ReadPropertyNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((ExecuteForeign1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    TruffleObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = ReadPropertyNodeGen.expectTruffleObject(this.root.arguments0_.execute(frameValue));
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                            return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.executeForeign(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof TruffleObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.executeForeign(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReadPropertyNodeGen root, Object arguments1Value) {
                    return new ExecuteForeign1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="executeForeign(VirtualFrame, TruffleObject, int)", value=TruffleInteropNodes.ReadPropertyNode.class)
            private static final class ExecuteForeign0Node_
            extends BaseNode_ {
                ExecuteForeign0Node_(ReadPropertyNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    TruffleObject arguments0Value_;
                    try {
                        arguments0Value_ = ReadPropertyNodeGen.expectTruffleObject(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.executeForeign(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof Integer) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.executeForeign(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReadPropertyNodeGen root) {
                    return new ExecuteForeign0Node_(root);
                }
            }

            @GeneratedBy(value=TruffleInteropNodes.ReadPropertyNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ReadPropertyNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReadPropertyNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=TruffleInteropNodes.ReadPropertyNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ReadPropertyNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReadPropertyNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=TruffleInteropNodes.ReadPropertyNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ReadPropertyNodeGen root;

                BaseNode_(ReadPropertyNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        if (arguments1Value instanceof Integer) {
                            return ExecuteForeign0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return ExecuteForeign1Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                            if (RubyGuards.isRubySymbol(arguments1Value_)) {
                                return ExecuteForeignSymbolNode_.create(this.root);
                            }
                            if (RubyGuards.isRubyString(arguments1Value_)) {
                                return ExecuteForeignStringNode_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=TruffleInteropNodes.HasSizePropertyNode.class)
    public static final class HasSizePropertyNodeFactory
    extends NodeFactoryBase<TruffleInteropNodes.HasSizePropertyNode> {
        private static HasSizePropertyNodeFactory hasSizePropertyNodeFactoryInstance;

        private HasSizePropertyNodeFactory() {
            super(TruffleInteropNodes.HasSizePropertyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TruffleInteropNodes.HasSizePropertyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return HasSizePropertyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleInteropNodes.HasSizePropertyNode> getInstance() {
            if (hasSizePropertyNodeFactoryInstance == null) {
                hasSizePropertyNodeFactoryInstance = new HasSizePropertyNodeFactory();
            }
            return hasSizePropertyNodeFactoryInstance;
        }

        public static TruffleInteropNodes.HasSizePropertyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new HasSizePropertyNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TruffleInteropNodes.HasSizePropertyNode.class)
        public static final class HasSizePropertyNodeGen
        extends TruffleInteropNodes.HasSizePropertyNode {
            @Node.Child
            private RubyNode arguments0_;

            private HasSizePropertyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                TruffleObject arguments0Value_;
                try {
                    arguments0Value_ = HasSizePropertyNodeGen.expectTruffleObject(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.hasSizeProperty(frameValue, arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static TruffleObject expectTruffleObject(Object value) throws UnexpectedResultException {
                if (value instanceof TruffleObject) {
                    return (TruffleObject)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=TruffleInteropNodes.IsNullNode.class)
    public static final class IsNullNodeFactory
    extends NodeFactoryBase<TruffleInteropNodes.IsNullNode> {
        private static IsNullNodeFactory isNullNodeFactoryInstance;

        private IsNullNodeFactory() {
            super(TruffleInteropNodes.IsNullNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TruffleInteropNodes.IsNullNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsNullNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleInteropNodes.IsNullNode> getInstance() {
            if (isNullNodeFactoryInstance == null) {
                isNullNodeFactoryInstance = new IsNullNodeFactory();
            }
            return isNullNodeFactoryInstance;
        }

        public static TruffleInteropNodes.IsNullNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IsNullNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TruffleInteropNodes.IsNullNode.class)
        public static final class IsNullNodeGen
        extends TruffleInteropNodes.IsNullNode {
            @Node.Child
            private RubyNode arguments0_;

            private IsNullNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                TruffleObject arguments0Value_;
                try {
                    arguments0Value_ = IsNullNodeGen.expectTruffleObject(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.isNull(frameValue, arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static TruffleObject expectTruffleObject(Object value) throws UnexpectedResultException {
                if (value instanceof TruffleObject) {
                    return (TruffleObject)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=TruffleInteropNodes.IsBoxedPrimitiveNode.class)
    public static final class IsBoxedPrimitiveNodeFactory
    extends NodeFactoryBase<TruffleInteropNodes.IsBoxedPrimitiveNode> {
        private static IsBoxedPrimitiveNodeFactory isBoxedPrimitiveNodeFactoryInstance;

        private IsBoxedPrimitiveNodeFactory() {
            super(TruffleInteropNodes.IsBoxedPrimitiveNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TruffleInteropNodes.IsBoxedPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsBoxedPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleInteropNodes.IsBoxedPrimitiveNode> getInstance() {
            if (isBoxedPrimitiveNodeFactoryInstance == null) {
                isBoxedPrimitiveNodeFactoryInstance = new IsBoxedPrimitiveNodeFactory();
            }
            return isBoxedPrimitiveNodeFactoryInstance;
        }

        public static TruffleInteropNodes.IsBoxedPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IsBoxedPrimitiveNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TruffleInteropNodes.IsBoxedPrimitiveNode.class)
        public static final class IsBoxedPrimitiveNodeGen
        extends TruffleInteropNodes.IsBoxedPrimitiveNode {
            @Node.Child
            private RubyNode arguments0_;

            private IsBoxedPrimitiveNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                TruffleObject arguments0Value_;
                try {
                    arguments0Value_ = IsBoxedPrimitiveNodeGen.expectTruffleObject(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.isBoxedPrimitive(frameValue, arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static TruffleObject expectTruffleObject(Object value) throws UnexpectedResultException {
                if (value instanceof TruffleObject) {
                    return (TruffleObject)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=TruffleInteropNodes.IsExecutableNode.class)
    public static final class IsExecutableNodeFactory
    extends NodeFactoryBase<TruffleInteropNodes.IsExecutableNode> {
        private static IsExecutableNodeFactory isExecutableNodeFactoryInstance;

        private IsExecutableNodeFactory() {
            super(TruffleInteropNodes.IsExecutableNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TruffleInteropNodes.IsExecutableNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsExecutableNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleInteropNodes.IsExecutableNode> getInstance() {
            if (isExecutableNodeFactoryInstance == null) {
                isExecutableNodeFactoryInstance = new IsExecutableNodeFactory();
            }
            return isExecutableNodeFactoryInstance;
        }

        public static TruffleInteropNodes.IsExecutableNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IsExecutableNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TruffleInteropNodes.IsExecutableNode.class)
        public static final class IsExecutableNodeGen
        extends TruffleInteropNodes.IsExecutableNode {
            @Node.Child
            private RubyNode arguments0_;

            private IsExecutableNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                TruffleObject arguments0Value_;
                try {
                    arguments0Value_ = IsExecutableNodeGen.expectTruffleObject(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.isExecutable(frameValue, arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }

            private static TruffleObject expectTruffleObject(Object value) throws UnexpectedResultException {
                if (value instanceof TruffleObject) {
                    return (TruffleObject)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=TruffleInteropNodes.InteropToRubyNode.class)
    public static final class InteropToRubyNodeFactory
    extends NodeFactoryBase<TruffleInteropNodes.InteropToRubyNode> {
        private static InteropToRubyNodeFactory interopToRubyNodeFactoryInstance;

        private InteropToRubyNodeFactory() {
            super(TruffleInteropNodes.InteropToRubyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TruffleInteropNodes.InteropToRubyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InteropToRubyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleInteropNodes.InteropToRubyNode> getInstance() {
            if (interopToRubyNodeFactoryInstance == null) {
                interopToRubyNodeFactoryInstance = new InteropToRubyNodeFactory();
            }
            return interopToRubyNodeFactoryInstance;
        }

        public static TruffleInteropNodes.InteropToRubyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InteropToRubyNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TruffleInteropNodes.InteropToRubyNode.class)
        public static final class InteropToRubyNodeGen
        extends TruffleInteropNodes.InteropToRubyNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private InteropToRubyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static byte expectByte(Object value) throws UnexpectedResultException {
                if (value instanceof Byte) {
                    return (Byte)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static char expectCharacter(Object value) throws UnexpectedResultException {
                if (value instanceof Character) {
                    return ((Character)value).charValue();
                }
                throw new UnexpectedResultException(value);
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static float expectFloat(Object value) throws UnexpectedResultException {
                if (value instanceof Float) {
                    return ((Float)value).floatValue();
                }
                throw new UnexpectedResultException(value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static short expectShort(Object value) throws UnexpectedResultException {
                if (value instanceof Short) {
                    return (Short)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="convert(String)", value=TruffleInteropNodes.InteropToRubyNode.class)
            private static final class Convert7Node_
            extends BaseNode_ {
                Convert7Node_(InteropToRubyNodeGen root) {
                    super(root, 8);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    String arguments0Value_;
                    try {
                        arguments0Value_ = InteropToRubyNodeGen.expectString(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return InteropToRubyNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.convert(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof String) {
                        String arguments0Value_ = (String)arguments0Value;
                        return this.root.convert(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(InteropToRubyNodeGen root) {
                    return new Convert7Node_(root);
                }
            }

            @GeneratedBy(methodName="convert(double)", value=TruffleInteropNodes.InteropToRubyNode.class)
            private static final class Convert6Node_
            extends BaseNode_ {
                Convert6Node_(InteropToRubyNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InteropToRubyNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.convert(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.convert(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(InteropToRubyNodeGen root) {
                    return new Convert6Node_(root);
                }
            }

            @GeneratedBy(methodName="convert(float)", value=TruffleInteropNodes.InteropToRubyNode.class)
            private static final class Convert5Node_
            extends BaseNode_ {
                Convert5Node_(InteropToRubyNodeGen root) {
                    super(root, 6);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    float arguments0Value_;
                    try {
                        arguments0Value_ = InteropToRubyNodeGen.expectFloat(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return InteropToRubyNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.convert(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Float) {
                        float arguments0Value_ = ((Float)arguments0Value).floatValue();
                        return this.root.convert(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(InteropToRubyNodeGen root) {
                    return new Convert5Node_(root);
                }
            }

            @GeneratedBy(methodName="convert(long)", value=TruffleInteropNodes.InteropToRubyNode.class)
            private static final class Convert4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Convert4Node_(InteropToRubyNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Convert4Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return InteropToRubyNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                        }
                    }
                    return this.root.convert(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.convert(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(InteropToRubyNodeGen root, Object arguments0Value) {
                    return new Convert4Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="convert(int)", value=TruffleInteropNodes.InteropToRubyNode.class)
            private static final class Convert3Node_
            extends BaseNode_ {
                Convert3Node_(InteropToRubyNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InteropToRubyNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.convert(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.convert(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(InteropToRubyNodeGen root) {
                    return new Convert3Node_(root);
                }
            }

            @GeneratedBy(methodName="convert(char)", value=TruffleInteropNodes.InteropToRubyNode.class)
            private static final class Convert2Node_
            extends BaseNode_ {
                Convert2Node_(InteropToRubyNodeGen root) {
                    super(root, 3);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    char arguments0Value_;
                    try {
                        arguments0Value_ = InteropToRubyNodeGen.expectCharacter(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return InteropToRubyNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.convert(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Character) {
                        char arguments0Value_ = ((Character)arguments0Value).charValue();
                        return this.root.convert(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(InteropToRubyNodeGen root) {
                    return new Convert2Node_(root);
                }
            }

            @GeneratedBy(methodName="convert(short)", value=TruffleInteropNodes.InteropToRubyNode.class)
            private static final class Convert1Node_
            extends BaseNode_ {
                Convert1Node_(InteropToRubyNodeGen root) {
                    super(root, 2);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    short arguments0Value_;
                    try {
                        arguments0Value_ = InteropToRubyNodeGen.expectShort(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return InteropToRubyNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.convert(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Short) {
                        short arguments0Value_ = (Short)arguments0Value;
                        return this.root.convert(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(InteropToRubyNodeGen root) {
                    return new Convert1Node_(root);
                }
            }

            @GeneratedBy(methodName="convert(byte)", value=TruffleInteropNodes.InteropToRubyNode.class)
            private static final class Convert0Node_
            extends BaseNode_ {
                Convert0Node_(InteropToRubyNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    byte arguments0Value_;
                    try {
                        arguments0Value_ = InteropToRubyNodeGen.expectByte(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return InteropToRubyNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.convert(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Byte) {
                        byte arguments0Value_ = (Byte)arguments0Value;
                        return this.root.convert(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(InteropToRubyNodeGen root) {
                    return new Convert0Node_(root);
                }
            }

            @GeneratedBy(value=TruffleInteropNodes.InteropToRubyNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InteropToRubyNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(InteropToRubyNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=TruffleInteropNodes.InteropToRubyNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InteropToRubyNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(InteropToRubyNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=TruffleInteropNodes.InteropToRubyNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InteropToRubyNodeGen root;

                BaseNode_(InteropToRubyNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return InteropToRubyNodeGen.expectDouble(this.execute(frameValue));
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return InteropToRubyNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return InteropToRubyNodeGen.expectLong(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Byte) {
                        return Convert0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Short) {
                        return Convert1Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Character) {
                        return Convert2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Integer) {
                        return Convert3Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Convert4Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof Float) {
                        return Convert5Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Convert6Node_.create(this.root);
                    }
                    if (arguments0Value instanceof String) {
                        return Convert7Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }
}

