/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.FiberNodes;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=FiberNodes.class)
public final class FiberNodesFactory {
    public static List<NodeFactory<? extends CoreMethodArrayArgumentsNode>> getFactories() {
        return Arrays.asList(FiberTransferNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), ResumeNodeFactory.getInstance(), YieldNodeFactory.getInstance(), AllocateNodeFactory.getInstance());
    }

    @GeneratedBy(value=FiberNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<FiberNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(FiberNodes.AllocateNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FiberNodes.AllocateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllocateNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static FiberNodes.AllocateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AllocateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FiberNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends FiberNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;

            private AllocateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=FiberNodes.YieldNode.class)
    public static final class YieldNodeFactory
    extends NodeFactoryBase<FiberNodes.YieldNode> {
        private static YieldNodeFactory yieldNodeFactoryInstance;

        private YieldNodeFactory() {
            super(FiberNodes.YieldNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FiberNodes.YieldNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return YieldNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.YieldNode> getInstance() {
            if (yieldNodeFactoryInstance == null) {
                yieldNodeFactoryInstance = new YieldNodeFactory();
            }
            return yieldNodeFactoryInstance;
        }

        public static FiberNodes.YieldNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new YieldNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FiberNodes.YieldNode.class)
        public static final class YieldNodeGen
        extends FiberNodes.YieldNode {
            @Node.Child
            private RubyNode arguments0_;

            private YieldNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.yield(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=FiberNodes.ResumeNode.class)
    public static final class ResumeNodeFactory
    extends NodeFactoryBase<FiberNodes.ResumeNode> {
        private static ResumeNodeFactory resumeNodeFactoryInstance;

        private ResumeNodeFactory() {
            super(FiberNodes.ResumeNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FiberNodes.ResumeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ResumeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.ResumeNode> getInstance() {
            if (resumeNodeFactoryInstance == null) {
                resumeNodeFactoryInstance = new ResumeNodeFactory();
            }
            return resumeNodeFactoryInstance;
        }

        public static FiberNodes.ResumeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ResumeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FiberNodes.ResumeNode.class)
        public static final class ResumeNodeGen
        extends FiberNodes.ResumeNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private ResumeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.resume(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=FiberNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<FiberNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(FiberNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FiberNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static FiberNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FiberNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends FiberNodes.InitializeNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private InitializeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                if (RubyGuards.isRubyProc(arguments1Value_)) {
                    return this.initialize(arguments0Value_, arguments1Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=FiberNodes.FiberTransferNode.class)
    public static final class FiberTransferNodeFactory
    extends NodeFactoryBase<FiberNodes.FiberTransferNode> {
        private static FiberTransferNodeFactory fiberTransferNodeFactoryInstance;

        private FiberTransferNodeFactory() {
            super(FiberNodes.FiberTransferNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FiberNodes.FiberTransferNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FiberTransferNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.FiberTransferNode> getInstance() {
            if (fiberTransferNodeFactoryInstance == null) {
                fiberTransferNodeFactoryInstance = new FiberTransferNodeFactory();
            }
            return fiberTransferNodeFactoryInstance;
        }

        public static FiberNodes.FiberTransferNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new FiberTransferNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FiberNodes.FiberTransferNode.class)
        public static final class FiberTransferNodeGen
        extends FiberNodes.FiberTransferNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;

            private FiberTransferNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object executeTransferControlTo(VirtualFrame frameValue, DynamicObject arguments0Value, boolean arguments1Value, Object[] arguments2Value) {
                if (RubyGuards.isRubyFiber(arguments0Value)) {
                    return this.transfer(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                throw this.unsupported(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments2Value_;
                boolean arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value, arguments2Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    throw this.unsupported(arguments0Value_, ex.getResult(), arguments2Value);
                }
                try {
                    arguments2Value_ = this.arguments2_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, arguments1Value_, ex.getResult());
                }
                if (RubyGuards.isRubyFiber(arguments0Value_)) {
                    return this.transfer(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_, arguments2Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
            }
        }
    }
}

