/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.arguments;

import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;

public class ReadCallerFrameNode
extends RubyNode {
    private final ConditionProfile hasCallerFrameProfile = ConditionProfile.createBinaryProfile();

    public ReadCallerFrameNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        MaterializedFrame callerFrame = RubyArguments.getCallerFrame(frame.getArguments());
        if (this.hasCallerFrameProfile.profile(callerFrame != null)) {
            return callerFrame;
        }
        return NotProvided.INSTANCE;
    }
}

